/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.JSLinterCodeStyleImporter;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.prettierjs.PrettierBundle;
import com.intellij.prettierjs.PrettierConfig;
import com.intellij.prettierjs.PrettierConfigurable;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.prettierjs.PrettierUtil;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrettierCodeStyleImporter
extends JSLinterCodeStyleImporter<PrettierConfig> {
    public PrettierCodeStyleImporter(boolean isForInitialImport) {
        super(isForInitialImport);
    }

    @NotNull
    protected Configurable createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            PrettierCodeStyleImporter.$$$reportNull$$$0(0);
        }
        return new PrettierConfigurable(project);
    }

    @NotNull
    protected JSNpmLinterState getStoredState(Project project) {
        PrettierConfiguration prettierConfiguration = PrettierConfiguration.getInstance(project);
        if (prettierConfiguration == null) {
            PrettierCodeStyleImporter.$$$reportNull$$$0(1);
        }
        return prettierConfiguration;
    }

    @NotNull
    protected String getNpmPackageName() {
        return "prettier";
    }

    @NotNull
    protected String getToolName() {
        String prettier;
        String string = prettier = "Prettier";
        if (string == null) {
            PrettierCodeStyleImporter.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected boolean isDirectlyImportable(@NotNull PsiFile configPsi, @Nullable PrettierConfig parsedConfig) {
        if (configPsi == null) {
            PrettierCodeStyleImporter.$$$reportNull$$$0(3);
        }
        return parsedConfig != null;
    }

    @Nullable
    protected PrettierConfig parseConfigFromFile(@NotNull PsiFile configPsi) {
        if (configPsi == null) {
            PrettierCodeStyleImporter.$$$reportNull$$$0(4);
        }
        return PrettierUtil.parseConfig(configPsi.getProject(), configPsi.getVirtualFile());
    }

    @Nullable
    protected PrettierConfig computeEffectiveConfig(@NotNull PsiFile configPsi, @NotNull NodeJsInterpreter interpreter, @NotNull NodePackage linterPackage) throws ExecutionException {
        if (configPsi == null) {
            PrettierCodeStyleImporter.$$$reportNull$$$0(5);
        }
        if (interpreter == null) {
            PrettierCodeStyleImporter.$$$reportNull$$$0(6);
        }
        if (linterPackage == null) {
            PrettierCodeStyleImporter.$$$reportNull$$$0(7);
        }
        String configFilePath = FileUtil.toSystemDependentName((String)configPsi.getVirtualFile().getPath());
        String convertConfigScriptPath = JSLanguageServiceUtil.getPluginDirectory(PrettierCodeStyleImporter.class, (String)"prettierLanguageService/convert-prettier-config.js").getAbsolutePath();
        String absPkgPathToRequire = linterPackage.getAbsolutePackagePathToRequire(configPsi.getProject());
        if (absPkgPathToRequire == null) {
            throw new ExecutionException(PrettierBundle.message("dialog.message.cannot.find.absolute.package.path.to.require", linterPackage));
        }
        List<String> parameters = Arrays.asList(convertConfigScriptPath, absPkgPathToRequire, configFilePath);
        String text = this.runToolWithArguments(configPsi, interpreter, parameters);
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Prettier: computed effective config for file %s:\n%s", configFilePath, text));
        }
        return PrettierUtil.parseConfigFromJsonText(text);
    }

    @NotNull
    protected JSLinterCodeStyleImporter.ImportResult importConfig(@NotNull PsiFile configPsi, @NotNull PrettierConfig config) {
        if (configPsi == null) {
            PrettierCodeStyleImporter.$$$reportNull$$$0(8);
        }
        if (config == null) {
            PrettierCodeStyleImporter.$$$reportNull$$$0(9);
        }
        if (config.isInstalled(configPsi.getProject())) {
            JSLinterCodeStyleImporter.ImportResult importResult = JSLinterCodeStyleImporter.ImportResult.alreadyImported();
            if (importResult == null) {
                PrettierCodeStyleImporter.$$$reportNull$$$0(10);
            }
            return importResult;
        }
        config.install(configPsi.getProject());
        JSLinterCodeStyleImporter.ImportResult importResult = JSLinterCodeStyleImporter.ImportResult.success(Collections.emptyList());
        if (importResult == null) {
            PrettierCodeStyleImporter.$$$reportNull$$$0(11);
        }
        return importResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/prettierjs/PrettierCodeStyleImporter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPsi";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterPackage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/prettierjs/PrettierCodeStyleImporter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStoredState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "importConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsConfigurable";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyImportable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseConfigFromFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeEffectiveConfig";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "importConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 10, 11 -> new IllegalStateException(string);
        };
    }
}

