/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.switchtoif;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSRedundantSwitchStatementInspection;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.psi.util.SideEffectChecker;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.switchtoif.CaseUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSReplaceSwitchWithIfIntention
extends JSIntention {
    @NonNls
    private static final String IF_PREFIX = "if (";
    @NonNls
    private static final String IF_SUFFIX = ") {";
    @NonNls
    private static final String ELSE = "} else {";
    @NonNls
    private static final String ELSE_KEYWORD = "else ";
    @NonNls
    private static final String VAR_PREFIX = "var ";
    @NonNls
    private static final String BREAK_KEYWORD = "break ";
    @NonNls
    private static final String DEFAULT_LABEL_NAME = "Label";

    @IntentionName
    @NotNull
    public String getText() {
        String string = JSIntentionBundle.message("switchtoif.replace-switch-with-if.display-name", new Object[0]);
        if (string == null) {
            JSReplaceSwitchWithIfIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("switchtoif.replace-switch-with-if.family-name", new Object[0]);
        if (string == null) {
            JSReplaceSwitchWithIfIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new SwitchPredicate();
    }

    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        String declarationString;
        String expressionText;
        if (project == null) {
            JSReplaceSwitchWithIfIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSReplaceSwitchWithIfIntention.$$$reportNull$$$0(3);
        }
        JSSwitchStatement switchStatement = (JSSwitchStatement)element.getParent();
        assert (switchStatement != null);
        JSExpression switchExpression = switchStatement.getSwitchExpression();
        boolean hadSideEffects = SideEffectChecker.mayHaveSideEffects((JSExpression)switchExpression);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)switchExpression);
        if (hadSideEffects) {
            PsiElement nameSuggetionScope = PsiTreeUtil.getParentOfType((PsiElement)switchExpression, JSExecutionScope.class);
            JSCaseClause[] variableName = JSNameSuggestionsUtil.generateVariableNameFromExpression((JSExpression)switchExpression, (PsiElement)nameSuggetionScope);
            expressionText = variableName;
            declarationString = JSChangeUtil.getVariablePrefix((PsiElement)switchStatement) + " " + (String)variableName + " = " + switchExpression.getText() + semicolon;
        } else {
            declarationString = null;
            expressionText = switchExpression.getText();
        }
        boolean renameBreaks = false;
        for (JSCaseClause caseClause : switchStatement.getCaseClauses()) {
            if (!CaseUtil.containsHiddenBreak(caseClause)) continue;
            renameBreaks = true;
            break;
        }
        StringBuilder ifStatementBuffer = new StringBuilder(1024);
        String breakLabel = null;
        if (renameBreaks) {
            breakLabel = CaseUtil.findUniqueLabel((JSStatement)switchStatement, DEFAULT_LABEL_NAME);
            ifStatementBuffer.append(breakLabel).append(':');
        }
        ArrayList<SwitchStatementBranch> openBranches = new ArrayList<SwitchStatementBranch>();
        HashSet<JSVariable> declaredVars = new HashSet<JSVariable>(5);
        ArrayList<SwitchStatementBranch> allBranches = new ArrayList<SwitchStatementBranch>();
        SwitchStatementBranch currentBranch = null;
        for (JSCaseClause caseClause : switchStatement.getCaseClauses()) {
            PsiElement[] caseClauseChildren;
            for (PsiElement child : caseClauseChildren = caseClause.getChildren()) {
                if (child == caseClauseChildren[0]) {
                    if (currentBranch == null) {
                        openBranches.clear();
                        currentBranch = new SwitchStatementBranch();
                        currentBranch.addPendingVariableDeclarations(declaredVars);
                        allBranches.add(currentBranch);
                        openBranches.add(currentBranch);
                    } else if (currentBranch.hasStatements()) {
                        currentBranch = new SwitchStatementBranch();
                        allBranches.add(currentBranch);
                        openBranches.add(currentBranch);
                    }
                    if (caseClause.isDefault()) {
                        currentBranch.setDefault();
                    }
                }
                if (child instanceof JSExpression) {
                    JSExpression caseExpression = caseClause.getCaseExpression();
                    JSExpression value = (JSExpression)ObjectUtils.coalesce((Object)JSParenthesesUtils.stripParentheses((JSExpression)caseExpression), (Object)caseExpression);
                    assert (currentBranch != null);
                    currentBranch.addLabel(value.getText());
                    continue;
                }
                if (child instanceof JSSourceElement) {
                    JSSourceElement statement = (JSSourceElement)child;
                    if (statement instanceof JSVarStatement) {
                        Collections.addAll(declaredVars, ((JSVarStatement)statement).getVariables());
                    }
                    if (statement instanceof JSBlockStatement) {
                        for (PsiElement blockElement : statement.getChildren()) {
                            boolean isJsElement = blockElement instanceof JSElement;
                            boolean isWhiteSpace = blockElement instanceof PsiWhiteSpace;
                            for (SwitchStatementBranch branch : openBranches) {
                                if (isJsElement) {
                                    branch.addStatement((JSElement)blockElement);
                                    continue;
                                }
                                if (isWhiteSpace) {
                                    branch.addWhiteSpace(blockElement);
                                    continue;
                                }
                                branch.addElement(blockElement);
                            }
                        }
                    } else {
                        for (SwitchStatementBranch branch : openBranches) {
                            branch.addStatement((JSElement)statement);
                        }
                    }
                    if (!(statement instanceof JSStatement) || ControlFlowUtils.statementMayCompleteNormally((JSStatement)((JSStatement)statement))) continue;
                    currentBranch = null;
                    continue;
                }
                if (!(child instanceof PsiWhiteSpace) && !(child instanceof PsiComment)) continue;
                boolean isWhiteSpace = child instanceof PsiWhiteSpace;
                for (SwitchStatementBranch openBranch : openBranches) {
                    if (isWhiteSpace) {
                        openBranch.addWhiteSpace(child);
                        continue;
                    }
                    openBranch.addElement(child);
                }
            }
        }
        boolean firstBranch = true;
        SwitchStatementBranch defaultBranch = null;
        for (SwitchStatementBranch branch : allBranches) {
            if (branch.isDefault()) {
                defaultBranch = branch;
                continue;
            }
            List<String> labels = branch.getLabels();
            List<PsiElement> bodyElements = branch.getBodyElements();
            Set<JSVariable> pendingVariableDeclarations = branch.getPendingVariableDeclarations();
            JSReplaceSwitchWithIfIntention.dumpBranch(ifStatementBuffer, expressionText, labels, bodyElements, firstBranch, renameBreaks && CaseUtil.containsHiddenBreak(bodyElements), breakLabel, pendingVariableDeclarations);
            firstBranch = false;
        }
        if (defaultBranch != null) {
            List<PsiElement> bodyElements = defaultBranch.getBodyElements();
            Set<JSVariable> pendingVariableDeclarations = defaultBranch.getPendingVariableDeclarations();
            JSReplaceSwitchWithIfIntention.dumpDefaultBranch(ifStatementBuffer, bodyElements, firstBranch, renameBreaks, breakLabel, pendingVariableDeclarations);
        }
        CodeStyleManager codeStyleMgr = CodeStyleManager.getInstance((Project)switchStatement.getProject());
        if (hadSideEffects) {
            ifStatementString = ifStatementBuffer.toString();
            JSStatement declarationStatement = JSPsiElementFactory.createJSStatement((String)declarationString, (PsiElement)element);
            JSStatement ifStatement = JSPsiElementFactory.createJSStatement((String)ifStatementString, (PsiElement)element);
            codeStyleMgr.reformat((PsiElement)declarationStatement);
            codeStyleMgr.reformat((PsiElement)ifStatement);
            JSChangeUtil.doAddBefore((PsiElement)switchStatement.getParent(), (PsiElement)declarationStatement, (PsiElement)switchStatement);
            JSRefactoringUtil.replaceStatementAndReformat((JSStatement)switchStatement, (String)ifStatement.getText());
        } else {
            ifStatementString = ifStatementBuffer.toString();
            JSStatement newStatement = JSPsiElementFactory.createJSStatement((String)ifStatementString, (PsiElement)element);
            codeStyleMgr.reformat((PsiElement)newStatement);
            JSRefactoringUtil.replaceStatementAndReformat((JSStatement)switchStatement, (String)newStatement.getText());
        }
    }

    private static void dumpBranch(StringBuilder ifStatementString, String expressionText, List<String> labels, List<PsiElement> bodyStatements, boolean firstBranch, boolean renameBreaks, String breakLabel, Set<JSVariable> variableDecls) {
        if (!firstBranch) {
            ifStatementString.append(ELSE_KEYWORD);
        }
        JSReplaceSwitchWithIfIntention.dumpLabels(ifStatementString, expressionText, labels);
        JSReplaceSwitchWithIfIntention.dumpBody(ifStatementString, bodyStatements, renameBreaks, breakLabel, variableDecls);
    }

    private static void dumpDefaultBranch(StringBuilder ifStatementString, List<PsiElement> bodyStatements, boolean firstBranch, boolean renameBreaks, String breakLabel, Set<JSVariable> variableDecls) {
        if (!firstBranch) {
            ifStatementString.append(ELSE_KEYWORD);
        }
        JSReplaceSwitchWithIfIntention.dumpBody(ifStatementString, bodyStatements, renameBreaks, breakLabel, variableDecls);
    }

    private static void dumpLabels(StringBuilder ifStatementString, String expressionText, List<String> labels) {
        boolean firstLabel = true;
        ifStatementString.append(IF_PREFIX);
        for (String label : labels) {
            if (!firstLabel) {
                ifStatementString.append("||");
            }
            firstLabel = false;
            ifStatementString.append(expressionText).append("===").append(label);
        }
        ifStatementString.append(')');
    }

    private static void dumpBody(StringBuilder ifStatementString, List<PsiElement> bodyStatements, boolean renameBreaks, String breakLabel, Set<JSVariable> variableDecls) {
        ifStatementString.append('{');
        for (JSVariable var : variableDecls) {
            String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)var);
            if (!CaseUtil.isUsedByStatementList(var, bodyStatements)) continue;
            ifStatementString.append(VAR_PREFIX).append(var.getName()).append(semicolon);
        }
        for (PsiElement bodyStatement : bodyStatements) {
            if (bodyStatement instanceof JSBreakStatement) continue;
            JSReplaceSwitchWithIfIntention.appendElement(ifStatementString, bodyStatement, renameBreaks, breakLabel);
        }
        ifStatementString.append('}');
    }

    private static void appendElement(StringBuilder ifStatementString, PsiElement element, boolean renameBreakElements, String breakLabelString) {
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)element);
        if (!renameBreakElements) {
            String text = element.getText();
            ifStatementString.append(text);
        } else if (element instanceof JSBreakStatement) {
            String identifier = ((JSBreakStatement)element).getLabel();
            if (identifier == null || identifier.length() == 0) {
                ifStatementString.append(BREAK_KEYWORD).append(breakLabelString).append(semicolon);
            } else {
                String text = element.getText();
                ifStatementString.append(text);
            }
        } else if (element instanceof JSBlockStatement) {
            for (PsiElement child : element.getChildren()) {
                JSReplaceSwitchWithIfIntention.appendElement(ifStatementString, child, renameBreakElements, breakLabelString);
            }
        } else if (element instanceof JSIfStatement) {
            JSIfStatement ifStatement = (JSIfStatement)element;
            JSStatement elseBranch = (JSStatement)ifStatement.getElseBranch();
            ifStatementString.append(IF_PREFIX).append(ifStatement.getCondition().getText()).append(IF_SUFFIX);
            JSReplaceSwitchWithIfIntention.appendElement(ifStatementString, (PsiElement)ifStatement.getThenBranch(), renameBreakElements, breakLabelString);
            if (elseBranch != null) {
                ifStatementString.append(ELSE);
                JSReplaceSwitchWithIfIntention.appendElement(ifStatementString, (PsiElement)elseBranch, renameBreakElements, breakLabelString);
            }
            ifStatementString.append('}');
        } else {
            ifStatementString.append(element.getText());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/switchtoif/JSReplaceSwitchWithIfIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/switchtoif/JSReplaceSwitchWithIfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static class SwitchPredicate
    implements JSElementPredicate {
        private SwitchPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            PsiElement parent;
            if (element == null) {
                SwitchPredicate.$$$reportNull$$$0(0);
            }
            if (!((parent = element.getParent()) instanceof JSSwitchStatement)) {
                return false;
            }
            JSSwitchStatement switchStatement = (JSSwitchStatement)parent;
            if (PsiUtilCore.hasErrorElementChild((PsiElement)switchStatement)) {
                return false;
            }
            JSExpression expression = switchStatement.getSwitchExpression();
            if (expression == null || !expression.isValid()) {
                return false;
            }
            JSCaseClause[] clauses = switchStatement.getCaseClauses();
            return clauses.length > 1 && !JSRedundantSwitchStatementInspection.isCaseDefaultWithProperExits((JSCaseClause[])clauses);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/switchtoif/JSReplaceSwitchWithIfIntention$SwitchPredicate", "satisfiedBy"));
        }
    }

    private static class SwitchStatementBranch {
        private final Set<JSVariable> pendingVariableDeclarations = new HashSet<JSVariable>(5);
        private final List<String> labels = new ArrayList<String>(2);
        private final List<PsiElement> bodyElements = new ArrayList<PsiElement>(5);
        private final List<PsiElement> pendingWhiteSpace = new ArrayList<PsiElement>(2);
        private boolean isDefault;
        private boolean hasStatements;

        private SwitchStatementBranch() {
        }

        public void addLabel(String labelString) {
            this.labels.add(labelString);
        }

        public void addStatement(JSElement statement) {
            this.hasStatements = true;
            this.addElement((PsiElement)statement);
        }

        private void addElement(PsiElement element) {
            this.bodyElements.addAll(this.pendingWhiteSpace);
            this.pendingWhiteSpace.clear();
            this.bodyElements.add(element);
        }

        public void addWhiteSpace(PsiElement whiteSpace) {
            if (this.bodyElements.size() > 0) {
                this.pendingWhiteSpace.add(whiteSpace);
            }
        }

        public List<String> getLabels() {
            return Collections.unmodifiableList(this.labels);
        }

        public List<PsiElement> getBodyElements() {
            return Collections.unmodifiableList(this.bodyElements);
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault() {
            this.isDefault = true;
        }

        public boolean hasStatements() {
            return this.hasStatements;
        }

        public void addPendingVariableDeclarations(Set<JSVariable> vars) {
            this.pendingVariableDeclarations.addAll(vars);
        }

        public Set<JSVariable> getPendingVariableDeclarations() {
            return Collections.unmodifiableSet(this.pendingVariableDeclarations);
        }
    }
}

