/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.api.actions.NotebookEditorRunActionsHandler;
import com.intellij.jupyter.core.core.impl.actions.JupyterCellData;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellsContents;
import com.intellij.jupyter.core.core.impl.actions.RemoveOutputsUndoableAction;
import com.intellij.jupyter.core.core.impl.actions.SetOutputsUndoableAction;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.actions.ActionDestination;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.lang.JupyterLangData;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputListener;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellLinesUtilsKt;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.core.api.psi.NotebookPsiFile;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u00ac\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u001a/\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u001d\u0010\u0004\u001a\u0019\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\b\u0007H\u0000\u001a4\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\t2\u001e\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\u000bH\u0080\b\u00f8\u0001\u0000\u001a4\u0010\b\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00032\u001e\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\u000bH\u0080\b\u00f8\u0001\u0000\u001a(\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a,\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u001a(\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0015H\u0000\u001a0\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010 \u001a\u0004\u0018\u00010!H\u0000\u001a0\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a<\u0010&\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\r2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00182\u0006\u0010*\u001a\u00020+H\u0000\u001a\u001a\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\rH\u0002\u001a\u001a\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\rH\u0002\u001a(\u00103\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u0002042\u0006\u0010\u0012\u001a\u00020\r2\u0006\u00105\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a0\u00106\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u0002042\u0006\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u0002092\u0006\u0010\u0012\u001a\u00020\r2\b\u0010:\u001a\u0004\u0018\u00010;\u001a*\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=2\u0006\u0010?\u001a\u00020@2\u0006\u00107\u001a\u00020\u00192\b\u0010:\u001a\u0004\u0018\u00010;H\u0002\u001a\u001c\u0010A\u001a\u00020\u0001*\u0002042\u0006\u0010B\u001a\u0002092\u0006\u0010C\u001a\u00020DH\u0000\u001a\u0018\u0010E\u001a\u00020\u0001*\u0002042\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u001a$\u0010E\u001a\u00020\u0001*\u00020@2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010 \u001a\u0004\u0018\u00010!H\u0000\u001a\u001e\u0010H\u001a\u00020\u0001*\u00020@2\u0006\u00107\u001a\u00020\u00192\b\u0010 \u001a\u0004\u0018\u00010!H\u0000\u001a*\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018*\u00020@2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010J\u001a\u00020\u00192\u0006\u0010K\u001a\u00020=H\u0000\u001a2\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018*\u00020@2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010M\u001a\u00020=2\u0006\u0010N\u001a\u0002092\b\b\u0002\u0010O\u001a\u00020+\u001a&\u0010P\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u0002042\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010Q\u001a\u00020R\u001a&\u0010S\u001a\u00020\u00192\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00190T2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\rH\u0002\"\u001a\u00100\u001a\u0004\u0018\u00010/*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006U"}, d2={"withRunActionsHandler", "", "event", "Lcom/intellij/openapi/actionSystem/DataContext;", "handler", "Lkotlin/Function2;", "Lcom/intellij/jupyter/core/core/api/actions/NotebookEditorRunActionsHandler;", "Lkotlin/ExtensionFunctionType;", "withCellLinesAndSelection", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "func", "Lkotlin/Function3;", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "Lcom/intellij/notebooks/visualization/NotebookCellSelectionModel;", "dataContext", "moveCellsWithOutputs", "editor", "cellLines", "cellSelection", "direction", "Lcom/intellij/jupyter/core/jupyter/actions/ActionDestination;", "moveCarets", "from", "", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "to", "mergePrimaryCell", "actionDest", "mergeCells", "target", "sources", "ptrFactory", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointerFactory;", "pasteCell", "project", "Lcom/intellij/openapi/project/Project;", "selectionModel", "trySetJupyterOutputs", "insertedCells", "clipboardJupyterCells", "Lcom/intellij/jupyter/core/core/impl/actions/JupyterCellData;", "setCellId", "", "getUpdatedJupyterNotebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "getUpdatedJupyterFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "notebookVirtualFile", "getNotebookVirtualFile", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "expandSelection", "Lcom/intellij/openapi/editor/Editor;", "model", "trySplitCellAtOffset", "cell", "splitAtOffset", "", "editHelper", "Lcom/intellij/jupyter/core/core/api/actions/NotebookCellLinesEditHelper;", "makeCellWithText", "", "text", "document", "Lcom/intellij/openapi/editor/Document;", "scrollTo", "targetLine", "scrollType", "Lcom/intellij/openapi/editor/ScrollType;", "removeCells", "removedCells", "cells", "removeCell", "replaceCell", "oldCell", "newText", "insertCells", "cellsText", "targetOrdinal", "shouldKeepEmptyCell", "convertCells", "newType", "Lcom/intellij/jupyter/core/jupyter/lang/JupyterLangData;", "findNewPrimaryCell", "", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookCellLinesActionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellLinesActionUtil.kt\ncom/intellij/jupyter/core/core/impl/actions/NotebookCellLinesActionUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,422:1\n46#1:423\n47#1,2:425\n1#2:424\n1#2:427\n1557#3:428\n1628#3,3:429\n774#3:432\n865#3,2:433\n774#3:435\n865#3,2:436\n183#4,2:438\n183#4,2:440\n*S KotlinDebug\n*F\n+ 1 NotebookCellLinesActionUtil.kt\ncom/intellij/jupyter/core/core/impl/actions/NotebookCellLinesActionUtilKt\n*L\n39#1:423\n39#1:425,2\n39#1:424\n73#1:428\n73#1:429,3\n130#1:432\n130#1:433,2\n131#1:435\n131#1:436,2\n414#1:438,2\n420#1:440,2\n*E\n"})
public final class NotebookCellLinesActionUtilKt {
    public static final void withRunActionsHandler(@NotNull DataContext event, @NotNull Function2<? super NotebookEditorRunActionsHandler, ? super DataContext, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        NotebookPsiFile notebookPsiFile = JupyterDataContextExtensionsKt.getNotebookPsiFile(event);
        if (notebookPsiFile == null) {
            return;
        }
        NotebookPsiFile psiFile = notebookPsiFile;
        NotebookEditorRunActionsHandler notebookEditorRunActionsHandler = (NotebookEditorRunActionsHandler)NotebookEditorRunActionsHandler.Companion.forLanguage(psiFile.getLanguage());
        if (notebookEditorRunActionsHandler == null) {
            return;
        }
        NotebookEditorRunActionsHandler actionsHandler = notebookEditorRunActionsHandler;
        handler.invoke((Object)actionsHandler, (Object)event);
    }

    public static final void withCellLinesAndSelection(@NotNull AnActionEvent event, @NotNull Function3<? super EditorImpl, ? super NotebookCellLines, ? super NotebookCellSelectionModel, Unit> func) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        boolean $i$f$withCellLinesAndSelection = false;
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext$iv = dataContext;
        boolean $i$f$withCellLinesAndSelection2 = false;
        Object object = NotebookDataContext.INSTANCE.getNotebookEditor(dataContext$iv);
        if (object != null) {
            EditorImpl editorImpl;
            EditorImpl it$iv = editorImpl = object;
            boolean bl = false;
            object = NotebookCellSelectionModelProviderKt.getHasCellSelectionModelSupport((Editor)((Editor)it$iv)) ? editorImpl : null;
            if (object == null) {
            } else {
                EditorImpl editor$iv = object;
                NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)editor$iv));
                if (notebookCellSelectionModel != null) {
                    func.invoke((Object)editor$iv, (Object)NotebookCellLines.Companion.get((Editor)editor$iv), (Object)notebookCellSelectionModel);
                }
            }
        }
    }

    public static final void withCellLinesAndSelection(@NotNull DataContext dataContext, @NotNull Function3<? super EditorImpl, ? super NotebookCellLines, ? super NotebookCellSelectionModel, Unit> func) {
        Object object;
        block5: {
            block4: {
                EditorImpl editorImpl;
                Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                Intrinsics.checkNotNullParameter(func, (String)"func");
                boolean $i$f$withCellLinesAndSelection = false;
                object = NotebookDataContext.INSTANCE.getNotebookEditor(dataContext);
                if (object == null) break block4;
                EditorImpl it = editorImpl = object;
                boolean bl = false;
                object = NotebookCellSelectionModelProviderKt.getHasCellSelectionModelSupport((Editor)((Editor)it)) ? editorImpl : null;
                if (object != null) break block5;
            }
            return;
        }
        EditorImpl editor = object;
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)editor));
        if (notebookCellSelectionModel == null) {
            return;
        }
        func.invoke((Object)editor, (Object)NotebookCellLines.Companion.get((Editor)editor), (Object)notebookCellSelectionModel);
    }

    /*
     * WARNING - void declaration
     */
    public static final void moveCellsWithOutputs(@NotNull EditorImpl editor, @NotNull NotebookCellLines cellLines, @NotNull NotebookCellSelectionModel cellSelection, @NotNull ActionDestination direction) {
        block9: {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
            Intrinsics.checkNotNullParameter((Object)cellSelection, (String)"cellSelection");
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            DocumentEx documentEx = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            DocumentEx document = documentEx;
            List selectedRegion = cellSelection.getPrimarySelectedRegion();
            NotebookIntervalPointerFactory ptrFactory = NotebookIntervalPointerFactory.Companion.getOrNull((Editor)editor);
            switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: {
                    NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.getOrNull((List)cellLines.getIntervals(), (int)(((NotebookCellLines.Interval)CollectionsKt.first((List)selectedRegion)).getOrdinal() - 1));
                    if (interval == null) {
                        return;
                    }
                    pair = new Pair((Object)CollectionsKt.listOf((Object)interval), (Object)selectedRegion);
                    break;
                }
                case 2: {
                    NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.getOrNull((List)cellLines.getIntervals(), (int)(((NotebookCellLines.Interval)CollectionsKt.last((List)selectedRegion)).getOrdinal() + 1));
                    if (interval == null) {
                        return;
                    }
                    pair = new Pair((Object)selectedRegion, (Object)CollectionsKt.listOf((Object)interval));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Pair pair2 = pair;
            List upperCells = (List)pair2.component1();
            List lowerCells = (List)pair2.component2();
            boolean bl2 = false;
            NotebookCellLinesEditHelper helper = NotebookCellLinesEditHelper.Companion.get((Editor)editor);
            int targetOrdinal2 = ((NotebookCellLines.Interval)CollectionsKt.last((List)lowerCells)).getOrdinal() + 1;
            NotebookCellsContents upperCellsContent = NotebookCellsContents.Companion.invoke(editor, upperCells);
            Object object = helper;
            if (object == null || (object = object.makeInsertedCells(upperCellsContent, targetOrdinal2)) == null) {
                object = upperCellsContent.getRawText();
            }
            Object textToInsert = object;
            List insertedCells = NotebookCellLinesActionUtilKt.insertCells$default((Document)document, cellLines, (String)textToInsert, targetOrdinal2, false, 8, null);
            NotebookIntervalPointerFactory notebookIntervalPointerFactory = ptrFactory;
            if (notebookIntervalPointerFactory != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable bl2 = CollectionsKt.zip((Iterable)upperCells, (Iterable)insertedCells);
                NotebookIntervalPointerFactory notebookIntervalPointerFactory2 = notebookIntervalPointerFactory;
                boolean $i$f$map = false;
                void targetOrdinal2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair3 = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(new NotebookIntervalPointerFactory.Swap(((NotebookCellLines.Interval)it.getFirst()).getOrdinal(), ((NotebookCellLines.Interval)it.getSecond()).getOrdinal()));
                }
                notebookIntervalPointerFactory2.modifyPointers((Iterable)((List)destination$iv$iv));
            }
            NotebookCellLinesActionUtilKt.getUpdatedJupyterNotebook(editor, cellLines);
            NotebookCellLinesActionUtilKt.moveCarets(editor, upperCells, insertedCells);
            NotebookCellLinesActionUtilKt.removeCells((Document)document, upperCells, ptrFactory);
            NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)editor));
            if (notebookCellSelectionModel == null || (notebookCellSelectionModel = notebookCellSelectionModel.getPrimarySelectedCell()) == null || (notebookCellSelectionModel = notebookCellSelectionModel.getLines()) == null) break block9;
            int it = notebookCellSelectionModel.getFirst();
            boolean bl4 = false;
            NotebookCellLinesActionUtilKt.scrollTo((Editor)editor, it, ScrollType.MAKE_VISIBLE);
        }
    }

    private static final void moveCarets(EditorImpl editor, List<NotebookCellLines.Interval> from, List<NotebookCellLines.Interval> to) {
        Map paired = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)from, (Iterable)to));
        editor.getCaretModel().runBatchCaretOperation(() -> NotebookCellLinesActionUtilKt.moveCarets$lambda$7(editor, from, paired));
    }

    public static final void mergePrimaryCell(@NotNull EditorImpl editor, @NotNull NotebookCellLines cellLines, @NotNull NotebookCellSelectionModel cellSelection, @NotNull ActionDestination actionDest) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
            Intrinsics.checkNotNullParameter((Object)cellSelection, (String)"cellSelection");
            Intrinsics.checkNotNullParameter((Object)((Object)actionDest), (String)"actionDest");
            NotebookCellLines.Interval target = cellSelection.getPrimarySelectedCell();
            int sourceIndex = switch (WhenMappings.$EnumSwitchMapping$0[actionDest.ordinal()]) {
                case 1 -> target.getOrdinal() - 1;
                case 2 -> target.getOrdinal() + 1;
                default -> throw new NoWhenBranchMatchedException();
            };
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.getOrNull((List)cellLines.getIntervals(), (int)sourceIndex);
            if (interval == null) break block4;
            NotebookCellLines.Interval source = interval;
            boolean bl = false;
            cellSelection.selectSingleCell(target);
            NotebookCellLinesActionUtilKt.mergeCells(editor, target, CollectionsKt.listOf((Object)source), NotebookIntervalPointerFactory.Companion.getOrNull((Editor)editor));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void mergeCells(@NotNull EditorImpl editor, @NotNull NotebookCellLines.Interval target, @NotNull List<NotebookCellLines.Interval> sources, @Nullable NotebookIntervalPointerFactory ptrFactory) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        DocumentEx documentEx = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        UndoManager undoManager = UndoManager.getInstance((Project)project);
        Iterable $this$filter$iv = sources;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            NotebookCellLines.Interval it = (NotebookCellLines.Interval)element$iv$iv;
            boolean bl = false;
            if (!(it.getOrdinal() < target.getOrdinal())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cellsAbove = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv2 = sources;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NotebookCellLines.Interval it = (NotebookCellLines.Interval)element$iv$iv;
            boolean bl = false;
            if (!(it.getOrdinal() > target.getOrdinal())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List cellsBelow = CollectionsKt.sorted((Iterable)((List)destination$iv$iv2));
        if (!((Collection)cellsBelow).isEmpty()) {
            String contentBelow = CollectionsKt.joinToString$default((Iterable)cellsBelow, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> NotebookCellLinesActionUtilKt.mergeCells$lambda$11(document, arg_0), (int)30, null);
            undoManager.undoableActionPerformed((UndoableAction)new RemoveOutputsUndoableAction(editor, cellsBelow));
            NotebookCellLinesActionUtilKt.removeCells((Document)document, cellsBelow, ptrFactory);
            document.insertString(document.getLineEndOffset(target.getLastContentLine()), (CharSequence)("\n" + contentBelow));
        }
        if (!((Collection)cellsAbove).isEmpty()) {
            String contentAbove = CollectionsKt.joinToString$default((Iterable)cellsAbove, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> NotebookCellLinesActionUtilKt.mergeCells$lambda$12(document, arg_0), (int)30, null);
            document.insertString(document.getLineStartOffset(target.getFirstContentLine()), (CharSequence)(contentAbove + "\n"));
            undoManager.undoableActionPerformed((UndoableAction)new RemoveOutputsUndoableAction(editor, cellsAbove));
            NotebookCellLinesActionUtilKt.removeCells((Document)document, cellsAbove, ptrFactory);
        }
    }

    public static final void pasteCell(@NotNull Project project, @NotNull EditorImpl editor, @NotNull NotebookCellLines cellLines, @NotNull NotebookCellSelectionModel selectionModel, @NotNull ActionDestination direction) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        NotebookCellsContents notebookCellsContents = NotebookCellsContents.Companion.getFromClipboard();
        if (notebookCellsContents == null) {
            return;
        }
        NotebookCellsContents cellsToInsert = notebookCellsContents;
        DocumentEx documentEx = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        int targetOrdinal = switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> ((NotebookCellLines.Interval)CollectionsKt.first((List)selectionModel.getPrimarySelectedRegion())).getOrdinal();
            case 2 -> {
                if (document.getTextLength() > 0) {
                    yield ((NotebookCellLines.Interval)CollectionsKt.last((List)selectionModel.getPrimarySelectedRegion())).getOrdinal() + 1;
                }
                yield 0;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        NotebookCellLinesEditHelper notebookCellLinesEditHelper = NotebookCellLinesEditHelper.Companion.get((Editor)editor);
        String textToInsert = notebookCellLinesEditHelper != null && (string = notebookCellLinesEditHelper.makeInsertedCells(cellsToInsert, targetOrdinal)) != null ? string : cellsToInsert.getRawText();
        List insertedCells = NotebookCellLinesActionUtilKt.insertCells$default((Document)document, cellLines, textToInsert, targetOrdinal, false, 8, null);
        selectionModel.selectSingleCell((NotebookCellLines.Interval)CollectionsKt.first((List)insertedCells));
        List<JupyterCellData> list = cellsToInsert.getJupyterCells();
        if (list != null) {
            List<JupyterCellData> outputData = list;
            boolean bl = false;
            NotebookCellLinesActionUtilKt.trySetJupyterOutputs(editor, cellLines, insertedCells, outputData, false);
            UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new SetOutputsUndoableAction(editor, insertedCells, outputData));
        }
        NotebookCellLinesActionUtilKt.scrollTo((Editor)editor, ((NotebookCellLines.Interval)CollectionsKt.first((List)insertedCells)).getLines().getFirst(), ScrollType.MAKE_VISIBLE);
    }

    public static final void trySetJupyterOutputs(@NotNull EditorImpl editor, @NotNull NotebookCellLines cellLines, @NotNull List<NotebookCellLines.Interval> insertedCells, @NotNull List<JupyterCellData> clipboardJupyterCells, boolean setCellId) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        Intrinsics.checkNotNullParameter(insertedCells, (String)"insertedCells");
        Intrinsics.checkNotNullParameter(clipboardJupyterCells, (String)"clipboardJupyterCells");
        JupyterNotebook jupyterNotebook = NotebookCellLinesActionUtilKt.getUpdatedJupyterNotebook(editor, cellLines);
        if (jupyterNotebook == null) {
            return;
        }
        JupyterNotebook jupyterNotebook2 = jupyterNotebook;
        for (Pair pair : CollectionsKt.zip((Iterable)clipboardJupyterCells, (Iterable)insertedCells)) {
            JupyterCellData jupyterData = (JupyterCellData)pair.component1();
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)pair.component2();
            int ordinal = interval.getOrdinal();
            JupyterCell cell = jupyterNotebook2.getCell(ordinal);
            jupyterData.setToCell(cell, setCellId);
            NotebookIntervalPointerFactory notebookIntervalPointerFactory = NotebookIntervalPointerFactory.Companion.getOrNull((Editor)editor);
            if (notebookIntervalPointerFactory == null || (notebookIntervalPointerFactory = notebookIntervalPointerFactory.getForOrdinalIfExists(ordinal)) == null) continue;
            NotebookIntervalPointerFactory intervalPointer = notebookIntervalPointerFactory;
            ((JupyterOutputListener)jupyterNotebook2.getListeners().getOutputListeners().getMulticaster()).outputUpdated(jupyterNotebook2, (NotebookIntervalPointer)intervalPointer);
        }
    }

    private static final JupyterNotebook getUpdatedJupyterNotebook(EditorImpl editor, NotebookCellLines cellLines) {
        BackedNotebookVirtualFile backedNotebookVirtualFile = NotebookCellLinesActionUtilKt.getUpdatedJupyterFile(editor, cellLines);
        return backedNotebookVirtualFile != null ? backedNotebookVirtualFile.getNotebook() : null;
    }

    private static final BackedNotebookVirtualFile getUpdatedJupyterFile(EditorImpl editor, NotebookCellLines cellLines) {
        boolean bl;
        BackedNotebookVirtualFile backedNotebookVirtualFile = NotebookCellLinesActionUtilKt.getNotebookVirtualFile(editor);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile jupyterFile = backedNotebookVirtualFile;
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        PsiDocumentManager.getInstance((Project)project2).commitDocument((Document)editor.getDocument());
        boolean bl2 = bl = jupyterFile.getNotebook().cellsCount() == cellLines.getIntervals().size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Jupyter Notebook hasn't updated model yet";
            throw new AssertionError((Object)string);
        }
        return jupyterFile;
    }

    private static final BackedNotebookVirtualFile getNotebookVirtualFile(EditorImpl $this$notebookVirtualFile) {
        BackedNotebookVirtualFile backedNotebookVirtualFile;
        VirtualFile virtualFile = $this$notebookVirtualFile.getVirtualFile();
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            BackedNotebookVirtualFile.Companion companion = BackedNotebookVirtualFile.Companion;
            VirtualFile p0 = virtualFile2;
            boolean $i$f$_get_notebookVirtualFile_$stub_for_inlining = false;
            boolean bl = false;
            backedNotebookVirtualFile = companion.takeIfBacked(p0);
        } else {
            backedNotebookVirtualFile = null;
        }
        return backedNotebookVirtualFile;
    }

    public static final void expandSelection(@NotNull Editor editor, @NotNull NotebookCellLines cellLines, @NotNull NotebookCellSelectionModel model, @NotNull ActionDestination direction) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        NotebookCellLines.Interval primaryCell = model.getPrimarySelectedCell();
        List primarySelectedRegion = model.getPrimarySelectedRegion();
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                if (Intrinsics.areEqual((Object)CollectionsKt.last((List)primarySelectedRegion), (Object)primaryCell)) {
                    NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.getOrNull((List)cellLines.getIntervals(), (int)(((NotebookCellLines.Interval)CollectionsKt.first((List)primarySelectedRegion)).getOrdinal() - 1));
                    if (interval != null) {
                        NotebookCellLines.Interval it = interval;
                        boolean bl = false;
                        NotebookCellSelectionModel.DefaultImpls.selectCell$default((NotebookCellSelectionModel)model, (NotebookCellLines.Interval)it, (boolean)false, (int)2, null);
                        NotebookCellLinesActionUtilKt.scrollTo(editor, it.getLines().getFirst(), ScrollType.MAKE_VISIBLE);
                    }
                    break;
                }
                model.removeSelection((NotebookCellLines.Interval)CollectionsKt.last((List)primarySelectedRegion));
                NotebookCellLinesActionUtilKt.scrollTo(editor, ((NotebookCellLines.Interval)primarySelectedRegion.get(CollectionsKt.getLastIndex((List)primarySelectedRegion) - 1)).getLines().getFirst(), ScrollType.MAKE_VISIBLE);
                break;
            }
            case 2: {
                if (Intrinsics.areEqual((Object)CollectionsKt.first((List)primarySelectedRegion), (Object)primaryCell)) {
                    NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.getOrNull((List)cellLines.getIntervals(), (int)(((NotebookCellLines.Interval)CollectionsKt.last((List)primarySelectedRegion)).getOrdinal() + 1));
                    if (interval != null) {
                        NotebookCellLines.Interval it = interval;
                        boolean bl = false;
                        NotebookCellSelectionModel.DefaultImpls.selectCell$default((NotebookCellSelectionModel)model, (NotebookCellLines.Interval)it, (boolean)false, (int)2, null);
                        NotebookCellLinesActionUtilKt.scrollTo(editor, it.getLines().getLast(), ScrollType.MAKE_VISIBLE);
                    }
                    break;
                }
                model.removeSelection((NotebookCellLines.Interval)CollectionsKt.first((List)primarySelectedRegion));
                NotebookCellLinesActionUtilKt.scrollTo(editor, ((NotebookCellLines.Interval)primarySelectedRegion.get(1)).getLines().getLast(), ScrollType.MAKE_VISIBLE);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ((EditorEx)editor).getGutterComponentEx().repaint();
    }

    public static final void trySplitCellAtOffset(@NotNull Editor editor, @NotNull NotebookCellLines.Interval cell, int splitAtOffset, @NotNull NotebookCellLines cellLines, @Nullable NotebookCellLinesEditHelper editHelper) {
        String string;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        if (editHelper == null && !cell.getMarkers().getHasTopLine() && !cell.getMarkers().getHasBottomLine()) {
            return;
        }
        if (Math.max(1, document2.getLineCount()) <= cell.getFirstContentLine()) {
            return;
        }
        int startOffset = document2.getLineStartOffset(cell.getFirstContentLine());
        int endOffset = document2.getLineEndOffset(cell.getLastContentLine());
        if (splitAtOffset < startOffset || splitAtOffset > endOffset) {
            return;
        }
        int splitAtLine = document2.getLineNumber(splitAtOffset);
        boolean isAtLineStart = document2.getLineStartOffset(splitAtLine) == splitAtOffset;
        boolean isAtLineEnd = document2.getLineEndOffset(splitAtLine) == splitAtOffset;
        String it = document2.getText(new TextRange(splitAtOffset, endOffset));
        boolean bl = false;
        if (isAtLineEnd && !isAtLineStart) {
            Intrinsics.checkNotNull((Object)it);
            string = StringsKt.drop((String)it, (int)1);
        } else {
            Intrinsics.checkNotNull((Object)it);
            string = it;
        }
        String textBelow = string;
        String newCellText = NotebookCellLinesActionUtilKt.makeCellWithText(textBelow, document2, cell, editHelper);
        List<NotebookCellLines.Interval> newCells = NotebookCellLinesActionUtilKt.insertCells(document2, cellLines, newCellText, cell.getOrdinal() + 1, true);
        editor.getCaretModel().getPrimaryCaret().moveToLogicalPosition(new LogicalPosition(((NotebookCellLines.Interval)CollectionsKt.first(newCells)).getFirstContentLine(), 0));
        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.singleOrNull(newCells);
        if (interval != null) {
            NotebookCellLines.Interval newCell = interval;
            boolean bl2 = false;
            NotebookIntervalPointerFactory notebookIntervalPointerFactory = NotebookIntervalPointerFactory.Companion.getOrNull(editor);
            if (notebookIntervalPointerFactory != null) {
                notebookIntervalPointerFactory.modifyPointers((Iterable)CollectionsKt.listOf((Object)new NotebookIntervalPointerFactory.Swap(cell.getOrdinal(), newCell.getOrdinal())));
            }
        }
        int deleteStartOffset = isAtLineStart && splitAtLine > cell.getFirstContentLine() ? splitAtOffset - 1 : splitAtOffset;
        document2.deleteString(deleteStartOffset, endOffset);
    }

    private static final String makeCellWithText(String text, Document document, NotebookCellLines.Interval cell, NotebookCellLinesEditHelper editHelper) {
        Object object = editHelper;
        if (object == null || (object = NotebookCellLinesEditHelper.DefaultImpls.makeCell$default((NotebookCellLinesEditHelper)object, text, cell.getType(), null, 4, null)) == null) {
            Object[] objectArray = new String[]{cell.getTopMarker(document), text, cell.getBottomMarker(document)};
            object = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        return object;
    }

    public static final void scrollTo(@NotNull Editor $this$scrollTo, int targetLine, @NotNull ScrollType scrollType) {
        Intrinsics.checkNotNullParameter((Object)$this$scrollTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scrollType, (String)"scrollType");
        $this$scrollTo.getScrollingModel().scrollTo(new LogicalPosition(targetLine, 0), scrollType);
    }

    public static final void removeCells(@NotNull Editor $this$removeCells, @NotNull List<NotebookCellLines.Interval> removedCells) {
        Intrinsics.checkNotNullParameter((Object)$this$removeCells, (String)"<this>");
        Intrinsics.checkNotNullParameter(removedCells, (String)"removedCells");
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)$this$removeCells);
        if (notebookCellSelectionModel != null) {
            NotebookCellSelectionModel model = notebookCellSelectionModel;
            boolean bl = false;
            NotebookCellLines.Interval newPrimaryCell = NotebookCellLinesActionUtilKt.findNewPrimaryCell(CollectionsKt.toSet((Iterable)removedCells), model, NotebookCellLines.Companion.get($this$removeCells));
            model.selectSingleCell(newPrimaryCell);
        }
        Document document = $this$removeCells.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        NotebookCellLinesActionUtilKt.removeCells(document, removedCells, NotebookIntervalPointerFactory.Companion.getOrNull($this$removeCells));
    }

    public static final void removeCells(@NotNull Document $this$removeCells, @NotNull List<NotebookCellLines.Interval> cells, @Nullable NotebookIntervalPointerFactory ptrFactory) {
        Intrinsics.checkNotNullParameter((Object)$this$removeCells, (String)"<this>");
        Intrinsics.checkNotNullParameter(cells, (String)"cells");
        for (NotebookCellLines.Interval cell : CollectionsKt.asReversed(cells)) {
            NotebookCellLinesActionUtilKt.removeCell($this$removeCells, cell, ptrFactory);
        }
    }

    public static final void removeCell(@NotNull Document $this$removeCell, @NotNull NotebookCellLines.Interval cell, @Nullable NotebookIntervalPointerFactory ptrFactory) {
        Intrinsics.checkNotNullParameter((Object)$this$removeCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        if (cell.getLines().getFirst() > 0) {
            $this$removeCell.deleteString($this$removeCell.getLineStartOffset(cell.getLines().getFirst()) - 1, $this$removeCell.getLineEndOffset(cell.getLines().getLast()));
        } else if (cell.getLines().getLast() + 1 == $this$removeCell.getLineCount()) {
            NotebookIntervalPointerFactory notebookIntervalPointerFactory = ptrFactory;
            if (notebookIntervalPointerFactory != null) {
                notebookIntervalPointerFactory.modifyPointers((Iterable)CollectionsKt.listOf((Object)new NotebookIntervalPointerFactory.Invalidate(cell)));
            }
            $this$removeCell.deleteString($this$removeCell.getLineStartOffset(cell.getFirstContentLine()), $this$removeCell.getLineEndOffset(cell.getLastContentLine()));
        } else {
            $this$removeCell.deleteString(0, $this$removeCell.getLineStartOffset(cell.getLines().getLast() + 1));
        }
    }

    @NotNull
    public static final List<NotebookCellLines.Interval> replaceCell(@NotNull Document $this$replaceCell, @NotNull NotebookCellLines cellLines, @NotNull NotebookCellLines.Interval oldCell, @NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        Intrinsics.checkNotNullParameter((Object)oldCell, (String)"oldCell");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        int lineCountBefore = $this$replaceCell.getLineCount();
        $this$replaceCell.replaceString($this$replaceCell.getLineStartOffset(oldCell.getLines().getFirst()), $this$replaceCell.getLineEndOffset(oldCell.getLines().getLast()), (CharSequence)newText);
        int lineCountAfter = $this$replaceCell.getLineCount();
        return SequencesKt.toList((Sequence)NotebookVisualizationUiUtilKt.getCells((NotebookCellLines)cellLines, (IntRange)new IntRange(oldCell.getLines().getFirst(), oldCell.getLines().getLast() + lineCountAfter - lineCountBefore)));
    }

    @NotNull
    public static final List<NotebookCellLines.Interval> insertCells(@NotNull Document $this$insertCells, @NotNull NotebookCellLines cellLines, @NotNull String cellsText, int targetOrdinal, boolean shouldKeepEmptyCell) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$insertCells, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        Intrinsics.checkNotNullParameter((Object)cellsText, (String)"cellsText");
        int lineCountBefore = $this$insertCells.getLineCount();
        if (lineCountBefore == 0 && !shouldKeepEmptyCell) {
            $this$insertCells.insertString(0, (CharSequence)cellsText);
            return cellLines.getIntervals();
        }
        if (targetOrdinal == 0) {
            $this$insertCells.insertString(0, (CharSequence)(cellsText + "\n"));
            n = 0;
        } else {
            NotebookCellLines.Interval prevCell = (NotebookCellLines.Interval)cellLines.getIntervals().get(targetOrdinal - 1);
            $this$insertCells.insertString($this$insertCells.getLineEndOffset(prevCell.getLines().getLast()), (CharSequence)("\n" + cellsText));
            n = prevCell.getLines().getLast() + 1;
        }
        int firstLine = n;
        int lineCountAfter = $this$insertCells.getLineCount();
        return SequencesKt.toList((Sequence)NotebookVisualizationUiUtilKt.getCells((NotebookCellLines)cellLines, (IntRange)RangesKt.until((int)firstLine, (int)(firstLine + (lineCountAfter - lineCountBefore)))));
    }

    public static /* synthetic */ List insertCells$default(Document document, NotebookCellLines notebookCellLines, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return NotebookCellLinesActionUtilKt.insertCells(document, notebookCellLines, string, n, bl);
    }

    public static final void convertCells(@NotNull Editor editor, @NotNull NotebookCellLines cellLines, @NotNull NotebookCellSelectionModel cellSelection, @NotNull JupyterLangData newType) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        Intrinsics.checkNotNullParameter((Object)cellSelection, (String)"cellSelection");
        Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
        NotebookCellLinesEditHelper notebookCellLinesEditHelper = NotebookCellLinesEditHelper.Companion.get(editor);
        if (notebookCellLinesEditHelper == null) {
            return;
        }
        NotebookCellLinesEditHelper editHelper = notebookCellLinesEditHelper;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        List selectedCells = cellSelection.getSelectedCells();
        for (NotebookCellLines.Interval cell : CollectionsKt.reversed((Iterable)selectedCells)) {
            String headerSuffix;
            String string;
            if (JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType(cell) == newType.getJupyterCellType()) continue;
            CharSequence cellText = NotebookCellLinesUtilsKt.getContentText((Document)document2, (NotebookCellLines.Interval)cell);
            String it = string = newType.getHeaderSuffix();
            boolean bl = false;
            String string2 = headerSuffix = newType.getCellType() == NotebookCellLines.CellType.CODE ? string : null;
            String newText = editHelper.makeCell(((Object)cellText).toString(), newType.getCellType(), headerSuffix);
            if (newText == null) continue;
            editor.getCaretModel().runBatchCaretOperation(() -> NotebookCellLinesActionUtilKt.convertCells$lambda$21(document2, cellLines, cell, newText));
        }
    }

    private static final NotebookCellLines.Interval findNewPrimaryCell(Set<NotebookCellLines.Interval> removedCells, NotebookCellSelectionModel selectionModel, NotebookCellLines cellLines) {
        NotebookCellLines.Interval cellBeforePrimary;
        Object v1;
        block6: {
            Object v0;
            List allCells;
            NotebookCellLines.Interval currentPrimaryCell;
            block5: {
                if (removedCells.size() == cellLines.getIntervals().size()) {
                    return (NotebookCellLines.Interval)CollectionsKt.first((List)cellLines.getIntervals());
                }
                currentPrimaryCell = selectionModel.getPrimarySelectedCell();
                if (!removedCells.contains(selectionModel.getPrimarySelectedCell())) {
                    return currentPrimaryCell;
                }
                allCells = cellLines.getIntervals();
                Sequence $this$firstOrNull$iv = SequencesKt.drop((Sequence)SequencesKt.asSequence((Iterator)allCells.listIterator(currentPrimaryCell.getOrdinal())), (int)1);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    NotebookCellLines.Interval it = (NotebookCellLines.Interval)element$iv;
                    boolean bl = false;
                    if (!(!removedCells.contains(it))) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            NotebookCellLines.Interval cellAfterPrimary = v0;
            if (cellAfterPrimary != null) {
                return cellAfterPrimary;
            }
            Sequence $this$firstOrNull$iv = SequencesKt.drop((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.asReversed((List)allCells).listIterator(CollectionsKt.getLastIndex((List)allCells) - currentPrimaryCell.getOrdinal())), (int)1);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NotebookCellLines.Interval it = (NotebookCellLines.Interval)element$iv;
                boolean bl = false;
                if (!(!removedCells.contains(it))) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        NotebookCellLines.Interval interval = cellBeforePrimary = (NotebookCellLines.Interval)v1;
        Intrinsics.checkNotNull((Object)interval);
        return interval;
    }

    private static final void moveCarets$lambda$7(EditorImpl $editor, List $from, Map $paired) {
        for (Caret caret : $editor.getCaretModel().getAllCarets()) {
            NotebookCellLines.Interval toCell;
            NotebookCellLines.Interval fromCell;
            Object v1;
            LogicalPosition caretPos;
            int n;
            int n2;
            block2: {
                Intrinsics.checkNotNullExpressionValue((Object)caret.getLogicalPosition(), (String)"getLogicalPosition(...)");
                Iterable iterable = $from;
                for (Object t : iterable) {
                    NotebookCellLines.Interval it = (NotebookCellLines.Interval)t;
                    boolean bl = false;
                    IntRange intRange = it.getLines();
                    n2 = intRange.getFirst();
                    n = intRange.getLast();
                    int n3 = caretPos.line;
                    boolean bl2 = n2 <= n3 ? n3 <= n : false;
                    if (!bl2) continue;
                    v1 = t;
                    break block2;
                }
                v1 = null;
            }
            if ((NotebookCellLines.Interval)v1 == null) continue;
            boolean bl = false;
            if ((NotebookCellLines.Interval)$paired.get(fromCell) == null) continue;
            boolean bl3 = false;
            IntRange intRange = fromCell.getContentLines();
            int n4 = intRange.getFirst();
            n2 = intRange.getLast();
            n = caretPos.line;
            int shift = (n4 <= n ? n <= n2 : false) ? toCell.getFirstContentLine() - fromCell.getFirstContentLine() : toCell.getLines().getFirst() - fromCell.getLines().getFirst();
            caret.moveToLogicalPosition(new LogicalPosition(caretPos.line + shift, caretPos.column));
        }
    }

    private static final CharSequence mergeCells$lambda$11(DocumentEx $document, NotebookCellLines.Interval it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NotebookCellLinesUtilsKt.getContentText((Document)((Document)$document), (NotebookCellLines.Interval)it);
    }

    private static final CharSequence mergeCells$lambda$12(DocumentEx $document, NotebookCellLines.Interval it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NotebookCellLinesUtilsKt.getContentText((Document)((Document)$document), (NotebookCellLines.Interval)it);
    }

    private static final void convertCells$lambda$21(Document $document, NotebookCellLines $cellLines, NotebookCellLines.Interval $cell, String $newText) {
        NotebookCellLinesActionUtilKt.replaceCell($document, $cellLines, $cell, $newText);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ActionDestination.values().length];
            try {
                nArray[ActionDestination.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionDestination.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

