/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.actions.JupyterEditorActionBase;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParametersSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.connections.settings.ConfiguredServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0014\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/jupyter/actions/JupyterOpenNotebookInBrowserAction;", "Lcom/intellij/jupyter/core/jupyter/actions/JupyterEditorActionBase;", "<init>", "()V", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "e", "appendNotebookPath", "Ljava/net/URI;", "suffix", "", "isRemote", "", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "Companion", "intellij.jupyter.core"})
public final class JupyterOpenNotebookInBrowserAction
extends JupyterEditorActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object object = JupyterAnActionEventExtensionsKt.getEditor(event);
        if (object == null || (object = JupyterEditorExtensionsKt.getNotebookFileOrNull(object)) == null) {
            return;
        }
        Object jupyterFile = object;
        super.update(event);
        if (!event.getPresentation().isVisible()) {
            return;
        }
        JupyterNotebookSession notebookSession = JupyterRuntimeService.Companion.getInstance(project2).getNotebookSession((BackedNotebookVirtualFile)jupyterFile);
        event.getPresentation().setEnabled(this.isRemote((BackedNotebookVirtualFile)jupyterFile) || notebookSession != null);
        event.getPresentation().setText(event.getPresentation().isEnabled() ? JupyterBundle.message("action.JupyterOpenNotebookInBrowserAction.text", new Object[0]) : (this.isRemote((BackedNotebookVirtualFile)jupyterFile) ? JupyterBundle.message("action.JupyterOpenNotebookInBrowserAction.remote.not.started", new Object[0]) : JupyterBundle.message("action.JupyterOpenNotebookInBrowserAction.local.not.started", new Object[0])));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object object = JupyterAnActionEventExtensionsKt.getEditor(e);
        if (object == null || (object = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)object)) == null) {
            return;
        }
        Object jupyterFile = object;
        if (this.isRemote((BackedNotebookVirtualFile)jupyterFile)) {
            ConfiguredServerJupyterModuleConnectionSettings connectionSettings;
            VirtualFile virtualFile = jupyterFile.getOriginFile();
            Intrinsics.checkNotNull((Object)virtualFile, (String)"null cannot be cast to non-null type com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteVirtualFile");
            JupyterRemotePath remotePath = ((JupyterRemoteVirtualFile)virtualFile).getRemotePath();
            ConfiguredServerJupyterModuleConnectionSettings configuredServerJupyterModuleConnectionSettings = connectionSettings = JupyterConnectionParametersSettings.Companion.getInstance(project2).getConnectionSettingsForAuthority(remotePath.getAuthority());
            if (configuredServerJupyterModuleConnectionSettings != null) {
                ConfiguredServerJupyterModuleConnectionSettings $this$actionPerformed_u24lambda_u240 = configuredServerJupyterModuleConnectionSettings;
                boolean bl = false;
                uRI = $this$actionPerformed_u24lambda_u240.getAuthHandler().shareableUrl(this.appendNotebookPath($this$actionPerformed_u24lambda_u240.getUri(), remotePath.getJupyterPath()));
            } else {
                uRI = null;
            }
        } else {
            JupyterNotebookSession session = JupyterRuntimeService.Companion.getInstance(project2).getNotebookSession((BackedNotebookVirtualFile)jupyterFile);
            if (session == null) {
                LOG.warn("Can't open a notebook since no session is running");
                return;
            }
            JupyterConnectionParameters $this$actionPerformed_u24lambda_u241 = session.getJupyterServer().getConnectionParameters();
            boolean bl = false;
            uRI = $this$actionPerformed_u24lambda_u241.getAuthHandler().shareableUrl(this.appendNotebookPath($this$actionPerformed_u24lambda_u241.getLocation().getUri(), session.getPathFromRoot()));
        }
        URI uri = uRI;
        if (uri != null) {
            BrowserUtil.open((String)uri.toASCIIString());
        }
    }

    private final URI appendNotebookPath(URI $this$appendNotebookPath, String suffix) {
        URIBuilder uRIBuilder = new URIBuilder($this$appendNotebookPath);
        String string = $this$appendNotebookPath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        char[] cArray = new char[]{'/'};
        URI uRI = uRIBuilder.setPath(StringsKt.trimEnd((String)string, (char[])cArray) + "/notebooks/" + suffix).build();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"build(...)");
        return uRI;
    }

    private final boolean isRemote(BackedNotebookVirtualFile $this$isRemote) {
        return !$this$isRemote.getOriginFile().isInLocalFileSystem();
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jupyter/core/jupyter/actions/JupyterOpenNotebookInBrowserAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

