/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.actions;

import com.intellij.jupyter.core.core.api.NotebookDisposable;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.JupyterErrorHandlingUtilKt;
import com.intellij.jupyter.core.jupyter.actions.ActionLaunchData;
import com.intellij.jupyter.core.jupyter.actions.JupyterRestartKernelAction;
import com.intellij.jupyter.core.jupyter.actions.JupyterRestartKernelActionKt;
import com.intellij.jupyter.core.jupyter.actions.JupyterRestartKernelListener;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameterSettingsUtilsKt;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookOfflineSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookRuntimeSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookSessionSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.ManagedJupyterServerNotebookSessionSettings;
import com.intellij.jupyter.core.jupyter.connections.settings.ConfiguredServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.editor.JupyterActionsKt;
import com.intellij.jupyter.core.jupyter.editor.JupyterKernelManagementActionKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterKernelSpec;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerFinished;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerStarted;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerStarting;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerState;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerStopped;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.messages.MessageBus;
import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002\u001a$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\nH\u0002\u001a\u001c\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0002\u001a$\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u000e\b\u0006\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012H\u0086\b\u00f8\u0001\u0000\u001a\u001e\u0010\u0013\u001a\u00020\u0007*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0018"}, d2={"makeActionLaunchData", "Lcom/intellij/jupyter/core/jupyter/actions/ActionLaunchData;", "postActionClass", "Lkotlin/reflect/KClass;", "actionEvent", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "checkKernelAvailable", "", "e", "callback", "Lkotlin/Function1;", "", "restartKernelAndLaunchAction", "editor", "Lcom/intellij/openapi/editor/Editor;", "postRestartActionData", "restartKernel", "postRestartCallback", "Lkotlin/Function0;", "launchAction", "Lcom/intellij/openapi/actionSystem/ActionManager;", "actionData", "targetComponent", "Ljava/awt/Component;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterRestartKernelAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRestartKernelAction.kt\ncom/intellij/jupyter/core/jupyter/actions/JupyterRestartKernelActionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,217:1\n179#1,3:218\n182#1,2:222\n184#1,4:225\n209#1:229\n1863#2:221\n1864#2:224\n1863#2,2:230\n*S KotlinDebug\n*F\n+ 1 JupyterRestartKernelAction.kt\ncom/intellij/jupyter/core/jupyter/actions/JupyterRestartKernelActionKt\n*L\n162#1:218,3\n162#1:222,2\n162#1:225,4\n162#1:229\n162#1:221\n162#1:224\n181#1:230,2\n*E\n"})
public final class JupyterRestartKernelActionKt {
    private static final ActionLaunchData makeActionLaunchData(KClass<?> postActionClass, AnActionEvent actionEvent) {
        String string = postActionClass.getSimpleName();
        if (string == null) {
            return null;
        }
        String name = string;
        DataContext dataContext = actionEvent.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Object object = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        Component component2 = object != null && (object = object.getComponent()) != null ? (Component)object : (Component)actionEvent.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        return new ActionLaunchData(name, actionEvent, component2);
    }

    private static final void checkKernelAvailable(AnActionEvent e) {
        JupyterRestartKernelActionKt.checkKernelAvailable(e, (Function1<? super Boolean, Unit>)((Function1)arg_0 -> JupyterRestartKernelActionKt.checkKernelAvailable$lambda$0(e, arg_0)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void checkKernelAvailable(AnActionEvent e, Function1<? super Boolean, Unit> callback2) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        VirtualFile virtualFile = JupyterActionsKt.getVirtualFile(e);
        JupyterNotebookRuntimeSettings runtimeSettings = JupyterActionsKt.getJupyterNotebookRuntimeSettings(e);
        if (runtimeSettings == null) {
            List<JupyterKernelSpec> kernelSpecs = JupyterKernelManagementActionKt.getKernelSpecsForCurrentConnectionParameters(project2, virtualFile);
            Collection collection = kernelSpecs;
            callback2.invoke((Object)(!(collection == null || collection.isEmpty()) ? 1 : 0));
            return;
        } else {
            JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings = runtimeSettings;
            if (jupyterNotebookRuntimeSettings instanceof JupyterNotebookOfflineSettings) {
                JupyterRestartKernelActionKt.checkKernelAvailable$serverIsOffline(callback2);
                return;
            } else if (jupyterNotebookRuntimeSettings instanceof JupyterNotebookSessionSettings) {
                JupyterRestartKernelActionKt.checkKernelAvailable$serverIsOnline(callback2);
                return;
            } else {
                if (!(jupyterNotebookRuntimeSettings instanceof ManagedJupyterServerNotebookSessionSettings)) throw new NoWhenBranchMatchedException();
                JupyterServerState jupyterServerState = ((ManagedJupyterServerNotebookSessionSettings)runtimeSettings).getJupyterServerExecution().getState();
                if (Intrinsics.areEqual((Object)jupyterServerState, (Object)JupyterServerFinished.INSTANCE) || Intrinsics.areEqual((Object)jupyterServerState, (Object)JupyterServerStarting.INSTANCE) || Intrinsics.areEqual((Object)jupyterServerState, (Object)JupyterServerStopped.INSTANCE)) {
                    JupyterRestartKernelActionKt.checkKernelAvailable$serverIsOffline(callback2);
                    return;
                } else {
                    if (!(jupyterServerState instanceof JupyterServerStarted)) throw new NoWhenBranchMatchedException();
                    JupyterRestartKernelActionKt.checkKernelAvailable$serverIsOnline(callback2);
                }
            }
        }
    }

    private static final void restartKernelAndLaunchAction(Editor editor, ActionLaunchData postRestartActionData) {
        boolean $i$f$restartKernel = false;
        Project project = editor.getProject();
        if (project != null) {
            Project project$iv = project;
            BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull(editor);
            if (backedNotebookVirtualFile != null) {
                BackedNotebookVirtualFile jupyterVirtualFile$iv = backedNotebookVirtualFile;
                Iterable $this$forEach$iv$iv = jupyterVirtualFile$iv.getNotebook().computeCells();
                boolean $i$f$forEach = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    JupyterCell it$iv = (JupyterCell)element$iv$iv;
                    boolean bl = false;
                    it$iv.setExecuting(false);
                }
                MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
                Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
                MessageBus messageBus$iv = messageBus;
                ((JupyterRestartKernelListener)messageBus$iv.syncPublisher(JupyterRestartKernelListener.Companion.getTOPIC())).inActionPerformed(jupyterVirtualFile$iv);
                BuildersKt.launch$default((CoroutineScope)NotebookDisposable.Companion.forProject(project$iv), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project$iv, jupyterVirtualFile$iv, editor, null, postRestartActionData, editor){
                    int label;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ BackedNotebookVirtualFile $jupyterVirtualFile;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ ActionLaunchData $postRestartActionData$inlined;
                    final /* synthetic */ Editor $editor$inlined;
                    {
                        this.$project = $project;
                        this.$jupyterVirtualFile = $jupyterVirtualFile;
                        this.$editor = $editor;
                        this.$postRestartActionData$inlined = actionLaunchData;
                        this.$editor$inlined = editor;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = TasksKt.withBackgroundProgress((Project)this.$project, (String)JupyterBundle.message("jupyter.restart.kernel.action.progress.title", new Object[0]), (boolean)false, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$jupyterVirtualFile, this.$project, this.$editor, null, this.$postRestartActionData$inlined, this.$editor$inlined){
                                    Object L$0;
                                    Object L$1;
                                    Object L$2;
                                    Object L$3;
                                    Object L$4;
                                    Object L$5;
                                    int I$0;
                                    int label;
                                    final /* synthetic */ BackedNotebookVirtualFile $jupyterVirtualFile;
                                    final /* synthetic */ Project $project;
                                    final /* synthetic */ Editor $editor;
                                    final /* synthetic */ ActionLaunchData $postRestartActionData$inlined;
                                    final /* synthetic */ Editor $editor$inlined;
                                    {
                                        this.$jupyterVirtualFile = $jupyterVirtualFile;
                                        this.$project = $project;
                                        this.$editor = $editor;
                                        this.$postRestartActionData$inlined = actionLaunchData;
                                        this.$editor$inlined = editor;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object invokeSuspend(Object var1_1) {
                                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)var1_1);
                                                var3_3 = JupyterRestartKernelAction.Companion.getLOG();
                                                var4_4 = this.$jupyterVirtualFile;
                                                var5_5 = false;
                                                var6_6 = this.$project;
                                                var7_7 = this.$jupyterVirtualFile;
                                                var8_8 = this.$editor;
                                                $i$f$runHandlingConnectionErrors = false;
                                                $this$runHandlingConnectionErrors$iv$iv = $this$runHandlingConnectionErrors$iv;
                                                $i$f$runHandlingConnectionErrors = false;
                                                $i$a$-runHandlingConnectionErrors-JupyterRestartKernelActionKt$restartKernel$3$1$1 = false;
                                                runtimeService = JupyterRuntimeService.Companion.getInstance(var6_6);
                                                this.L$0 = virtualFile$iv;
                                                this.L$1 = var7_7;
                                                this.L$2 = var8_8;
                                                this.L$3 = $this$runHandlingConnectionErrors$iv$iv;
                                                this.L$4 = runtimeService;
                                                this.I$0 = suggestRemovingConnection$iv;
                                                this.label = 1;
                                                v0 = runtimeService.getOrCreateSession(var7_7, (Continuation<? super JupyterNotebookSession>)this);
                                                ** if (v0 != var2_2) goto lbl28
lbl27:
                                                // 1 sources

                                                return var2_2;
lbl28:
                                                // 1 sources

                                                ** GOTO lbl43
                                            }
                                            case 1: {
                                                $i$f$runHandlingConnectionErrors = false;
                                                $i$f$runHandlingConnectionErrors = false;
                                                $i$a$-runHandlingConnectionErrors-JupyterRestartKernelActionKt$restartKernel$3$1$1 = false;
                                                suggestRemovingConnection$iv = this.I$0;
                                                runtimeService = (JupyterRuntimeService)this.L$4;
                                                $this$runHandlingConnectionErrors$iv$iv = (Logger)this.L$3;
                                                var8_8 = (Editor)this.L$2;
                                                var7_7 = (BackedNotebookVirtualFile)this.L$1;
                                                virtualFile$iv = (BackedNotebookVirtualFile)this.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl43:
                                                // 2 sources

                                                session = (JupyterNotebookSession)v0;
                                                $i$a$-let-JupyterRestartKernelActionKt$restartKernel$3$1$1$1 = false;
                                                try {
                                                    session.getKernelClient().restart();
                                                }
                                                catch (Exception e) {
                                                    JupyterRestartKernelAction.Companion.getLOG().warn("Failed to restart Jupyter kernel", (Throwable)e);
                                                }
                                                runtimeService.clearRuntime(var8_8);
                                                this.L$0 = virtualFile$iv;
                                                this.L$1 = $this$runHandlingConnectionErrors$iv$iv;
                                                this.L$2 = null;
                                                this.L$3 = null;
                                                this.L$4 = null;
                                                this.I$0 = suggestRemovingConnection$iv;
                                                this.label = 2;
                                                v1 = runtimeService.getOrCreateSession(var7_7, (Continuation<? super JupyterNotebookSession>)this);
                                                ** if (v1 != var2_2) goto lbl65
lbl64:
                                                // 1 sources

                                                return var2_2;
lbl65:
                                                // 1 sources

                                                ** GOTO lbl77
                                            }
                                            case 2: {
                                                $i$f$runHandlingConnectionErrors = false;
                                                $i$f$runHandlingConnectionErrors = false;
                                                $i$a$-runHandlingConnectionErrors-JupyterRestartKernelActionKt$restartKernel$3$1$1 = false;
                                                suggestRemovingConnection$iv = this.I$0;
                                                $this$runHandlingConnectionErrors$iv$iv = (Logger)this.L$1;
                                                virtualFile$iv = (BackedNotebookVirtualFile)this.L$0;
                                                try {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v1 = $result;
lbl77:
                                                    // 2 sources

                                                    $i$a$-restartKernel-JupyterRestartKernelActionKt$restartKernelAndLaunchAction$1 = false;
                                                    if (this.$postRestartActionData$inlined != null) {
                                                        targetComponent = this.$postRestartActionData$inlined.getTargetComponent();
                                                        $i$a$-let-JupyterRestartKernelActionKt$restartKernelAndLaunchAction$1$1 = false;
                                                        if (!(targetComponent instanceof EditorComponentImpl) || !((EditorComponentImpl)targetComponent).getEditor().isDisposed()) {
                                                            BuildersKt.launch$default((CoroutineScope)NotebookDisposable.Companion.forProject(this.$editor$inlined.getProject()), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$postRestartActionData$inlined, null){
                                                                int label;
                                                                final /* synthetic */ ActionLaunchData $postRestartActionData;
                                                                {
                                                                    this.$postRestartActionData = $postRestartActionData;
                                                                    super(2, $completion);
                                                                }

                                                                /*
                                                                 * Unable to fully structure code
                                                                 */
                                                                public final Object invokeSuspend(Object var1_1) {
                                                                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                    switch (this.label) {
                                                                        case 0: {
                                                                            ResultKt.throwOnFailure((Object)var1_1);
                                                                            $i$f$serviceAsync = false;
                                                                            v0 = ApplicationManager.getApplication();
                                                                            Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                                                                            this.label = 1;
                                                                            v1 = ((ComponentManagerEx)v0).getServiceAsync(ActionManager.class, (Continuation)this);
                                                                            if (v1 == var4_2) {
                                                                                return var4_2;
                                                                            }
                                                                            ** GOTO lbl18
                                                                        }
                                                                        case 1: {
                                                                            $i$f$serviceAsync = false;
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            v1 = $result;
lbl18:
                                                                            // 2 sources

                                                                            actionManager = (ActionManager)v1;
                                                                            this.label = 2;
                                                                            v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(actionManager, this.$postRestartActionData, null){
                                                                                int label;
                                                                                final /* synthetic */ ActionManager $actionManager;
                                                                                final /* synthetic */ ActionLaunchData $postRestartActionData;
                                                                                {
                                                                                    this.$actionManager = $actionManager;
                                                                                    this.$postRestartActionData = $postRestartActionData;
                                                                                    super(2, $completion);
                                                                                }

                                                                                public final Object invokeSuspend(Object object) {
                                                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                                    switch (this.label) {
                                                                                        case 0: {
                                                                                            ResultKt.throwOnFailure((Object)object);
                                                                                            JupyterRestartKernelActionKt.access$launchAction(this.$actionManager, this.$postRestartActionData, this.$postRestartActionData.getTargetComponent());
                                                                                            return Unit.INSTANCE;
                                                                                        }
                                                                                    }
                                                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                                }

                                                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                                                }

                                                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                                                }
                                                                            }), (Continuation)((Continuation)this));
                                                                            if (v2 == var4_2) {
                                                                                return var4_2;
                                                                            }
                                                                            ** GOTO lbl27
                                                                        }
                                                                        case 2: {
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            v2 = $result;
lbl27:
                                                                            // 2 sources

                                                                            return Unit.INSTANCE;
                                                                        }
                                                                    }
                                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                }

                                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                                }

                                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                                }
                                                            }), (int)3, null);
                                                        }
                                                    }
                                                    var20_26 = Unit.INSTANCE;
                                                }
                                                catch (IOException e$iv$iv) {
                                                    $i$a$-runHandlingConnectionErrors-JupyterErrorHandlingUtilKt$runHandlingConnectionErrors$3$iv = false;
                                                    $this$asSafely$iv$iv = virtualFile$iv.getOriginFile();
                                                    $i$f$asSafely = false;
                                                    v2 = $this$asSafely$iv$iv;
                                                    if (!(v2 instanceof JupyterRemoteVirtualFile)) {
                                                        v2 = null;
                                                    }
                                                    if ((var25_35 = (JupyterRemoteVirtualFile)v2) != null && ($this$asSafely$iv$iv = var25_35.getRemotePath()) != null && ($i$f$asSafely = $this$asSafely$iv$iv.getAuthority()) != null) {
                                                        p0$iv = $i$f$asSafely;
                                                        $i$a$-let-JupyterErrorHandlingUtilKt$runHandlingConnectionErrors$3$1$iv = false;
                                                        $i$f$runHandlingConnectionErrors$lambda$2$stub_for_inlining = false;
                                                        v3 = JupyterConnectionParameterSettingsUtilsKt.getAnyConnectionSettingsForAuthority(p0$iv);
                                                    } else {
                                                        v3 = null;
                                                    }
                                                    if (v3 == null) {
                                                        throw e$iv$iv;
                                                    }
                                                    JupyterErrorHandlingUtilKt.suggestRemovingConnection(v3, suggestRemovingConnection$iv != 0);
                                                    var29_39 = $this$runHandlingConnectionErrors$iv$iv;
                                                    $i$a$-runHandlingConnectionErrors-JupyterErrorHandlingUtilKt$runHandlingConnectionErrors$3$iv = false;
                                                    $this$asSafely$iv$iv = virtualFile$iv.getOriginFile();
                                                    $i$f$asSafely = false;
                                                    v4 = $this$asSafely$iv$iv;
                                                    if (!(v4 instanceof JupyterRemoteVirtualFile)) {
                                                        v4 = null;
                                                    }
                                                    if ((var25_35 = (JupyterRemoteVirtualFile)v4) != null && (var23_30 = var25_35.getRemotePath()) != null && (var24_34 = var23_30.getAuthority()) != null) {
                                                        p0$iv = var24_34;
                                                        $i$a$-let-JupyterErrorHandlingUtilKt$runHandlingConnectionErrors$3$1$iv = false;
                                                        $i$f$runHandlingConnectionErrors$lambda$2$stub_for_inlining = false;
                                                        v5 = JupyterConnectionParameterSettingsUtilsKt.getAnyConnectionSettingsForAuthority(p0$iv);
                                                    } else {
                                                        v5 = null;
                                                    }
                                                    var29_39.warn("Unexpected exception for " + v5, (Throwable)e$iv$iv);
                                                    var20_27 = null;
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
    }

    static /* synthetic */ void restartKernelAndLaunchAction$default(Editor editor, ActionLaunchData actionLaunchData, int n, Object object) {
        if ((n & 2) != 0) {
            actionLaunchData = null;
        }
        JupyterRestartKernelActionKt.restartKernelAndLaunchAction(editor, actionLaunchData);
    }

    public static final void restartKernel(@NotNull Editor editor, @NotNull Function0<Unit> postRestartCallback) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(postRestartCallback, (String)"postRestartCallback");
        boolean $i$f$restartKernel = false;
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull(editor);
        if (backedNotebookVirtualFile == null) {
            return;
        }
        BackedNotebookVirtualFile jupyterVirtualFile = backedNotebookVirtualFile;
        Iterable $this$forEach$iv = jupyterVirtualFile.getNotebook().computeCells();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterCell it = (JupyterCell)element$iv;
            boolean bl = false;
            it.setExecuting(false);
        }
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        MessageBus messageBus2 = messageBus;
        ((JupyterRestartKernelListener)messageBus2.syncPublisher(JupyterRestartKernelListener.Companion.getTOPIC())).inActionPerformed(jupyterVirtualFile);
        BuildersKt.launch$default((CoroutineScope)NotebookDisposable.Companion.forProject(project2), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project2, jupyterVirtualFile, editor, postRestartCallback, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ BackedNotebookVirtualFile $jupyterVirtualFile;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Function0<Unit> $postRestartCallback;
            {
                this.$project = $project;
                this.$jupyterVirtualFile = $jupyterVirtualFile;
                this.$editor = $editor;
                this.$postRestartCallback = $postRestartCallback;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = TasksKt.withBackgroundProgress((Project)this.$project, (String)JupyterBundle.message("jupyter.restart.kernel.action.progress.title", new Object[0]), (boolean)false, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$jupyterVirtualFile, this.$project, this.$editor, this.$postRestartCallback, null){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            Object L$3;
                            Object L$4;
                            Object L$5;
                            int I$0;
                            int label;
                            final /* synthetic */ BackedNotebookVirtualFile $jupyterVirtualFile;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ Editor $editor;
                            final /* synthetic */ Function0<Unit> $postRestartCallback;
                            {
                                this.$jupyterVirtualFile = $jupyterVirtualFile;
                                this.$project = $project;
                                this.$editor = $editor;
                                this.$postRestartCallback = $postRestartCallback;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var27_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        var2_3 = JupyterRestartKernelAction.Companion.getLOG();
                                        var3_4 = this.$jupyterVirtualFile;
                                        var4_5 = false;
                                        var5_6 = this.$project;
                                        var6_7 = this.$jupyterVirtualFile;
                                        var7_8 = this.$editor;
                                        var8_9 = this.$postRestartCallback;
                                        $i$f$runHandlingConnectionErrors = false;
                                        $this$runHandlingConnectionErrors$iv$iv = $this$runHandlingConnectionErrors$iv;
                                        $i$f$runHandlingConnectionErrors = false;
                                        $i$a$-runHandlingConnectionErrors-JupyterRestartKernelActionKt$restartKernel$3$1$1 = false;
                                        runtimeService = JupyterRuntimeService.Companion.getInstance(var5_6);
                                        this.L$0 = virtualFile$iv;
                                        this.L$1 = var6_7;
                                        this.L$2 = var7_8;
                                        this.L$3 = var8_9;
                                        this.L$4 = $this$runHandlingConnectionErrors$iv$iv;
                                        this.L$5 = runtimeService;
                                        this.I$0 = suggestRemovingConnection$iv;
                                        this.label = 1;
                                        v0 = runtimeService.getOrCreateSession(var6_7, (Continuation<? super JupyterNotebookSession>)this);
                                        ** if (v0 != var27_2) goto lbl30
lbl29:
                                        // 1 sources

                                        return var27_2;
lbl30:
                                        // 1 sources

                                        ** GOTO lbl46
                                    }
                                    case 1: {
                                        $i$f$runHandlingConnectionErrors = false;
                                        $i$f$runHandlingConnectionErrors = false;
                                        $i$a$-runHandlingConnectionErrors-JupyterRestartKernelActionKt$restartKernel$3$1$1 = false;
                                        suggestRemovingConnection$iv = this.I$0;
                                        runtimeService = (JupyterRuntimeService)this.L$5;
                                        $this$runHandlingConnectionErrors$iv$iv = (Logger)this.L$4;
                                        var8_9 = (Function0)this.L$3;
                                        var7_8 = (Editor)this.L$2;
                                        var6_7 = (BackedNotebookVirtualFile)this.L$1;
                                        virtualFile$iv = (BackedNotebookVirtualFile)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl46:
                                        // 2 sources

                                        session = (JupyterNotebookSession)v0;
                                        $i$a$-let-JupyterRestartKernelActionKt$restartKernel$3$1$1$1 = false;
                                        try {
                                            session.getKernelClient().restart();
                                        }
                                        catch (Exception e) {
                                            JupyterRestartKernelAction.Companion.getLOG().warn("Failed to restart Jupyter kernel", (Throwable)e);
                                        }
                                        runtimeService.clearRuntime(var7_8);
                                        this.L$0 = virtualFile$iv;
                                        this.L$1 = var8_9;
                                        this.L$2 = $this$runHandlingConnectionErrors$iv$iv;
                                        this.L$3 = null;
                                        this.L$4 = null;
                                        this.L$5 = null;
                                        this.I$0 = suggestRemovingConnection$iv;
                                        this.label = 2;
                                        v1 = runtimeService.getOrCreateSession(var6_7, (Continuation<? super JupyterNotebookSession>)this);
                                        ** if (v1 != var27_2) goto lbl69
lbl68:
                                        // 1 sources

                                        return var27_2;
lbl69:
                                        // 1 sources

                                        ** GOTO lbl82
                                    }
                                    case 2: {
                                        $i$f$runHandlingConnectionErrors = false;
                                        $i$f$runHandlingConnectionErrors = false;
                                        $i$a$-runHandlingConnectionErrors-JupyterRestartKernelActionKt$restartKernel$3$1$1 = false;
                                        suggestRemovingConnection$iv = this.I$0;
                                        $this$runHandlingConnectionErrors$iv$iv = (Logger)this.L$2;
                                        var8_9 = (Function0<Unit>)this.L$1;
                                        virtualFile$iv = (BackedNotebookVirtualFile)this.L$0;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl82:
                                            // 2 sources

                                            var8_9.invoke();
                                            var17_24 = Unit.INSTANCE;
                                        }
                                        catch (IOException e$iv$iv) {
                                            $i$a$-runHandlingConnectionErrors-JupyterErrorHandlingUtilKt$runHandlingConnectionErrors$3$iv = false;
                                            $this$asSafely$iv$iv = virtualFile$iv.getOriginFile();
                                            $i$f$asSafely = false;
                                            v2 = $this$asSafely$iv$iv;
                                            if (!(v2 instanceof JupyterRemoteVirtualFile)) {
                                                v2 = null;
                                            }
                                            if ((var22_33 = (JupyterRemoteVirtualFile)v2) != null && ($this$asSafely$iv$iv = var22_33.getRemotePath()) != null && ($i$f$asSafely = $this$asSafely$iv$iv.getAuthority()) != null) {
                                                p0$iv = $i$f$asSafely;
                                                $i$a$-let-JupyterErrorHandlingUtilKt$runHandlingConnectionErrors$3$1$iv = false;
                                                $i$f$runHandlingConnectionErrors$lambda$2$stub_for_inlining = false;
                                                v3 = JupyterConnectionParameterSettingsUtilsKt.getAnyConnectionSettingsForAuthority(p0$iv);
                                            } else {
                                                v3 = null;
                                            }
                                            if (v3 == null) {
                                                throw e$iv$iv;
                                            }
                                            JupyterErrorHandlingUtilKt.suggestRemovingConnection(v3, suggestRemovingConnection$iv != 0);
                                            var26_37 = $this$runHandlingConnectionErrors$iv$iv;
                                            $i$a$-runHandlingConnectionErrors-JupyterErrorHandlingUtilKt$runHandlingConnectionErrors$3$iv = false;
                                            $this$asSafely$iv$iv = virtualFile$iv.getOriginFile();
                                            $i$f$asSafely = false;
                                            v4 = $this$asSafely$iv$iv;
                                            if (!(v4 instanceof JupyterRemoteVirtualFile)) {
                                                v4 = null;
                                            }
                                            if ((var22_33 = (JupyterRemoteVirtualFile)v4) != null && (var20_28 = var22_33.getRemotePath()) != null && (var21_32 = var20_28.getAuthority()) != null) {
                                                p0$iv = var21_32;
                                                $i$a$-let-JupyterErrorHandlingUtilKt$runHandlingConnectionErrors$3$1$iv = false;
                                                $i$f$runHandlingConnectionErrors$lambda$2$stub_for_inlining = false;
                                                v5 = JupyterConnectionParameterSettingsUtilsKt.getAnyConnectionSettingsForAuthority(p0$iv);
                                            } else {
                                                v5 = null;
                                            }
                                            var26_37.warn("Unexpected exception for " + v5, (Throwable)e$iv$iv);
                                            var17_25 = null;
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend$$forInline(Object $result) {
                                Unit unit;
                                void $this$runHandlingConnectionErrors$iv;
                                Logger logger = JupyterRestartKernelAction.Companion.getLOG();
                                BackedNotebookVirtualFile backedNotebookVirtualFile = this.$jupyterVirtualFile;
                                boolean bl = false;
                                Project project = this.$project;
                                BackedNotebookVirtualFile backedNotebookVirtualFile2 = this.$jupyterVirtualFile;
                                Editor editor = this.$editor;
                                Function0<Unit> function0 = this.$postRestartCallback;
                                boolean $i$f$runHandlingConnectionErrors = false;
                                void $this$runHandlingConnectionErrors$iv$iv = $this$runHandlingConnectionErrors$iv;
                                boolean $i$f$runHandlingConnectionErrors2 = false;
                                try {
                                    boolean bl2 = false;
                                    JupyterRuntimeService runtimeService = JupyterRuntimeService.Companion.getInstance(project);
                                    InlineMarker.mark((int)3);
                                    InlineMarker.mark((int)0);
                                    Object object = runtimeService.getOrCreateSession(backedNotebookVirtualFile2, null);
                                    InlineMarker.mark((int)1);
                                    Object object2 = object;
                                    JupyterNotebookSession session = (JupyterNotebookSession)object2;
                                    boolean bl3 = false;
                                    try {
                                        session.getKernelClient().restart();
                                    }
                                    catch (Exception e) {
                                        JupyterRestartKernelAction.Companion.getLOG().warn("Failed to restart Jupyter kernel", (Throwable)e);
                                    }
                                    runtimeService.clearRuntime(editor);
                                    InlineMarker.mark((int)3);
                                    InlineMarker.mark((int)0);
                                    runtimeService.getOrCreateSession(backedNotebookVirtualFile2, null);
                                    InlineMarker.mark((int)1);
                                    function0.invoke();
                                    unit = Unit.INSTANCE;
                                }
                                catch (IOException e$iv$iv) {
                                    ConfiguredServerJupyterModuleConnectionSettings configuredServerJupyterModuleConnectionSettings;
                                    String string;
                                    void suggestRemovingConnection$iv;
                                    ConfiguredServerJupyterModuleConnectionSettings configuredServerJupyterModuleConnectionSettings2;
                                    boolean $i$f$runHandlingConnectionErrors$lambda$2$stub_for_inlining;
                                    boolean bl4;
                                    String p0$iv;
                                    JupyterRemoteVirtualFile jupyterRemoteVirtualFile;
                                    JupyterRemotePath $this$asSafely$iv$iv;
                                    void virtualFile$iv;
                                    boolean bl5 = false;
                                    VirtualFile virtualFile = virtualFile$iv.getOriginFile();
                                    boolean $i$f$asSafely = false;
                                    JupyterRemotePath jupyterRemotePath = $this$asSafely$iv$iv;
                                    if (!(jupyterRemotePath instanceof JupyterRemoteVirtualFile)) {
                                        jupyterRemotePath = null;
                                    }
                                    if ((jupyterRemoteVirtualFile = (JupyterRemoteVirtualFile)jupyterRemotePath) != null && ($this$asSafely$iv$iv = jupyterRemoteVirtualFile.getRemotePath()) != null && ($i$f$asSafely = $this$asSafely$iv$iv.getAuthority()) != null) {
                                        p0$iv = $i$f$asSafely;
                                        bl4 = false;
                                        $i$f$runHandlingConnectionErrors$lambda$2$stub_for_inlining = false;
                                        configuredServerJupyterModuleConnectionSettings2 = JupyterConnectionParameterSettingsUtilsKt.getAnyConnectionSettingsForAuthority(p0$iv);
                                    } else {
                                        configuredServerJupyterModuleConnectionSettings2 = null;
                                    }
                                    ConfiguredServerJupyterModuleConnectionSettings configuredServerJupyterModuleConnectionSettings3 = configuredServerJupyterModuleConnectionSettings2;
                                    if (configuredServerJupyterModuleConnectionSettings3 == null) {
                                        throw e$iv$iv;
                                    }
                                    JupyterErrorHandlingUtilKt.suggestRemovingConnection(configuredServerJupyterModuleConnectionSettings3, (boolean)suggestRemovingConnection$iv);
                                    void var27_30 = $this$runHandlingConnectionErrors$iv$iv;
                                    bl5 = false;
                                    $this$asSafely$iv$iv = virtualFile$iv.getOriginFile();
                                    $i$f$asSafely = false;
                                    JupyterRemotePath jupyterRemotePath2 = $this$asSafely$iv$iv;
                                    if (!(jupyterRemotePath2 instanceof JupyterRemoteVirtualFile)) {
                                        jupyterRemotePath2 = null;
                                    }
                                    if ((jupyterRemoteVirtualFile = (JupyterRemoteVirtualFile)jupyterRemotePath2) != null && (virtualFile = jupyterRemoteVirtualFile.getRemotePath()) != null && (string = virtualFile.getAuthority()) != null) {
                                        p0$iv = string;
                                        bl4 = false;
                                        $i$f$runHandlingConnectionErrors$lambda$2$stub_for_inlining = false;
                                        configuredServerJupyterModuleConnectionSettings = JupyterConnectionParameterSettingsUtilsKt.getAnyConnectionSettingsForAuthority(p0$iv);
                                    } else {
                                        configuredServerJupyterModuleConnectionSettings = null;
                                    }
                                    var27_30.warn("Unexpected exception for " + configuredServerJupyterModuleConnectionSettings, (Throwable)e$iv$iv);
                                    unit = null;
                                }
                                return Unit.INSTANCE;
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invokeSuspend$$forInline(Object $result) {
                String string = JupyterBundle.message("jupyter.restart.kernel.action.progress.title", new Object[0]);
                Function2 function2 = (Function2)new /* invalid duplicate definition of identical inner class */;
                Continuation continuation = (Continuation)this;
                InlineMarker.mark((int)0);
                TasksKt.withBackgroundProgress((Project)this.$project, (String)string, (boolean)false, (Function2)function2, (Continuation)continuation);
                InlineMarker.mark((int)1);
                return Unit.INSTANCE;
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void restartKernel$default(Editor editor, Function0 postRestartCallback, int n, Object object) {
        if ((n & 2) != 0) {
            postRestartCallback = restartKernel.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)postRestartCallback, (String)"postRestartCallback");
        boolean $i$f$restartKernel = false;
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull(editor);
        if (backedNotebookVirtualFile == null) {
            return;
        }
        BackedNotebookVirtualFile jupyterVirtualFile = backedNotebookVirtualFile;
        Iterable $this$forEach$iv = jupyterVirtualFile.getNotebook().computeCells();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterCell it = (JupyterCell)element$iv;
            boolean bl = false;
            it.setExecuting(false);
        }
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        MessageBus messageBus2 = messageBus;
        ((JupyterRestartKernelListener)messageBus2.syncPublisher(JupyterRestartKernelListener.Companion.getTOPIC())).inActionPerformed(jupyterVirtualFile);
        BuildersKt.launch$default((CoroutineScope)NotebookDisposable.Companion.forProject(project2), null, null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)3, null);
    }

    private static final void launchAction(ActionManager $this$launchAction, ActionLaunchData actionData, Component targetComponent) {
        AnAction anAction = $this$launchAction.getAction(actionData.getActionId());
        if (anAction == null) {
            return;
        }
        AnAction action = anAction;
        $this$launchAction.tryToExecute(action, actionData.getActionEvent().getInputEvent(), targetComponent, actionData.getActionEvent().getPlace(), true);
    }

    private static final Unit checkKernelAvailable$lambda$0(AnActionEvent $e, boolean it) {
        $e.getPresentation().setEnabled(it);
        if (Intrinsics.areEqual((Object)$e.getPlace(), (Object)"ProjectViewPopup")) {
            $e.getPresentation().setVisible(it);
        }
        return Unit.INSTANCE;
    }

    private static final void checkKernelAvailable$serverIsOffline(Function1<? super Boolean, Unit> $callback) {
        $callback.invoke((Object)false);
    }

    private static final void checkKernelAvailable$serverIsOnline(Function1<? super Boolean, Unit> $callback) {
        $callback.invoke((Object)true);
    }

    public static final /* synthetic */ void access$checkKernelAvailable(AnActionEvent e) {
        JupyterRestartKernelActionKt.checkKernelAvailable(e);
    }

    public static final /* synthetic */ void access$checkKernelAvailable(AnActionEvent e, Function1 callback2) {
        JupyterRestartKernelActionKt.checkKernelAvailable(e, (Function1<? super Boolean, Unit>)callback2);
    }

    public static final /* synthetic */ void access$restartKernelAndLaunchAction(Editor editor, ActionLaunchData postRestartActionData) {
        JupyterRestartKernelActionKt.restartKernelAndLaunchAction(editor, postRestartActionData);
    }

    public static final /* synthetic */ ActionLaunchData access$makeActionLaunchData(KClass postActionClass, AnActionEvent actionEvent) {
        return JupyterRestartKernelActionKt.makeActionLaunchData(postActionClass, actionEvent);
    }

    public static final /* synthetic */ void access$launchAction(ActionManager $receiver, ActionLaunchData actionData, Component targetComponent) {
        JupyterRestartKernelActionKt.launchAction($receiver, actionData, targetComponent);
    }
}

