/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.actions.utils;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterDebugNotificationGroupProvider;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterDebugSessionManager;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterSessionPath;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/actions/utils/JupyterDebugger;", "", "<init>", "()V", "isUnderDebugger", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "showWarningIfUnderDebugger", "file", "intellij.jupyter.core"})
public final class JupyterDebugger {
    @NotNull
    public static final JupyterDebugger INSTANCE = new JupyterDebugger();

    private JupyterDebugger() {
    }

    public final boolean isUnderDebugger(@NotNull Project project, @NotNull BackedNotebookVirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (project.isDisposed()) {
            return false;
        }
        return JupyterDebugSessionManager.Companion.getInstance(project).isSessionUnderDebug-MgfaZcY(JupyterSessionPath.constructor-impl(virtualFile));
    }

    public final boolean showWarningIfUnderDebugger(@NotNull Project project, @NotNull BackedNotebookVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.isUnderDebugger(project, file)) {
            NotificationGroup notificationGroup = JupyterDebugNotificationGroupProvider.Companion.getNotificationGroup(file);
            if (notificationGroup == null) {
                return true;
            }
            NotificationGroup notificationGroup2 = notificationGroup;
            notificationGroup2.createNotification(JupyterBundle.message("Jupyter.debugger.other.cell.under.debugger.warning", new Object[0]), NotificationType.ERROR).notify(project);
            return true;
        }
        return false;
    }
}

