/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.actions.utils;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.markdown.MarkdownEditorCell;
import com.intellij.jupyter.core.editor.settings.JupyterDSSettings;
import com.intellij.jupyter.core.jupyter.actions.CellRunMode;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionQueueManager;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionTask;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterTaskExecutorProvider;
import com.intellij.jupyter.core.jupyter.connections.ui.JupyterErrorReporter;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListenersKt;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellLinesUtilsKt;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u000e\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/jupyter/actions/utils/JupyterRunner;", "", "<init>", "()V", "runCells", "", "project", "Lcom/intellij/openapi/project/Project;", "cellsPointers", "", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "cellRunMode", "Lcom/intellij/jupyter/core/jupyter/actions/CellRunMode;", "overrideVirtualFileForSession", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRunner.kt\ncom/intellij/jupyter/core/jupyter/actions/utils/JupyterRunner\n+ 2 EditorCell.kt\ncom/intellij/notebooks/visualization/ui/EditorCell\n*L\n1#1,61:1\n139#2:62\n*S KotlinDebug\n*F\n+ 1 JupyterRunner.kt\ncom/intellij/jupyter/core/jupyter/actions/utils/JupyterRunner\n*L\n55#1:62\n*E\n"})
public final class JupyterRunner {
    @NotNull
    public static final JupyterRunner INSTANCE = new JupyterRunner();

    private JupyterRunner() {
    }

    public final void runCells(@NotNull Project project, @NotNull List<? extends NotebookIntervalPointer> cellsPointers, @NotNull Editor editor, @NotNull BackedNotebookVirtualFile notebookVirtualFile, @NotNull CellRunMode cellRunMode, @NotNull BackedNotebookVirtualFile overrideVirtualFileForSession) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(cellsPointers, (String)"cellsPointers");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile, (String)"notebookVirtualFile");
        Intrinsics.checkNotNullParameter((Object)((Object)cellRunMode), (String)"cellRunMode");
        Intrinsics.checkNotNullParameter((Object)overrideVirtualFileForSession, (String)"overrideVirtualFileForSession");
        ThreadingAssertions.assertReadAccess();
        if (editor.getEditorKind() == EditorKind.DIFF) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        JupyterExecutionQueueManager queue = JupyterExecutionQueueManager.Companion.getInstance(project);
        for (NotebookIntervalPointer notebookIntervalPointer : cellsPointers) {
            NotebookCellLines.Interval interval = notebookIntervalPointer.get();
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            List<JupyterExecutionTask> alternativeExecutorTasks = JupyterTaskExecutorProvider.INSTANCE.createTasksIfApplicable(project, notebookVirtualFile, document, notebookIntervalPointer);
            if (alternativeExecutorTasks != null) {
                JupyterExecutionQueueManager.submitTasksAndStart$default(queue, alternativeExecutorTasks, false, 2, null);
            } else {
                NotebookCellLines.Interval interval2 = interval;
                if ((interval2 != null ? interval2.getType() : null) == NotebookCellLines.CellType.CODE) {
                    Document document2 = editor.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
                    String code = NotebookCellLinesUtilsKt.getContentText((Document)document2, (NotebookCellLines.Interval)interval) + "\n";
                    JupyterExecutionTask task2 = new JupyterExecutionTask(code, JupyterExecutionTask.Options.Companion.cellExecution(notebookIntervalPointer), arg_0 -> JupyterRunner.runCells$lambda$0(project, arg_0), null, notebookVirtualFile, overrideVirtualFileForSession, project, null, null, 392, null);
                    JupyterExecutionQueueManager.submitTask$default(queue, task2, true, false, 4, null);
                } else {
                    Object object;
                    NotebookCellLines.Interval interval3 = interval;
                    if ((interval3 != null ? interval3.getType() : null) == NotebookCellLines.CellType.MARKDOWN && !JupyterDSSettings.Companion.getInstance().getAutoRunMarkdownCellOnFocusLeave() && (object = NotebookCellInlayManager.Companion.get(editor)) != null && (object = object.getCell(notebookIntervalPointer)) != null) {
                        NotebookCellInlayManager this_$iv = object;
                        boolean $i$f$getExtension = false;
                        object = (MarkdownEditorCell)this_$iv.getExtension(Reflection.getOrCreateKotlinClass(MarkdownEditorCell.class));
                        if (object != null && (object = ((MarkdownEditorCell)object).getRendered()) != null) {
                            object.set((Object)true);
                        }
                    }
                }
            }
            JupyterListenersKt.cellExecuted(notebookVirtualFile.getNotebook(), notebookIntervalPointer, cellRunMode);
        }
        queue.startExecution(notebookVirtualFile);
    }

    public static /* synthetic */ void runCells$default(JupyterRunner jupyterRunner, Project project, List list, Editor editor, BackedNotebookVirtualFile backedNotebookVirtualFile, CellRunMode cellRunMode, BackedNotebookVirtualFile backedNotebookVirtualFile2, int n, Object object) {
        if ((n & 0x10) != 0) {
            cellRunMode = CellRunMode.RUN;
        }
        if ((n & 0x20) != 0) {
            backedNotebookVirtualFile2 = backedNotebookVirtualFile;
        }
        jupyterRunner.runCells(project, list, editor, backedNotebookVirtualFile, cellRunMode, backedNotebookVirtualFile2);
    }

    private static final Unit runCells$lambda$0(Project $project, Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JupyterErrorReporter.Companion.displayAndLogError($project, e);
        return Unit.INSTANCE;
    }
}

