/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.execution.callbacks;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterCellOutputUtils;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionTask;
import com.intellij.jupyter.core.jupyter.connections.execution.MessageTracker;
import com.intellij.jupyter.core.jupyter.connections.execution.callbacks.JupyterExecutionCallbackData;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterExecutionCallbackAdapter;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterClearOutputMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterExecutionState;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessageChannel;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessageHeader;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterStatusMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.inlays.progress.JupyterInlayProgressStatusManager;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListenersKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputs;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputsBase;
import com.intellij.jupyter.core.jupyter.nbformat.schema.v4.V4JupyterOutputSchema;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerConcurrentMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThrowableRunnable;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\u0010\u0010\t\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0019\u0010\u0018\u001a\u00020\u00192\u000e\b\u0004\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0082\bJ\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0019H\u0016J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\"H\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/execution/callbacks/JupyterCellOutputUpdateCallback;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterExecutionCallbackAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "task", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionTask;", "taskId", "", "Lcom/intellij/jupyter/core/jupyter/connections/execution/TaskId;", "lastTaskIdForCell", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointerConcurrentMap;", "lastStoppedTimeForCell", "Ljava/time/ZonedDateTime;", "shouldClearCellsMap", "", "messageTracker", "Lcom/intellij/jupyter/core/jupyter/connections/execution/MessageTracker;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionTask;ILcom/intellij/notebooks/visualization/NotebookIntervalPointerConcurrentMap;Lcom/intellij/notebooks/visualization/NotebookIntervalPointerConcurrentMap;Lcom/intellij/notebooks/visualization/NotebookIntervalPointerConcurrentMap;Lcom/intellij/jupyter/core/jupyter/connections/execution/MessageTracker;)V", "channel", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageChannel;", "getChannel", "()Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageChannel;", "expired", "defer", "", "runnable", "Lkotlin/Function0;", "onUpdateOutput", "message", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "onDisplayData", "onClearOutput", "onStatus", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterStatusMessage;", "expire", "onBusyStatus", "clearOutputs", "data", "Lcom/intellij/jupyter/core/jupyter/connections/execution/callbacks/JupyterExecutionCallbackData;", "updateNotebook", "updateAsyncOutputState", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterCellOutputUpdateCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterCellOutputUpdateCallback.kt\ncom/intellij/jupyter/core/jupyter/connections/execution/callbacks/JupyterCellOutputUpdateCallback\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n41#1,3:140\n41#1,3:143\n41#1,3:146\n1#2:139\n*S KotlinDebug\n*F\n+ 1 JupyterCellOutputUpdateCallback.kt\ncom/intellij/jupyter/core/jupyter/connections/execution/callbacks/JupyterCellOutputUpdateCallback\n*L\n45#1:140,3\n49#1:143,3\n53#1:146,3\n*E\n"})
public final class JupyterCellOutputUpdateCallback
extends JupyterExecutionCallbackAdapter {
    @NotNull
    private final Project project;
    @NotNull
    private final JupyterExecutionTask task;
    private final int taskId;
    @NotNull
    private final NotebookIntervalPointerConcurrentMap<Integer> lastTaskIdForCell;
    @NotNull
    private final NotebookIntervalPointerConcurrentMap<ZonedDateTime> lastStoppedTimeForCell;
    @NotNull
    private final NotebookIntervalPointerConcurrentMap<Boolean> shouldClearCellsMap;
    @NotNull
    private final MessageTracker messageTracker;
    @NotNull
    private final JupyterMessageChannel channel;
    private volatile boolean expired;

    public JupyterCellOutputUpdateCallback(@NotNull Project project, @NotNull JupyterExecutionTask task2, int taskId, @NotNull NotebookIntervalPointerConcurrentMap<Integer> lastTaskIdForCell, @NotNull NotebookIntervalPointerConcurrentMap<ZonedDateTime> lastStoppedTimeForCell, @NotNull NotebookIntervalPointerConcurrentMap<Boolean> shouldClearCellsMap, @NotNull MessageTracker messageTracker) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter(lastTaskIdForCell, (String)"lastTaskIdForCell");
        Intrinsics.checkNotNullParameter(lastStoppedTimeForCell, (String)"lastStoppedTimeForCell");
        Intrinsics.checkNotNullParameter(shouldClearCellsMap, (String)"shouldClearCellsMap");
        Intrinsics.checkNotNullParameter((Object)messageTracker, (String)"messageTracker");
        this.project = project;
        this.task = task2;
        this.taskId = taskId;
        this.lastTaskIdForCell = lastTaskIdForCell;
        this.lastStoppedTimeForCell = lastStoppedTimeForCell;
        this.shouldClearCellsMap = shouldClearCellsMap;
        this.messageTracker = messageTracker;
        if (!(this.task.getOptions().getCellPointer() != null)) {
            boolean bl = false;
            String string = "Jupyter task without cell couldn't update output";
            throw new IllegalArgumentException(string.toString());
        }
        this.channel = JupyterMessageChannel.IOPUB;
    }

    @Override
    @NotNull
    public JupyterMessageChannel getChannel() {
        return this.channel;
    }

    private final void defer(Function0<Unit> runnable) {
        boolean $i$f$defer = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(this, runnable){
            final /* synthetic */ JupyterCellOutputUpdateCallback this$0;
            final /* synthetic */ Function0<Unit> $runnable;
            {
                this.this$0 = $receiver;
                this.$runnable = $runnable;
            }

            public final void run() {
                if (!JupyterCellOutputUpdateCallback.access$getExpired$p(this.this$0)) {
                    this.$runnable.invoke();
                }
            }
        });
    }

    @Override
    public void onUpdateOutput(@NotNull JupyterMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        JupyterCellOutputUpdateCallback this_$iv = this;
        boolean $i$f$defer = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(this_$iv, this, message2){
            final /* synthetic */ JupyterCellOutputUpdateCallback this$0$inline_fun;
            final /* synthetic */ JupyterCellOutputUpdateCallback this$0;
            final /* synthetic */ JupyterMessage $message$inlined;
            {
                this.this$0$inline_fun = $receiver;
                this.this$0 = jupyterCellOutputUpdateCallback;
                this.$message$inlined = jupyterMessage;
            }

            /*
             * WARNING - void declaration
             */
            public final void run() {
                if (!JupyterCellOutputUpdateCallback.access$getExpired$p(this.this$0$inline_fun)) {
                    void taskId$iv;
                    void task$iv;
                    boolean bl = false;
                    JupyterCellOutputUtils jupyterCellOutputUtils = JupyterCellOutputUtils.INSTANCE;
                    JupyterExecutionTask jupyterExecutionTask = JupyterCellOutputUpdateCallback.access$getTask$p(this.this$0);
                    int n = JupyterCellOutputUpdateCallback.access$getTaskId$p(this.this$0);
                    NotebookIntervalPointerConcurrentMap lastTaskIdForCell$iv = JupyterCellOutputUpdateCallback.access$getLastTaskIdForCell$p(this.this$0);
                    boolean $i$f$updateCell$intellij_jupyter_core = false;
                    WriteAction.run((ThrowableRunnable)new ThrowableRunnable((JupyterExecutionTask)task$iv, lastTaskIdForCell$iv, (int)taskId$iv, this.$message$inlined, this.this$0){
                        final /* synthetic */ JupyterExecutionTask $task;
                        final /* synthetic */ NotebookIntervalPointerConcurrentMap $lastTaskIdForCell;
                        final /* synthetic */ int $taskId;
                        final /* synthetic */ JupyterMessage $message;
                        final /* synthetic */ JupyterCellOutputUpdateCallback $receiver$inlined;
                        {
                            this.$task = $task;
                            this.$lastTaskIdForCell = $lastTaskIdForCell;
                            this.$taskId = $taskId;
                            this.$message = $message;
                            this.$receiver$inlined = jupyterCellOutputUpdateCallback;
                        }

                        public final void run() {
                            Project project = this.$task.getProject();
                            if (!(this.$task.getOptions().getCellPointer() != null)) {
                                boolean $i$a$-require-JupyterCellOutputUtils$updateCell$1$22 = false;
                                String $i$a$-require-JupyterCellOutputUtils$updateCell$1$22 = "Jupyter task without cell couldn't update output";
                                throw new IllegalArgumentException($i$a$-require-JupyterCellOutputUtils$updateCell$1$22.toString());
                            }
                            if (this.$task.isValid() && project != null) {
                                JupyterExecutionCallbackData updateData;
                                Integer n = (Integer)this.$lastTaskIdForCell.get(this.$task.getOptions().getCellPointer());
                                int $i$a$-require-JupyterCellOutputUtils$updateCell$1$22 = this.$taskId;
                                boolean isLastTaskForCell = n != null && n == $i$a$-require-JupyterCellOutputUtils$updateCell$1$22;
                                JupyterExecutionCallbackData p0 = updateData = new JupyterExecutionCallbackData(this.$task, this.$message, project, isLastTaskForCell);
                                boolean bl = false;
                                boolean $i$f$onUpdateOutput$lambda$1$stub_for_inlining = false;
                                JupyterCellOutputUpdateCallback.access$updateNotebook(this.$receiver$inlined, p0);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public void onDisplayData(@NotNull JupyterMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        JupyterCellOutputUpdateCallback this_$iv = this;
        boolean $i$f$defer = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(this_$iv, this, message2){
            final /* synthetic */ JupyterCellOutputUpdateCallback this$0$inline_fun;
            final /* synthetic */ JupyterCellOutputUpdateCallback this$0;
            final /* synthetic */ JupyterMessage $message$inlined;
            {
                this.this$0$inline_fun = $receiver;
                this.this$0 = jupyterCellOutputUpdateCallback;
                this.$message$inlined = jupyterMessage;
            }

            /*
             * WARNING - void declaration
             */
            public final void run() {
                if (!JupyterCellOutputUpdateCallback.access$getExpired$p(this.this$0$inline_fun)) {
                    void taskId$iv;
                    void task$iv;
                    boolean bl = false;
                    JupyterCellOutputUtils jupyterCellOutputUtils = JupyterCellOutputUtils.INSTANCE;
                    JupyterExecutionTask jupyterExecutionTask = JupyterCellOutputUpdateCallback.access$getTask$p(this.this$0);
                    int n = JupyterCellOutputUpdateCallback.access$getTaskId$p(this.this$0);
                    NotebookIntervalPointerConcurrentMap lastTaskIdForCell$iv = JupyterCellOutputUpdateCallback.access$getLastTaskIdForCell$p(this.this$0);
                    boolean $i$f$updateCell$intellij_jupyter_core = false;
                    WriteAction.run((ThrowableRunnable)new ThrowableRunnable((JupyterExecutionTask)task$iv, lastTaskIdForCell$iv, (int)taskId$iv, this.$message$inlined, this.this$0){
                        final /* synthetic */ JupyterExecutionTask $task;
                        final /* synthetic */ NotebookIntervalPointerConcurrentMap $lastTaskIdForCell;
                        final /* synthetic */ int $taskId;
                        final /* synthetic */ JupyterMessage $message;
                        final /* synthetic */ JupyterCellOutputUpdateCallback $receiver$inlined;
                        {
                            this.$task = $task;
                            this.$lastTaskIdForCell = $lastTaskIdForCell;
                            this.$taskId = $taskId;
                            this.$message = $message;
                            this.$receiver$inlined = jupyterCellOutputUpdateCallback;
                        }

                        public final void run() {
                            Project project = this.$task.getProject();
                            if (!(this.$task.getOptions().getCellPointer() != null)) {
                                boolean $i$a$-require-JupyterCellOutputUtils$updateCell$1$22 = false;
                                String $i$a$-require-JupyterCellOutputUtils$updateCell$1$22 = "Jupyter task without cell couldn't update output";
                                throw new IllegalArgumentException($i$a$-require-JupyterCellOutputUtils$updateCell$1$22.toString());
                            }
                            if (this.$task.isValid() && project != null) {
                                JupyterExecutionCallbackData updateData;
                                Integer n = (Integer)this.$lastTaskIdForCell.get(this.$task.getOptions().getCellPointer());
                                int $i$a$-require-JupyterCellOutputUtils$updateCell$1$22 = this.$taskId;
                                boolean isLastTaskForCell = n != null && n == $i$a$-require-JupyterCellOutputUtils$updateCell$1$22;
                                JupyterExecutionCallbackData p0 = updateData = new JupyterExecutionCallbackData(this.$task, this.$message, project, isLastTaskForCell);
                                boolean bl = false;
                                boolean $i$f$onDisplayData$lambda$3$stub_for_inlining$2 = false;
                                JupyterCellOutputUpdateCallback.access$updateNotebook(this.$receiver$inlined, p0);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public void onClearOutput(@NotNull JupyterMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        JupyterCellOutputUpdateCallback this_$iv = this;
        boolean $i$f$defer = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(this_$iv, this, message2){
            final /* synthetic */ JupyterCellOutputUpdateCallback this$0$inline_fun;
            final /* synthetic */ JupyterCellOutputUpdateCallback this$0;
            final /* synthetic */ JupyterMessage $message$inlined;
            {
                this.this$0$inline_fun = $receiver;
                this.this$0 = jupyterCellOutputUpdateCallback;
                this.$message$inlined = jupyterMessage;
            }

            /*
             * WARNING - void declaration
             */
            public final void run() {
                if (!JupyterCellOutputUpdateCallback.access$getExpired$p(this.this$0$inline_fun)) {
                    void taskId$iv;
                    void task$iv;
                    boolean bl = false;
                    JupyterCellOutputUtils jupyterCellOutputUtils = JupyterCellOutputUtils.INSTANCE;
                    JupyterExecutionTask jupyterExecutionTask = JupyterCellOutputUpdateCallback.access$getTask$p(this.this$0);
                    int n = JupyterCellOutputUpdateCallback.access$getTaskId$p(this.this$0);
                    NotebookIntervalPointerConcurrentMap lastTaskIdForCell$iv = JupyterCellOutputUpdateCallback.access$getLastTaskIdForCell$p(this.this$0);
                    boolean $i$f$updateCell$intellij_jupyter_core = false;
                    WriteAction.run((ThrowableRunnable)new ThrowableRunnable((JupyterExecutionTask)task$iv, lastTaskIdForCell$iv, (int)taskId$iv, this.$message$inlined, this.this$0){
                        final /* synthetic */ JupyterExecutionTask $task;
                        final /* synthetic */ NotebookIntervalPointerConcurrentMap $lastTaskIdForCell;
                        final /* synthetic */ int $taskId;
                        final /* synthetic */ JupyterMessage $message;
                        final /* synthetic */ JupyterCellOutputUpdateCallback this$0;
                        {
                            this.$task = $task;
                            this.$lastTaskIdForCell = $lastTaskIdForCell;
                            this.$taskId = $taskId;
                            this.$message = $message;
                            this.this$0 = jupyterCellOutputUpdateCallback;
                        }

                        public final void run() {
                            Project project = this.$task.getProject();
                            if (!(this.$task.getOptions().getCellPointer() != null)) {
                                boolean $i$a$-require-JupyterCellOutputUtils$updateCell$1$22 = false;
                                String $i$a$-require-JupyterCellOutputUtils$updateCell$1$22 = "Jupyter task without cell couldn't update output";
                                throw new IllegalArgumentException($i$a$-require-JupyterCellOutputUtils$updateCell$1$22.toString());
                            }
                            if (this.$task.isValid() && project != null) {
                                JupyterExecutionCallbackData updateData;
                                Integer n = (Integer)this.$lastTaskIdForCell.get(this.$task.getOptions().getCellPointer());
                                int $i$a$-require-JupyterCellOutputUtils$updateCell$1$22 = this.$taskId;
                                boolean isLastTaskForCell = n != null && n == $i$a$-require-JupyterCellOutputUtils$updateCell$1$22;
                                JupyterExecutionCallbackData updateData2 = updateData = new JupyterExecutionCallbackData(this.$task, this.$message, project, isLastTaskForCell);
                                boolean bl = false;
                                if (Intrinsics.areEqual((Object)updateData2.isLastTaskForCell(), (Object)true)) {
                                    JupyterCellOutputUpdateCallback.access$clearOutputs(this.this$0, updateData2);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public void onStatus(@NotNull JupyterStatusMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        switch (WhenMappings.$EnumSwitchMapping$0[message2.getExecutionState().ordinal()]) {
            case 1: {
                this.onBusyStatus(message2);
                break;
            }
            case 2: 
            case 3: {
                this.getFinalizeCallback().invoke();
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void expire() {
        this.expired = true;
    }

    private final void onBusyStatus(JupyterStatusMessage message2) {
        NotebookIntervalPointer notebookIntervalPointer = this.task.getOptions().getCellPointer();
        if (notebookIntervalPointer == null) {
            return;
        }
        NotebookIntervalPointer cellPointer = notebookIntervalPointer;
        ApplicationManager.getApplication().invokeLater(() -> JupyterCellOutputUpdateCallback.onBusyStatus$lambda$6(this, message2, cellPointer));
    }

    private final void clearOutputs(JupyterExecutionCallbackData data) {
        NotebookCellLines.Interval interval = data.getCellPointer().get();
        if (interval == null) {
            return;
        }
        int cellIndex = interval.getOrdinal();
        if (!new JupyterClearOutputMessage(data.getMessage()).getWait()) {
            JupyterCell cell = data.getTask().getNotebookVirtualFile().getNotebook().getCell(cellIndex);
            cell.setOutputs(null);
            cell.setExecutionStartTime(null);
        } else {
            this.shouldClearCellsMap.set(data.getCellPointer(), (Object)true);
        }
    }

    private final void updateNotebook(JupyterExecutionCallbackData data) {
        JupyterOutputs jupyterOutputs;
        if (!Intrinsics.areEqual((Object)data.isLastTaskForCell(), (Object)true)) {
            return;
        }
        Boolean bl = (Boolean)this.shouldClearCellsMap.remove(data.getCellPointer());
        boolean shouldClear = bl != null ? bl : false;
        JupyterNotebook notebook = data.getTask().getNotebookVirtualFile().getNotebook();
        JupyterCell jupyterCell = data.getTask().getJupyterCell();
        if (jupyterCell == null) {
            return;
        }
        JupyterCell jupyterCell2 = jupyterCell;
        if (shouldClear) {
            jupyterCell2.setOutputs(null);
            jupyterCell2.setExecutionStartTime(null);
        }
        if ((jupyterOutputs = jupyterCell2.getOutputs()) == null) {
            JupyterOutputsBase jupyterOutputsBase;
            JupyterOutputsBase it = jupyterOutputsBase = new JupyterOutputsBase(null, V4JupyterOutputSchema.INSTANCE, 1, null);
            boolean bl2 = false;
            jupyterCell2.setOutputs(it);
            jupyterOutputs = jupyterOutputsBase;
        }
        JupyterOutputs outputs = jupyterOutputs;
        outputs.update(data.getMessage());
        JupyterNotebookSession jupyterNotebookSession = JupyterRuntimeService.Companion.getInstance(this.project).getNotebookSession(data.getTask().getVirtualFileForSession());
        if (jupyterNotebookSession != null) {
            JupyterNotebookSession session = jupyterNotebookSession;
            boolean bl3 = false;
            JupyterInlayProgressStatusManager.Companion.getInstance(this.project).outputAdded(data.getCellPointer(), session);
        }
        JupyterListenersKt.outputUpdated(notebook, data.getCellPointer());
        this.updateAsyncOutputState(data);
    }

    private final void updateAsyncOutputState(JupyterExecutionCallbackData data) {
        JupyterCell jupyterCell = data.getTask().getJupyterCell();
        Object object = data.getMessage().getParentHeader();
        if (object == null || (object = object.getSession-nLGbpMM()) == null) {
            return;
        }
        Object sessionId = object;
        if (jupyterCell != null && JupyterCellOutputUtils.INSTANCE.hasAsyncOutput$intellij_jupyter_core(this.project, data.getTask(), jupyterCell)) {
            this.messageTracker.asyncOutputArrived-sG23Yws((String)sessionId, data.getCellPointer());
        }
        JupyterMessageHeader jupyterMessageHeader = data.getMessage().getParentHeader();
        if (jupyterMessageHeader == null) {
            return;
        }
        String messageId = jupyterMessageHeader.getMessageId-j9c_AtQ();
        this.messageTracker.handleExecutionFinished-d3ImeOY((String)sessionId, messageId, this.project, data.getTask().getNotebookVirtualFile());
    }

    private static final void onBusyStatus$lambda$6(JupyterCellOutputUpdateCallback this$0, JupyterStatusMessage $message, NotebookIntervalPointer $cellPointer) {
        ZonedDateTime lastStoppedTime;
        ZonedDateTime startTime;
        ZonedDateTime zonedDateTime = this$0.task.getOptions().get(JupyterInlayProgressStatusManager.Companion.getKeyStartTime());
        if (zonedDateTime == null && (zonedDateTime = JupyterCellOutputUtils.INSTANCE.getMessageTime$intellij_jupyter_core($message)) == null) {
            zonedDateTime = startTime = ZonedDateTime.now();
        }
        if ((lastStoppedTime = (ZonedDateTime)this$0.lastStoppedTimeForCell.get($cellPointer)) == null || lastStoppedTime.compareTo(startTime) < 0) {
            JupyterInlayProgressStatusManager manager = JupyterInlayProgressStatusManager.Companion.getInstance(this$0.project);
            BackedNotebookVirtualFile backedNotebookVirtualFile = this$0.task.getNotebookVirtualFile();
            Intrinsics.checkNotNull((Object)startTime);
            manager.executionStarted($cellPointer, backedNotebookVirtualFile, startTime);
        }
    }

    public static final /* synthetic */ boolean access$getExpired$p(JupyterCellOutputUpdateCallback $this) {
        return $this.expired;
    }

    public static final /* synthetic */ void access$updateNotebook(JupyterCellOutputUpdateCallback $this, JupyterExecutionCallbackData data) {
        $this.updateNotebook(data);
    }

    public static final /* synthetic */ JupyterExecutionTask access$getTask$p(JupyterCellOutputUpdateCallback $this) {
        return $this.task;
    }

    public static final /* synthetic */ int access$getTaskId$p(JupyterCellOutputUpdateCallback $this) {
        return $this.taskId;
    }

    public static final /* synthetic */ NotebookIntervalPointerConcurrentMap access$getLastTaskIdForCell$p(JupyterCellOutputUpdateCallback $this) {
        return $this.lastTaskIdForCell;
    }

    public static final /* synthetic */ void access$clearOutputs(JupyterCellOutputUpdateCallback $this, JupyterExecutionCallbackData data) {
        $this.clearOutputs(data);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterExecutionState.values().length];
            try {
                nArray[JupyterExecutionState.BUSY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterExecutionState.IDLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterExecutionState.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterExecutionState.STARTING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

