/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.execution.core;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterKernelTerminatedException;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterExecutionCallback;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterKernelClientImpl;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterServer;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessageId;
import com.intellij.jupyter.core.jupyter.messages.JupyterKernelToFrontEndApi;
import com.intellij.jupyter.core.jupyter.messages.JupyterMessageBuffer;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterKernelSpec;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002BQ\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\n\u0012\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J:\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\n2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000200032\f\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u00108\u001a\u000209H\u0016J\u001a\u0010:\u001a\u0002002\u0006\u0010;\u001a\u00020&2\b\u0010<\u001a\u0004\u0018\u000107H\u0017J\b\u0010=\u001a\u000200H\u0016J\b\u0010>\u001a\u000200H\u0016J\u0010\u0010?\u001a\u0002002\u0006\u0010;\u001a\u00020&H\u0016J\u001a\u0010@\u001a\u0002002\u0006\u0010;\u001a\u00020&2\b\u0010<\u001a\u0004\u0018\u000107H\u0016J\b\u0010A\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0016\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010\u000f\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001bR\u0016\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020,X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006B"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSessionImpl;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "Lcom/intellij/jupyter/core/jupyter/messages/JupyterKernelToFrontEndApi;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "jupyterServer", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterServer;", "kernelName", "", "kernelId", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterKernelId;", "sessionId", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSessionId;", "pathFromRoot", "frontEndProducer", "Lkotlin/Function0;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterServer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getVirtualFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getJupyterServer", "()Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterServer;", "getKernelName", "()Ljava/lang/String;", "Ljava/lang/String;", "getSessionId-PaPw8_s", "getPathFromRoot", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "getExecutor", "()Ljava/util/concurrent/ExecutorService;", "frontEndMessageBuffer", "Lcom/intellij/jupyter/core/jupyter/messages/JupyterMessageBuffer;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "kernelSpec", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterKernelSpec;", "getKernelSpec", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterKernelSpec;", "kernelClient", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterKernelClientImpl;", "getKernelClient", "()Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterKernelClientImpl;", "execute", "", "code", "onMessageCreated", "Lkotlin/Function1;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageId;", "callbacks", "", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterExecutionCallback;", "silent", "", "sendMessage", "message", "callback", "deleteSession", "purgeFrontEndMessageBuffer", "sendMessageToSink", "sendMessageOnPooledThread", "toString", "intellij.jupyter.core"})
public final class JupyterNotebookSessionImpl
implements JupyterNotebookSession,
JupyterKernelToFrontEndApi {
    @NotNull
    private final Project project;
    @Nullable
    private final BackedNotebookVirtualFile virtualFile;
    @NotNull
    private final JupyterServer jupyterServer;
    @NotNull
    private final String kernelName;
    @NotNull
    private final String kernelId;
    @NotNull
    private final String sessionId;
    @NotNull
    private final String pathFromRoot;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final JupyterMessageBuffer<JupyterMessage> frontEndMessageBuffer;
    @NotNull
    private final JupyterKernelSpec kernelSpec;
    @NotNull
    private final JupyterKernelClientImpl kernelClient;

    private JupyterNotebookSessionImpl(Project project, BackedNotebookVirtualFile virtualFile, JupyterServer jupyterServer, String kernelName, String kernelId, String sessionId, String pathFromRoot, Function0<? extends JupyterKernelToFrontEndApi> frontEndProducer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)jupyterServer, (String)"jupyterServer");
        Intrinsics.checkNotNullParameter((Object)kernelName, (String)"kernelName");
        Intrinsics.checkNotNullParameter((Object)kernelId, (String)"kernelId");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)pathFromRoot, (String)"pathFromRoot");
        Intrinsics.checkNotNullParameter(frontEndProducer, (String)"frontEndProducer");
        this.project = project;
        this.virtualFile = virtualFile;
        this.jupyterServer = jupyterServer;
        this.kernelName = kernelName;
        this.kernelId = kernelId;
        this.sessionId = sessionId;
        this.pathFromRoot = pathFromRoot;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Jupyter", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.executor = executorService;
        this.frontEndMessageBuffer = new JupyterMessageBuffer(frontEndProducer);
        this.kernelSpec = this.getJupyterServer().getClient().getKernelSpec(this.getKernelName());
        this.kernelClient = new JupyterKernelClientImpl(this.getProject(), this.getKernelSpec(), this.getJupyterServer(), this.kernelId, this.getSessionId-PaPw8_s(), this, null);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public BackedNotebookVirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @Override
    @NotNull
    public JupyterServer getJupyterServer() {
        return this.jupyterServer;
    }

    @Override
    @NotNull
    public String getKernelName() {
        return this.kernelName;
    }

    @Override
    @NotNull
    public String getSessionId-PaPw8_s() {
        return this.sessionId;
    }

    @Override
    @NotNull
    public String getPathFromRoot() {
        return this.pathFromRoot;
    }

    @NotNull
    public final ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    @NotNull
    public JupyterKernelSpec getKernelSpec() {
        return this.kernelSpec;
    }

    @Override
    @NotNull
    public JupyterKernelClientImpl getKernelClient() {
        return this.kernelClient;
    }

    @Override
    public void execute(@NotNull String code, @NotNull Function1<? super JupyterMessageId, Unit> onMessageCreated, @NotNull List<? extends JupyterExecutionCallback> callbacks, boolean silent) throws JupyterKernelTerminatedException {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter(onMessageCreated, (String)"onMessageCreated");
        Intrinsics.checkNotNullParameter(callbacks, (String)"callbacks");
        try {
            this.getKernelClient().execute-gHvIo8s(code, this.getSessionId-PaPw8_s(), onMessageCreated, callbacks, silent);
        }
        catch (JupyterKernelTerminatedException err) {
            try {
                this.executor.shutdown();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            throw err;
        }
    }

    @Override
    @Deprecated(message="Should be encapsulated")
    public void sendMessage(@NotNull JupyterMessage message2, @Nullable JupyterExecutionCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.getKernelClient().sendMessage(message2, callback2);
    }

    @Override
    public void deleteSession() {
        this.getKernelClient().deleteSession();
        try {
            this.executor.shutdown();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void purgeFrontEndMessageBuffer() {
        this.frontEndMessageBuffer.purgeIfPossible();
    }

    @Override
    public void sendMessageToSink(@NotNull JupyterMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.frontEndMessageBuffer.sendMessageToSink(message2);
    }

    @Override
    public void sendMessageOnPooledThread(@NotNull JupyterMessage message2, @Nullable JupyterExecutionCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (!this.executor.isShutdown()) {
            try {
                this.executor.execute(() -> JupyterNotebookSessionImpl.sendMessageOnPooledThread$lambda$0(this, message2, callback2));
            }
            catch (RejectedExecutionException ex) {
                Logger.getInstance(JupyterNotebookSession.class).warn((Throwable)ex);
            }
        }
    }

    @NotNull
    public String toString() {
        return "Session " + this.getSessionId-PaPw8_s() + ", kernel: " + this.getKernelName();
    }

    private static final void sendMessageOnPooledThread$lambda$0(JupyterNotebookSessionImpl this$0, JupyterMessage $message, JupyterExecutionCallback $callback) {
        this$0.sendMessage($message, $callback);
    }

    public /* synthetic */ JupyterNotebookSessionImpl(Project project, BackedNotebookVirtualFile virtualFile, JupyterServer jupyterServer, String kernelName, String kernelId, String sessionId, String pathFromRoot, Function0 frontEndProducer, DefaultConstructorMarker $constructor_marker) {
        this(project, virtualFile, jupyterServer, kernelName, kernelId, sessionId, pathFromRoot, (Function0<? extends JupyterKernelToFrontEndApi>)frontEndProducer);
    }
}

