/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.filecontentsapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.core.api.NotebookDisposable;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.ContentsApiModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileContentsApi;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.LeafContentsApiModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.RemoteTimeStampCache;
import com.intellij.jupyter.core.jupyter.connections.http.HttpSession;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterHttpSessionRestUtilsKt;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterRestClientErrorResponseException;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterVFileEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a)\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u0002H\u00022\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u001a\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a*\u0010\f\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0007H\u0002\u001a \u0010\u0010\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0002\u001a \u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u0018\u001a\u00020\u0019*\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0005\u001a\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0002\u001a\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\"\u000e\u0010\u001f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"getFileNode", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/ContentsApiModel;", "F", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/FileContentsApi;", "path", "", "content", "", "(Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/FileContentsApi;Ljava/lang/String;Z)Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/ContentsApiModel;", "buildFullPath", "httpSession", "Lcom/intellij/jupyter/core/jupyter/connections/http/HttpSession;", "renameRemoteFile", "oldPath", "newPath", "allowDelete", "copyRemoteFile", "originalPath", "targetDirectory", "handleLastModified", "", "fileModel", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/LeafContentsApiModel;", "finalPath", "notebookWriter", "Ljava/io/OutputStream;", "jupyterPath", "normalizePath", "value", "splitDirectoryAndName", "Lkotlin/Pair;", "CONTENTS", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nFileContentsApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileContentsApi.kt\ncom/intellij/jupyter/core/jupyter/connections/filecontentsapi/FileContentsApiKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 JupyterJson.kt\ncom/intellij/jupyter/core/JupyterJsonKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,614:1\n1#2:615\n61#3,5:616\n61#3,5:621\n61#3,5:632\n14#3:643\n46#4,6:626\n170#5,6:637\n*S KotlinDebug\n*F\n+ 1 FileContentsApi.kt\ncom/intellij/jupyter/core/jupyter/connections/filecontentsapi/FileContentsApiKt\n*L\n312#1:616,5\n320#1:621,5\n340#1:632,5\n613#1:643\n330#1:626,6\n606#1:637,6\n*E\n"})
public final class FileContentsApiKt {
    @NotNull
    private static final String CONTENTS = "/api/contents";
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final <F extends FileContentsApi> ContentsApiModel getFileNode(@NotNull F $this$getFileNode, @NotNull String path, boolean content) {
        Intrinsics.checkNotNullParameter($this$getFileNode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return $this$getFileNode.getFileNode(path, content, ContentsApiModel.class);
    }

    private static final String buildFullPath(HttpSession httpSession, String path) {
        URL it = new URL(httpSession.getBaseURI().toURL(), path);
        boolean bl = false;
        return it.getAuthority() + it.getPath();
    }

    private static final ContentsApiModel renameRemoteFile(HttpSession httpSession, String oldPath, String newPath, boolean allowDelete) {
        Object object;
        Logger logger;
        ObjectNode objectNode;
        Object $this$renameRemoteFile_u24lambda_u241 = objectNode = JupyterJsonKt.getJackson().createObjectNode();
        boolean bl = false;
        $this$renameRemoteFile_u24lambda_u241.put("path", newPath);
        ObjectNode rootNode = objectNode;
        $this$renameRemoteFile_u24lambda_u241 = new char[1];
        $this$renameRemoteFile_u24lambda_u241[0] = (ObjectNode)47;
        String endpoint = "/api/contents/" + StringsKt.trim((String)oldPath, (char[])$this$renameRemoteFile_u24lambda_u241);
        Logger $this$debug_u24default$iv = LOG;
        String e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl2 = false;
            logger.debug("Authority " + httpSession.getBaseURI().getAuthority() + ", call rename(oldPath=\"" + oldPath + "\", newPath=\"" + newPath + "\").", e$iv);
        }
        try {
            String string = JupyterJsonKt.getJackson().writeValueAsString((Object)rootNode);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            e$iv = JupyterHttpSessionRestUtilsKt.patch$default(httpSession, endpoint, string, 0, 4, null);
        }
        catch (JupyterRestClientErrorResponseException err) {
            if (!allowDelete || err.getCode() != 409) {
                throw err;
            }
            Logger $this$debug_u24default$iv2 = LOG;
            Object e$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl3 = false;
                logger.debug("Failed to rename \"" + oldPath + "\" to \"" + newPath + "\", because the new file already exist. Deleting the new file and trying again.", (Throwable)e$iv2);
            }
            char[] cArray = new char[]{'/'};
            JupyterHttpSessionRestUtilsKt.delete(httpSession, CONTENTS, StringsKt.trim((String)newPath, (char[])cArray));
            return FileContentsApiKt.renameRemoteFile(httpSession, oldPath, newPath, false);
        }
        String response = e$iv;
        JupyterRemotePath jupyterRemotePath = JupyterRemotePath.Companion.parse(FileContentsApiKt.buildFullPath(httpSession, oldPath));
        if (jupyterRemotePath != null && (jupyterRemotePath = jupyterRemotePath.getParent()) != null) {
            JupyterRemotePath changedRemoteDirectoryPath = jupyterRemotePath;
            boolean bl4 = false;
            JupyterVFileEvent.DirectoryContentChanged event = new JupyterVFileEvent.DirectoryContentChanged(changedRemoteDirectoryPath);
            ((JupyterVFileEvent.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(JupyterVFileEvent.Companion.getTOPIC())).invoke((JupyterVFileEvent)event);
        }
        ObjectMapper $this$readValueWrappingError$iv = JupyterJsonKt.getJackson();
        boolean $i$f$readValueWrappingError = false;
        try {
            object = $this$readValueWrappingError$iv.readValue(response, ContentsApiModel.class);
        }
        catch (JsonProcessingException err$iv) {
            boolean bl5 = false;
            Attachment[] attachmentArray = new Attachment[]{new Attachment("response.json", response)};
            Attachment[] attachmentArray2 = attachmentArray;
            Throwable throwable = err$iv;
            String string = "PATCH " + endpoint;
            throw new RuntimeExceptionWithAttachments(string, throwable, attachmentArray2);
        }
        return (ContentsApiModel)object;
    }

    static /* synthetic */ ContentsApiModel renameRemoteFile$default(HttpSession httpSession, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return FileContentsApiKt.renameRemoteFile(httpSession, string, string2, bl);
    }

    private static final ContentsApiModel copyRemoteFile(HttpSession httpSession, String originalPath, String targetDirectory) {
        ObjectNode objectNode;
        Object $this$copyRemoteFile_u24lambda_u246 = objectNode = JupyterJsonKt.getJackson().createObjectNode();
        boolean bl = false;
        $this$copyRemoteFile_u24lambda_u246.put("copy_from", originalPath);
        ObjectNode rootNode = objectNode;
        $this$copyRemoteFile_u24lambda_u246 = new char[1];
        $this$copyRemoteFile_u24lambda_u246[0] = (ObjectNode)47;
        String endpoint = "/api/contents/" + StringsKt.trim((String)targetDirectory, (char[])$this$copyRemoteFile_u24lambda_u246);
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl2 = false;
            logger.debug("Authority " + httpSession.getBaseURI().getAuthority() + ", call copy(originalPath=\"" + originalPath + "\", targetDirectory=\"" + targetDirectory + "\").", e$iv);
        }
        String string = JupyterJsonKt.getJackson().writeValueAsString((Object)rootNode);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        int[] nArray = new int[]{201};
        ObjectNode response = JupyterHttpSessionRestUtilsKt.post(httpSession, endpoint, string, nArray);
        Object object = JupyterJsonKt.getJackson().convertValue((Object)response, ContentsApiModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"convertValue(...)");
        return (ContentsApiModel)object;
    }

    private static final void handleLastModified(HttpSession httpSession, LeafContentsApiModel fileModel, String finalPath) {
        ZonedDateTime zonedDateTime = fileModel.getLastModified();
        if (zonedDateTime == null) {
            return;
        }
        ZonedDateTime lastModified = zonedDateTime;
        RemoteTimeStampCache.Companion.getInstance().setOrUpdateTimeStampForPath(FileContentsApiKt.buildFullPath(httpSession, finalPath), lastModified.toInstant().toEpochMilli());
        JupyterRemotePath jupyterRemotePath = JupyterRemotePath.Companion.parse(FileContentsApiKt.buildFullPath(httpSession, finalPath));
        if (jupyterRemotePath == null || (jupyterRemotePath = jupyterRemotePath.getParent()) == null) {
            return;
        }
        JupyterRemotePath changedRemoteDirectoryPath = jupyterRemotePath;
        JupyterVFileEvent.DirectoryContentChanged event = new JupyterVFileEvent.DirectoryContentChanged(changedRemoteDirectoryPath);
        ((JupyterVFileEvent.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(JupyterVFileEvent.Companion.getTOPIC())).invoke((JupyterVFileEvent)event);
    }

    @NotNull
    public static final OutputStream notebookWriter(@NotNull FileContentsApi $this$notebookWriter, @NotNull String jupyterPath) {
        Intrinsics.checkNotNullParameter((Object)$this$notebookWriter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)jupyterPath, (String)"jupyterPath");
        PipedInputStream inputStream = new PipedInputStream();
        PipedOutputStream outputStream = new PipedOutputStream(inputStream);
        Deferred uploader2 = BuildersKt.async$default((CoroutineScope)NotebookDisposable.Companion.getForApp(), (CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)new CoroutineName("Uploading " + jupyterPath)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(inputStream, $this$notebookWriter, jupyterPath, null){
            int label;
            final /* synthetic */ PipedInputStream $inputStream;
            final /* synthetic */ FileContentsApi $this_notebookWriter;
            final /* synthetic */ String $jupyterPath;
            {
                this.$inputStream = $inputStream;
                this.$this_notebookWriter = $receiver;
                this.$jupyterPath = $jupyterPath;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        JsonNode jsonNode = JupyterJsonKt.getJackson().readTree((InputStream)this.$inputStream);
                        Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                        ObjectNode notebookJson = (ObjectNode)jsonNode;
                        this.$this_notebookWriter.writeNotebook(this.$jupyterPath, notebookJson);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return new OutputStream(outputStream, (Deferred<Unit>)uploader2){
            final /* synthetic */ PipedOutputStream $outputStream;
            final /* synthetic */ Deferred<Unit> $uploader;
            {
                this.$outputStream = $outputStream;
                this.$uploader = $uploader;
            }

            public void close() {
                this.$outputStream.close();
                BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$uploader, null){
                    int label;
                    final /* synthetic */ Deferred<Unit> $uploader;
                    {
                        this.$uploader = $uploader;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.$uploader.await((Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
            }

            public void flush() {
                this.$outputStream.flush();
            }

            public void write(int p0) {
                this.$outputStream.write(p0);
            }

            public void write(byte[] b, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                this.$outputStream.write(b, off, len);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final String normalizePath(String value) {
        String string;
        char[] cArray = new char[]{'/'};
        String it = StringsKt.trim((String)value, (char[])cArray);
        boolean bl = false;
        if (StringsKt.contains$default((CharSequence)it, (CharSequence)"//", (boolean)false, (int)2, null)) {
            CharSequence charSequence = it;
            Regex regex = new Regex("//+");
            String string2 = "/";
            string = regex.replace(charSequence, string2);
        } else {
            void var2_2;
            string = var2_2;
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Pair<String, String> splitDirectoryAndName(String path) {
        Object object;
        Integer n;
        int n2;
        block4: {
            CharSequence $this$indexOfLast$iv = path;
            boolean $i$f$indexOfLast = false;
            int n3 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n3) {
                do {
                    int index$iv = n3--;
                    char chr = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(chr == '/')) continue;
                    n2 = index$iv;
                    break block4;
                } while (0 <= n3);
            }
            n2 = -1;
        }
        Integer n4 = n2;
        int index = ((Number)n4).intValue();
        boolean bl = false;
        Integer n5 = n = index != -1 ? n4 : null;
        if (n != null) {
            int index2 = ((Number)n).intValue();
            boolean bl2 = false;
            n4 = TuplesKt.to((Object)StringsKt.substring((String)path, (IntRange)RangesKt.until((int)0, (int)index2)), (Object)StringsKt.substring((String)path, (IntRange)RangesKt.until((int)index2, (int)path.length())));
            if (n4 != null) {
                object = n4;
                return object;
            }
        }
        object = TuplesKt.to((Object)"", (Object)path);
        return object;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ String access$normalizePath(String value) {
        return FileContentsApiKt.normalizePath(value);
    }

    public static final /* synthetic */ void access$handleLastModified(HttpSession httpSession, LeafContentsApiModel fileModel, String finalPath) {
        FileContentsApiKt.handleLastModified(httpSession, fileModel, finalPath);
    }

    public static final /* synthetic */ String access$buildFullPath(HttpSession httpSession, String path) {
        return FileContentsApiKt.buildFullPath(httpSession, path);
    }

    public static final /* synthetic */ ContentsApiModel access$copyRemoteFile(HttpSession httpSession, String originalPath, String targetDirectory) {
        return FileContentsApiKt.copyRemoteFile(httpSession, originalPath, targetDirectory);
    }

    public static final /* synthetic */ Pair access$splitDirectoryAndName(String path) {
        return FileContentsApiKt.splitDirectoryAndName(path);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FileContentsApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

