/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.filecontentsapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.ContentsApiModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.DirectoryModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileContentsApi;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileWriterOutputStream;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.JavaIoFileWriterOutputStream;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.LeafContentsApiModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.NotebookModel;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J5\u0010\u001a\u001a\u0002H\u001b\"\b\b\u0000\u0010\u001b*\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\r2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\"\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bH\u0016J\u0018\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\bH\u0016J\b\u0010.\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\u00020\u0017*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006/"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/JavaIoFileContentsApi;", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/FileContentsApi;", "root", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getFile", "path", "", "getDirectoryNode", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/DirectoryModel;", "file", "contentNeeded", "", "getRegularFileNode", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/FileModel;", "getNotebookNode", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/NotebookModel;", "getLeafFileNode", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/LeafContentsApiModel;", "getDefaultFileNode", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/ContentsApiModel;", "zonedLastModified", "Ljava/time/ZonedDateTime;", "getZonedLastModified", "(Ljava/io/File;)Ljava/time/ZonedDateTime;", "getFileNode", "T", "content", "type", "Ljava/lang/Class;", "(Ljava/lang/String;ZLjava/lang/Class;)Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/ContentsApiModel;", "fileWriter", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/FileWriterOutputStream;", "writeNotebook", "notebookJson", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "createDirectory", "delete", "", "rename", "oldPath", "newPath", "copy", "originalPath", "targetDirectory", "toString", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJavaIoFileContentsApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaIoFileContentsApi.kt\ncom/intellij/jupyter/core/jupyter/connections/filecontentsapi/JavaIoFileContentsApi\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,132:1\n11165#2:133\n11500#2,3:134\n*S KotlinDebug\n*F\n+ 1 JavaIoFileContentsApi.kt\ncom/intellij/jupyter/core/jupyter/connections/filecontentsapi/JavaIoFileContentsApi\n*L\n24#1:133\n24#1:134,3\n*E\n"})
public final class JavaIoFileContentsApi
implements FileContentsApi {
    @NotNull
    private final File root;

    public JavaIoFileContentsApi(@NotNull File root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
    }

    private final File getFile(String path) {
        return FilesKt.resolve((File)this.root, (String)path);
    }

    /*
     * WARNING - void declaration
     */
    private final DirectoryModel getDirectoryNode(File file, boolean contentNeeded) {
        List list;
        if (!file.isDirectory()) {
            throw new RuntimeException("Requesting path " + file + " as a directory, but it's not a directory");
        }
        if (!contentNeeded) {
            list = null;
        } else {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                void $this$mapTo$iv$iv;
                File[] $this$map$iv = fileArray;
                boolean $i$f$map = false;
                File[] fileArray2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var12_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(this.getDefaultFileNode((File)it, false));
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
        }
        List content = list;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new DirectoryModel(string, content, this.getZonedLastModified(file));
    }

    private final FileModel getRegularFileNode(File file, boolean contentNeeded) {
        if (!file.isFile()) {
            throw new RuntimeException("Requesting path " + file + " as a file, but it's not a file");
        }
        byte[] content = contentNeeded ? FilesKt.readBytes((File)file) : null;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new FileModel(string, content, this.getZonedLastModified(file));
    }

    private final NotebookModel getNotebookNode(File file, boolean contentNeeded) {
        ObjectNode objectNode;
        if (!file.isFile()) {
            throw new RuntimeException("Requesting path " + file + " as a notebook, but it's not a file");
        }
        if (!contentNeeded) {
            objectNode = null;
        } else {
            JsonNode jsonNode = JupyterJsonKt.getJackson().readTree(file);
            Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            objectNode = (ObjectNode)jsonNode;
        }
        ObjectNode content = objectNode;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new NotebookModel(string, content, this.getZonedLastModified(file));
    }

    @NotNull
    public final LeafContentsApiModel getLeafFileNode(@NotNull File file, boolean contentNeeded) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isFile()) {
            throw new RuntimeException("Requesting path " + file + " as a leaf node, but it's not a file");
        }
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"ipynb") ? (LeafContentsApiModel)this.getNotebookNode(file, contentNeeded) : (LeafContentsApiModel)this.getRegularFileNode(file, contentNeeded);
    }

    private final ContentsApiModel getDefaultFileNode(File file, boolean contentNeeded) {
        ContentsApiModel contentsApiModel;
        if (file.isDirectory()) {
            contentsApiModel = this.getDirectoryNode(file, contentNeeded);
        } else if (file.isFile()) {
            contentsApiModel = this.getLeafFileNode(file, contentNeeded);
        } else {
            throw new RuntimeException("Requesting " + file + ", but it possibly doesn't exist");
        }
        return contentsApiModel;
    }

    private final ZonedDateTime getZonedLastModified(File $this$zonedLastModified) {
        long millis = $this$zonedLastModified.lastModified();
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ofInstant(...)");
        return zonedDateTime;
    }

    @Override
    @NotNull
    public <T extends ContentsApiModel> T getFileNode(@NotNull String path, boolean content, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        File file = this.getFile(path);
        Class<T> clazz = type;
        ContentsApiModel model = Intrinsics.areEqual(clazz, DirectoryModel.class) ? (ContentsApiModel)this.getDirectoryNode(file, content) : (Intrinsics.areEqual(clazz, FileModel.class) ? (ContentsApiModel)this.getRegularFileNode(file, content) : (Intrinsics.areEqual(clazz, NotebookModel.class) ? (ContentsApiModel)this.getNotebookNode(file, content) : this.getDefaultFileNode(file, content)));
        T t = type.cast(model);
        Intrinsics.checkNotNullExpressionValue(t, (String)"cast(...)");
        return (T)((ContentsApiModel)t);
    }

    @Override
    @NotNull
    public FileWriterOutputStream fileWriter(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new JavaIoFileWriterOutputStream(this.getFile(path), this);
    }

    @Override
    @NotNull
    public NotebookModel writeNotebook(@NotNull String path, @NotNull ObjectNode notebookJson) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)notebookJson, (String)"notebookJson");
        File file = this.getFile(path);
        JupyterJsonKt.getJackson().writeValue(file, (Object)notebookJson);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new NotebookModel(string, notebookJson, this.getZonedLastModified(file));
    }

    @Override
    @NotNull
    public DirectoryModel createDirectory(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = this.getFile(path);
        file.mkdirs();
        return this.getDirectoryNode(file, true);
    }

    @Override
    public void delete(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = this.getFile(path);
        if (!FilesKt.deleteRecursively((File)file)) {
            throw new IOException("Unable to delete directory " + file + ". Contents root: " + this.root + ", path: " + path + ".");
        }
    }

    @Override
    @NotNull
    public ContentsApiModel rename(@NotNull String oldPath, @NotNull String newPath) {
        Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        File oldFile = this.getFile(oldPath);
        File newFile = this.getFile(newPath);
        oldFile.renameTo(newFile);
        return this.getDefaultFileNode(newFile, false);
    }

    @Override
    @NotNull
    public ContentsApiModel copy(@NotNull String originalPath, @NotNull String targetDirectory) {
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        File originalFile = this.getFile(originalPath);
        File targetFile = this.getFile(targetDirectory);
        FilesKt.copyTo$default((File)originalFile, (File)targetFile, (boolean)false, (int)0, (int)6, null);
        return this.getDefaultFileNode(originalFile, false);
    }

    @NotNull
    public String toString() {
        return "<IO-based file contents API for root '" + this.root + "'>";
    }
}

