/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.editor.NotebookCellExecutionCountProvider;
import com.intellij.jupyter.core.editor.settings.JupyterDSSettings;
import com.intellij.jupyter.core.editor.settings.JupyterShowExecutionTimeMode;
import com.intellij.jupyter.core.jupyter.actions.utils.JupyterDebugger;
import com.intellij.jupyter.core.jupyter.editor.BelowCellExecutionStatusTextFormatter;
import com.intellij.jupyter.core.jupyter.editor.BelowCellInlayController$Factory$getOldController$;
import com.intellij.jupyter.core.jupyter.editor.BelowCellInlayControllerData;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditorKt;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutine;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.inlays.progress.JupyterInlayProgressStatusManager;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterTagsService;
import com.intellij.jupyter.core.jupyter.nbformat.metadata.JupyterTag;
import com.intellij.lang.Language;
import com.intellij.notebooks.jupyter.core.icons.JupyterCoreIcons;
import com.intellij.notebooks.ui.visualization.NotebookBelowCellDelimiterPanel;
import com.intellij.notebooks.ui.visualization.NotebookEditorAppearanceUtils;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.ui.visualization.markerRenderers.NotebookBelowCellCellGutterLineMarkerRenderer;
import com.intellij.notebooks.visualization.NotebookCellInlayController;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.ui.CellExecutionStatusView;
import com.intellij.notebooks.visualization.ui.EditorCellView;
import com.intellij.notebooks.visualization.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SpinningProgressIcon;
import com.intellij.util.Consumer;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0002,-B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b J5\u0010!\u001a\u00020\u00162\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010'H\u0016\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020\u001eH\u0002J$\u0010+\u001a\u00020\u00162\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010*\u001a\u00020\u001eH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006."}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/BelowCellInlayController;", "Lcom/intellij/notebooks/visualization/NotebookCellInlayController;", "Lcom/intellij/notebooks/visualization/ui/CellExecutionStatusView;", "factory", "Lcom/intellij/jupyter/core/jupyter/editor/BelowCellInlayController$Factory;", "data", "Lcom/intellij/jupyter/core/jupyter/editor/BelowCellInlayControllerData;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/editor/BelowCellInlayController$Factory;Lcom/intellij/jupyter/core/jupyter/editor/BelowCellInlayControllerData;)V", "getFactory", "()Lcom/intellij/jupyter/core/jupyter/editor/BelowCellInlayController$Factory;", "getData", "()Lcom/intellij/jupyter/core/jupyter/editor/BelowCellInlayControllerData;", "settings", "Lcom/intellij/jupyter/core/editor/settings/JupyterDSSettings;", "panel", "Lcom/intellij/notebooks/ui/visualization/NotebookBelowCellDelimiterPanel;", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "getInlay", "()Lcom/intellij/openapi/editor/Inlay;", "createGutterRendererLineMarker", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "cellView", "Lcom/intellij/notebooks/visualization/ui/EditorCellView;", "hasSameData", "", "otherData", "hasSameData$intellij_jupyter_core", "updateExecutionStatus", "executionCount", "", "progressStatus", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "startTime", "Ljava/time/ZonedDateTime;", "endTime", "(Ljava/lang/Integer;Lcom/intellij/notebooks/visualization/ui/ProgressStatus;Ljava/time/ZonedDateTime;Ljava/time/ZonedDateTime;)V", "isUnderDebugger", "startElapsedTimeUpdateIfNeeded", "Factory", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nBelowCellInlayController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BelowCellInlayController.kt\ncom/intellij/jupyter/core/jupyter/editor/BelowCellInlayController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n1557#2:202\n1628#2,3:203\n1#3:206\n*S KotlinDebug\n*F\n+ 1 BelowCellInlayController.kt\ncom/intellij/jupyter/core/jupyter/editor/BelowCellInlayController\n*L\n45#1:202\n45#1:203,3\n*E\n"})
public final class BelowCellInlayController
implements NotebookCellInlayController,
CellExecutionStatusView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Factory factory;
    @NotNull
    private final BelowCellInlayControllerData data;
    @NotNull
    private final JupyterDSSettings settings;
    @NotNull
    private final NotebookBelowCellDelimiterPanel panel;
    @NotNull
    private final Inlay<?> inlay;
    private static final boolean IS_RELATED_TO_PRECEDING_TEXT = true;
    @NotNull
    private static final BelowCellExecutionStatusTextFormatter textFormatter = new BelowCellExecutionStatusTextFormatter();

    /*
     * WARNING - void declaration
     */
    private BelowCellInlayController(Factory factory2, BelowCellInlayControllerData data) {
        List list;
        this.factory = factory2;
        this.data = data;
        this.settings = JupyterDSSettings.Companion.getInstance();
        BelowCellInlayController belowCellInlayController = this;
        EditorImpl editorImpl = this.data.getEditor();
        boolean bl = this.data.isExecutable();
        List<JupyterTag> list2 = this.data.getCellTags();
        if (list2 != null) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            boolean bl2 = bl;
            EditorImpl editorImpl2 = editorImpl;
            BelowCellInlayController belowCellInlayController2 = belowCellInlayController;
            boolean $i$f$map = false;
            void var5_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JupyterTag jupyterTag = (JupyterTag)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getName());
            }
            collection = (List)destination$iv$iv;
            belowCellInlayController = belowCellInlayController2;
            editorImpl = editorImpl2;
            bl = bl2;
            list = collection;
        } else {
            list = CollectionsKt.emptyList();
        }
        CoroutineScope coroutineScope = JupyterCoroutine.Utils.INSTANCE.getScope();
        String string = this.data.getInitExecutionDurationText();
        String string2 = this.data.getInitTooltipText();
        Icon icon = this.data.getInitStatusIcon();
        Integer n = this.data.getExecutionCount();
        boolean bl4 = this.data.isRenderedMarkdown();
        int n2 = this.data.getCellNum();
        List list3 = list;
        boolean bl5 = bl;
        EditorImpl editorImpl3 = editorImpl;
        belowCellInlayController.panel = new NotebookBelowCellDelimiterPanel(editorImpl3, bl5, list3, n2, bl4, n, icon, string2, string, coroutineScope);
        EditorEx editorEx = (EditorEx)this.data.getEditor();
        JComponent jComponent = (JComponent)this.panel;
        int n3 = NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.data.getEditor()).getJUPYTER_CELL_SPACERS_INLAY_PRIORITY();
        DocumentEx documentEx = this.data.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        this.inlay = NotebookEditorUiUtilKt.addComponentInlay$default((EditorEx)editorEx, (JComponent)jComponent, (boolean)true, (boolean)false, (boolean)false, (int)n3, (int)BelowCellInlayController.Companion.offset((Document)documentEx, this.data.getInterval().getLines()), null, (int)72, null);
        this.startElapsedTimeUpdateIfNeeded(this.data.getProgressStatus(), this.data.getStartTime(), this.isUnderDebugger());
    }

    @NotNull
    public Factory getFactory() {
        return this.factory;
    }

    @NotNull
    public final BelowCellInlayControllerData getData() {
        return this.data;
    }

    @NotNull
    public Inlay<?> getInlay() {
        return this.inlay;
    }

    public void createGutterRendererLineMarker(@NotNull EditorEx editor, @NotNull NotebookCellLines.Interval interval, @NotNull EditorCellView cellView) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)cellView, (String)"cellView");
        if (interval.getType() == NotebookCellLines.CellType.CODE) {
            int startOffset = editor.getDocument().getLineStartOffset(interval.getLines().getFirst());
            int endOffset = editor.getDocument().getLineEndOffset(interval.getLines().getLast());
            Consumer changeAction = arg_0 -> BelowCellInlayController.createGutterRendererLineMarker$lambda$1(this, arg_0);
            cellView.addCellHighlighter(() -> BelowCellInlayController.createGutterRendererLineMarker$lambda$2(editor, startOffset, endOffset, changeAction));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasSameData$intellij_jupyter_core(@NotNull BelowCellInlayControllerData otherData) {
        Intrinsics.checkNotNullParameter((Object)otherData, (String)"otherData");
        if (!this.getInlay().isRelatedToPrecedingText()) return false;
        int n = this.getInlay().getOffset();
        DocumentEx documentEx = otherData.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        if (n != BelowCellInlayController.Companion.offset((Document)documentEx, otherData.getInterval().getLines())) return false;
        if (this.data.getCellNum() != otherData.getCellNum()) return false;
        if (!Intrinsics.areEqual(this.data.getCellTags(), otherData.getCellTags())) return false;
        if (this.data.isRenderedMarkdown() != otherData.isRenderedMarkdown()) return false;
        return true;
    }

    public void updateExecutionStatus(@Nullable Integer executionCount, @Nullable ProgressStatus progressStatus, @Nullable ZonedDateTime startTime, @Nullable ZonedDateTime endTime) {
        boolean underDebugger = this.isUnderDebugger();
        this.panel.stopElapsedTimeUpdate();
        ZonedDateTime zonedDateTime = startTime;
        if (zonedDateTime == null) {
            zonedDateTime = this.data.getStartTime();
        }
        ZonedDateTime panelStartTime = zonedDateTime;
        Icon statusIcon = Companion.getIconForStatus(progressStatus);
        String tooltipText = textFormatter.getExecutionStatusText(progressStatus, endTime);
        String executionDurationText = !underDebugger ? textFormatter.getExecutionDurationString(progressStatus, panelStartTime, endTime) : null;
        this.panel.updateExecutionStatus(tooltipText, executionCount, statusIcon, executionDurationText);
        this.startElapsedTimeUpdateIfNeeded(progressStatus, panelStartTime, underDebugger);
    }

    private final boolean isUnderDebugger() {
        boolean bl;
        Project project = this.data.getEditor().getProject();
        if (project != null) {
            Project it = project;
            boolean bl2 = false;
            bl = JupyterDebugger.INSTANCE.isUnderDebugger(it, JupyterEditorExtensionsKt.getNotebookFile((Editor)this.data.getEditor()));
        } else {
            bl = false;
        }
        return bl;
    }

    private final void startElapsedTimeUpdateIfNeeded(ProgressStatus progressStatus, ZonedDateTime startTime, boolean isUnderDebugger) {
        if (progressStatus == ProgressStatus.RUNNING && !isUnderDebugger && this.settings.getExecutionTimeShowMode() != JupyterShowExecutionTimeMode.HIDDEN && startTime != null) {
            this.panel.startElapsedTimeUpdate(startTime, (Function2)new Function2<ZonedDateTime, ZonedDateTime, String>((Object)textFormatter){

                public final String invoke(ZonedDateTime p0, ZonedDateTime p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((BelowCellExecutionStatusTextFormatter)this.receiver).presentableTimeDiff(p0, p1);
                }
            });
        }
    }

    public void onViewportChange() {
        NotebookCellInlayController.DefaultImpls.onViewportChange((NotebookCellInlayController)this);
    }

    public void paintGutter(@NotNull EditorImpl editor, @NotNull Graphics g, @NotNull Rectangle r, @NotNull NotebookCellLines.Interval interval) {
        NotebookCellInlayController.DefaultImpls.paintGutter((NotebookCellInlayController)this, (EditorImpl)editor, (Graphics)g, (Rectangle)r, (NotebookCellLines.Interval)interval);
    }

    private static final void createGutterRendererLineMarker$lambda$1(BelowCellInlayController this$0, RangeHighlighterEx o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (this$0.getInlay().isValid()) {
            RangeHighlighter rangeHighlighter = (RangeHighlighter)o;
            Inlay<?> inlay = this$0.getInlay();
            Intrinsics.checkNotNull(inlay, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.RangeMarkerEx");
            o.setLineMarkerRenderer((LineMarkerRenderer)new NotebookBelowCellCellGutterLineMarkerRenderer(rangeHighlighter, ((RangeMarkerEx)inlay).getId()));
        }
    }

    private static final RangeHighlighter createGutterRendererLineMarker$lambda$2(EditorEx $editor, int $startOffset, int $endOffset, Consumer $changeAction) {
        RangeHighlighterEx rangeHighlighterEx = $editor.getMarkupModel().addRangeHighlighterAndChangeAttributes(null, $startOffset, $endOffset, 1000, HighlighterTargetArea.LINES_IN_RANGE, false, $changeAction);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
        return (RangeHighlighter)rangeHighlighterEx;
    }

    public /* synthetic */ BelowCellInlayController(Factory factory2, BelowCellInlayControllerData data, DefaultConstructorMarker $constructor_marker) {
        this(factory2, data);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0017\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/BelowCellInlayController$Companion;", "", "<init>", "()V", "IS_RELATED_TO_PRECEDING_TEXT", "", "offset", "", "document", "Lcom/intellij/openapi/editor/Document;", "codeLines", "Lkotlin/ranges/IntRange;", "textFormatter", "Lcom/intellij/jupyter/core/jupyter/editor/BelowCellExecutionStatusTextFormatter;", "getIconForStatus", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "status", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        private final int offset(Document document, IntRange codeLines) {
            return document.getLineEndOffset(codeLines.getLast());
        }

        @Nullable
        public final Icon getIconForStatus(@Nullable ProgressStatus status) {
            ProgressStatus progressStatus = status;
            return switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[progressStatus.ordinal()]) {
                case 1 -> (Icon)new SpinningProgressIcon(null, 0, 3, null);
                case 2 -> AllIcons.General.GreenCheckmark;
                case 3 -> JupyterCoreIcons.ResultIncorrect;
                case 4 -> AllIcons.Empty;
                case 5 -> AllIcons.General.History;
                case 6 -> AllIcons.Run.ShowIgnored;
                default -> null;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ProgressStatus.values().length];
                try {
                    nArray[ProgressStatus.RUNNING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProgressStatus.STOPPED_OK.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProgressStatus.STOPPED_ERROR.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProgressStatus.NOT_STARTED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProgressStatus.QUEUED.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProgressStatus.CANCELLED.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u0004\u0018\u00010\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/BelowCellInlayController$Factory;", "Lcom/intellij/notebooks/visualization/NotebookCellInlayController$Factory;", "<init>", "()V", "compute", "Lcom/intellij/notebooks/visualization/NotebookCellInlayController;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "currentControllers", "", "intervalIterator", "", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "makeNewController", "Lcom/intellij/jupyter/core/jupyter/editor/BelowCellInlayController;", "data", "Lcom/intellij/jupyter/core/jupyter/editor/BelowCellInlayControllerData;", "getOldController", "getExecutionCountProvider", "Lcom/intellij/jupyter/core/editor/NotebookCellExecutionCountProvider;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nBelowCellInlayController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BelowCellInlayController.kt\ncom/intellij/jupyter/core/jupyter/editor/BelowCellInlayController$Factory\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,201:1\n477#2:202\n183#2,2:203\n*S KotlinDebug\n*F\n+ 1 BelowCellInlayController.kt\ncom/intellij/jupyter/core/jupyter/editor/BelowCellInlayController$Factory\n*L\n170#1:202\n171#1:203,2\n*E\n"})
    public static final class Factory
    implements NotebookCellInlayController.Factory {
        @Nullable
        public NotebookCellInlayController compute(@NotNull EditorImpl editor, @NotNull Collection<? extends NotebookCellInlayController> currentControllers, @NotNull ListIterator<NotebookCellLines.Interval> intervalIterator) {
            BelowCellInlayController oldController;
            Integer n;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(currentControllers, (String)"currentControllers");
            Intrinsics.checkNotNullParameter(intervalIterator, (String)"intervalIterator");
            if (!JupyterFileEditorKt.isJupyter((Editor)editor)) {
                return null;
            }
            Project project = editor.getProject();
            if (project == null) {
                return null;
            }
            Project project2 = project;
            if (NotebookEditorAppearanceUtils.INSTANCE.isDiffKind((Editor)editor)) {
                return null;
            }
            NotebookCellLines.Interval interval = intervalIterator.next();
            int cellNum = interval.getOrdinal();
            boolean isCellEmpty = ((CharSequence)JupyterEditorExtensionsKt.getNotebookFile((Editor)editor).getNotebook().getCell(cellNum).getSource()).length() == 0;
            NotebookCellExecutionCountProvider executionCountProvider = this.getExecutionCountProvider(editor);
            if (isCellEmpty) {
                n = null;
            } else {
                NotebookCellExecutionCountProvider notebookCellExecutionCountProvider = executionCountProvider;
                n = notebookCellExecutionCountProvider != null ? notebookCellExecutionCountProvider.getCellExecutionCount((Editor)editor, cellNum) : null;
            }
            Integer executionCount = n;
            NotebookIntervalPointer cellPointer = NotebookIntervalPointerFactory.Companion.get((Editor)editor).create(interval);
            ProgressStatus status = isCellEmpty ? null : JupyterInlayProgressStatusManager.Companion.getInstance(project2).getProgressStatus(cellPointer);
            Icon statusIcon = Companion.getIconForStatus(status);
            JupyterCell cell = JupyterEditorExtensionsKt.getNotebookFile((Editor)editor).getNotebook().getCell(interval.getOrdinal());
            ZonedDateTime executionStartTime = cell.getExecutionStartTime();
            ZonedDateTime executionEndTime = cell.getExecutionEndTime();
            String tooltipText = textFormatter.getExecutionStatusText(status, executionEndTime);
            String executionDurationText = textFormatter.getExecutionDurationString(status, executionStartTime, executionEndTime);
            boolean isExecutable = interval.getType() == NotebookCellLines.CellType.CODE;
            boolean isMarkdownAndRendered = false;
            List<JupyterTag> cellTags = JupyterTagsService.Companion.getInstance().getTagsForCell((Editor)editor, cellNum);
            BelowCellInlayControllerData controllerData = new BelowCellInlayControllerData(editor, interval, isExecutable, cellTags, cellNum, isMarkdownAndRendered, executionStartTime, executionCount, status, statusIcon, tooltipText, executionDurationText);
            BelowCellInlayController belowCellInlayController = oldController = this.getOldController(currentControllers, controllerData);
            return belowCellInlayController != null ? (NotebookCellInlayController)belowCellInlayController : (NotebookCellInlayController)this.makeNewController(controllerData);
        }

        private final BelowCellInlayController makeNewController(BelowCellInlayControllerData data) {
            return new BelowCellInlayController(this, data, null);
        }

        private final BelowCellInlayController getOldController(Collection<? extends NotebookCellInlayController> currentControllers, BelowCellInlayControllerData data) {
            Object v1;
            block1: {
                Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)currentControllers);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Factory$getOldController$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                Sequence $this$firstOrNull$iv = sequence;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    BelowCellInlayController it = (BelowCellInlayController)element$iv;
                    boolean bl = false;
                    if (!it.hasSameData$intellij_jupyter_core(data)) continue;
                    v1 = element$iv;
                    break block1;
                }
                v1 = null;
            }
            return v1;
        }

        private final NotebookCellExecutionCountProvider getExecutionCountProvider(EditorImpl editor) {
            Project project = editor.getProject();
            if (project == null) {
                return null;
            }
            Project project2 = project;
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile((Document)editor.getDocument());
            if (psiFile == null) {
                return null;
            }
            PsiFile psiFile2 = psiFile;
            Language language = psiFile2.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            Language language2 = language;
            return (NotebookCellExecutionCountProvider)NotebookCellExecutionCountProvider.Companion.forLanguage(language2);
        }
    }
}

