/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor;

import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParametersSettings;
import com.intellij.jupyter.core.jupyter.connections.JupyterManagedServerConfiguration;
import com.intellij.jupyter.core.jupyter.connections.configuration.JupyterServerConfigurable;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookOfflineSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookRuntimeSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookSessionSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.ManagedJupyterServerNotebookSessionSettings;
import com.intellij.jupyter.core.jupyter.connections.settings.ConfiguredServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.connections.settings.ManagedServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.editor.JupyterActionsKt;
import com.intellij.jupyter.core.jupyter.editor.JupyterServerChooserActionPresentationUpdater;
import com.intellij.jupyter.core.jupyter.server.JupyterManagedServerConfigurationProvider;
import com.intellij.jupyter.core.jupyter.server.JupyterManagedServerExecutionServiceProvider;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerExecution;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerFinished;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerStarted;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerStarting;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerState;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerStopped;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0003J\u001c\u0010\u0014\u001a\u00020\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u001c\u0010\u0019\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0003\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/JupyterServerChooserAction;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$BackendOnly;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getConnectionPresentationText", "", "managedServerConfiguration", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterManagedServerConfiguration;", "notebookConnectionParameters", "Lcom/intellij/jupyter/core/jupyter/connections/settings/JupyterModuleConnectionSettings;", "activeConnectionParameters", "createPopupActionGroup", "currentProject", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getJupyterServerExecutionStatusText", "execution", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerExecution;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterServerChooserAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterServerChooserAction.kt\ncom/intellij/jupyter/core/jupyter/editor/JupyterServerChooserAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,164:1\n1#2:165\n24#3:166\n24#3:167\n*S KotlinDebug\n*F\n+ 1 JupyterServerChooserAction.kt\ncom/intellij/jupyter/core/jupyter/editor/JupyterServerChooserAction\n*L\n83#1:166\n128#1:167\n*E\n"})
public final class JupyterServerChooserAction
extends DefaultActionGroup
implements DumbAware,
ActionRemoteBehaviorSpecification.BackendOnly {
    public JupyterServerChooserAction() {
        Presentation presentation;
        Presentation $this$_init__u24lambda_u240 = presentation = this.getTemplatePresentation();
        boolean bl = false;
        $this$_init__u24lambda_u240.putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
        $this$_init__u24lambda_u240.putClientProperty(ActionUtil.USE_SMALL_FONT_IN_TOOLBAR, (Object)true);
        $this$_init__u24lambda_u240.setPerformGroup(true);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        VirtualFile virtualFile = JupyterActionsKt.getVirtualFile(e);
        try {
            String string;
            JupyterModuleConnectionSettings connectionSettings;
            Module module;
            Module module2;
            JupyterNotebookRuntimeSettings settings = JupyterActionsKt.getJupyterNotebookRuntimeSettings(e);
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            if (JupyterServerChooserActionPresentationUpdater.Companion.updatePresentation(presentation, virtualFile).getShouldStop()) {
                return;
            }
            VirtualFile virtualFile2 = virtualFile;
            if (virtualFile2 != null) {
                VirtualFile it = virtualFile2;
                boolean bl = false;
                module2 = ModuleUtilCore.findModuleForFile((VirtualFile)it, (Project)project2);
            } else {
                module2 = null;
            }
            Module module3 = module = module2;
            if (module3 != null) {
                Module it = module3;
                boolean bl = false;
                Project project3 = it.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                v6 = JupyterConnectionParametersSettings.Companion.getInstance(project3).guessConnectionSettings(project2, virtualFile);
            } else {
                v6 = connectionSettings = null;
            }
            if (module == null) {
                e.getPresentation().setText(JupyterBundle.message("jupyter.file.outside.module", new Object[0]));
                e.getPresentation().setEnabled(false);
                return;
            }
            if (!(connectionSettings != null)) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            JupyterManagedServerConfiguration jupyterManagedServerConfiguration = JupyterActionsKt.getJupyterManagedServerConfiguration(e);
            if (jupyterManagedServerConfiguration == null) {
                jupyterManagedServerConfiguration = JupyterManagedServerConfigurationProvider.Companion.getJupyterManagedServerConfiguration$default(JupyterManagedServerConfigurationProvider.Companion, module, null, 2, null);
            }
            JupyterManagedServerConfiguration managedServerConfiguration = jupyterManagedServerConfiguration;
            Presentation presentation2 = e.getPresentation();
            if (settings == null) {
                string = this.getConnectionPresentationText(managedServerConfiguration, connectionSettings, connectionSettings);
            } else {
                JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings = settings;
                if (jupyterNotebookRuntimeSettings instanceof JupyterNotebookOfflineSettings || jupyterNotebookRuntimeSettings instanceof JupyterNotebookSessionSettings) {
                    string = this.getConnectionPresentationText(managedServerConfiguration, settings.getConnectionSettings(), connectionSettings);
                } else if (jupyterNotebookRuntimeSettings instanceof ManagedJupyterServerNotebookSessionSettings) {
                    string = this.getJupyterServerExecutionStatusText(((ManagedJupyterServerNotebookSessionSettings)settings).getJupyterServerExecution(), connectionSettings);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            presentation2.setText(string);
        }
        catch (Throwable t) {
            if (t instanceof ControlFlowException) {
                throw t;
            }
            JupyterServerChooserAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterServerChooserAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(t);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        InputEvent inputEvent = e.getInputEvent();
        Object object = inputEvent != null ? inputEvent.getSource() : null;
        Component component2 = object instanceof Component ? (Component)object : null;
        if (component2 == null) {
            return;
        }
        Component component3 = component2;
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)this.createPopupActionGroup(e.getProject(), JupyterActionsKt.getVirtualFile(e)), e.getDataContext(), null, true, null).showUnderneathOf(component3);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @NlsSafe
    private final String getConnectionPresentationText(JupyterManagedServerConfiguration managedServerConfiguration, JupyterModuleConnectionSettings notebookConnectionParameters, JupyterModuleConnectionSettings activeConnectionParameters) {
        String string;
        JupyterModuleConnectionSettings jupyterModuleConnectionSettings = notebookConnectionParameters;
        if (jupyterModuleConnectionSettings instanceof ManagedServerJupyterModuleConnectionSettings) {
            JupyterServerExecution currentExecution = JupyterManagedServerExecutionServiceProvider.Companion.getInstance().getCurrentExecution(managedServerConfiguration);
            string = this.getJupyterServerExecutionStatusText(currentExecution, activeConnectionParameters);
        } else if (jupyterModuleConnectionSettings instanceof ConfiguredServerJupyterModuleConnectionSettings) {
            if (Intrinsics.areEqual((Object)notebookConnectionParameters, (Object)activeConnectionParameters)) {
                String string2 = ((ConfiguredServerJupyterModuleConnectionSettings)notebookConnectionParameters).getUri().toASCIIString();
                Intrinsics.checkNotNull((Object)string2);
                string = string2;
            } else {
                Object[] objectArray = new Object[]{((ConfiguredServerJupyterModuleConnectionSettings)notebookConnectionParameters).getUri().toASCIIString()};
                string = JupyterBundle.message("Jupyter.configured.server.retained", objectArray);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final DefaultActionGroup createPopupActionGroup(Project currentProject, VirtualFile virtualFile) {
        if (currentProject == null || virtualFile == null) {
            JupyterServerChooserAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterServerChooserAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Illegal state: project=" + currentProject + ", virtual file=" + virtualFile);
            return new DefaultActionGroup();
        }
        String string = JupyterBundle.message("Jupyter.server.configure", new Object[0]);
        List actionList2 = CollectionsKt.listOf((Object)new AnAction(currentProject, string){
            final /* synthetic */ Project $currentProject;
            {
                this.$currentProject = $currentProject;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ShowSettingsUtil.getInstance().showSettingsDialog(this.$currentProject, JupyterServerConfigurable.class);
            }
        });
        return new DefaultActionGroup(actionList2);
    }

    @Nls
    private final String getJupyterServerExecutionStatusText(JupyterServerExecution execution, JupyterModuleConnectionSettings activeConnectionParameters) {
        String string;
        JupyterServerState state;
        JupyterServerExecution jupyterServerExecution = execution;
        JupyterServerState jupyterServerState = state = jupyterServerExecution != null ? jupyterServerExecution.getState() : null;
        if (state instanceof JupyterServerStopped) {
            string = JupyterBundle.message("Jupyter.managed.server.auto.start", new Object[0]);
        } else if (state instanceof JupyterServerStarting) {
            string = JupyterBundle.message("Jupyter.managed.server.starting", new Object[0]);
        } else if (state instanceof JupyterServerStarted) {
            String string2;
            JupyterConnectionParameters $this$getJupyterServerExecutionStatusText_u24lambda_u243 = ((JupyterServerStarted)state).getConnectionParameters();
            boolean bl = false;
            JupyterConnectionParameters.Ownership o = $this$getJupyterServerExecutionStatusText_u24lambda_u243.getOwnership();
            if (Intrinsics.areEqual((Object)o, (Object)JupyterConnectionParameters.Ownership.NotStartedManaged.INSTANCE) || Intrinsics.areEqual((Object)o, (Object)JupyterConnectionParameters.Ownership.Unmanaged.INSTANCE)) {
                string2 = $this$getJupyterServerExecutionStatusText_u24lambda_u243.getLocation().getUri().toASCIIString();
            } else if (o instanceof JupyterConnectionParameters.Ownership.StartedManaged) {
                string2 = ((JupyterConnectionParameters.Ownership.StartedManaged)o).getPresentableName();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String urlString = string2;
            if (!(activeConnectionParameters instanceof ManagedServerJupyterModuleConnectionSettings)) {
                Object[] objectArray = new Object[]{urlString};
                string = JupyterBundle.message("Jupyter.managed.server.running.retained", objectArray);
            } else {
                Object[] objectArray = new Object[]{urlString};
                string = JupyterBundle.message("Jupyter.managed.server.running", objectArray);
            }
        } else if (state instanceof JupyterServerFinished) {
            string = JupyterBundle.message("Jupyter.managed.server.auto.start", new Object[0]);
        } else if (state == null) {
            string = JupyterBundle.message("Jupyter.managed.server.auto.start", new Object[0]);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }
}

