/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.ui;

import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.ui.ExceptionUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/core/jupyter/ui/JupyterNotificationUtils;", "", "<init>", "()V", "showExceptionDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "throwable", "", "createStackPanel", "Ljavax/swing/JScrollPane;", "stackTrace", "", "intellij.jupyter.core"})
public final class JupyterNotificationUtils {
    @NotNull
    public static final JupyterNotificationUtils INSTANCE = new JupyterNotificationUtils();

    private JupyterNotificationUtils() {
    }

    public final void showExceptionDialog(@NotNull Project project, @NotNull Throwable throwable) {
        DialogBuilder dialogBuilder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        JScrollPane stack = this.createStackPanel(ExceptionsKt.stackTraceToString((Throwable)throwable));
        DialogPanel panel2 = BuilderKt.panel(arg_0 -> JupyterNotificationUtils.showExceptionDialog$lambda$3(throwable, stack, arg_0));
        DialogBuilder $this$showExceptionDialog_u24lambda_u244 = dialogBuilder = new DialogBuilder(project);
        boolean bl = false;
        $this$showExceptionDialog_u24lambda_u244.addOkAction();
        $this$showExceptionDialog_u24lambda_u244.setCenterPanel((JComponent)panel2);
        $this$showExceptionDialog_u24lambda_u244.setTitle(JupyterBundle.message("notification.title.jupyter", new Object[0]));
        $this$showExceptionDialog_u24lambda_u244.show();
    }

    @NotNull
    public final JScrollPane createStackPanel(@NotNull String stackTrace) {
        JScrollPane jScrollPane;
        JTextArea jTextArea;
        Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
        JTextArea $this$createStackPanel_u24lambda_u245 = jTextArea = new JTextArea();
        boolean bl = false;
        $this$createStackPanel_u24lambda_u245.setLineWrap(false);
        $this$createStackPanel_u24lambda_u245.setText(stackTrace);
        $this$createStackPanel_u24lambda_u245.setCaretPosition(0);
        $this$createStackPanel_u24lambda_u245.setRows(4);
        JTextArea stackEditor = jTextArea;
        FontMetrics fontMetrics = stackEditor.getFontMetrics(stackEditor.getFont());
        int lineHeight = fontMetrics.getAscent() - fontMetrics.getDescent();
        int bestWidth = Math.max(500, Toolkit.getDefaultToolkit().getScreenSize().width / 5);
        JScrollPane $this$createStackPanel_u24lambda_u246 = jScrollPane = ScrollPaneFactory.createScrollPane((Component)stackEditor, (boolean)true);
        boolean bl2 = false;
        $this$createStackPanel_u24lambda_u246.setPreferredSize(new Dimension(bestWidth, Math.min(JBUIScale.scale((int)200), Math.max(2 * lineHeight, stackEditor.getPreferredSize().height))));
        JScrollPane jScrollPane2 = jScrollPane;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane2, (String)"apply(...)");
        JScrollPane stackScrollPane = jScrollPane2;
        return stackScrollPane;
    }

    private static final Unit showExceptionDialog$lambda$3$lambda$0(Throwable $throwable, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(ExceptionUtilsKt.toPresentableText($throwable));
        return Unit.INSTANCE;
    }

    private static final Unit showExceptionDialog$lambda$3$lambda$2$lambda$1(JScrollPane $stack, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$stack).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit showExceptionDialog$lambda$3$lambda$2(JScrollPane $stack, Panel $this$collapsibleGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$collapsibleGroup, (String)"$this$collapsibleGroup");
        Panel.row$default((Panel)$this$collapsibleGroup, null, arg_0 -> JupyterNotificationUtils.showExceptionDialog$lambda$3$lambda$2$lambda$1($stack, arg_0), (int)1, null).bottomGap(BottomGap.NONE).topGap(TopGap.NONE).layout(RowLayout.INDEPENDENT);
        return Unit.INSTANCE;
    }

    private static final Unit showExceptionDialog$lambda$3(Throwable $throwable, JScrollPane $stack, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterNotificationUtils.showExceptionDialog$lambda$3$lambda$0($throwable, arg_0), (int)1, null);
        Panel.collapsibleGroup$default((Panel)$this$panel, (String)JupyterBundle.message("exception.dialog.stacktrace.title", new Object[0]), (boolean)false, arg_0 -> JupyterNotificationUtils.showExceptionDialog$lambda$3$lambda$2($stack, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }
}

