/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.collaboration.file.codereview.CodeReviewDiffVirtualFile;
import com.intellij.collaboration.ui.codereview.CodeReviewAdvancedSettings;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.editor.ComplexPathVirtualFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffVirtualFileKt;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.ui.diff.GHPRDiffService;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.model.GHPRToolWindowProjectViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.model.GHPRToolWindowViewModel;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\f\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\t\u0010\u0017\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c2\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c2\u0003J1\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRDiffVirtualFile;", "Lcom/intellij/collaboration/file/codereview/CodeReviewDiffVirtualFile;", "fileManagerId", "", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "pullRequest", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;)V", "getFileSystem", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem;", "getPath", "getPresentablePath", "getPresentableName", "isValid", "", "createViewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "findProjectVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/model/GHPRToolWindowProjectViewModel;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRDiffVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRDiffVirtualFile.kt\norg/jetbrains/plugins/github/pullrequest/GHPRDiffVirtualFile\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n31#2,2:53\n31#2,2:55\n31#2,2:57\n1#3:59\n*S KotlinDebug\n*F\n+ 1 GHPRDiffVirtualFile.kt\norg/jetbrains/plugins/github/pullrequest/GHPRDiffVirtualFile\n*L\n35#1:53,2\n38#1:55,2\n45#1:57,2\n*E\n"})
public final class GHPRDiffVirtualFile
extends CodeReviewDiffVirtualFile {
    @NotNull
    private final String fileManagerId;
    @NotNull
    private final Project project;
    @NotNull
    private final GHRepositoryCoordinates repository;
    @NotNull
    private final GHPRIdentifier pullRequest;

    public GHPRDiffVirtualFile(@NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)fileManagerId, (String)"fileManagerId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        super(GHPRDiffVirtualFileKt.access$getFileName(pullRequest));
        this.fileManagerId = fileManagerId;
        this.project = project;
        this.repository = repository;
        this.pullRequest = pullRequest;
    }

    @NotNull
    public ComplexPathVirtualFileSystem<?> getFileSystem() {
        return GHPRVirtualFileSystem.Companion.getInstance();
    }

    @NotNull
    public String getPath() {
        ComplexPathVirtualFileSystem<?> complexPathVirtualFileSystem = this.getFileSystem();
        Intrinsics.checkNotNull(complexPathVirtualFileSystem, (String)"null cannot be cast to non-null type org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem");
        return ((GHPRVirtualFileSystem)complexPathVirtualFileSystem).getPath(this.fileManagerId, this.project, this.repository, this.pullRequest, true);
    }

    @NotNull
    public String getPresentablePath() {
        return GHPRDiffVirtualFileKt.access$getPresentablePath(this.repository, this.pullRequest);
    }

    @NotNull
    public String getPresentableName() {
        Object[] objectArray = new Object[]{this.pullRequest.getNumber()};
        String string = GithubBundle.message("pull.request.diff.editor.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isValid() {
        return this.findProjectVm() != null;
    }

    @NotNull
    public DiffEditorViewer createViewer(@NotNull Project project) {
        DiffEditorViewer diffEditorViewer;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (CodeReviewAdvancedSettings.INSTANCE.isCombinedDiffEnabled()) {
            $this$service$iv = (ComponentManager)project;
            $i$f$service = false;
            serviceClass$iv = GHPRDiffService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            diffEditorViewer = (DiffEditorViewer)((GHPRDiffService)object).createCombinedDiffProcessor(this.repository, this.pullRequest);
        } else {
            $this$service$iv = (ComponentManager)project;
            $i$f$service = false;
            serviceClass$iv = GHPRDiffService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            diffEditorViewer = (DiffEditorViewer)((GHPRDiffService)object).createDiffRequestProcessor(this.repository, this.pullRequest);
        }
        DiffEditorViewer processor2 = diffEditorViewer;
        processor2.getContext().putUserData(DiffUserDataKeysEx.COMBINED_DIFF_TOGGLE, (Object)CodeReviewAdvancedSettings.INSTANCE.getCodeReviewCombinedDiffToggle());
        return processor2;
    }

    private final GHPRToolWindowProjectViewModel findProjectVm() {
        GHPRToolWindowProjectViewModel gHPRToolWindowProjectViewModel;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GHPRToolWindowViewModel> serviceClass$iv = GHPRToolWindowViewModel.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GHPRToolWindowProjectViewModel gHPRToolWindowProjectViewModel2 = (GHPRToolWindowProjectViewModel)((GHPRToolWindowViewModel)object).getProjectVm().getValue();
        if (gHPRToolWindowProjectViewModel2 != null) {
            GHPRToolWindowProjectViewModel gHPRToolWindowProjectViewModel3;
            GHPRToolWindowProjectViewModel it = gHPRToolWindowProjectViewModel3 = gHPRToolWindowProjectViewModel2;
            boolean bl = false;
            gHPRToolWindowProjectViewModel = Intrinsics.areEqual((Object)it.getRepository(), (Object)this.repository) ? gHPRToolWindowProjectViewModel3 : null;
        } else {
            gHPRToolWindowProjectViewModel = null;
        }
        return gHPRToolWindowProjectViewModel;
    }

    private final String component1() {
        return this.fileManagerId;
    }

    private final Project component2() {
        return this.project;
    }

    private final GHRepositoryCoordinates component3() {
        return this.repository;
    }

    private final GHPRIdentifier component4() {
        return this.pullRequest;
    }

    @NotNull
    public final GHPRDiffVirtualFile copy(@NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)fileManagerId, (String)"fileManagerId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        return new GHPRDiffVirtualFile(fileManagerId, project, repository, pullRequest);
    }

    public static /* synthetic */ GHPRDiffVirtualFile copy$default(GHPRDiffVirtualFile gHPRDiffVirtualFile, String string, Project project, GHRepositoryCoordinates gHRepositoryCoordinates, GHPRIdentifier gHPRIdentifier, int n, Object object) {
        if ((n & 1) != 0) {
            string = gHPRDiffVirtualFile.fileManagerId;
        }
        if ((n & 2) != 0) {
            project = gHPRDiffVirtualFile.project;
        }
        if ((n & 4) != 0) {
            gHRepositoryCoordinates = gHPRDiffVirtualFile.repository;
        }
        if ((n & 8) != 0) {
            gHPRIdentifier = gHPRDiffVirtualFile.pullRequest;
        }
        return gHPRDiffVirtualFile.copy(string, project, gHRepositoryCoordinates, gHPRIdentifier);
    }

    @NotNull
    public String toString() {
        return "GHPRDiffVirtualFile(fileManagerId=" + this.fileManagerId + ", project=" + this.project + ", repository=" + this.repository + ", pullRequest=" + this.pullRequest + ")";
    }

    public int hashCode() {
        int result = this.fileManagerId.hashCode();
        result = result * 31 + this.project.hashCode();
        result = result * 31 + this.repository.hashCode();
        result = result * 31 + this.pullRequest.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHPRDiffVirtualFile)) {
            return false;
        }
        GHPRDiffVirtualFile gHPRDiffVirtualFile = (GHPRDiffVirtualFile)((Object)other);
        if (!Intrinsics.areEqual((Object)this.fileManagerId, (Object)gHPRDiffVirtualFile.fileManagerId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.project, (Object)gHPRDiffVirtualFile.project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.repository, (Object)gHPRDiffVirtualFile.repository)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.pullRequest, (Object)gHPRDiffVirtualFile.pullRequest);
    }
}

