/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.google.common.base.Predicate;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.vagrant.VagrantBundle;
import com.jetbrains.plugins.vagrant.VagrantItem;
import com.jetbrains.plugins.vagrant.VagrantItemsModel;
import com.jetbrains.plugins.vagrant.actions.VagrantTask;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVagrantItemManager<T extends VagrantItem>
implements VagrantItemsModel<T> {
    private static final Logger LOG = Logger.getInstance(AbstractVagrantItemManager.class);
    protected final Project myProject;
    private Ref<List<T>> myItemsCache = null;
    private String myVagrantPath;
    private final List<VagrantItemsModel.VagrantItemListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public AbstractVagrantItemManager(Project project) {
        this.myProject = project;
    }

    private List<T> parseItemsList(ProcessOutput output) {
        ArrayList<T> result = new ArrayList<T>();
        for (String line : output.getStdoutLines()) {
            if (line.contains(this.emptyListText())) {
                return result;
            }
            result.add(this.createItem(line));
        }
        return result;
    }

    protected abstract T createItem(String var1);

    @Nls
    protected abstract String emptyListText();

    @Override
    public void dropCache() {
        this.myItemsCache = null;
    }

    @Override
    @Nullable
    public List<T> listItems() {
        if (this.myItemsCache == null) {
            this.myItemsCache = Ref.create(this.doListItems(this.listItemsArguments()));
        }
        return (List)this.myItemsCache.get();
    }

    protected abstract String[] listItemsArguments();

    @Nullable
    private List<T> doListItems(String ... arguments) {
        block4: {
            VagrantTask listBoxesTask = this.createTask(arguments);
            if (listBoxesTask != null) {
                try {
                    CapturingAnsiEscapesAwareProcessHandler handler = new CapturingAnsiEscapesAwareProcessHandler(listBoxesTask.createCommandLine());
                    ProcessOutput output = handler.runProcess();
                    List<T> boxes = this.parseItemsList(output);
                    if (boxes.size() == 0 && output.getExitCode() != 0) {
                        LOG.error("Error loading list " + output.getStderr());
                    }
                    return boxes;
                }
                catch (Exception e) {
                    if (!new File(this.myVagrantPath).exists()) break block4;
                    LOG.error("Can't list vagrant items: " + listBoxesTask.createCommandLine().getCommandLineString(), (Throwable)e);
                }
            }
        }
        return null;
    }

    protected VagrantTask createTask(String ... commands) {
        if (StringUtil.isEmpty((String)this.myVagrantPath)) {
            return null;
        }
        return VagrantTask.create(this.myProject, this.myVagrantPath, null, commands);
    }

    public void setVagrantPath(String vagrantPath) {
        if (!StringUtil.equals((CharSequence)vagrantPath, (CharSequence)this.myVagrantPath)) {
            this.dropCache();
        }
        this.myVagrantPath = vagrantPath;
        this.fireEvent();
    }

    public void reset() {
        this.setVagrantPath("");
    }

    protected void fireEvent() {
        for (VagrantItemsModel.VagrantItemListener l : this.myListeners) {
            l.fireEvent();
        }
    }

    @Override
    public void remove(VagrantItem box) {
        VagrantTask task = this.createTask(this.removeItemArguments(box));
        if (task != null) {
            this.runTask(task, VagrantBundle.message("vagrant.box.deleting.vagrant.progress.title", this.getItemName()), VagrantBundle.message("vagrant.box.deleting.vagrant.dialog.title", this.getItemName()), false);
        }
    }

    @Nls
    protected abstract String getItemName();

    private void runTask(final @NotNull VagrantTask task, @NotNull @NlsContexts.ProgressTitle String progressTitle, final @NotNull @NlsContexts.DialogTitle String dialogTitle, final @Nullable Predicate<ProcessOutput> onSuccess) {
        if (task == null) {
            AbstractVagrantItemManager.$$$reportNull$$$0(0);
        }
        if (progressTitle == null) {
            AbstractVagrantItemManager.$$$reportNull$$$0(1);
        }
        if (dialogTitle == null) {
            AbstractVagrantItemManager.$$$reportNull$$$0(2);
        }
        Task.Backgroundable backgroundableTask = new Task.Backgroundable(this.myProject, progressTitle, true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setFraction(0.0);
                indicator.isIndeterminate();
                try {
                    CapturingAnsiEscapesAwareProcessHandler handler = new CapturingAnsiEscapesAwareProcessHandler(task.createCommandLine());
                    ProcessOutput output = handler.runProcess();
                    if (output.getExitCode() != 0) {
                        UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.myProject, (String)output.getStderr(), (String)dialogTitle));
                    } else {
                        AbstractVagrantItemManager.this.dropCache();
                        if (onSuccess != null) {
                            onSuccess.apply((Object)output);
                        }
                        AbstractVagrantItemManager.this.fireEvent();
                    }
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.myProject, (String)VagrantBundle.message("vagrant.error.cant.add", AbstractVagrantItemManager.this.getItemName() + message), (String)dialogTitle));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/vagrant/AbstractVagrantItemManager$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)backgroundableTask);
    }

    protected void runTask(@NotNull VagrantTask task, @NotNull @NlsContexts.ProgressTitle String progressTitle, @NotNull @NlsContexts.DialogTitle String dialogTitle, boolean showResult) {
        if (task == null) {
            AbstractVagrantItemManager.$$$reportNull$$$0(3);
        }
        if (progressTitle == null) {
            AbstractVagrantItemManager.$$$reportNull$$$0(4);
        }
        if (dialogTitle == null) {
            AbstractVagrantItemManager.$$$reportNull$$$0(5);
        }
        this.runTask(task, progressTitle, dialogTitle, showResult ? output -> {
            UIUtil.invokeLaterIfNeeded(() -> Messages.showInfoMessage((Project)this.myProject, (String)output.getStdout(), (String)dialogTitle));
            return true;
        } : null);
    }

    protected abstract String[] removeItemArguments(VagrantItem var1);

    @Override
    public void addListener(VagrantItemsModel.VagrantItemListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(VagrantItemsModel.VagrantItemListener listener) {
        this.myListeners.remove(listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "task";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "progressTitle";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "dialogTitle";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/plugins/vagrant/AbstractVagrantItemManager";
        objectArray[2] = "runTask";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

