/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.vagrant.VagrantInstance;
import com.jetbrains.plugins.vagrant.VagrantProjectSettings;
import com.jetbrains.plugins.vagrant.VagrantService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantManager {
    private final Project myProject;

    public VagrantManager(@NotNull Project project) {
        if (project == null) {
            VagrantManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            VagrantManager.$$$reportNull$$$0(1);
        }
        return project;
    }

    public static VagrantManager getInstance(@NotNull Project project) {
        if (project == null) {
            VagrantManager.$$$reportNull$$$0(2);
        }
        return (VagrantManager)project.getService(VagrantManager.class);
    }

    @NotNull
    public List<VagrantInstance> listInstances() {
        ArrayList<VagrantInstance> result = new ArrayList<VagrantInstance>();
        String instanceFolder = this.getInstanceFolder();
        if (!StringUtil.isEmpty((String)instanceFolder)) {
            result.add(VagrantManager.fromFolder(instanceFolder));
        }
        ArrayList<VagrantInstance> arrayList = result;
        if (arrayList == null) {
            VagrantManager.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Contract(value="null -> null; !null -> !null")
    private static VagrantInstance fromFolder(@Nullable String folder) {
        if (folder == null) {
            return null;
        }
        return VagrantService.getInstance().getVagrantInstance(folder);
    }

    @Nullable
    public VagrantInstance currentInstance() {
        return VagrantManager.fromFolder(this.getInstanceFolder());
    }

    @Nullable
    public String getVagrantExecutable(boolean askIfNotSet) {
        return VagrantService.getInstance().getVagrantExecutable(this.myProject, askIfNotSet);
    }

    public boolean haveInstance() {
        String instanceFolder = this.getInstanceFolder();
        return !StringUtil.isEmpty((String)instanceFolder);
    }

    @Nullable
    public String getInstanceFolder() {
        VagrantProjectSettings settings = VagrantProjectSettings.getInstance(this.myProject);
        String instanceFolder = settings.getInstanceFolder();
        if (StringUtil.isEmpty((String)instanceFolder)) {
            instanceFolder = this.detectInstanceInCurrentProject();
        }
        return instanceFolder;
    }

    @NotNull
    public Map<String, String> getEnvs() {
        VagrantProjectSettings settings = VagrantProjectSettings.getInstance(this.myProject);
        Map<String, String> map = settings.getEnvs();
        if (map == null) {
            VagrantManager.$$$reportNull$$$0(4);
        }
        return map;
    }

    @Nullable
    public String detectInstanceInCurrentProject() {
        for (VirtualFile root : ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()) {
            if (!VagrantManager.isVagrantInstance(root)) continue;
            return root.getPath();
        }
        return null;
    }

    private static boolean isVagrantInstance(@NotNull VirtualFile folder) {
        if (folder == null) {
            VagrantManager.$$$reportNull$$$0(5);
        }
        return folder.findChild("Vagrantfile") != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/vagrant/VagrantManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/vagrant/VagrantManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "listInstances";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isVagrantInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4 -> new IllegalStateException(string);
        };
    }
}

