/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.actions.StopProcessAction;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.plugins.reactnative.ProcessRunnerFactory;
import com.jetbrains.plugins.reactnative.ReactNativeDebuggerBundle;
import com.jetbrains.plugins.reactnative.ReactNativePackagerKt;
import com.jetbrains.plugins.reactnative.ViewerProcessRunnerFactory;
import icons.JavaScriptLanguageIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\b\b\u0001\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a8\u0006\u0010"}, d2={"showHelperProcessRunContent", "Lcom/intellij/execution/ui/ConsoleView;", "header", "", "runHandler", "Lcom/intellij/execution/process/ProcessHandler;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "chromeDebugUrl", "Lcom/intellij/util/Url;", "packagerHost", "packagerPort", "", "reactNativePackageToNodeArgument", "reactNativePackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "intellij.javascript.reactNativeDebugger"})
public final class ReactNativeProgramRunnerKt {
    @NotNull
    public static final ConsoleView showHelperProcessRunContent(@NlsSafe @NotNull String header, @NotNull ProcessHandler runHandler, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)runHandler, (String)"runHandler");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        ProcessRunnerFactory processRunnerFactory = (ProcessRunnerFactory)runHandler.getUserData(ReactNativePackagerKt.getPROCESS_RUNNER_FACTORY());
        if (processRunnerFactory == null) {
            processRunnerFactory = ViewerProcessRunnerFactory.INSTANCE;
        }
        ProcessRunnerFactory processRunnerFactory2 = processRunnerFactory;
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ConsoleView consoleView = processRunnerFactory2.createConsoleView(project, runHandler);
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)consoleView.getComponent(), "Center");
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ReactNativeRunner", (ActionGroup)toolbarActions, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent(consoleView.getComponent());
        panel.add((Component)toolbar.getComponent(), "West");
        RunContentDescriptor runDescriptor = new RunContentDescriptor((ExecutionConsole)consoleView, runHandler, (JComponent)panel, header, JavaScriptLanguageIcons.Logos.Jsx_16);
        AnAction[] anActionArray = consoleView.createConsoleActions();
        toolbarActions.addAll(Arrays.copyOf(anActionArray, anActionArray.length));
        toolbarActions.add((AnAction)new StopProcessAction(ReactNativeDebuggerBundle.message("react.native.runner.action.stop.text", new Object[0]), null, runHandler));
        toolbarActions.add((AnAction)new CloseAction(environment.getExecutor(), runDescriptor, environment.getProject()));
        consoleView.attachToProcess(runHandler);
        RunContentManager.getInstance((Project)environment.getProject()).showRunContent(environment.getExecutor(), runDescriptor);
        return consoleView;
    }

    @NotNull
    public static final Url chromeDebugUrl(@NotNull String packagerHost, int packagerPort) {
        Intrinsics.checkNotNullParameter((Object)packagerHost, (String)"packagerHost");
        String string = Integer.toString(packagerPort, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return Urls.newHttpUrl((String)(packagerHost + ":" + string), (String)"/debugger-ui");
    }

    @NotNull
    public static final String reactNativePackageToNodeArgument(@NotNull NodePackage reactNativePackage) {
        Intrinsics.checkNotNullParameter((Object)reactNativePackage, (String)"reactNativePackage");
        return reactNativePackage.getSystemDependentPath() + (Intrinsics.areEqual((Object)reactNativePackage.getName(), (Object)"react-native") ? "/local-cli/cli.js" : "");
    }
}

