/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.settings;

import com.intellij.docker.agent.settings.DockerPortBinding;
import java.util.Objects;

public class DockerPortBindingImpl
implements DockerPortBinding {
    public static final String PROTOCOL_TCP = "tcp";
    public static final String PROTOCOL_UDP = "udp";
    private int myContainerPort;
    private String myProtocol = "tcp";
    private String myHostIp;
    private Integer myHostPort;

    public static DockerPortBindingImpl fromString(String serialized) {
        if (serialized == null) {
            return null;
        }
        String[] parts = serialized.split(":+");
        return switch (parts.length) {
            case 3 -> DockerPortBindingImpl.createFromSubstrings(parts[0] + ":" + parts[1], parts[2]);
            case 2 -> DockerPortBindingImpl.createFromSubstrings(parts[0], parts[1]);
            case 1 -> DockerPortBindingImpl.createFromSubstrings("", parts[0]);
            default -> throw new IllegalArgumentException("Can't parse port binding: " + serialized);
        };
    }

    private static DockerPortBindingImpl createFromSubstrings(String binding, String exposedPort) {
        DockerPortBindingImpl result2 = new DockerPortBindingImpl();
        if (binding != null && !binding.isEmpty()) {
            String[] bindingParts = binding.split(":");
            switch (bindingParts.length) {
                case 2: {
                    result2.setHostIp(bindingParts[0]);
                    result2.setHostPortSpec(bindingParts[1]);
                    break;
                }
                case 1: {
                    if (bindingParts[0].contains(".")) {
                        result2.setHostIp(bindingParts[0]);
                        break;
                    }
                    result2.setHostPortSpec(bindingParts[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Can't parse host part: " + binding + " : " + exposedPort);
                }
            }
        }
        if (exposedPort != null && !exposedPort.isEmpty()) {
            int containerPort;
            String[] exposedParts = exposedPort.split("/");
            try {
                containerPort = Integer.parseInt(exposedParts[0]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Can't parse container part: " + binding + " : " + exposedPort);
            }
            result2.setContainerPort(containerPort);
            if (exposedParts.length > 1) {
                result2.setProtocol(exposedParts[1]);
            }
        }
        return result2;
    }

    public DockerPortBindingImpl() {
    }

    public DockerPortBindingImpl(DockerPortBinding source) {
        this.myContainerPort = source.getContainerPort();
        this.myProtocol = source.getProtocol();
        this.myHostIp = source.getHostIp();
        this.myHostPort = source.getHostPort();
    }

    @Override
    public int getContainerPort() {
        return this.myContainerPort;
    }

    public void setContainerPort(int containerPort) {
        this.myContainerPort = containerPort;
    }

    @Override
    public String getProtocol() {
        return this.myProtocol;
    }

    public void setProtocol(String protocol) {
        this.myProtocol = protocol;
    }

    @Override
    public String getHostIp() {
        return this.myHostIp;
    }

    public void setHostIp(String hostIp) {
        this.myHostIp = hostIp;
    }

    @Override
    public Integer getHostPort() {
        return this.myHostPort;
    }

    public void setHostPort(Integer hostPort) {
        this.myHostPort = hostPort;
    }

    public void setHostPortSpec(String hostPortSpec) {
        if (hostPortSpec == null) {
            this.myHostPort = null;
            return;
        }
        try {
            int hostPort = Integer.parseInt(hostPortSpec.trim());
            this.setHostPort(hostPort);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Range port-spec is not supported, expected single port: " + hostPortSpec);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerPortBindingImpl binding = (DockerPortBindingImpl)o;
        if (this.myContainerPort != binding.myContainerPort) {
            return false;
        }
        if (!Objects.equals(this.myProtocol, binding.myProtocol)) {
            return false;
        }
        if (!Objects.equals(this.myHostIp, binding.myHostIp)) {
            return false;
        }
        return Objects.equals(this.myHostPort, binding.myHostPort);
    }

    public int hashCode() {
        int result2 = this.myContainerPort;
        result2 = 31 * result2 + (this.myProtocol != null ? this.myProtocol.hashCode() : 0);
        result2 = 31 * result2 + (this.myHostIp != null ? this.myHostIp.hashCode() : 0);
        result2 = 31 * result2 + (this.myHostPort != null ? this.myHostPort.hashCode() : 0);
        return result2;
    }

    public String toCommandLineString() {
        StringBuilder result2 = new StringBuilder();
        if (this.myHostIp != null && !this.myHostIp.isEmpty()) {
            result2.append(this.myHostIp).append(':');
        }
        result2.append(this.myHostPort == null ? "" : this.myHostPort);
        if (result2.length() > 0) {
            result2.append(':');
        }
        result2.append(this.myContainerPort);
        if (this.myProtocol != null && !PROTOCOL_TCP.equals(this.myProtocol)) {
            result2.append('/').append(this.myProtocol);
        }
        return result2.toString();
    }
}

