/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remoteRunRuntime;

import com.intellij.docker.DockerAgentPathMapperImpl;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.DockerAgentDeployment;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.impl.DockerAgentContainerInfo;
import com.intellij.docker.agent.remote.DockerAttachResult;
import com.intellij.docker.agent.remote.DockerRemoteUtilsKt;
import com.intellij.docker.remoteRunRuntime.InputStreamConsumer;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.remoteRunRuntime.WrappedNotFoundException;
import com.intellij.docker.utils.RemoteDockerRuntimeUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.concurrency.Semaphore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteDockerApplicationRuntime {
    private static final Logger LOG = Logger.getInstance(RemoteDockerApplicationRuntime.class);
    private final RemoteDockerRuntime myRuntime;
    private DockerAttachResult myAttachResult;
    private final Semaphore mySemaphore;
    private DockerAgentContainer myContainer;

    private RemoteDockerApplicationRuntime(RemoteDockerRuntime runtime, DockerAgentContainer container) {
        this(runtime);
        this.myContainer = container;
    }

    private RemoteDockerApplicationRuntime(RemoteDockerRuntime runtime) {
        this.myRuntime = runtime;
        this.mySemaphore = new Semaphore();
        this.mySemaphore.down();
    }

    public static RemoteDockerApplicationRuntime create(RemoteDockerRuntime runtime, DockerAgentContainer container) {
        return new RemoteDockerApplicationRuntime(runtime, container);
    }

    public static RemoteDockerApplicationRuntime create(RemoteDockerRuntime runtime, DockerAgentDeploymentConfig config2) throws ServerRuntimeException {
        RemoteDockerApplicationRuntime result2 = new RemoteDockerApplicationRuntime(runtime);
        result2.create(config2, runtime.getProject());
        return result2;
    }

    public void start() throws ServerRuntimeException {
        this.executeAgentTask(this.myContainer.startContainer());
    }

    public void attach() throws ServerRuntimeException {
        this.myAttachResult = (DockerAttachResult)RemoteDockerRuntimeUtil.executeAgentTask(() -> {
            try {
                return DockerRemoteUtilsKt.attach(this.myContainer);
            }
            catch (Exception e) {
                this.mySemaphore.up();
                throw new ServerRuntimeException((Throwable)e);
            }
        });
        this.myAttachResult.getClosePromise().thenAccept(e -> this.mySemaphore.up());
    }

    public void startAndAttach() throws ServerRuntimeException {
        this.attach();
        this.start();
    }

    @NotNull
    public ProcessOutput exec(String @NotNull [] command) throws IOException, ServerRuntimeException {
        if (command == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(0);
        }
        ProcessOutput result2 = new ProcessOutput();
        Integer exitCode2 = this.executeAgentTask(DockerRemoteUtilsKt.execCommand(this.myContainer, command, true, out -> result2.appendStdout(out), err -> result2.appendStderr(err)));
        result2.setExitCode(exitCode2.intValue());
        ProcessOutput processOutput2 = result2;
        if (processOutput2 == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(1);
        }
        return processOutput2;
    }

    @NotNull
    public ProcessOutput execWithoutTty(String @NotNull [] command, @Nullable String workingDir2, @NotNull List<String> envVars) throws ServerRuntimeException {
        if (envVars == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(2);
        }
        if (command == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(3);
        }
        ProcessOutput result2 = new ProcessOutput();
        Integer exitCode2 = this.executeAgentTask(DockerRemoteUtilsKt.execCommand(this.myContainer, command, false, null, workingDir2, envVars, out -> result2.appendStdout(out), err -> result2.appendStderr(err)));
        result2.setExitCode(exitCode2.intValue());
        ProcessOutput processOutput2 = result2;
        if (processOutput2 == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(4);
        }
        return processOutput2;
    }

    private void create(DockerAgentDeploymentConfig config2, @Nullable Project project) throws ServerRuntimeException {
        DockerAgentPathMapperImpl pathMapper2 = new DockerAgentPathMapperImpl(project, this.myRuntime.getAccount());
        DockerAgentDeployment deployment = this.getAgent().createDeployment(config2, pathMapper2);
        DockerAgentApplication.ContainerUpdateResult result2 = this.executeAgentTask(deployment.deployAsync(null));
        this.myContainer = result2.getCreatedAgentContainer();
    }

    public ProcessOutput startAndGetOutput() throws ServerRuntimeException, IOException {
        try {
            this.startAndAttach();
            ProcessOutput processOutput2 = this.wait4AndGetOutput();
            return processOutput2;
        }
        finally {
            this.removeContainerWithVolumes();
        }
    }

    public void removeContainer() {
        try {
            this.executeAgentTask(this.myContainer.deleteContainer());
        }
        catch (ServerRuntimeException e) {
            LOG.info(e.getMessage());
        }
    }

    public void removeContainerWithVolumes() {
        try {
            this.executeAgentTask(this.myContainer.deleteContainerWithVolumes());
        }
        catch (ServerRuntimeException e) {
            LOG.info(e.getMessage());
        }
    }

    private void stopContainerImmediate() {
        try {
            this.executeAgentTask(this.myContainer.stopContainer());
        }
        catch (ServerRuntimeException e) {
            LOG.info(e.getMessage());
        }
    }

    public <T> T executeAgentTask(CompletableFuture<T> future) throws ServerRuntimeException {
        return RemoteDockerRuntimeUtil.executeAgentTask(future);
    }

    @NotNull
    public InputStream getStdout() {
        InputStream inputStream = this.myAttachResult.getStdout();
        if (inputStream == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(5);
        }
        return inputStream;
    }

    @NotNull
    public InputStream getStderr() {
        InputStream inputStream = this.myAttachResult.getStderr();
        if (inputStream == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(6);
        }
        return inputStream;
    }

    @NotNull
    public OutputStream getStdin() {
        OutputStream outputStream = this.myAttachResult.getStdin();
        if (outputStream == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(7);
        }
        return outputStream;
    }

    public void wait4terminal() {
        this.mySemaphore.waitFor();
    }

    public int wait4Exit() throws ServerRuntimeException {
        return this.executeAgentTask(this.myContainer.waitForExit());
    }

    public ProcessOutput wait4AndGetOutput() throws IOException, ServerRuntimeException {
        ProcessOutput result2 = new ProcessOutput();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        InputStreamConsumer stdoutConsumer = InputStreamConsumer.consume(this.myAttachResult.getStdout());
        InputStreamConsumer stderrConsumer = InputStreamConsumer.consume(this.myAttachResult.getStderr());
        if (indicator instanceof ProgressIndicatorEx) {
            ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                public void cancel() {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> RemoteDockerApplicationRuntime.this.stopContainerImmediate());
                }
            });
        }
        int exitCode2 = this.wait4Exit();
        result2.setExitCode(exitCode2);
        result2.appendStdout(stdoutConsumer.wait4Result());
        result2.appendStderr(stderrConsumer.wait4Result());
        return result2;
    }

    public DockerAgentContainerInfo inspect() throws ServerRuntimeException {
        return this.myContainer.getInfo();
    }

    public RemoteDockerRuntime getDockerRuntime() {
        return this.myRuntime;
    }

    public DockerAgent getAgent() {
        return this.myRuntime.getAgent();
    }

    public DockerAgentContainer getAgentContainer() {
        return this.myContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadDirectoryAndRemove(String sourceDirPath, File targetDir, Map<String, String> remoteToLocalPathName, String machineName) throws IOException, ServerRuntimeException {
        try {
            this.downloadDirectory(sourceDirPath, targetDir, remoteToLocalPathName, machineName, null);
        }
        finally {
            this.removeContainerWithVolumes();
        }
    }

    public void downloadDirectory(@NotNull String resourcePath, @NotNull File targetFile, @Nullable Map<String, String> remoteToLocalPathName, @Nullable String machineName, @Nullable Predicate<String> remotePathFilter) throws IOException, ServerRuntimeException {
        if (resourcePath == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(8);
        }
        if (targetFile == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(9);
        }
        RemoteDockerRuntimeUtil.download(this.myContainer, resourcePath, targetFile, remoteToLocalPathName, machineName, remotePathFilter);
    }

    @NotNull
    static String replacePathPrefix(@NotNull String path, @NotNull String newPrefix) {
        if (path == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(10);
        }
        if (newPrefix == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(11);
        }
        String string = RemoteDockerRuntimeUtil.replacePathPrefix(path, newPrefix);
        if (string == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(12);
        }
        return string;
    }

    public String getContainerId() {
        return this.getAgentContainer().getContainerId();
    }

    public void setWindowSize(int columns, int rows) {
        this.getAgent().resizeContainerTty(this.myContainer.getContainerId(), columns, rows);
    }

    public static RemoteDockerApplicationRuntime createWithImageInitialization(RemoteDockerRuntime dockerRuntime, DockerAgentDeploymentConfig config2, ImageInitializer initializer) throws ServerRuntimeException, IOException {
        try {
            return RemoteDockerApplicationRuntime.create(dockerRuntime, config2);
        }
        catch (WrappedNotFoundException e) {
            LOG.debug("Image {", new Object[]{Arrays.toString(config2.getImageTags()), "} has not been found", e});
            initializer.init();
            return RemoteDockerApplicationRuntime.create(dockerRuntime, config2);
        }
    }

    public static RemoteDockerApplicationRuntime createWithPullImage(RemoteDockerRuntime dockerRuntime, DockerAgentDeploymentConfig config2) throws IOException, ServerRuntimeException {
        Object[] tags = config2.getImageTags();
        if (tags.length != 1) {
            throw new IOException("Exactly one image tag or ID is required: " + Arrays.toString(tags));
        }
        return RemoteDockerApplicationRuntime.createWithImageInitialization(dockerRuntime, config2, () -> RemoteDockerApplicationRuntime.lambda$createWithPullImage$6(dockerRuntime, (String[])tags));
    }

    private static /* synthetic */ void lambda$createWithPullImage$6(RemoteDockerRuntime dockerRuntime, String[] tags) throws IOException, ServerRuntimeException {
        dockerRuntime.pullImage(tags[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6, 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remoteRunRuntime/RemoteDockerApplicationRuntime";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVars";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remoteRunRuntime/RemoteDockerApplicationRuntime";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "exec";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "execWithoutTty";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdout";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStderr";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdin";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "replacePathPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "exec";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execWithoutTty";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "downloadDirectory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replacePathPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 6, 7, 12 -> new IllegalStateException(string);
        };
    }

    public static interface ImageInitializer {
        public void init() throws IOException, ServerRuntimeException;
    }
}

