/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.infer;

import com.thaiopensource.relaxng.output.common.Name;
import com.thaiopensource.xml.infer.ChoiceParticle;
import com.thaiopensource.xml.infer.ContentModelInferrer;
import com.thaiopensource.xml.infer.ElementParticle;
import com.thaiopensource.xml.infer.EmptyParticle;
import com.thaiopensource.xml.infer.OneOrMoreParticle;
import com.thaiopensource.xml.infer.Particle;
import com.thaiopensource.xml.infer.SequenceParticle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

class ContentModelInferrerImpl
extends ContentModelInferrer {
    private static final Name START = new Name("", "#start");
    private static final Name END = new Name("", "#end");
    private final Map nameMap = new HashMap();
    private SingleNode prevNode;
    private final SingleNode startNode = this.lookup(START);
    private final SingleNode endNode = this.lookup(END);

    ContentModelInferrerImpl() {
        this.prevNode = this.startNode;
    }

    public void addElement(Name name) {
        SingleNode singleNode = this.lookup(name);
        if (singleNode == this.prevNode) {
            this.prevNode.repeated = true;
        } else {
            this.prevNode.followingNodes.add(singleNode);
            this.prevNode = singleNode;
        }
    }

    public void endSequence() {
        this.prevNode.followingNodes.add(this.endNode);
        this.prevNode = this.startNode;
    }

    private SingleNode lookup(Name name) {
        SingleNode singleNode = (SingleNode)this.nameMap.get(name);
        if (singleNode == null) {
            singleNode = new SingleNode(name, this.nameMap.size());
            this.nameMap.put(name, singleNode);
        }
        return singleNode;
    }

    public Particle inferContentModel() {
        if (this.startNode.followingNodes.size() == 0 || this.prevNode != this.startNode) {
            throw new IllegalStateException();
        }
        ParticleNode particleNode = new StronglyConnectedComponentsFinder(this.nameMap.size()).makeDag(this.lookup(START));
        int n = particleNode.index + 1;
        new ParticleMerger(n).merge(particleNode);
        return new ParticleBuilder(n).build(particleNode);
    }

    private static Particle makeParticle(Name name) {
        if (name == START || name == END) {
            return null;
        }
        return new ElementParticle(name);
    }

    public Set getElementNames() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.nameMap.keySet());
        hashSet.remove(START);
        hashSet.remove(END);
        return hashSet;
    }

    private static class ParticleMerger {
        private final boolean[] done;

        private ParticleMerger(int n) {
            this.done = new boolean[n];
        }

        void merge(ParticleNode particleNode) {
            Object object;
            if (this.done[particleNode.index]) {
                return;
            }
            this.done[particleNode.index] = true;
            if (particleNode.particle != null) {
                while (particleNode.followingNodes.size() == 1) {
                    object = (ParticleNode)particleNode.followingNodes.iterator().next();
                    if (((ParticleNode)object).refCount != 1 || ((ParticleNode)object).particle == null) break;
                    particleNode.particle = new SequenceParticle(particleNode.particle, ((ParticleNode)object).particle);
                    particleNode.followingNodes = ((ParticleNode)object).followingNodes;
                }
            }
            object = particleNode.followingNodes.iterator();
            while (object.hasNext()) {
                this.merge((ParticleNode)object.next());
            }
        }
    }

    private static class ParticleBuilder {
        private final int[] rank;
        private int currentRank = 0;
        private Particle rankParticleChoice;
        private Particle followParticle;
        int followRanksTotalRefCount = 0;
        int currentRankTotalRefCount = 0;
        int totalCoveredRefCount = 0;

        ParticleBuilder(int n) {
            this.rank = new int[n];
        }

        Particle build(ParticleNode particleNode) {
            this.visit(particleNode);
            if (this.followParticle == null) {
                this.followParticle = new EmptyParticle();
            }
            return this.followParticle;
        }

        void visit(ParticleNode particleNode) {
            int n;
            int n2 = 0;
            Iterator iterator = particleNode.followingNodes.iterator();
            while (iterator.hasNext()) {
                ParticleNode particleNode2 = (ParticleNode)iterator.next();
                if (this.rank[particleNode2.index] == 0) {
                    this.visit(particleNode2);
                }
                n2 = Math.max(n2, this.rank[particleNode2.index]);
            }
            this.rank[particleNode.index] = n = n2 + 1;
            if (n == this.currentRank) {
                this.rankParticleChoice = new ChoiceParticle(this.rankParticleChoice, particleNode.particle);
                this.currentRankTotalRefCount += particleNode.refCount;
            } else {
                if (this.totalCoveredRefCount != this.followRanksTotalRefCount) {
                    this.rankParticleChoice = new ChoiceParticle(this.rankParticleChoice, new EmptyParticle());
                }
                this.followParticle = this.followParticle == null ? this.rankParticleChoice : new SequenceParticle(this.rankParticleChoice, this.followParticle);
                this.followRanksTotalRefCount += this.currentRankTotalRefCount;
                this.rankParticleChoice = particleNode.particle;
                this.currentRankTotalRefCount = particleNode.refCount;
                this.currentRank = n;
            }
            this.totalCoveredRefCount += particleNode.followingNodes.size();
        }
    }

    private static class StronglyConnectedComponentsFinder {
        private final int[] visited;
        private final SingleNode[] root;
        private int visitIndex = 0;
        private final Stack stack = new Stack();
        private final ParticleNode[] particleNodes;
        private final SingleNode[] singleNodes;
        private int nParticles = 0;

        StronglyConnectedComponentsFinder(int n) {
            this.visited = new int[n];
            this.root = new SingleNode[n];
            this.particleNodes = new ParticleNode[n];
            this.singleNodes = new SingleNode[n];
        }

        ParticleNode makeDag(SingleNode singleNode) {
            this.visit(singleNode);
            int n = 0;
            while (n < this.singleNodes.length) {
                Iterator iterator = this.singleNodes[n].followingNodes.iterator();
                while (iterator.hasNext()) {
                    this.particleNodes[n].addFollowing(this.particleNodes[((SingleNode)iterator.next()).index]);
                }
                ++n;
            }
            return this.particleNodes[singleNode.index];
        }

        void visit(SingleNode singleNode) {
            SingleNode singleNode2;
            this.root[singleNode.index] = singleNode;
            this.visited[singleNode.index] = ++this.visitIndex;
            this.singleNodes[singleNode.index] = singleNode;
            this.stack.push(singleNode);
            Iterator iterator = singleNode.followingNodes.iterator();
            while (iterator.hasNext()) {
                singleNode2 = (SingleNode)iterator.next();
                if (this.visited[singleNode2.index] == 0) {
                    this.visit(singleNode2);
                }
                if (this.particleNodes[singleNode2.index] != null) continue;
                this.root[singleNode.index] = this.firstVisited(this.root[singleNode.index], this.root[singleNode2.index]);
            }
            if (this.root[singleNode.index] == singleNode) {
                singleNode2 = (SingleNode)this.stack.pop();
                ParticleNode particleNode = new ParticleNode(this.nParticles++);
                particleNode.particle = ContentModelInferrerImpl.makeParticle(singleNode2.name);
                this.particleNodes[singleNode2.index] = particleNode;
                if (singleNode2 != singleNode) {
                    do {
                        singleNode2 = (SingleNode)this.stack.pop();
                        this.particleNodes[singleNode2.index] = particleNode;
                        particleNode.particle = new ChoiceParticle(ContentModelInferrerImpl.makeParticle(singleNode2.name), particleNode.particle);
                    } while (singleNode2 != singleNode);
                    particleNode.particle = new OneOrMoreParticle(particleNode.particle);
                } else if (singleNode2.repeated) {
                    particleNode.particle = new OneOrMoreParticle(particleNode.particle);
                }
            }
        }

        SingleNode firstVisited(SingleNode singleNode, SingleNode singleNode2) {
            return this.visited[singleNode.index] < this.visited[singleNode2.index] ? singleNode : singleNode2;
        }
    }

    private static class ParticleNode {
        final int index;
        Particle particle;
        int refCount = 0;
        Set followingNodes = new HashSet();

        ParticleNode(int n) {
            this.index = n;
        }

        void addFollowing(ParticleNode particleNode) {
            if (particleNode != this && !this.followingNodes.contains(particleNode)) {
                ++particleNode.refCount;
                this.followingNodes.add(particleNode);
            }
        }
    }

    private static class SingleNode {
        final Set followingNodes = new HashSet();
        final Name name;
        final int index;
        boolean repeated = false;

        SingleNode(Name name, int n) {
            this.name = name;
            this.index = n;
        }
    }
}

