/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.files;

import com.intellij.lang.Language;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.LocalModelDescriptor;
import org.jetbrains.completion.full.line.language.ModelSettings;
import org.jetbrains.completion.full.line.language.ModelSettingsKt;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;
import org.jetbrains.completion.full.line.local.files.DownloadingLanguagesMaintainer;
import org.jetbrains.completion.full.line.local.files.LocalModelsBundleManager;
import org.jetbrains.completion.full.line.local.files.LocalModelsFilesService;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/completion/full/line/local/files/LocalModelsShipmentState;", "", "<init>", "(Ljava/lang/String;I)V", "BUNDLED", "DOWNLOADED", "DOWNLOADING", "AVAILABLE_TO_DOWNLOAD", "UNAVAILABLE", "Companion", "intellij.fullLine"})
public final class LocalModelsShipmentState
extends Enum<LocalModelsShipmentState> {
    @NotNull
    public static final Companion Companion;
    public static final /* enum */ LocalModelsShipmentState BUNDLED;
    public static final /* enum */ LocalModelsShipmentState DOWNLOADED;
    public static final /* enum */ LocalModelsShipmentState DOWNLOADING;
    public static final /* enum */ LocalModelsShipmentState AVAILABLE_TO_DOWNLOAD;
    public static final /* enum */ LocalModelsShipmentState UNAVAILABLE;
    private static final /* synthetic */ LocalModelsShipmentState[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    public static LocalModelsShipmentState[] values() {
        return (LocalModelsShipmentState[])$VALUES.clone();
    }

    public static LocalModelsShipmentState valueOf(String value) {
        return Enum.valueOf(LocalModelsShipmentState.class, value);
    }

    @NotNull
    public static EnumEntries<LocalModelsShipmentState> getEntries() {
        return $ENTRIES;
    }

    static {
        BUNDLED = new LocalModelsShipmentState();
        DOWNLOADED = new LocalModelsShipmentState();
        DOWNLOADING = new LocalModelsShipmentState();
        AVAILABLE_TO_DOWNLOAD = new LocalModelsShipmentState();
        UNAVAILABLE = new LocalModelsShipmentState();
        $VALUES = localModelsShipmentStateArray = new LocalModelsShipmentState[]{LocalModelsShipmentState.BUNDLED, LocalModelsShipmentState.DOWNLOADED, LocalModelsShipmentState.DOWNLOADING, LocalModelsShipmentState.AVAILABLE_TO_DOWNLOAD, LocalModelsShipmentState.UNAVAILABLE};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/completion/full/line/local/files/LocalModelsShipmentState$Companion;", "", "<init>", "()V", "downloadingStarted", "", "language", "Lcom/intellij/lang/Language;", "getState", "Lorg/jetbrains/completion/full/line/local/files/LocalModelsShipmentState;", "intellij.fullLine"})
    public static final class Companion {
        private Companion() {
        }

        public final void downloadingStarted(@NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            DownloadingLanguagesMaintainer.Companion.getInstance().downloadingStarted(language);
        }

        @NotNull
        public final LocalModelsShipmentState getState(@NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            ModelSettings modelsSettings = FullLineLanguageSupporter.Companion.modelSettingsFor(language);
            if (modelsSettings == null) {
                return UNAVAILABLE;
            }
            LocalModelDescriptor descriptor = ModelSettingsKt.getLocalModelDescriptor(modelsSettings);
            if (LocalModelsBundleManager.Companion.getInstance().isBundled(descriptor)) {
                return BUNDLED;
            }
            DownloadingLanguagesMaintainer downloadingMaintainer = DownloadingLanguagesMaintainer.Companion.getInstance();
            LocalModelsFilesService filesService = LocalModelsFilesService.Companion.getInstance();
            downloadingMaintainer.update(language, descriptor);
            return filesService.isRefreshing(descriptor) ? (downloadingMaintainer.isDownloadingStarted(language) ? DOWNLOADING : AVAILABLE_TO_DOWNLOAD) : (filesService.tryGetNow(descriptor) != null ? DOWNLOADED : AVAILABLE_TO_DOWNLOAD);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

