/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inlayHints;

import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.Option;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u000b0\u0005H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\u00020\n*\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0005H\u0016J\b\u0010\u001c\u001a\u00020\nH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/python/inlayHints/PythonInlayParameterHintsProvider;", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "<init>", "()V", "getInlayInfoForArgumentList", "", "Lcom/intellij/codeInsight/hints/InlayInfo;", "node", "Lcom/jetbrains/python/psi/PyArgumentList;", "isParameterHintSafeOverloads", "", "Lcom/jetbrains/python/psi/PyCallExpression$PyArgumentsMapping;", "getHintInfo", "Lcom/intellij/codeInsight/hints/HintInfo;", "element", "Lcom/intellij/psi/PsiElement;", "isLiteralArgument", "Lcom/jetbrains/python/psi/PyExpression;", "toQNameForBuiltins", "", "getParameterHints", "file", "Lcom/intellij/psi/PsiFile;", "getDefaultBlackList", "", "getBlacklistExplanationHTML", "getSupportedOptions", "Lcom/intellij/codeInsight/hints/Option;", "isBlackListSupported", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPythonInlayParameterHintsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonInlayParameterHintsProvider.kt\ncom/jetbrains/python/inlayHints/PythonInlayParameterHintsProvider\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n216#2,2:164\n11165#3:166\n11500#3,3:167\n1557#4:170\n1628#4,3:171\n*S KotlinDebug\n*F\n+ 1 PythonInlayParameterHintsProvider.kt\ncom/jetbrains/python/inlayHints/PythonInlayParameterHintsProvider\n*L\n56#1:164,2\n120#1:166\n120#1:167,3\n90#1:170\n90#1:171,3\n*E\n"})
public final class PythonInlayParameterHintsProvider
implements InlayParameterHintsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Option showForClassConstructorCalls;
    @NotNull
    private static final Option showForNonLiteralArguments;

    private final List<InlayInfo> getInlayInfoForArgumentList(PyArgumentList node) {
        Map<PyExpression, PyCallableParameter> mappedParameters;
        PyCallable callable;
        if (node.getParent() instanceof PyClass || node.getArguments().length == 1) {
            return CollectionsKt.emptyList();
        }
        TypeEvalContext context = TypeEvalContext.codeAnalysis(node.getProject(), node.getContainingFile());
        PyResolveContext pyResolveContext = PyResolveContext.defaultContext(context);
        Intrinsics.checkNotNullExpressionValue((Object)pyResolveContext, (String)"defaultContext(...)");
        PyResolveContext resolveContext = pyResolveContext;
        PyCallExpression pyCallExpression = node.getCallExpression();
        if (pyCallExpression == null) {
            return CollectionsKt.emptyList();
        }
        PyCallExpression callExpression = pyCallExpression;
        List<PyCallExpression.PyArgumentsMapping> list = callExpression.multiMapArguments(resolveContext);
        Intrinsics.checkNotNullExpressionValue(list, (String)"multiMapArguments(...)");
        List<PyCallExpression.PyArgumentsMapping> argumentMappings = list;
        if (!this.isParameterHintSafeOverloads(argumentMappings)) {
            return CollectionsKt.emptyList();
        }
        PyCallExpression.PyArgumentsMapping pyArgumentsMapping = (PyCallExpression.PyArgumentsMapping)CollectionsKt.first(argumentMappings);
        Intrinsics.checkNotNull((Object)pyArgumentsMapping);
        PyCallExpression.PyArgumentsMapping mapping = pyArgumentsMapping;
        PyCallableType pyCallableType = mapping.getCallableType();
        PyCallable pyCallable = callable = pyCallableType != null ? pyCallableType.getCallable() : null;
        if (callable == null || PyUtil.isInitOrNewMethod((PsiElement)callable) && !showForClassConstructorCalls.isEnabled()) {
            return CollectionsKt.emptyList();
        }
        List info = new ArrayList();
        Map<PyExpression, PyCallableParameter> map2 = mapping.getMappedParameters();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getMappedParameters(...)");
        Map<PyExpression, PyCallableParameter> $this$forEach$iv = mappedParameters = map2;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<PyExpression, PyCallableParameter>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PyExpression, PyCallableParameter> element$iv;
            Map.Entry<PyExpression, PyCallableParameter> entry = element$iv = iterator.next();
            boolean bl = false;
            PyExpression argument = entry.getKey();
            PyCallableParameter parameter = entry.getValue();
            if (parameter == null || argument == null) continue;
            if (parameter.isPositionalContainer()) {
                info.add(new InlayInfo("*" + parameter.getName(), argument.getTextOffset()));
                return info;
            }
            if (parameter.isKeywordContainer()) {
                return info;
            }
            if (argument instanceof PyKeywordArgument || !this.isLiteralArgument(argument) && !showForNonLiteralArguments.isEnabled()) continue;
            info.add(new InlayInfo(String.valueOf(parameter.getName()), argument.getTextOffset()));
        }
        return info;
    }

    private final boolean isParameterHintSafeOverloads(List<? extends PyCallExpression.PyArgumentsMapping> $this$isParameterHintSafeOverloads) {
        if ($this$isParameterHintSafeOverloads.size() == 1) {
            return true;
        }
        return SequencesKt.count((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$isParameterHintSafeOverloads), PythonInlayParameterHintsProvider::isParameterHintSafeOverloads$lambda$1), PythonInlayParameterHintsProvider::isParameterHintSafeOverloads$lambda$2), PythonInlayParameterHintsProvider::isParameterHintSafeOverloads$lambda$4))) == 1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public HintInfo getHintInfo(@NotNull PsiElement element) {
        PsiElement parent;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PyArgumentList && (parent = ((PyArgumentList)element).getParent()) instanceof PyCallExpression) {
            PyExpression callee = ((PyCallExpression)parent).getCallee();
            if (callee == null) {
                return null;
            }
            TypeEvalContext context = TypeEvalContext.codeAnalysis(((PyArgumentList)element).getProject(), ((PyArgumentList)element).getContainingFile());
            PyResolveContext pyResolveContext = PyResolveContext.defaultContext(context);
            Intrinsics.checkNotNullExpressionValue((Object)pyResolveContext, (String)"defaultContext(...)");
            PyResolveContext resolveContext = pyResolveContext;
            List<PyCallableType> list = ((PyCallExpression)parent).multiResolveCallee(resolveContext);
            Intrinsics.checkNotNullExpressionValue(list, (String)"multiResolveCallee(...)");
            PyCallableType pyCallableType = (PyCallableType)CollectionsKt.firstOrNull(list);
            if (pyCallableType == null) {
                return null;
            }
            PyCallableType callableType = pyCallableType;
            PyCallable callable = callableType.getCallable();
            if (callable instanceof PyQualifiedNameOwner) {
                String string;
                String qName = callable.getQualifiedName();
                if (PyBuiltinCache.isInBuiltins(callee)) {
                    String string2 = qName;
                    string = string2 != null ? this.toQNameForBuiltins(string2) : null;
                } else {
                    string = qName;
                }
                String fullQName = string;
                PyParameterList pyParameterList = callable.getParameterList();
                Intrinsics.checkNotNullExpressionValue((Object)pyParameterList, (String)"getParameterList(...)");
                PyParameterList parameterList = pyParameterList;
                if (fullQName != null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    PyParameter[] pyParameterArray = parameterList.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)pyParameterArray, (String)"getParameters(...)");
                    Object[] objectArray = pyParameterArray;
                    String string3 = fullQName;
                    boolean $i$f$map = false;
                    void var13_14 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        void parameter;
                        PyParameter pyParameter = (PyParameter)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Object object = parameter.getAsNamed();
                        if (object == null || (object = object.getRepr(false)) == null || (object = StringsKt.replace$default((String)object, (String)"*", (String)"<star>", (boolean)false, (int)4, null)) == null) {
                            object = parameter instanceof PySlashParameter ? "/" : "*";
                        }
                        collection.add(object);
                    }
                    List list2 = (List)destination$iv$iv;
                    String string4 = string3;
                    return (HintInfo)new HintInfo.MethodInfo(string4, list2);
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLiteralArgument(PyExpression $this$isLiteralArgument) {
        if ($this$isLiteralArgument instanceof PyLiteralExpression) return true;
        if ($this$isLiteralArgument instanceof PyListLiteralExpression) return true;
        if ($this$isLiteralArgument instanceof PyDictLiteralExpression) return true;
        if (!($this$isLiteralArgument instanceof PyParenthesizedExpression)) return false;
        PsiElement[] psiElementArray = ((PyParenthesizedExpression)$this$isLiteralArgument).getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        if (!(ArraysKt.first((Object[])psiElementArray) instanceof PyTupleExpression)) return false;
        return true;
    }

    private final String toQNameForBuiltins(String $this$toQNameForBuiltins) {
        Object[] objectArray = new String[]{"builtins"};
        List components = CollectionsKt.mutableListOf((Object[])objectArray);
        objectArray = new String[]{"."};
        components.addAll(StringsKt.split$default((CharSequence)$this$toQNameForBuiltins, (String[])objectArray, (boolean)false, (int)0, (int)6, null));
        String string = QualifiedName.fromComponents((Collection)components).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return element instanceof PyArgumentList ? this.getInlayInfoForArgumentList((PyArgumentList)element) : CollectionsKt.emptyList();
    }

    @NotNull
    public Set<String> getDefaultBlackList() {
        Object[] objectArray = new String[]{"builtins.*", "typing.*"};
        return SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public String getBlacklistExplanationHTML() {
        Object[] objectArray = new Object[]{KeymapUtil.getFirstKeyboardShortcutText((String)"ShowIntentionActions")};
        String string = PyBundle.message("inlay.parameters.python.hints.blacklist.explanation", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public List<Option> getSupportedOptions() {
        Object[] objectArray = new Option[]{showForClassConstructorCalls, showForNonLiteralArguments};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean isBlackListSupported() {
        return true;
    }

    private static final Map isParameterHintSafeOverloads$lambda$1(PyCallExpression.PyArgumentsMapping mapping) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        return mapping.getMappedParameters();
    }

    private static final Collection isParameterHintSafeOverloads$lambda$2(Map parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        return parameters.values();
    }

    /*
     * WARNING - void declaration
     */
    private static final List isParameterHintSafeOverloads$lambda$4(Collection listOfParameters) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)listOfParameters, (String)"listOfParameters");
        Iterable $this$map$iv = listOfParameters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void parameter;
            PyCallableParameter pyCallableParameter = (PyCallableParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(parameter.getPresentableText(false));
        }
        return (List)destination$iv$iv;
    }

    static {
        Supplier<String> supplier = PyBundle.messagePointer("inlay.parameters.python.show.class.constructor.call.parameter.names", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        showForClassConstructorCalls = new Option("python.show.class.constructor.call.parameter.names", supplier, true);
        Supplier<String> supplier2 = PyBundle.messagePointer("inlay.parameters.python.show.hints.for.non-literal.arguments", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier2, (String)"messagePointer(...)");
        showForNonLiteralArguments = new Option("python.show.hints.for.non-literal.arguments", supplier2, false);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/inlayHints/PythonInlayParameterHintsProvider$Companion;", "", "<init>", "()V", "showForClassConstructorCalls", "Lcom/intellij/codeInsight/hints/Option;", "getShowForClassConstructorCalls", "()Lcom/intellij/codeInsight/hints/Option;", "showForNonLiteralArguments", "getShowForNonLiteralArguments", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Option getShowForClassConstructorCalls() {
            return showForClassConstructorCalls;
        }

        @NotNull
        public final Option getShowForNonLiteralArguments() {
            return showForNonLiteralArguments;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

