/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.installer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.Binary;
import com.jetbrains.python.sdk.Release;
import com.jetbrains.python.sdk.installer.BinaryInstallation;
import com.jetbrains.python.sdk.installer.BinaryInstaller;
import com.jetbrains.python.sdk.installer.BinaryInstallerException;
import com.jetbrains.python.sdk.installer.BinaryInstallerKt;
import com.jetbrains.python.sdk.installer.BinaryInstallerUsagesCollector;
import com.jetbrains.python.sdk.installer.CancelledPrepareException;
import com.jetbrains.python.sdk.installer.CancelledProcessException;
import com.jetbrains.python.sdk.installer.PrepareException;
import com.jetbrains.python.sdk.installer.ResourcePreview;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u001a=\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\r\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0010\b\u0002\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u000e0\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014\u001a\"\u0010\u0015\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001a"}, d2={"LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOGGER", "()Lcom/intellij/openapi/diagnostic/Logger;", "toResourcePreview", "Lcom/jetbrains/python/sdk/installer/ResourcePreview;", "Lcom/jetbrains/python/sdk/installer/BinaryInstallation;", "selectInstallations", "", "Lcom/jetbrains/python/sdk/Release;", "installers", "Lcom/jetbrains/python/sdk/installer/BinaryInstaller;", "installBinary", "Lkotlin/Result;", "T", "installation", "project", "Lcom/intellij/openapi/project/Project;", "postInstall", "Lkotlin/Function0;", "(Lcom/jetbrains/python/sdk/installer/BinaryInstallation;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "showErrorNotification", "", "release", "ex", "Lcom/jetbrains/python/sdk/installer/BinaryInstallerException;", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nBinaryInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinaryInstaller.kt\ncom/jetbrains/python/sdk/installer/BinaryInstallerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,98:1\n774#2:99\n865#2,2:100\n1611#2,9:102\n1863#2:111\n295#2,2:112\n1864#2:116\n1620#2:117\n1#3:114\n1#3:115\n14#4:118\n*S KotlinDebug\n*F\n+ 1 BinaryInstaller.kt\ncom/jetbrains/python/sdk/installer/BinaryInstallerKt\n*L\n56#1:99\n56#1:100,2\n57#1:102,9\n57#1:111\n58#1:112,2\n57#1:116\n57#1:117\n57#1:115\n15#1:118\n*E\n"})
public final class BinaryInstallerKt {
    @NotNull
    private static final Logger LOGGER;

    @NotNull
    public static final Logger getLOGGER() {
        return LOGGER;
    }

    @NotNull
    public static final ResourcePreview toResourcePreview(@NotNull BinaryInstallation $this$toResourcePreview) {
        Intrinsics.checkNotNullParameter((Object)$this$toResourcePreview, (String)"<this>");
        return $this$toResourcePreview.getInstaller().getPreview($this$toResourcePreview.getBinary());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<BinaryInstallation> selectInstallations(@NotNull Release $this$selectInstallations, @NotNull List<? extends BinaryInstaller> installers) {
        void $this$mapNotNullTo$iv$iv;
        List list;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$this$selectInstallations, (String)"<this>");
        Intrinsics.checkNotNullParameter(installers, (String)"installers");
        List<Binary> list2 = $this$selectInstallations.getBinaries();
        if (list2 != null) {
            void $this$filterTo$iv$iv;
            $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Binary it = (Binary)element$iv$iv;
                boolean bl = false;
                if (!Binary.isCompatible$default(it, null, null, 3, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List compatibleBinaries = list;
        Iterable $this$mapNotNull$iv = compatibleBinaries;
        boolean $i$f$mapNotNull = false;
        $this$filter$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BinaryInstallation binaryInstallation;
            Object v2;
            Binary binary;
            block7: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                binary = (Binary)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$firstOrNull$iv = installers;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    BinaryInstaller it = (BinaryInstaller)element$iv;
                    boolean bl3 = false;
                    if (!it.canInstall(binary)) continue;
                    v2 = element$iv;
                    break block7;
                }
                v2 = null;
            }
            if ((BinaryInstaller)v2 != null) {
                BinaryInstaller it;
                boolean bl = false;
                binaryInstallation = new BinaryInstallation($this$selectInstallations, binary, it);
            } else {
                binaryInstallation = null;
            }
            if (binaryInstallation == null) continue;
            BinaryInstallation it$iv$iv = binaryInstallation;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @RequiresEdt
    @NotNull
    public static final <T> Object installBinary(@NotNull BinaryInstallation installation, @Nullable Project project, @NotNull Function0<? extends T> postInstall) {
        Intrinsics.checkNotNullParameter((Object)installation, (String)"installation");
        Intrinsics.checkNotNullParameter(postInstall, (String)"postInstall");
        Release release = installation.component1();
        Binary binary = installation.component2();
        BinaryInstaller installer = installation.component3();
        try {
            Object[] objectArray = new Object[]{release.getTitle()};
            String string = PyBundle.message("python.sdk.installing", objectArray);
            return Result.constructor-impl((Object)ProgressManager.getInstance().run(new Task.WithResult<T, Exception>(project, installer, binary, release, postInstall, string){
                final /* synthetic */ Project $project;
                final /* synthetic */ BinaryInstaller $installer;
                final /* synthetic */ Binary $binary;
                final /* synthetic */ Release $release;
                final /* synthetic */ Function0<T> $postInstall;
                {
                    this.$project = $project;
                    this.$installer = $installer;
                    this.$binary = $binary;
                    this.$release = $release;
                    this.$postInstall = $postInstall;
                    super($project, $super_call_param$1, true);
                }

                protected T compute(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    this.$installer.install(this.$binary, indicator, (Function0<Unit>)((Function0)() -> installBinary.2.compute$lambda$0(this.$project, this.$release)));
                    BinaryInstallerUsagesCollector.INSTANCE.logInstallationEvent(this.$project, this.$release, BinaryInstallerUsagesCollector.InstallationResult.OK);
                    return (T)this.$postInstall.invoke();
                }

                private static final Unit compute$lambda$0(Project $project, Release $release) {
                    BinaryInstallerUsagesCollector.INSTANCE.logDownloadEvent($project, $release, BinaryInstallerUsagesCollector.DownloadResult.OK);
                    return Unit.INSTANCE;
                }
            }));
        }
        catch (BinaryInstallerException ex) {
            LOGGER.info((Throwable)ex);
            BinaryInstallerUsagesCollector.INSTANCE.logInstallerException$intellij_python_community_impl(project, installation.getRelease(), ex);
            BinaryInstallerKt.showErrorNotification(project, release, ex);
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)ex));
        }
    }

    public static /* synthetic */ Object installBinary$default(BinaryInstallation binaryInstallation, Project project, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = installBinary.1.INSTANCE;
        }
        return BinaryInstallerKt.installBinary(binaryInstallation, project, function0);
    }

    private static final void showErrorNotification(Project project, Release release, BinaryInstallerException ex) {
        String string;
        String string2;
        Object object;
        if (ex instanceof PrepareException) {
            object = new Object[]{release.getTitle()};
            string2 = PyBundle.message("python.sdk.download.failed.title", object);
        } else {
            object = new Object[]{release.getTitle()};
            string2 = PyBundle.message("python.sdk.installation.failed.title", object);
        }
        String string3 = string2;
        Intrinsics.checkNotNull((Object)string3);
        String title = string3;
        object = ex;
        if (object instanceof CancelledProcessException || object instanceof CancelledPrepareException) {
            string = PyBundle.message("python.sdk.installation.cancelled.message", new Object[0]);
        } else if (object instanceof PrepareException) {
            string = PyBundle.message("python.sdk.download.failed.message", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{release.getTitle()};
            string = PyBundle.message("python.sdk.try.to.install.manually", objectArray);
        }
        String string4 = string;
        Intrinsics.checkNotNull((Object)string4);
        String message = string4;
        Messages.showErrorDialog((Project)project, (String)message, (String)title);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BinaryInstaller.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }
}

