/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.highlighting;

import com.intellij.jinja.lexer.Jinja2Lexer;
import com.intellij.jinja.lexer.Jinja2TokenTypes;
import com.intellij.jinja.template.highlighting.Jinja2TemplateHighlighterColors;
import com.intellij.jinja.template.parsing.DjangoTemplateTokenTypes;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class Jinja2SyntaxHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();

    @NotNull
    public Lexer getHighlightingLexer() {
        return new Jinja2Lexer();
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)ATTRIBUTES.get(tokenType));
        if (textAttributesKeyArray == null) {
            Jinja2SyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    private static void register(IElementType type, TextAttributesKey key) {
        ATTRIBUTES.put(type, key);
    }

    static {
        Jinja2SyntaxHighlighter.register(DjangoTemplateTokenTypes.DJANGO_COMMENT, Jinja2TemplateHighlighterColors.DJANGO_COMMENT);
        Jinja2SyntaxHighlighter.register(DjangoTemplateTokenTypes.DJANGO_COMMENT_START, Jinja2TemplateHighlighterColors.DJANGO_COMMENT);
        Jinja2SyntaxHighlighter.register(DjangoTemplateTokenTypes.DJANGO_COMMENT_END, Jinja2TemplateHighlighterColors.DJANGO_COMMENT);
        Jinja2SyntaxHighlighter.register(DjangoTemplateTokenTypes.DJANGO_TAG_START, Jinja2TemplateHighlighterColors.DJANGO_TAG_START_END);
        Jinja2SyntaxHighlighter.register(DjangoTemplateTokenTypes.DJANGO_TAG_END, Jinja2TemplateHighlighterColors.DJANGO_TAG_START_END);
        Jinja2SyntaxHighlighter.register(Jinja2TokenTypes.TAG_START_TRIM, Jinja2TemplateHighlighterColors.DJANGO_TAG_START_END);
        Jinja2SyntaxHighlighter.register(Jinja2TokenTypes.TAG_END_TRIM, Jinja2TemplateHighlighterColors.DJANGO_TAG_START_END);
        Jinja2SyntaxHighlighter.register(Jinja2TokenTypes.TAG_START_PRESERVE, Jinja2TemplateHighlighterColors.DJANGO_TAG_START_END);
        Jinja2SyntaxHighlighter.register(Jinja2TokenTypes.TAG_END_PRESERVE, Jinja2TemplateHighlighterColors.DJANGO_TAG_START_END);
        Jinja2SyntaxHighlighter.register(DjangoTemplateTokenTypes.DJANGO_TAG_NAME, Jinja2TemplateHighlighterColors.DJANGO_TAG_NAME);
        Jinja2SyntaxHighlighter.register(DjangoTemplateTokenTypes.ID, Jinja2TemplateHighlighterColors.DJANGO_ID);
        Jinja2SyntaxHighlighter.register(DjangoTemplateTokenTypes.IN, Jinja2TemplateHighlighterColors.DJANGO_KEYWORD);
        Jinja2SyntaxHighlighter.register(DjangoTemplateTokenTypes.OR, Jinja2TemplateHighlighterColors.DJANGO_KEYWORD);
        Jinja2SyntaxHighlighter.register(DjangoTemplateTokenTypes.AND, Jinja2TemplateHighlighterColors.DJANGO_KEYWORD);
        Jinja2SyntaxHighlighter.register(DjangoTemplateTokenTypes.NOT, Jinja2TemplateHighlighterColors.DJANGO_KEYWORD);
        Jinja2SyntaxHighlighter.register(DjangoTemplateTokenTypes.AS, Jinja2TemplateHighlighterColors.DJANGO_KEYWORD);
        Jinja2SyntaxHighlighter.register(DjangoTemplateTokenTypes.DOUBLE_QUOTED_STRING_LITERAL, Jinja2TemplateHighlighterColors.DJANGO_STRING_LITERAL);
        Jinja2SyntaxHighlighter.register(DjangoTemplateTokenTypes.I18N_STRING_LITERAL, Jinja2TemplateHighlighterColors.DJANGO_STRING_LITERAL);
        Jinja2SyntaxHighlighter.register(DjangoTemplateTokenTypes.SINGLE_QUOTED_STRING_LITERAL, Jinja2TemplateHighlighterColors.DJANGO_STRING_LITERAL);
        Jinja2SyntaxHighlighter.register(DjangoTemplateTokenTypes.INT_LITERAL, Jinja2TemplateHighlighterColors.DJANGO_NUMBER);
        Jinja2SyntaxHighlighter.register(Jinja2TokenTypes.FLOAT_LITERAL, Jinja2TemplateHighlighterColors.DJANGO_NUMBER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jinja/highlighting/Jinja2SyntaxHighlighter", "getTokenHighlights"));
    }
}

