/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.tags;

import com.google.common.collect.ImmutableSet;
import com.intellij.jinja.model.TemplateLanguageTagLibrary;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class Jinja2TagLibrary
implements TemplateLanguageTagLibrary {
    protected final Set<String> myCoreTags = ImmutableSet.of((Object)"for", (Object)"block", (Object)"filter", (Object)"with", (Object)"blocktrans", (Object)"cache", (Object[])new String[]{"macro", "if", "call", "set", "include", "extends", "import", "from", "autoescape", "raw", "trans", "do", "break", "continue"});
    private final Set<String> myBlockTags = ImmutableSet.of((Object)"for", (Object)"block", (Object)"filter", (Object)"with", (Object)"blocktrans", (Object)"cache", (Object[])new String[]{"macro", "if", "call", "raw", "trans"});
    private static final String[] FOR_LOOP_ATTRIBUTES = new String[]{"index", "index0", "revindex", "revindex0", "first", "last", "length", "cycle", "previtem", "nextitem", "changed"};
    private static final String[] IF_INNER_TAGS = new String[]{"elif", "else"};
    private static final String[] FOR_INNER_TAGS = new String[]{"else"};

    @Override
    public Set<String> getCoreTags() {
        return this.myCoreTags;
    }

    @Override
    public boolean isBlockTag(String name) {
        return this.myBlockTags.contains(name);
    }

    @Override
    public String[] getInnerTags(String tagName) {
        if (tagName.equals("if")) {
            return IF_INNER_TAGS;
        }
        if (tagName.equals("for")) {
            return FOR_INNER_TAGS;
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Override
    public String getForLoopIterator() {
        return "loop";
    }

    @Override
    public String[] getForLoopAttributes() {
        return FOR_LOOP_ATTRIBUTES;
    }

    @Override
    public Collection<Pair<String, PyFunction>> collectLoadedFilters(PsiFile template) {
        return Jinja2TagLibrary.loadFunctions(template, QualifiedName.fromComponents((String[])new String[]{"jinja2", "filters"}), "FILTERS");
    }

    @Override
    @Nullable
    public PsiElement resolveFilter(PsiFile template, String name) {
        Collection<Pair<String, PyFunction>> filters = this.collectLoadedFilters(template);
        return Jinja2TagLibrary.resolveInList(name, filters);
    }

    @Override
    public Collection<String> collectLoadedTags(PsiFile template) {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public PsiElement resolveTag(PsiFile containingFile, String tagName) {
        return null;
    }

    @Nullable
    public static PsiElement resolveInList(String name, Collection<? extends Pair<String, PyFunction>> functions) {
        for (Pair<String, PyFunction> pair2 : functions) {
            if (!((String)pair2.getFirst()).equals(name)) continue;
            return (PsiElement)pair2.getSecond();
        }
        return null;
    }

    public static Collection<Pair<String, PyFunction>> loadTests(PsiFile template) {
        return Jinja2TagLibrary.loadFunctions(template, QualifiedName.fromComponents((String[])new String[]{"jinja2", "tests"}), "TESTS");
    }

    private static Collection<Pair<String, PyFunction>> loadFunctions(PsiFile template, QualifiedName qualifiedName, String attrName) {
        PyExpression assignedValue;
        PyTargetExpression filters;
        PsiElement filtersModule = ResolveImportUtil.resolveModuleInRoots((QualifiedName)qualifiedName, (PsiElement)template);
        if (filtersModule instanceof PyFile && (filters = ((PyFile)filtersModule).findTopLevelAttribute(attrName)) != null && (assignedValue = filters.findAssignedValue()) instanceof PyDictLiteralExpression) {
            return Jinja2TagLibrary.loadFunctionsFromDict((PyDictLiteralExpression)assignedValue);
        }
        return Collections.emptyList();
    }

    private static Collection<Pair<String, PyFunction>> loadFunctionsFromDict(PyDictLiteralExpression filterDict) {
        ArrayList<Pair<String, PyFunction>> result2 = new ArrayList<Pair<String, PyFunction>>();
        for (PyKeyValueExpression kve : filterDict.getElements()) {
            PsiReference valueRef;
            String name = PyPsiUtils.strValue((PyExpression)kve.getKey());
            PyExpression value2 = kve.getValue();
            if (value2 == null || (valueRef = value2.getReference()) == null) continue;
            PsiElement resolved = valueRef.resolve();
            if (name == null || !(resolved instanceof PyFunction)) continue;
            result2.add((Pair<String, PyFunction>)Pair.create((Object)name, (Object)((PyFunction)resolved)));
        }
        return result2;
    }

    public static abstract class TagProcessor {
        private boolean myDone = false;

        public void processTag(@Nullable String name, PyElement declaration) {
        }

        public void processFilter(@Nullable String name, PyElement declaration) {
        }

        public void process(String name, PyElement declaration, boolean isTag) {
            if (isTag) {
                this.processTag(name, declaration);
            } else {
                this.processFilter(name, declaration);
            }
        }

        public boolean isDone() {
            return this.myDone;
        }

        public void setDone(boolean done) {
            this.myDone = done;
        }
    }
}

