/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.coverage;

import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageLineMarkerRenderer;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.SimpleCoverageAnnotator;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.DirectoryCoverageViewExtension;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.pro.coverage.PyCoverageAnnotator;
import com.intellij.python.pro.coverage.PyCoverageEnabledConfiguration;
import com.intellij.python.pro.coverage.PyCoverageLineMarkerRenderer;
import com.intellij.python.pro.coverage.PyCoverageSuite;
import com.intellij.python.pro.coverage.PyCoverageUtil;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.util.Function;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.resolve.RootVisitor;
import com.jetbrains.python.psi.resolve.RootVisitorHost;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.sdk.PyRemoteSdkAdditionalDataMarker;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCoverageEngine
extends CoverageEngine {
    private static final Logger LOG = Logger.getInstance(PyCoverageEngine.class);
    private boolean myLineHighlightingEnabled = true;

    public boolean isApplicableTo(@NotNull RunConfigurationBase conf) {
        if (conf == null) {
            PyCoverageEngine.$$$reportNull$$$0(0);
        }
        return conf instanceof AbstractPythonRunConfiguration;
    }

    public String generateBriefReport(@NotNull Editor editor, @NotNull PsiFile psiFile, int lineNumber, int startOffset, int endOffset, @Nullable LineData lineData) {
        if (editor == null) {
            PyCoverageEngine.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            PyCoverageEngine.$$$reportNull$$$0(2);
        }
        StringBuilder report = new StringBuilder();
        if (lineData == null || lineData.getHits() == 0) {
            report.append("Line was missed");
        } else {
            report.append("Line was hit");
        }
        if (lineData != null && lineData.getStatus() == 1) {
            String linesStr = PyCoverageEngine.getMissingBranches(lineData).map(x2 -> (Integer)x2.first == 0 ? "exit" : ((Integer)x2.first).toString()).collect(Collectors.joining(","));
            report.append("\n").append("Line ").append(lineNumber).append(" didn't jump to ").append((String)("exit".equals(linesStr) ? linesStr : "line " + linesStr));
        }
        return report.toString();
    }

    public static Stream<Pair<Integer, JumpData>> getMissingBranches(@NotNull LineData lineData) {
        if (lineData == null) {
            PyCoverageEngine.$$$reportNull$$$0(3);
        }
        return IntStream.range(0, lineData.getJumps().length).mapToObj(idx -> Pair.create((Object)idx, (Object)lineData.getJumps()[idx])).filter(x2 -> ((JumpData)x2.second).getFalseHits() > 0);
    }

    @NotNull
    public CoverageEnabledConfiguration createCoverageEnabledConfiguration(@NotNull RunConfigurationBase conf) {
        if (conf == null) {
            PyCoverageEngine.$$$reportNull$$$0(4);
        }
        return new PyCoverageEnabledConfiguration((AbstractPythonRunConfiguration)conf);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, String[] filters, long lastCoverageTimeStamp, String suiteToMerge, boolean coverageByTestEnabled, boolean branchCoverage, boolean trackTestFolders, Project project) {
        void project2;
        if (covRunner == null) {
            PyCoverageEngine.$$$reportNull$$$0(5);
        }
        if (name == null) {
            PyCoverageEngine.$$$reportNull$$$0(6);
        }
        if (coverageDataFileProvider == null) {
            PyCoverageEngine.$$$reportNull$$$0(7);
        }
        return new PyCoverageSuite(name, (Project)project2, covRunner, coverageDataFileProvider, lastCoverageTimeStamp, null, this);
    }

    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @NotNull CoverageEnabledConfiguration config2) {
        if (covRunner == null) {
            PyCoverageEngine.$$$reportNull$$$0(8);
        }
        if (name == null) {
            PyCoverageEngine.$$$reportNull$$$0(9);
        }
        if (coverageDataFileProvider == null) {
            PyCoverageEngine.$$$reportNull$$$0(10);
        }
        if (config2 == null) {
            PyCoverageEngine.$$$reportNull$$$0(11);
        }
        if (config2 instanceof PyCoverageEnabledConfiguration) {
            PyCoverageEnabledConfiguration rConfig = (PyCoverageEnabledConfiguration)config2;
            @Nullable String workingDirectory = rConfig.getConfiguration().getWorkingDirectory();
            return new PyCoverageSuite(name, config2.getConfiguration().getProject(), covRunner, coverageDataFileProvider, rConfig.createTimestamp(), workingDirectory, this);
        }
        return null;
    }

    @Nullable
    public CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner covRunner) {
        if (covRunner == null) {
            PyCoverageEngine.$$$reportNull$$$0(12);
        }
        return new PyCoverageSuite(this);
    }

    @NotNull
    public CoverageAnnotator getCoverageAnnotator(@NotNull Project project) {
        if (project == null) {
            PyCoverageEngine.$$$reportNull$$$0(13);
        }
        PyCoverageAnnotator pyCoverageAnnotator = PyCoverageAnnotator.getInstance(project);
        if (pyCoverageAnnotator == null) {
            PyCoverageEngine.$$$reportNull$$$0(14);
        }
        return pyCoverageAnnotator;
    }

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            PyCoverageEngine.$$$reportNull$$$0(15);
        }
        return psiFile instanceof PyFile;
    }

    public boolean coverageProjectViewStatisticsApplicableTo(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            PyCoverageEngine.$$$reportNull$$$0(16);
        }
        return !fileOrDir.isDirectory() && fileOrDir.getFileType() instanceof PythonFileType;
    }

    public Object @NotNull [] postProcessExecutableLines(Object @NotNull [] executableLines, @NotNull Editor editor) {
        if (editor == null) {
            PyCoverageEngine.$$$reportNull$$$0(17);
        }
        if (executableLines == null) {
            PyCoverageEngine.$$$reportNull$$$0(18);
        }
        Document doc = editor.getDocument();
        Object[] objectArray = (Object[])ReadAction.compute(() -> {
            try {
                int i;
                if (editor.getProject() == null) {
                    return executableLines;
                }
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(doc);
                if (!(psiFile instanceof PyFile)) {
                    return super.postProcessExecutableLines(executableLines, editor);
                }
                PyStatement[] lineStatements = new PyStatement[doc.getLineCount()];
                Object[] lines = new Object[Math.max(executableLines.length, lineStatements.length + 1)];
                boolean[] isWhiteSpace = new boolean[lines.length];
                boolean[] isElse = new boolean[lines.length];
                Arrays.fill(isWhiteSpace, false);
                Arrays.fill(isElse, false);
                for (int curLine = 0; curLine < doc.getLineCount(); ++curLine) {
                    int begin = doc.getLineStartOffset(curLine);
                    int end = doc.getLineEndOffset(curLine);
                    int offset2 = begin;
                    boolean whiteSpaceOnly = true;
                    boolean isElseLine = false;
                    while (offset2 < end) {
                        PsiElement el = psiFile.findElementAt(offset2);
                        if (el == null) {
                            ++offset2;
                            continue;
                        }
                        if (!(el instanceof PsiWhiteSpace) && !(el instanceof PsiComment) && el.getNode().getElementType() != PyTokenTypes.DOCSTRING) {
                            PyStatement stmt;
                            if (isElseLine && el.getNode().getElementType() != PyTokenTypes.COLON) {
                                isElseLine = false;
                            }
                            whiteSpaceOnly = false;
                            if (el.getNode().getElementType() == PyTokenTypes.ELSE_KEYWORD) {
                                isElseLine = true;
                            }
                            if (!isElseLine && (stmt = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)el, PyStatement.class)) != null) {
                                lineStatements[curLine] = stmt;
                                break;
                            }
                        }
                        offset2 = el.getTextOffset() + el.getTextLength();
                    }
                    if (whiteSpaceOnly) {
                        isWhiteSpace[curLine] = true;
                    }
                    if (!isElseLine) continue;
                    isElse[curLine] = true;
                }
                if (executableLines.length > 1) {
                    lines[1] = executableLines[1];
                }
                for (i = 2; i < Math.min(lines.length, lineStatements.length); ++i) {
                    if (i < executableLines.length) {
                        lines[i] = executableLines[i];
                    }
                    if (lines[i] != null) continue;
                    if (lineStatements[i - 1] != null && lineStatements[i - 2] == lineStatements[i - 1]) {
                        PyCoverageEngine.fillFrom(lines, i, i - 1);
                        continue;
                    }
                    if (!isWhiteSpace[i - 1] || lines[i - 1] == null) continue;
                    PyCoverageEngine.fillFrom(lines, i, i - 1);
                    lineStatements[i - 1] = lineStatements[i - 2];
                }
                for (i = 2; i < lines.length; ++i) {
                    if (!isWhiteSpace[i - 1] || lines[i - 1] == null) continue;
                    PyCoverageEngine.fillFrom(lines, i, i - 1);
                }
                for (i = lines.length - 3; i >= 0; --i) {
                    if (!isElse[i] || lines[i + 2] == null) continue;
                    PyCoverageEngine.fillFrom(lines, i + 1, i + 2);
                }
                return lines;
            }
            catch (Exception e) {
                LOG.error("Error while post-processing coverage data");
                return executableLines;
            }
        });
        if (objectArray == null) {
            PyCoverageEngine.$$$reportNull$$$0(19);
        }
        return objectArray;
    }

    private static void fillFrom(Object[] lines, int to, int from2) {
        Object object = lines[from2];
        if (object instanceof LineData) {
            LineData prevLine = (LineData)object;
            LineData newLine = PyCoverageEngine.createNewLine(to, prevLine);
            lines[to] = newLine;
        }
    }

    private static LineData createNewLine(int i, LineData prevLine) {
        LineData newLine = new LineData(i, "");
        newLine.setHits(prevLine.getHits());
        newLine.setStatus((byte)prevLine.getStatus());
        return newLine;
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        if (psiFile == null) {
            PyCoverageEngine.$$$reportNull$$$0(20);
        }
        if (suite == null) {
            PyCoverageEngine.$$$reportNull$$$0(21);
        }
        return true;
    }

    @Nullable
    public String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        if (outputFile == null) {
            PyCoverageEngine.$$$reportNull$$$0(22);
        }
        if (sourceFile == null) {
            PyCoverageEngine.$$$reportNull$$$0(23);
        }
        return PyCoverageEngine.getQName(sourceFile);
    }

    @Nullable
    private static String getQName(PsiFile sourceFile) {
        VirtualFile file = sourceFile.getVirtualFile().getCanonicalFile();
        if (file == null) {
            return null;
        }
        String filePath2 = file.getPath();
        return SimpleCoverageAnnotator.getFilePath((String)filePath2);
    }

    @NotNull
    public Set<String> getQualifiedNames(@NotNull PsiFile sourceFile) {
        String qName;
        if (sourceFile == null) {
            PyCoverageEngine.$$$reportNull$$$0(24);
        }
        Set<String> set2 = (qName = PyCoverageEngine.getQName(sourceFile)) != null ? Collections.singleton(qName) : Collections.emptySet();
        if (set2 == null) {
            PyCoverageEngine.$$$reportNull$$$0(25);
        }
        return set2;
    }

    public boolean includeUntouchedFileInCoverage(@NotNull String qualifiedName, @NotNull File outputFile, @NotNull PsiFile sourceFile, @NotNull CoverageSuitesBundle suite) {
        if (qualifiedName == null) {
            PyCoverageEngine.$$$reportNull$$$0(26);
        }
        if (outputFile == null) {
            PyCoverageEngine.$$$reportNull$$$0(27);
        }
        if (sourceFile == null) {
            PyCoverageEngine.$$$reportNull$$$0(28);
        }
        if (suite == null) {
            PyCoverageEngine.$$$reportNull$$$0(29);
        }
        return true;
    }

    public boolean isReportGenerationAvailable(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        Sdk projectSdk;
        if (project == null) {
            PyCoverageEngine.$$$reportNull$$$0(30);
        }
        if (dataContext == null) {
            PyCoverageEngine.$$$reportNull$$$0(31);
        }
        if (currentSuite == null) {
            PyCoverageEngine.$$$reportNull$$$0(32);
        }
        return (projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk()) != null && !(projectSdk.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataMarker);
    }

    public void generateReport(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        if (project == null) {
            PyCoverageEngine.$$$reportNull$$$0(33);
        }
        if (dataContext == null) {
            PyCoverageEngine.$$$reportNull$$$0(34);
        }
        if (currentSuite == null) {
            PyCoverageEngine.$$$reportNull$$$0(35);
        }
        PyCoverageUtil.generateReport(project, dataContext, currentSuite);
    }

    @NotNull
    public ExportToHTMLDialog createGenerateReportDialog(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        if (project == null) {
            PyCoverageEngine.$$$reportNull$$$0(36);
        }
        if (dataContext == null) {
            PyCoverageEngine.$$$reportNull$$$0(37);
        }
        if (currentSuite == null) {
            PyCoverageEngine.$$$reportNull$$$0(38);
        }
        ExportToHTMLDialog exportToHTMLDialog = super.createGenerateReportDialog(project, dataContext, currentSuite);
        if (exportToHTMLDialog == null) {
            PyCoverageEngine.$$$reportNull$$$0(39);
        }
        return exportToHTMLDialog;
    }

    @Nls
    public String getPresentableText() {
        return "CoveragePy";
    }

    public CoverageLineMarkerRenderer getLineMarkerRenderer(int lineNumber, String className, @NotNull TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, @NotNull CoverageSuitesBundle coverageSuite, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        if (lines == null) {
            PyCoverageEngine.$$$reportNull$$$0(40);
        }
        if (coverageSuite == null) {
            PyCoverageEngine.$$$reportNull$$$0(41);
        }
        return PyCoverageLineMarkerRenderer.getPyRenderer(lineNumber, className, lines, coverageByTestApplicable, coverageSuite, newToOldConverter, oldToNewConverter, subCoverageActive);
    }

    public boolean shouldHighlightFullLines() {
        return this.myLineHighlightingEnabled;
    }

    public void setLineHighlightingEnabled(boolean lineHighlightingEnabled) {
        this.myLineHighlightingEnabled = lineHighlightingEnabled;
    }

    public CoverageViewExtension createCoverageViewExtension(Project project, CoverageSuitesBundle suiteBundle) {
        return new DirectoryCoverageViewExtension(project, this.getCoverageAnnotator(project), suiteBundle);
    }

    public boolean isInLibraryClasses(@NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            PyCoverageEngine.$$$reportNull$$$0(42);
        }
        if (file == null) {
            PyCoverageEngine.$$$reportNull$$$0(43);
        }
        final Ref result2 = Ref.create((Object)super.isInLibraryClasses(project, file));
        RootVisitorHost.visitRootsInAllModules((Project)project, (RootVisitor)new RootVisitor(){

            public boolean visitRoot(VirtualFile root, @Nullable Module module, @Nullable Sdk sdk, boolean isModuleSource) {
                if (isModuleSource && VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) {
                    result2.set((Object)false);
                    return false;
                }
                return true;
            }
        });
        return (Boolean)result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 19, 25, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineData";
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "covRunner";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageDataFileProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 13: 
            case 30: 
            case 33: 
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 19: 
            case 25: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/pro/coverage/PyCoverageEngine";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableLines";
                break;
            }
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 23: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 32: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSuite";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSuite";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/pro/coverage/PyCoverageEngine";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageAnnotator";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "postProcessExecutableLines";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNames";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenerateReportDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateBriefReport";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMissingBranches";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageEnabledConfiguration";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageSuite";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyCoverageSuite";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageAnnotator";
                break;
            }
            case 14: 
            case 19: 
            case 25: 
            case 39: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "coverageEditorHighlightingApplicableTo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "coverageProjectViewStatisticsApplicableTo";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "postProcessExecutableLines";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "acceptedByFilters";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNames";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "includeUntouchedFileInCoverage";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isReportGenerationAvailable";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "generateReport";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createGenerateReportDialog";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerRenderer";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraryClasses";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 19, 25, 39 -> new IllegalStateException(string);
        };
    }
}

