/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.localization;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.jinja.Jinja2TemplateUtil;
import com.intellij.jinja.psi.Jinja2StringLiteral;
import com.intellij.jinja.template.psi.DjangoTagName;
import com.intellij.jinja.template.psi.impl.DjangoTagElementImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.pro.localization.LocaleLineMarkerUtils;
import com.intellij.python.pro.localization.PythonLocalizationBundle;
import com.intellij.util.Function;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.lang.template.tags.Jinja2BlockTransTag;
import com.jetbrains.localization.LocaleFileType;
import com.jetbrains.localization.psi.impl.LocaleMsgid;
import com.jetbrains.python.codeInsight.PyElementListCellRenderer;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public final class LocaleLineMarkerProvider
implements LineMarkerProvider,
DumbAware {
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            LocaleLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        if (elements == null) {
            LocaleLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            LocaleLineMarkerProvider.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (elements.isEmpty() || DumbService.getInstance((Project)elements.get(0).getProject()).isDumb()) {
            return;
        }
        for (int i = 0; i < elements.size(); ++i) {
            DjangoTagName parentTagName;
            DjangoTagElementImpl parent;
            PsiElement element = elements.get(i);
            if (element instanceof Jinja2BlockTransTag) {
                PsiElement anchor = PsiTreeUtil.getDeepestFirst((PsiElement)element);
                result2.add(new LineMarkerInfo(anchor, anchor.getTextRange(), LocaleFileType.INSTANCE.getIcon(), (Function)new ViewTooltipProvider(), new LocaleNavigationHandler(), GutterIconRenderer.Alignment.LEFT));
                continue;
            }
            if (!(element instanceof Jinja2StringLiteral) || (parent = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)element, DjangoTagElementImpl.class, (boolean)false)) == null || (parentTagName = Jinja2TemplateUtil.getTagNameElement(parent)) == null || !"trans".equals(parentTagName.getTagName())) continue;
            PsiElement anchor = PsiTreeUtil.getDeepestFirst((PsiElement)element);
            result2.add(new LineMarkerInfo(anchor, anchor.getTextRange(), LocaleFileType.INSTANCE.getIcon(), (Function)new ViewTooltipProvider(), new LocaleNavigationHandler(), GutterIconRenderer.Alignment.LEFT));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/pro/localization/LocaleLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ViewTooltipProvider
    implements Function<PsiElement, String> {
        private ViewTooltipProvider() {
        }

        @NlsContexts.Tooltip
        public String fun(PsiElement element) {
            Set<LocaleMsgid> usages = LocaleLineMarkerUtils.getReferences(element);
            if (usages.size() == 0) {
                return PythonLocalizationBundle.message("line.marker.tooltip.cannot.find.related.locale.message", new Object[0]);
            }
            if (usages.size() == 1) {
                return PythonLocalizationBundle.message("line.marker.tooltip.referenced.from", ViewTooltipProvider.getReferenceLocaleName((PsiElement)usages.iterator().next()));
            }
            HtmlBuilder result2 = new HtmlBuilder();
            result2.append(PythonLocalizationBundle.message("line.marker.tooltip.header.referenced.from", new Object[0]));
            for (LocaleMsgid usage : usages) {
                result2.br().nbsp(2).append(ViewTooltipProvider.getReferenceLocaleName((PsiElement)usage));
            }
            return result2.toString();
        }

        @NlsSafe
        private static String getReferenceLocaleName(PsiElement usage) {
            PsiFile file = usage.getContainingFile();
            VirtualFile vFile = file.getVirtualFile();
            Project project = usage.getProject();
            if (vFile == null) {
                return "";
            }
            DjangoFacet facet = DjangoFacet.getInstance(usage);
            VirtualFile root = facet != null ? ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile() : project.getBaseDir();
            Object location2 = "";
            if (root == null) {
                return "";
            }
            if (vFile.getUrl().startsWith(root.getUrl())) {
                location2 = VfsUtilCore.getRelativePath((VirtualFile)vFile, (VirtualFile)root, (char)File.separatorChar);
            }
            location2 = ".../" + (String)location2;
            return location2;
        }
    }

    private static class LocaleNavigationHandler<T extends PsiElement>
    implements GutterIconNavigationHandler<T> {
        private LocaleNavigationHandler() {
        }

        public void navigate(MouseEvent e, T elt) {
            Set<LocaleMsgid> references = LocaleLineMarkerUtils.getReferences(elt);
            PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])references.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY), (String)PythonLocalizationBundle.message("line.marker.popup.title.select.locale", new Object[0]), (String)PythonLocalizationBundle.message("find.usages.tab.title", new Object[0]), (ListCellRenderer)this.createListCellRenderer());
        }

        protected PyElementListCellRenderer createListCellRenderer() {
            return new PyElementListCellRenderer(){

                public String getElementText(PsiElement element) {
                    if (element instanceof LocaleMsgid) {
                        return ((LocaleMsgid)element).getId();
                    }
                    return super.getElementText(element);
                }
            };
        }
    }
}

