/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.intellij.python.profiler.UtilsKt;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/python/profiler/NumberWithPercentCellRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "totalMs", "", "<init>", "(I)V", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "hasFocus", "row", "column", "intellij.python.profiler"})
public final class NumberWithPercentCellRenderer
extends ColoredTableCellRenderer {
    private final int totalMs;

    public NumberWithPercentCellRenderer(int totalMs) {
        this.totalMs = totalMs;
    }

    protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value2, boolean selected, boolean hasFocus, int row, int column) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        if (value2 instanceof Integer) {
            this.append(String.valueOf(((Number)value2).intValue()));
            String format2 = UtilsKt.percent(((Number)value2).intValue(), this.totalMs);
            this.append(format2, SimpleTextAttributes.GRAY_ATTRIBUTES);
            this.appendTextPadding(this.getFontMetrics(this.getFont()).stringWidth(this.totalMs + " 100%") + 20, 4);
        }
    }
}

