/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.figures.base;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.scientific.figures.WithBinaryContent;
import com.intellij.python.scientific.figures.image.ImageVirtualFile;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0004J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH&J\b\u0010\u001f\u001a\u00020\tH&J\b\u0010 \u001a\u00020\u0011H&R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0011@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/intellij/python/scientific/figures/base/FigureContentPanelBase;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/python/scientific/figures/WithBinaryContent;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "editorTypeId", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "value", "Lcom/intellij/openapi/fileEditor/FileEditor;", "editor", "getEditor", "()Lcom/intellij/openapi/fileEditor/FileEditor;", "", "isHidden", "()Z", "setHidden", "(Z)V", "dispose", "", "getBytes", "", "addEditorComponent", "closeEditor", "reinitEditor", "getFileWithBinaryContent", "Lcom/intellij/python/scientific/figures/image/ImageVirtualFile;", "getFormat", "isPngAvailable", "intellij.python.scientific"})
public abstract class FigureContentPanelBase
extends JPanel
implements Disposable,
WithBinaryContent {
    private FileEditor editor;
    private boolean isHidden;

    public FigureContentPanelBase(@NotNull VirtualFile virtualFile, @NotNull Project project, @NotNull String editorTypeId) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editorTypeId, (String)"editorTypeId");
        super(new BorderLayout());
        this.addEditorComponent(virtualFile, project, editorTypeId);
    }

    @NotNull
    public final FileEditor getEditor() {
        FileEditor fileEditor = this.editor;
        if (fileEditor != null) {
            return fileEditor;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"editor");
        return null;
    }

    public final boolean isHidden() {
        return this.isHidden;
    }

    protected final void setHidden(boolean bl) {
        this.isHidden = bl;
    }

    public void dispose() {
        ImageVirtualFile imageVirtualFile = this.getFileWithBinaryContent();
        if (imageVirtualFile != null) {
            imageVirtualFile.clearImage();
        }
        Disposer.dispose((Disposable)((Disposable)this.getEditor()));
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        Object object;
        block3: {
            block2: {
                object = this.getFileWithBinaryContent();
                if (object == null) break block2;
                byte[] byArray = object.getContent();
                object = byArray;
                if (byArray != null) break block3;
            }
            object = new byte[0];
        }
        return object;
    }

    protected final void addEditorComponent(@NotNull VirtualFile virtualFile, @NotNull Project project, @NotNull String editorTypeId) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editorTypeId, (String)"editorTypeId");
        FileEditorProvider provider = FileEditorProviderManager.Companion.getInstance().getProvider(editorTypeId);
        if (provider != null) {
            ApplicationManager.getApplication().invokeLater(() -> FigureContentPanelBase.addEditorComponent$lambda$0(provider, project, virtualFile, this));
        }
        this.setBackground(UIUtil.getEditorPaneBackground());
    }

    public void closeEditor() {
    }

    public void reinitEditor() {
    }

    @Nullable
    public abstract ImageVirtualFile getFileWithBinaryContent();

    @NotNull
    public abstract String getFormat();

    public abstract boolean isPngAvailable();

    private static final void addEditorComponent$lambda$0(FileEditorProvider $provider, Project $project, VirtualFile $virtualFile, FigureContentPanelBase this$0) {
        FileEditor createdEditor;
        FileEditor fileEditor = $provider.createEditor($project, $virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"createEditor(...)");
        this$0.editor = createdEditor = fileEditor;
        this$0.add((Component)this$0.getEditor().getComponent(), "Center");
    }
}

