/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.commands;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.Strings;
import com.intellij.scientific.tables.DSTableBundle;
import com.intellij.scientific.tables.DSTableDataException;
import com.intellij.scientific.tables.DSTableDataManager;
import com.intellij.scientific.tables.DSTableRateExceededException;
import com.intellij.scientific.tables.DSTableRawData;
import com.intellij.scientific.tables.DataId;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a \u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\bH\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u000b2\b\b\u0001\u0010\u001e\u001a\u00020\u0001\u001a\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0001\u0010\u001e\u001a\u00020\u0001\u001a\u0016\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0001\u001a\u001c\u0010%\u001a\u00020&2\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u00012\u0006\u0010'\u001a\u00020\u000bH\u0000\u001a\u0018\u0010(\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u0010\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"TABLE_TYPE_NEXT_VALUE_SEPARATOR", "", "TABLE_OCCURRENCES_COUNT_NEXT_COLUMN_SEPARATOR", "TABLE_OCCURRENCES_COUNT_NEXT_VALUE_SEPARATOR", "TABLE_OCCURRENCES_COUNT_DICT_SEPARATOR", "TABLE_OCCURRENCES_COUNT_OTHER", "parseDataFrameShape", "", "", "shapeStr", "parseDataFrameInfo", "Lcom/intellij/scientific/tables/api/DSDataFrameInfo;", "text", "typeName", "parseDataFrameInfoForNumpy", "splitCommandResultAndCheckContent", "unwrapElement", "el", "Lorg/jsoup/nodes/Element;", "getIntAttr", "tableElement", "attrKey", "getIndexColumnWidthFromDocument", "tableDocument", "Lorg/jsoup/nodes/Document;", "getColsFromDocument", "getColumnTypes", "data", "numberOfColumns", "parseTableHtmlToFrameInfo", "tableHtml", "parseTableHtmlToData", "Lcom/intellij/scientific/tables/DSTableRawData;", "id", "Lcom/intellij/scientific/tables/DataId;", "parseTableCsvToData", "csvString", "setDataFrameDimensions", "", "dataFrameInfo", "typeErrorMessage", "checkOutputForErrorsAndThrowExceptionIfNeeded", "output", "intellij.scientific.py.tables"})
@SourceDebugExtension(value={"SMAP\nDSTableParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DSTableParser.kt\ncom/intellij/scientific/py/tables/commands/DSTableParserKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,265:1\n1557#2:266\n1628#2,3:267\n1557#2:271\n1628#2,3:272\n1557#2:275\n1628#2,3:276\n774#2:283\n865#2:284\n1755#2,3:285\n866#2:288\n1557#2:289\n1628#2,3:290\n1#3:270\n11165#4:279\n11500#4,3:280\n*S KotlinDebug\n*F\n+ 1 DSTableParser.kt\ncom/intellij/scientific/py/tables/commands/DSTableParserKt\n*L\n32#1:266\n32#1:267,3\n76#1:271\n76#1:272,3\n134#1:275\n134#1:276,3\n219#1:283\n219#1:284\n219#1:285,3\n219#1:288\n221#1:289\n221#1:290,3\n208#1:279\n208#1:280,3\n*E\n"})
public final class DSTableParserKt {
    @NotNull
    public static final String TABLE_TYPE_NEXT_VALUE_SEPARATOR = "__pydev_table_column_type_val__";
    @NotNull
    public static final String TABLE_OCCURRENCES_COUNT_NEXT_COLUMN_SEPARATOR = "__pydev_table_occurrences_count_next_column__";
    @NotNull
    public static final String TABLE_OCCURRENCES_COUNT_NEXT_VALUE_SEPARATOR = "__pydev_table_occurrences_count_next_value__";
    @NotNull
    public static final String TABLE_OCCURRENCES_COUNT_DICT_SEPARATOR = "__pydev_table_occurrences_count_dict__";
    @NotNull
    public static final String TABLE_OCCURRENCES_COUNT_OTHER = "__pydev_table_other__";

    private static final List<Integer> parseDataFrameShape(String shapeStr) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        String shape = ((Object)StringsKt.trim((CharSequence)shapeStr)).toString();
        if (StringsKt.startsWith$default((String)shape, (String)"(", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)shape, (String)")", (boolean)false, (int)2, null)) {
            String string = shape.substring(1, shape.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            shape = string;
        }
        String[] stringArray = new String[]{","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)shape, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int n;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            try {
                n = Integer.parseInt(it);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            collection.add(n);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final DSDataFrameInfo parseDataFrameInfo(@NotNull String text2, @NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        List<String> results = DSTableParserKt.splitCommandResultAndCheckContent(text2, typeName);
        int rows = ((Number)DSTableParserKt.parseDataFrameShape(results.get(1)).get(0)).intValue();
        Document doc = Jsoup.parse((String)results.get(2));
        Intrinsics.checkNotNull((Object)doc);
        List<String> columnNames = DSTableParserKt.getColsFromDocument(doc);
        int indexColumnWidth = DSTableParserKt.getIndexColumnWidthFromDocument(doc);
        List<String> columnTypes = DSTableParserKt.getColumnTypes(results.get(3), columnNames.size());
        return new DSDataFrameInfo(rows, indexColumnWidth, columnNames, columnTypes, null, null, null, null, null, null, 1008, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DSDataFrameInfo parseDataFrameInfoForNumpy(@NotNull String text2, @NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        List<String> results = DSTableParserKt.splitCommandResultAndCheckContent(text2, typeName);
        List<Integer> parseDataFrameShape = DSTableParserKt.parseDataFrameShape(results.get(1));
        int rows = ((Number)parseDataFrameShape.get(0)).intValue();
        int cols = ((Number)parseDataFrameShape.get(1)).intValue();
        ArrayList<String> arrayList = new ArrayList<String>(cols);
        int n = 0;
        while (n < cols) {
            void it;
            int n2;
            int n3 = n2 = n++;
            ArrayList<String> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(String.valueOf((int)it));
        }
        List columnNames = arrayList;
        columnNames.add(0, "");
        int indexColumnWidth = 1;
        List<String> columnTypes = DSTableParserKt.getColumnTypes(results.get(3), columnNames.size());
        return new DSDataFrameInfo(rows, indexColumnWidth, columnNames, columnTypes, null, null, null, null, null, null, 1008, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> splitCommandResultAndCheckContent(String text2, String typeName) {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{"__pydev_val__"};
        List results = StringsKt.split$default((CharSequence)text2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (!((Collection)results).isEmpty() && !StringsKt.contains$default((CharSequence)((CharSequence)results.get(0)), (CharSequence)typeName, (boolean)false, (int)2, null)) {
            throw new DSTableDataException(DSTableParserKt.typeErrorMessage(typeName, text2));
        }
        if (results.size() != 4) {
            throw new DSTableDataException("Error occurred: " + text2);
        }
        Iterable $this$map$iv = results;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        results = (List)destination$iv$iv;
        return results;
    }

    private static final String unwrapElement(Element el) {
        Node node = el.unwrap();
        if (node == null) {
            return null;
        }
        Node unwrapped = node;
        String value2 = unwrapped instanceof TextNode ? ((TextNode)unwrapped).getWholeText() : unwrapped.toString();
        return Parser.unescapeEntities((String)value2, (boolean)true);
    }

    private static final int getIntAttr(Element tableElement, String attrKey) {
        int n;
        String colspan = tableElement.attr(attrKey);
        Intrinsics.checkNotNull((Object)colspan);
        if (((CharSequence)colspan).length() == 0) {
            n = 1;
        } else {
            int n2;
            try {
                n2 = Integer.parseInt(colspan);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 1;
            }
            n = n2;
        }
        return n;
    }

    private static final int getIndexColumnWidthFromDocument(Document tableDocument) {
        Elements table = tableDocument.select("table[class=dataframe]");
        Elements rows = table.select("tbody").select("tr");
        if (rows.size() > 0) {
            return ((Element)rows.get(0)).select("th").size();
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getColsFromDocument(@NotNull Document tableDocument) {
        void $this$mapTo$iv$iv;
        Object el;
        Intrinsics.checkNotNullParameter((Object)tableDocument, (String)"tableDocument");
        Iterator iterator2 = tableDocument.select("table[class=dataframe]").select("thead").select("tr").iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"iterator(...)");
        Iterator lines = iterator2;
        List cols = new ArrayList();
        Iterator iterator3 = CollectionsKt.withIndex((Iterator)lines);
        while (iterator3.hasNext()) {
            Iterator lineElements;
            IndexedValue indexedValue = (IndexedValue)iterator3.next();
            int i = indexedValue.component1();
            Element line2 = (Element)indexedValue.component2();
            int headIndex = 0;
            Intrinsics.checkNotNullExpressionValue((Object)line2.select("th").iterator(), (String)"iterator(...)");
            Iterator iterator4 = lineElements;
            while (iterator4.hasNext()) {
                String string;
                el = (Element)iterator4.next();
                Intrinsics.checkNotNull((Object)el);
                int columnsNum = DSTableParserKt.getIntAttr(el, "colspan");
                if (i == 0) {
                    int n = 0;
                    while (n < columnsNum) {
                        int it = n++;
                        boolean bl = false;
                        cols.add((List)new ArrayList());
                    }
                }
                if ((string = DSTableParserKt.unwrapElement(el)) == null) {
                    string = "";
                }
                String value2 = string;
                ((List)cols.get(headIndex)).add(value2);
                for (int c = 1; c < columnsNum; ++c) {
                    ((List)cols.get(headIndex + c)).add(value2);
                }
                headIndex += columnsNum;
            }
        }
        Iterable $this$map$iv = cols;
        boolean $i$f$map = false;
        Iterable i = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void list2;
            el = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionsKt.joinToString$default((Iterable)((Iterable)list2), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        return (List)destination$iv$iv;
    }

    private static final List<String> getColumnTypes(String data, int numberOfColumns) {
        List list2;
        String[] stringArray = new String[]{TABLE_TYPE_NEXT_VALUE_SEPARATOR};
        List $this$getColumnTypes_u24lambda_u247 = StringsKt.split$default((CharSequence)data, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        if ($this$getColumnTypes_u24lambda_u247.size() == numberOfColumns) {
            list2 = $this$getColumnTypes_u24lambda_u247;
        } else {
            DSTableDataManager.Companion.getLOG().warn("Can't parse DataFrame. Number of columns: " + numberOfColumns + ", number of data type values: " + $this$getColumnTypes_u24lambda_u247.size() + ", text to parse: " + StringsKt.take((String)data, (int)100));
            ArrayList<Object> arrayList = new ArrayList<Object>(numberOfColumns);
            int n = 0;
            while (n < numberOfColumns) {
                int n2;
                int n3 = n2 = n++;
                ArrayList<Object> arrayList2 = arrayList;
                boolean bl2 = false;
                arrayList2.add(null);
            }
            list2 = arrayList;
        }
        return list2;
    }

    @NotNull
    public static final DSDataFrameInfo parseTableHtmlToFrameInfo(@NlsSafe @NotNull String tableHtml) {
        Intrinsics.checkNotNullParameter((Object)tableHtml, (String)"tableHtml");
        Document doc = Jsoup.parse((String)tableHtml);
        Intrinsics.checkNotNull((Object)doc);
        List<String> columnNames = DSTableParserKt.getColsFromDocument(doc);
        int n = columnNames.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Object> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(null);
        }
        List columnTypes = arrayList;
        int indexWidth = DSTableParserKt.getIndexColumnWidthFromDocument(doc);
        Elements rows = doc.select("table[class=dataframe]").select("tbody").select("tr");
        DSDataFrameInfo dataFrameInfo = new DSDataFrameInfo(rows.size(), indexWidth, columnNames, columnTypes, null, null, null, null, null, null, 1008, null);
        DSTableParserKt.setDataFrameDimensions(tableHtml, dataFrameInfo);
        return dataFrameInfo;
    }

    @NotNull
    public static final DSTableRawData parseTableHtmlToData(@NotNull DataId id, @NlsSafe @NotNull String tableHtml) throws DSTableDataException, DSTableRateExceededException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)tableHtml, (String)"tableHtml");
        Document document = Jsoup.parse((String)tableHtml);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document doc = document;
        DSTableParserKt.checkOutputForErrorsAndThrowExceptionIfNeeded(tableHtml);
        Elements table = doc.select("table[class=dataframe]");
        List cols = CollectionsKt.toMutableList((Collection)DSTableParserKt.getColsFromDocument(doc));
        List columns = new ArrayList();
        int n = cols.size();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            columns.add((List)new ArrayList());
        }
        Elements rows = table.select("tbody").select("tr");
        Intrinsics.checkNotNull((Object)rows);
        for (IndexedValue row : CollectionsKt.withIndex((Iterable)((Iterable)rows))) {
            Iterator iterator2;
            int colIndex = 0;
            while (((List)columns.get(colIndex)).size() >= row.getIndex() + 1) {
                ++colIndex;
            }
            Elements rowValues = ((Element)row.getValue()).select("th,td");
            Intrinsics.checkNotNullExpressionValue((Object)rowValues.iterator(), (String)"iterator(...)");
            while (iterator2.hasNext()) {
                Element el = (Element)iterator2.next();
                List list2 = (List)columns.get(colIndex);
                Intrinsics.checkNotNull((Object)el);
                String string = DSTableParserKt.unwrapElement(el);
                if (string == null) {
                    string = "";
                }
                list2.add(string);
                int n3 = DSTableParserKt.getIntAttr(el, "rowspan");
                for (int c = 1; c < n3; ++c) {
                    ((List)columns.get(colIndex)).add("");
                }
                ++colIndex;
            }
        }
        return new DSTableRawData(id, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final DSTableRawData parseTableCsvToData(@NotNull DataId id, @NotNull String csvString) throws DSTableDataException, DSTableRateExceededException {
        block23: {
            block22: {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)csvString, (String)"csvString");
                DSTableParserKt.checkOutputForErrorsAndThrowExceptionIfNeeded(csvString);
                var3_2 = new char[]{'\''};
                v0 = StringsKt.trim((String)StringsKt.trim((CharSequence)csvString).toString(), (char[])var3_2);
                var3_2 = new char[]{'\"'};
                parsedData = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.trim((String)v0, (char[])var3_2), (String)"\\n", (String)"\\\n", (boolean)false, (int)4, null), (String)"\\r", (String)"\\\r", (boolean)false, (int)4, null);
                rows = new ArrayList<E>();
                try {
                    parser = new CSVParserBuilder().withSeparator('~').build();
                    var5_6 = (Closeable)new CSVReaderBuilder((Reader)new StringReader(parsedData)).withCSVParser((ICSVParser)parser).build();
                    var6_8 = null;
                    try {
                        reader = (CSVReader)var5_6;
                        $i$a$-use-DSTableParserKt$parseTableCsvToData$1 = false;
                        nextLine /* !! */  = null;
                        while (true) {
                            var10_15 = reader.readNext();
                            it = var10_15;
                            $i$a$-also-DSTableParserKt$parseTableCsvToData$1$1 = false;
                            nextLine /* !! */  = it;
                            if (var10_15 == null) break;
                            Intrinsics.checkNotNull((Object)nextLine /* !! */ );
                            var10_15 = nextLine /* !! */ ;
                            var13_24 = rows;
                            $i$f$map = false;
                            $i$a$-also-DSTableParserKt$parseTableCsvToData$1$1 = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                            $i$f$mapTo = false;
                            for (Iterator<T> item$iv$iv : $this$mapTo$iv$iv) {
                                var19_36 = (String)item$iv$iv /* !! */ ;
                                var20_37 = destination$iv$iv;
                                $i$a$-map-DSTableParserKt$parseTableCsvToData$1$2 = false;
                                v1 = it;
                                if (v1 == null) {
                                    v1 = "";
                                }
                                var20_37.add(v1);
                            }
                            var13_24.add((List)destination$iv$iv);
                        }
                        reader = Unit.INSTANCE;
                    }
                    catch (Throwable reader) {
                        var6_8 = reader;
                        throw reader;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var5_6, (Throwable)var6_8);
                    }
                }
                catch (IOException e) {
                    throw new DSTableDataException("Error parsing data from table output. Reason: " + e.getLocalizedMessage(), (Throwable)e);
                }
                if (!rows.isEmpty()) break block22;
                v2 = CollectionsKt.emptyList();
                break block23;
            }
            columnCount = ((List)rows.get(0)).size();
            $this$filter$iv = CollectionsKt.drop((Iterable)rows, (int)1);
            $i$f$filter = false;
            nextLine /* !! */  = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                block21: {
                    row /* !! */  = (List)element$iv$iv;
                    $i$a$-filter-DSTableParserKt$parseTableCsvToData$columnData$nonEmptyDataRows$1 = false;
                    if (!(((Collection)row /* !! */ ).isEmpty() == false)) ** GOTO lbl-1000
                    $this$any$iv = row /* !! */ ;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v3 = false;
                    } else {
                        item$iv$iv /* !! */  = $this$any$iv.iterator();
                        while (item$iv$iv /* !! */ .hasNext()) {
                            it = element$iv /* !! */  = item$iv$iv /* !! */ .next();
                            $i$a$-any-DSTableParserKt$parseTableCsvToData$columnData$nonEmptyDataRows$1$1 = false;
                            v4 = ((CharSequence)it.toString()).length() > 0;
                            if (!v4) continue;
                            v3 = true;
                            break block21;
                        }
                        v3 = false;
                    }
                }
                if (v3) {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                if (!v5) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            nonEmptyDataRows = (List)destination$iv$iv;
            var7_9 = new ArrayList<List>(columnCount);
            for (var8_12 = 0; var8_12 < columnCount; ++var8_12) {
                destination$iv$iv = var9_14 = var8_12;
                var25_42 = var7_9;
                $i$a$-List-DSTableParserKt$parseTableCsvToData$columnData$1 = false;
                $this$map$iv = nonEmptyDataRows;
                $i$f$map = false;
                row /* !! */  = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Iterator<T> item$iv$iv : $this$mapTo$iv$iv) {
                    element$iv /* !! */  = (List)item$iv$iv /* !! */ ;
                    var20_37 = destination$iv$iv;
                    $i$a$-map-DSTableParserKt$parseTableCsvToData$columnData$1$1 = false;
                    var22_39 = row;
                    v6 = false <= index ? index < var22_39.size() : false;
                    if (v6) {
                        v7 /* !! */  = var22_39.get((int)index);
                    } else {
                        it = index;
                        $i$a$-getOrElse-DSTableParserKt$parseTableCsvToData$columnData$1$1$1 = false;
                        v7 /* !! */  = "";
                    }
                    var20_37.add(v7 /* !! */ );
                }
                var25_42.add(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)));
            }
            v2 = var7_9;
        }
        columnData = v2;
        return new DSTableRawData(id, columnData);
    }

    public static final void setDataFrameDimensions(@NlsSafe @Nullable String tableHtml, @NotNull DSDataFrameInfo dataFrameInfo) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)dataFrameInfo, (String)"dataFrameInfo");
        String dimensions = null;
        if (tableHtml != null) {
            Element dim;
            Document doc = Jsoup.parse((String)tableHtml);
            Elements elements = doc.select("p");
            Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
            Element element = dim = (Element)CollectionsKt.lastOrNull((List)((List)elements));
            String string = dimensions = element != null ? DSTableParserKt.unwrapElement(element) : null;
            if (dimensions != null && StringsKt.contains$default((CharSequence)dimensions, (CharSequence)"columns", (boolean)false, (int)2, null)) {
                dimensions = StringsKt.replace$default((String)dimensions, (String)"columns", (String)"cols", (boolean)false, (int)4, null);
            }
        }
        if ((objectArray = (Object[])dimensions) == null || objectArray.length() == 0) {
            objectArray = new Object[]{dataFrameInfo.getRows(), dataFrameInfo.getColumnNames().size() - dataFrameInfo.getIndexColumnWidth()};
            dimensions = DSTableBundle.message((String)"ds.table.dimensions.info", (Object[])objectArray);
        }
        dataFrameInfo.setDim(dimensions);
    }

    private static final String typeErrorMessage(String typeName, String text2) {
        return ((CharSequence)text2).length() == 0 ? "The Result of Table command is empty" : "The Type of the Result isn't a " + typeName + ". Text for parsing: " + text2;
    }

    private static final void checkOutputForErrorsAndThrowExceptionIfNeeded(String output) throws DSTableDataException, DSTableRateExceededException {
        String string = Strings.escapeXmlEntities((String)output);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(...)");
        String escapedOutput = string;
        if (StringsKt.contains$default((CharSequence)escapedOutput, (CharSequence)"IOPub data rate exceeded.", (boolean)false, (int)2, null)) {
            throw new DSTableRateExceededException(escapedOutput);
        }
        if (StringsKt.contains$default((CharSequence)escapedOutput, (CharSequence)"_jb_get_info_command got exception: ", (boolean)false, (int)2, null)) {
            throw new DSTableDataException(StringsKt.substringAfter$default((String)escapedOutput, (String)"_jb_get_info_command got exception: ", null, (int)2, null));
        }
    }
}

