/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.panel.datawrangler;

import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.run.ui.table.statisticsPanel.StatisticsPanelMode;
import com.intellij.database.run.ui.table.statisticsPanel.StatisticsTableHeader;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.scientific.py.tables.panel.datawrangler.OneTransformationStepData;
import com.intellij.scientific.py.tables.panel.statistics.PyStatisticsTableHeader;
import com.intellij.scientific.tables.DSTableDataRetrieverFromDataSourceImpl;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.intellij.scientific.tables.api.DSPanelInfo;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.api.DSTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.api.TableStatisticsData;
import com.intellij.scientific.tables.editor.DSTableEditorPanelInfo;
import com.intellij.scientific.tables.panel.DSTableWithStatistics;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001a\u001a\u00020\u00192\n\u0010\u001b\u001a\u00060\tj\u0002`\nH\u0002J\u0016\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#H\u0002J\"\u0010$\u001a\u00020\u00142\n\u0010%\u001a\u00060\tj\u0002`\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082D\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\b\u0012\u00060\tj\u0002`\n\u0012\u0004\u0012\u00020\r0\fj\u0012\u0012\b\u0012\u00060\tj\u0002`\n\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u0004\u0018\u00010)*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lcom/intellij/scientific/py/tables/panel/datawrangler/DWTransformationsStorage;", "", "executor", "Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "<init>", "(Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;)V", "getExecutor", "()Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "initialStepNumber", "", "Lcom/intellij/scientific/py/tables/panel/datawrangler/StepNumber;", "myStorage", "Ljava/util/HashMap;", "Lcom/intellij/scientific/py/tables/panel/datawrangler/OneTransformationStepData;", "Lkotlin/collections/HashMap;", "project", "Lcom/intellij/openapi/project/Project;", "panelInfo", "Lcom/intellij/scientific/tables/editor/DSTableEditorPanelInfo;", "initialStep", "", "table", "Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;", "executeMainCommand", "command", "", "saveInPython", "newStepNumber", "addNewStep", "transformationCode", "getDataForNewTable", "Lcom/intellij/scientific/tables/DSTableDataRetrieverFromDataSourceImpl;", "previousStepTableDataRetrieverFromDataSource", "expressionNew", "prevStatHeaderMode", "Lcom/intellij/database/run/ui/table/statisticsPanel/StatisticsPanelMode;", "revert", "stepNumberToRestore", "source", "Lcom/intellij/database/datagrid/GridRequestSource;", "dsStatisticsHeaders", "Lcom/intellij/scientific/py/tables/panel/statistics/PyStatisticsTableHeader;", "getDsStatisticsHeaders", "(Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;)Lcom/intellij/scientific/py/tables/panel/statistics/PyStatisticsTableHeader;", "intellij.scientific.py.tables"})
public final class DWTransformationsStorage {
    @NotNull
    private final DSTableCommandExecutor executor;
    private final int initialStepNumber;
    @NotNull
    private final HashMap<Integer, OneTransformationStepData> myStorage;
    @NotNull
    private final Project project;
    @NotNull
    private final DSTableEditorPanelInfo panelInfo;

    public DWTransformationsStorage(@NotNull DSTableCommandExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executor = executor;
        this.myStorage = new HashMap();
        DataContext dataContext = DataManager.getInstance().getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Object object = CommonDataKeys.PROJECT.getData(dataContext);
        Intrinsics.checkNotNull((Object)object);
        this.project = (Project)object;
        this.panelInfo = new DSTableEditorPanelInfo(new JPanel(), null, null, false, null, (Disposable)this.project, false, false, true, false, null, 1092, null);
    }

    @NotNull
    public final DSTableCommandExecutor getExecutor() {
        return this.executor;
    }

    public final void initialStep(@NotNull DSTableWithStatistics table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        DSTableDataRetrieverFromDataSource dSTableDataRetrieverFromDataSource = table.getLoader().getTableDataRetrieverFromDataSource();
        Intrinsics.checkNotNull((Object)dSTableDataRetrieverFromDataSource);
        DSTableDataRetrieverFromDataSourceImpl tableDataRetriever = (DSTableDataRetrieverFromDataSourceImpl)dSTableDataRetrieverFromDataSource;
        OneTransformationStepData initialStepData = new OneTransformationStepData(tableDataRetriever, tableDataRetriever.getCurrentTableExpression());
        String tableVariableName = initialStepData.getInternalTableVariableName();
        this.executeMainCommand("df = " + tableVariableName);
        String toSaveExpression = "__dw_df_to_save_" + this.initialStepNumber + " = " + tableVariableName;
        this.executeMainCommand(toSaveExpression);
        ((Map)this.myStorage).put(this.initialStepNumber, initialStepData);
    }

    private final void executeMainCommand(String command) {
        this.executor.executeCommand(command);
    }

    private final String saveInPython(int newStepNumber) {
        String internalVariableName = "__dw_df_to_save_" + newStepNumber;
        String toSaveNewDFCommand = internalVariableName + " = df";
        this.executeMainCommand(toSaveNewDFCommand);
        return internalVariableName;
    }

    public final void addNewStep(@NotNull String transformationCode, @NotNull DSTableWithStatistics table) {
        Intrinsics.checkNotNullParameter((Object)transformationCode, (String)"transformationCode");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        StatisticsTableHeader statisticsTableHeader = table.getStatisticsHeader();
        if (statisticsTableHeader == null || (statisticsTableHeader = statisticsTableHeader.getStatisticsPanelMode()) == null) {
            statisticsTableHeader = StatisticsPanelMode.OFF;
        }
        StatisticsTableHeader prevStatHeaderMode = statisticsTableHeader;
        int newStepNumber = this.myStorage.size();
        int previousStepNumber = newStepNumber - 1;
        String expressionNew = "df";
        OneTransformationStepData oneTransformationStepData = this.myStorage.get(previousStepNumber);
        Object object = oneTransformationStepData != null ? oneTransformationStepData.getTableDataRetriever() : null;
        Intrinsics.checkNotNull((Object)object);
        DSTableDataRetrieverFromDataSourceImpl previousStepTableDataRetriever = object;
        this.executeMainCommand(transformationCode);
        String newStepInternalName = this.saveInPython(newStepNumber);
        DSTableDataRetrieverFromDataSourceImpl newTableDataRetriever = this.getDataForNewTable(previousStepTableDataRetriever, expressionNew, table, (StatisticsPanelMode)prevStatHeaderMode);
        Integer n = newStepNumber;
        ((Map)this.myStorage).put(n, new OneTransformationStepData(newTableDataRetriever, newStepInternalName));
    }

    private final DSTableDataRetrieverFromDataSourceImpl getDataForNewTable(DSTableDataRetrieverFromDataSourceImpl previousStepTableDataRetrieverFromDataSource, String expressionNew, DSTableWithStatistics table, StatisticsPanelMode prevStatHeaderMode) {
        DSDataFrameInfo newDataFrameInfo = previousStepTableDataRetrieverFromDataSource.getTableDataProvider().loadDynamicTableDataFrameInfo(this.executor, expressionNew, "");
        DSTableDataRetrieverFromDataSourceImpl newTableDataRetrieverFromDataSource = new DSTableDataRetrieverFromDataSourceImpl(previousStepTableDataRetrieverFromDataSource.getDataId(), previousStepTableDataRetrieverFromDataSource.getDataManager(), expressionNew, previousStepTableDataRetrieverFromDataSource.getTableDataProvider(), this.executor, newDataFrameInfo, (DSPanelInfo)this.panelInfo, true, null, null, null, null, null, 7936, null);
        table.getLoader().setTableDataRetrieverFromDataSource((DSTableDataRetrieverFromDataSource)newTableDataRetrieverFromDataSource);
        TableStatisticsData tableStatisticsData = newDataFrameInfo.getDataStatistics();
        if (tableStatisticsData != null) {
            tableStatisticsData.request();
        }
        StatisticsTableHeader statisticsTableHeader = table.getStatisticsHeader();
        if (statisticsTableHeader != null) {
            statisticsTableHeader.setStatisticsPanelMode(StatisticsPanelMode.OFF);
        }
        BuildersKt.launch$default((CoroutineScope)table.getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(newDataFrameInfo, this, table, newTableDataRetrieverFromDataSource, prevStatHeaderMode, null){
            int label;
            final /* synthetic */ DSDataFrameInfo $newDataFrameInfo;
            final /* synthetic */ DWTransformationsStorage this$0;
            final /* synthetic */ DSTableWithStatistics $table;
            final /* synthetic */ DSTableDataRetrieverFromDataSourceImpl $newTableDataRetrieverFromDataSource;
            final /* synthetic */ StatisticsPanelMode $prevStatHeaderMode;
            {
                this.$newDataFrameInfo = $newDataFrameInfo;
                this.this$0 = $receiver;
                this.$table = $table;
                this.$newTableDataRetrieverFromDataSource = $newTableDataRetrieverFromDataSource;
                this.$prevStatHeaderMode = $prevStatHeaderMode;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        TableStatisticsData tableStatisticsData = this.$newDataFrameInfo.getDataStatistics();
                        if (tableStatisticsData == null) break;
                        this.label = 1;
                        Object object3 = tableStatisticsData.await((Continuation)this);
                        if (object3 == object2) {
                            return object2;
                        }
                        break;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        break;
                    }
                }
                PyStatisticsTableHeader pyStatisticsTableHeader = DWTransformationsStorage.access$getDsStatisticsHeaders(this.this$0, this.$table);
                if (pyStatisticsTableHeader == null) {
                    throw new IllegalStateException("Updating Statistics Header has failed".toString());
                }
                pyStatisticsTableHeader.updateHeaders((DSTableDataRetrieverFromDataSource)this.$newTableDataRetrieverFromDataSource);
                StatisticsTableHeader statisticsTableHeader = this.$table.getStatisticsHeader();
                if (statisticsTableHeader != null) {
                    statisticsTableHeader.setStatisticsPanelMode(this.$prevStatHeaderMode);
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return newTableDataRetrieverFromDataSource;
    }

    public final void revert(int stepNumberToRestore, @NotNull DSTableWithStatistics table, @NotNull GridRequestSource source) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Integer n = stepNumberToRestore;
        if (!((Map)this.myStorage).containsKey(n)) {
            throw new Error("Wrong argument");
        }
        OneTransformationStepData oneTransformationStepData = this.myStorage.get(stepNumberToRestore);
        String command = "df = " + (oneTransformationStepData != null ? oneTransformationStepData.getInternalTableVariableName() : null);
        this.executeMainCommand(command);
        int n2 = this.myStorage.size();
        for (int curStep = stepNumberToRestore + 1; curStep < n2; ++curStep) {
            Integer n3 = curStep;
            if (!((Map)this.myStorage).containsKey(n3)) continue;
            OneTransformationStepData oneTransformationStepData2 = this.myStorage.get(curStep);
            String internalVariableName = oneTransformationStepData2 != null ? oneTransformationStepData2.getInternalTableVariableName() : null;
            this.executeMainCommand("del " + internalVariableName);
            this.myStorage.remove(curStep);
        }
        OneTransformationStepData oneTransformationStepData3 = this.myStorage.get(stepNumberToRestore);
        if (oneTransformationStepData3 == null) {
            return;
        }
        OneTransformationStepData stepToRestoreData = oneTransformationStepData3;
        table.getLoader().setTableDataRetrieverFromDataSource((DSTableDataRetrieverFromDataSource)stepToRestoreData.getTableDataRetriever());
        StatisticsTableHeader statisticsTableHeader = table.getStatisticsHeader();
        if (statisticsTableHeader == null || (statisticsTableHeader = statisticsTableHeader.getStatisticsPanelMode()) == null) {
            statisticsTableHeader = StatisticsPanelMode.OFF;
        }
        StatisticsTableHeader prevStatHeaderMode = statisticsTableHeader;
        StatisticsTableHeader statisticsTableHeader2 = table.getStatisticsHeader();
        if (statisticsTableHeader2 != null) {
            statisticsTableHeader2.setStatisticsPanelMode(StatisticsPanelMode.OFF);
        }
        PyStatisticsTableHeader pyStatisticsTableHeader = this.getDsStatisticsHeaders(table);
        if (pyStatisticsTableHeader != null) {
            pyStatisticsTableHeader.updateHeaders((DSTableDataRetrieverFromDataSource)stepToRestoreData.getTableDataRetriever());
        } else {
            System.out.println((Object)"FAILED");
        }
        StatisticsTableHeader statisticsTableHeader3 = table.getStatisticsHeader();
        if (statisticsTableHeader3 != null) {
            statisticsTableHeader3.setStatisticsPanelMode((StatisticsPanelMode)prevStatHeaderMode);
        }
        table.getLoader().loadAndSetColumns(source);
    }

    private final PyStatisticsTableHeader getDsStatisticsHeaders(DSTableWithStatistics $this$dsStatisticsHeaders) {
        StatisticsTableHeader statisticsTableHeader = $this$dsStatisticsHeaders.getStatisticsHeader();
        return statisticsTableHeader instanceof PyStatisticsTableHeader ? (PyStatisticsTableHeader)statisticsTableHeader : null;
    }

    public static final /* synthetic */ PyStatisticsTableHeader access$getDsStatisticsHeaders(DWTransformationsStorage $this, DSTableWithStatistics $receiver) {
        return $this.getDsStatisticsHeaders($receiver);
    }
}

