/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.panel.datawrangler;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.RemovableView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.scientific.py.tables.panel.datawrangler.DSSummaryCreationSettings;
import com.intellij.scientific.py.tables.panel.datawrangler.DataWranglerMainPanelKt;
import com.intellij.scientific.py.tables.panel.datawrangler.SummaryGroupComponent;
import com.intellij.scientific.py.tables.panel.datawrangler.TransformationsMultiPanel;
import com.intellij.scientific.py.tables.panel.datawrangler.TransformationsPanel;
import com.intellij.scientific.py.tables.panel.datawrangler.actions.DSHideDataWranglerAction;
import com.intellij.scientific.tables.DSTableBundle;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.panel.DSTableWithStatistics;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0015\u0010$\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010%J\u0011\u0010&\u001a\r\u0012\t\u0012\u00070\u001f\u00a2\u0006\u0002\b(0'J\u0011\u0010)\u001a\r\u0012\t\u0012\u00070\u001f\u00a2\u0006\u0002\b(0'J\b\u0010*\u001a\u00020\u001aH\u0016J\b\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020\u001aH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006/"}, d2={"Lcom/intellij/scientific/py/tables/panel/datawrangler/DataWranglerMainPanel;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/database/datagrid/RemovableView;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "table", "Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;)V", "getTable", "()Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;", "splitter", "Lcom/intellij/ui/OnePixelSplitter;", "summaryGroup", "Lcom/intellij/scientific/py/tables/panel/datawrangler/SummaryGroupComponent;", "transformationsGroupComponent", "Lcom/intellij/scientific/py/tables/panel/datawrangler/TransformationsMultiPanel;", "commandExecutor", "Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "getCommandExecutor", "()Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "viewComponent", "Ljavax/swing/JComponent;", "getViewComponent", "()Ljavax/swing/JComponent;", "addNewSummary", "", "settings", "Lcom/intellij/scientific/py/tables/panel/datawrangler/DSSummaryCreationSettings;", "deleteSummary", "summaryName", "", "setSummaryVisibleAndRepaint", "isVisible", "", "getSummarySettings", "isSummaryVisible", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getSummaryNames", "", "Lorg/jetbrains/annotations/Nls;", "getNonDefaultSummaryNames", "onRemoved", "createDWTopPanel", "Ljavax/swing/JPanel;", "dispose", "Companion", "intellij.scientific.py.tables"})
public final class DataWranglerMainPanel
implements Disposable,
RemovableView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DSTableWithStatistics table;
    @NotNull
    private final OnePixelSplitter splitter;
    @NotNull
    private final SummaryGroupComponent summaryGroup;
    @NotNull
    private final TransformationsMultiPanel transformationsGroupComponent;
    @Nullable
    private final DSTableCommandExecutor commandExecutor;
    @NotNull
    private final JComponent viewComponent;

    public DataWranglerMainPanel(@NotNull DataGrid grid2, @NotNull DSTableWithStatistics table) {
        Intrinsics.checkNotNullParameter((Object)grid2, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.table = table;
        this.splitter = new OnePixelSplitter(true, 0.33f);
        this.summaryGroup = new SummaryGroupComponent(this.table);
        this.transformationsGroupComponent = new TransformationsPanel(this.table).getComponent();
        this.commandExecutor = this.table.getDSTableCommandExecutor();
        this.viewComponent = new JPanel(new BorderLayout());
        JPanel topPanelWithNameAndToolbar = this.createDWTopPanel();
        this.getViewComponent().add((Component)topPanelWithNameAndToolbar, "North");
        this.splitter.getDivider().setBackground(OnePixelDivider.BACKGROUND);
        this.splitter.setFirstComponent((JComponent)((Object)this.summaryGroup));
        this.splitter.setSecondComponent((JComponent)this.transformationsGroupComponent);
        this.getViewComponent().add((Component)this.splitter);
        grid2.putUserData(DataWranglerMainPanelKt.DATA_WRANGLER_GRID_KEY, (Object)this);
    }

    @NotNull
    public final DSTableWithStatistics getTable() {
        return this.table;
    }

    @Nullable
    public final DSTableCommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    @NotNull
    public JComponent getViewComponent() {
        return this.viewComponent;
    }

    public final void addNewSummary(@NotNull DSSummaryCreationSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.summaryGroup.addNewSummaryAndRepaint(settings);
    }

    public final void deleteSummary(@NotNull String summaryName) {
        Intrinsics.checkNotNullParameter((Object)summaryName, (String)"summaryName");
        this.summaryGroup.deleteSummaryAndRepaint(summaryName);
    }

    public final void setSummaryVisibleAndRepaint(@NotNull String summaryName, boolean isVisible2) {
        Intrinsics.checkNotNullParameter((Object)summaryName, (String)"summaryName");
        this.summaryGroup.setSummaryVisibleAndRepaint(summaryName, isVisible2);
    }

    @Nullable
    public final DSSummaryCreationSettings getSummarySettings(@NotNull String summaryName) {
        Intrinsics.checkNotNullParameter((Object)summaryName, (String)"summaryName");
        return this.summaryGroup.getTreeTable().getSummaryTreeModel().getSummarySettings(summaryName);
    }

    @Nullable
    public final Boolean isSummaryVisible(@NotNull String summaryName) {
        Intrinsics.checkNotNullParameter((Object)summaryName, (String)"summaryName");
        return this.summaryGroup.getTreeTable().getSummaryTreeModel().isSummaryVisible(summaryName);
    }

    @NotNull
    public final List<String> getSummaryNames() {
        return this.summaryGroup.getTreeTable().getSummaryTreeModel().getSummaryNames();
    }

    @NotNull
    public final List<String> getNonDefaultSummaryNames() {
        return this.summaryGroup.getTreeTable().getSummaryTreeModel().getNonDefaultSummaryNames();
    }

    public void onRemoved() {
    }

    private final JPanel createDWTopPanel() {
        JBLabel jBLabel;
        Object object = new ActionToolbar[]{new DSHideDataWranglerAction()};
        object = ActionManager.getInstance().createActionToolbar("TransformToolbar", (ActionGroup)new DefaultActionGroup((AnAction[])object), true);
        ActionToolbar $this$createDWTopPanel_u24lambda_u240 = object;
        boolean bl = false;
        $this$createDWTopPanel_u24lambda_u240.getComponent().setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 10));
        $this$createDWTopPanel_u24lambda_u240.setLayoutPolicy(0);
        ActionToolbar actionToolbar = object;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"apply(...)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent(this.getViewComponent());
        Object $this$createDWTopPanel_u24lambda_u241 = object = new JPanel(new BorderLayout());
        boolean bl2 = false;
        ((JComponent)$this$createDWTopPanel_u24lambda_u241).setBorder(IdeBorderFactory.createBorder((int)8));
        Object topPanel = object;
        String topPanelName = "<html><b>" + DSTableBundle.message((String)"ds.DataWrangler.main.panel.name", (Object[])new Object[0]) + "</b></html>";
        JBLabel $this$createDWTopPanel_u24lambda_u242 = jBLabel = new JBLabel(topPanelName);
        boolean bl3 = false;
        $this$createDWTopPanel_u24lambda_u242.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JBLabel topPanelLabel = jBLabel;
        ((Container)topPanel).add((Component)topPanelLabel, "West");
        ((Container)topPanel).add((Component)toolbar.getComponent(), "East");
        return topPanel;
    }

    public void dispose() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005\u00a8\u0006\u0010"}, d2={"Lcom/intellij/scientific/py/tables/panel/datawrangler/DataWranglerMainPanel$Companion;", "", "<init>", "()V", "createSummaryTransformationsTopPanel", "Ljavax/swing/JPanel;", "topPanelTitleName", "", "toolbarPlaceName", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "gapFromParentPanel", "", "createScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "panelToAdd", "intellij.scientific.py.tables"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JPanel createSummaryTransformationsTopPanel(@NlsContexts.Label @NotNull String topPanelTitleName, @NotNull String toolbarPlaceName, @NotNull ActionGroup actionGroup, int gapFromParentPanel) {
            JPanel jPanel;
            ActionToolbar actionToolbar;
            Intrinsics.checkNotNullParameter((Object)topPanelTitleName, (String)"topPanelTitleName");
            Intrinsics.checkNotNullParameter((Object)toolbarPlaceName, (String)"toolbarPlaceName");
            Intrinsics.checkNotNullParameter((Object)actionGroup, (String)"actionGroup");
            ActionToolbar $this$createSummaryTransformationsTopPanel_u24lambda_u240 = actionToolbar = ActionManager.getInstance().createActionToolbar(toolbarPlaceName, actionGroup, true);
            boolean bl = false;
            $this$createSummaryTransformationsTopPanel_u24lambda_u240.getComponent().setBorder(null);
            $this$createSummaryTransformationsTopPanel_u24lambda_u240.setLayoutPolicy(0);
            ActionToolbar actionToolbar2 = actionToolbar;
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
            ActionToolbar toolbar = actionToolbar2;
            ActionToolbar $this$createSummaryTransformationsTopPanel_u24lambda_u241 = actionToolbar = new JBLabel(topPanelTitleName);
            boolean bl2 = false;
            $this$createSummaryTransformationsTopPanel_u24lambda_u241.setForeground((Color)JBColor.GRAY);
            ActionToolbar topPanelTitle = actionToolbar;
            JPanel $this$createSummaryTransformationsTopPanel_u24lambda_u242 = jPanel = new JPanel(new BorderLayout());
            boolean bl3 = false;
            $this$createSummaryTransformationsTopPanel_u24lambda_u242.setOpaque(false);
            $this$createSummaryTransformationsTopPanel_u24lambda_u242.setBorder(BorderFactory.createEmptyBorder(gapFromParentPanel / 2, (int)((double)gapFromParentPanel * 1.5), gapFromParentPanel / 2, gapFromParentPanel));
            JPanel topPanel = jPanel;
            toolbar.setTargetComponent((JComponent)topPanel);
            topPanel.add((Component)topPanelTitle, "West");
            topPanel.add((Component)toolbar.getComponent(), "East");
            return topPanel;
        }

        @NotNull
        public final JBScrollPane createScrollPane(@NotNull JPanel panelToAdd) {
            Intrinsics.checkNotNullParameter((Object)panelToAdd, (String)"panelToAdd");
            return new JBScrollPane(panelToAdd){

                protected void setupCorners() {
                    super.setupCorners();
                    this.setBorder(null);
                }

                public void updateUI() {
                    super.updateUI();
                    this.setBorder(null);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

