/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.panel.datawrangler;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.scientific.py.tables.panel.datawrangler.CellContent;
import com.intellij.scientific.py.tables.panel.datawrangler.ColumnsSummaryTreePart;
import com.intellij.scientific.py.tables.panel.datawrangler.DSSummaryCreationSettings;
import com.intellij.scientific.py.tables.panel.datawrangler.DataShapeSummaryTreePart;
import com.intellij.scientific.py.tables.panel.datawrangler.MissingValuesSummaryTreePart;
import com.intellij.scientific.py.tables.panel.datawrangler.SummaryScripts;
import com.intellij.scientific.py.tables.panel.datawrangler.SummaryTreePart;
import com.intellij.scientific.py.tables.panel.datawrangler.SummaryTreeRootNode;
import com.intellij.scientific.tables.panel.DSTableWithStatistics;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.jetbrains.python.PythonFileType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\rH\u0002J\u0011\u0010\u0010\u001a\r\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\u00120\rJ\u0011\u0010\u0013\u001a\r\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\u00120\rJ\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0019H\u0016J\u0014\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001b\u001a\u00020\u0019H\u0016J\u001a\u0010\u001e\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u0019H\u0016J\u001a\u0010 \u001a\u00020!2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u0019H\u0016J$\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u0019H\u0016J\u0012\u0010%\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u001a\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u000e\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020\u000bJ\u000e\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\u0011J\u0010\u0010-\u001a\u0004\u0018\u00010\u000f2\u0006\u0010,\u001a\u00020\u0011J\u000e\u0010.\u001a\u00020#2\u0006\u0010*\u001a\u00020\u000bJ\u0016\u0010/\u001a\u00020#2\u0006\u0010,\u001a\u00020\u00112\u0006\u00100\u001a\u00020!J\u0015\u00101\u001a\u0004\u0018\u00010!2\u0006\u0010,\u001a\u00020\u0011\u00a2\u0006\u0002\u00102R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/scientific/py/tables/panel/datawrangler/SummaryTreeModel;", "Lcom/intellij/ui/tree/BaseTreeModel;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "Lcom/intellij/ui/treeStructure/treetable/TreeTableModel;", "table", "Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;", "<init>", "(Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;)V", "myRoot", "mySummaryStatistics", "", "Lcom/intellij/scientific/py/tables/panel/datawrangler/SummaryTreePart;", "summaryListOfTree", "", "getSummarySettingsFromScripts", "Lcom/intellij/scientific/py/tables/panel/datawrangler/DSSummaryCreationSettings;", "getSummaryNames", "", "Lorg/jetbrains/annotations/Nls;", "getNonDefaultSummaryNames", "getModelFromNode", "parent", "", "getRoot", "getColumnCount", "", "getColumnName", "column", "getColumnClass", "Ljava/lang/Class;", "getValueAt", "node", "isCellEditable", "", "setValueAt", "", "aValue", "setTree", "tree", "Ljavax/swing/JTree;", "getChildren", "addSummaryTreeModel", "model", "deleteSummaryTreeModel", "summaryName", "getSummarySettings", "replaceWithOneSummaryTreeModel", "setSummaryVisible", "isVisible", "isSummaryVisible", "(Ljava/lang/String;)Ljava/lang/Boolean;", "intellij.scientific.py.tables"})
@SourceDebugExtension(value={"SMAP\nSummaryTreeTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SummaryTreeTable.kt\ncom/intellij/scientific/py/tables/panel/datawrangler/SummaryTreeModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n1863#2,2:321\n1863#2,2:323\n1557#2:325\n1628#2,3:326\n774#2:329\n865#2,2:330\n1557#2:332\n1628#2,3:333\n774#2:336\n865#2,2:337\n1557#2:339\n1628#2,3:340\n1#3:343\n*S KotlinDebug\n*F\n+ 1 SummaryTreeTable.kt\ncom/intellij/scientific/py/tables/panel/datawrangler/SummaryTreeModel\n*L\n237#1:321,2\n238#1:323,2\n259#1:325\n259#1:326,3\n262#1:329\n262#1:330,2\n263#1:332\n263#1:333,3\n292#1:336\n292#1:337,2\n292#1:339\n292#1:340,3\n*E\n"})
public final class SummaryTreeModel
extends BaseTreeModel<DefaultMutableTreeNode>
implements TreeTableModel {
    @NotNull
    private final DefaultMutableTreeNode myRoot;
    @NotNull
    private final List<SummaryTreePart> mySummaryStatistics;
    @NotNull
    private final List<SummaryTreePart> summaryListOfTree;

    public SummaryTreeModel(@NotNull DSTableWithStatistics table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.myRoot = new DefaultMutableTreeNode("StatisticRoot");
        this.mySummaryStatistics = new ArrayList();
        SummaryTreePart[] summaryTreePartArray = new SummaryTreePart[]{new DataShapeSummaryTreePart("Data Shape", table), new ColumnsSummaryTreePart("Columns", table), new MissingValuesSummaryTreePart("Missing Values", table)};
        this.summaryListOfTree = CollectionsKt.listOf((Object[])summaryTreePartArray);
        Iterable $this$forEach$iv = this.summaryListOfTree;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SummaryTreePart it = (SummaryTreePart)((Object)element$iv);
            boolean bl = false;
            this.addSummaryTreeModel(it);
        }
        $this$forEach$iv = this.getSummarySettingsFromScripts();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DSSummaryCreationSettings setting = (DSSummaryCreationSettings)element$iv;
            boolean bl = false;
            this.addSummaryTreeModel(SummaryTreePart.Companion.createNewTreeFromSettings(table, setting));
        }
    }

    private final List<DSSummaryCreationSettings> getSummarySettingsFromScripts() {
        List list2;
        block2: {
            Path path2 = SummaryScripts.Companion.getSummaryScriptDirectory();
            if (path2 == null) {
                return CollectionsKt.emptyList();
            }
            Path pathToDir = path2;
            VirtualFile directory = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(pathToDir);
            List $this$getSummarySettingsFromScripts_u24lambda_u243 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            VirtualFile virtualFile = directory;
            if (virtualFile == null) break block2;
            VirtualFile it = virtualFile;
            boolean bl2 = false;
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])it.getChildren());
            while (iterator2.hasNext()) {
                VirtualFile childFile = (VirtualFile)iterator2.next();
                DSSummaryCreationSettings settings = new DSSummaryCreationSettings();
                FileType fileType = childFile.getFileType();
                if ((fileType instanceof PythonFileType ? (PythonFileType)fileType : null) == null) continue;
                ObservableMutableProperty<String> observableMutableProperty = settings.getNameProperty();
                String string = childFile.getNameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
                observableMutableProperty.set((Object)string);
                ObservableMutableProperty<String> observableMutableProperty2 = settings.getCodeForSummarizeProperty();
                Intrinsics.checkNotNull((Object)childFile);
                observableMutableProperty2.set((Object)VirtualFileUtil.readText((VirtualFile)childFile));
                $this$getSummarySettingsFromScripts_u24lambda_u243.add(settings);
            }
        }
        return CollectionsKt.build((List)list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getSummaryNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.mySummaryStatistics;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SummaryTreePart summaryTreePart = (SummaryTreePart)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSummaryName());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getNonDefaultSummaryNames() {
        void $this$mapTo$iv$iv;
        SummaryTreePart it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.mySummaryStatistics;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SummaryTreePart)((Object)element$iv$iv);
            boolean bl = false;
            if (!(it.getSummarySettings() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SummaryTreePart)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSummaryName());
        }
        return (List)destination$iv$iv;
    }

    private final SummaryTreePart getModelFromNode(Object parent) {
        DefaultMutableTreeNode defaultMutableTreeNode = parent instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)parent : null;
        TreeNode treeNode = defaultMutableTreeNode != null ? defaultMutableTreeNode.getRoot() : null;
        SummaryTreeRootNode summaryTreeRootNode = treeNode instanceof SummaryTreeRootNode ? (SummaryTreeRootNode)treeNode : null;
        return summaryTreeRootNode != null ? summaryTreeRootNode.getMyTree() : null;
    }

    @NotNull
    public Object getRoot() {
        return this.myRoot;
    }

    public int getColumnCount() {
        return 2;
    }

    @NotNull
    public String getColumnName(int column) {
        return "";
    }

    @NotNull
    public Class<?> getColumnClass(int column) {
        return column == 0 ? SummaryTreePart.class : CellContent.class;
    }

    @NotNull
    public Object getValueAt(@Nullable Object node, int column) {
        Object object = this.getModelFromNode(node);
        if (object == null || (object = object.getValueAt(node, column)) == null) {
            object = "";
        }
        return object;
    }

    public boolean isCellEditable(@Nullable Object node, int column) {
        return false;
    }

    public void setValueAt(@Nullable Object aValue, @Nullable Object node, int column) {
    }

    public void setTree(@Nullable JTree tree) {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public List<DefaultMutableTreeNode> getChildren(@Nullable Object parent) {
        Object object;
        if (Intrinsics.areEqual((Object)parent, (Object)this.myRoot)) {
            void $this$mapTo$iv$iv;
            SummaryTreePart it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.mySummaryStatistics;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (SummaryTreePart)((Object)element$iv$iv);
                boolean bl = false;
                if (!it.isShown()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (SummaryTreePart)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getRoot());
            }
            object = (List)destination$iv$iv;
        } else {
            object = this.getModelFromNode(parent);
            if (object == null || (object = object.getChildren(parent)) == null) {
                object = CollectionsKt.emptyList();
            }
        }
        return object;
    }

    public final void addSummaryTreeModel(@NotNull SummaryTreePart model2) {
        Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
        this.mySummaryStatistics.add(model2);
    }

    public final void deleteSummaryTreeModel(@NotNull String summaryName) {
        Intrinsics.checkNotNullParameter((Object)summaryName, (String)"summaryName");
        this.mySummaryStatistics.removeIf(arg_0 -> SummaryTreeModel.deleteSummaryTreeModel$lambda$10(arg_0 -> SummaryTreeModel.deleteSummaryTreeModel$lambda$9(summaryName, arg_0), arg_0));
    }

    @Nullable
    public final DSSummaryCreationSettings getSummarySettings(@NotNull String summaryName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)summaryName, (String)"summaryName");
            Iterable iterable = this.mySummaryStatistics;
            for (Object t : iterable) {
                SummaryTreePart it = (SummaryTreePart)((Object)t);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSummaryName(), (Object)summaryName)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        SummaryTreePart summaryTreePart = v0;
        return summaryTreePart != null ? summaryTreePart.getSummarySettings() : null;
    }

    public final void replaceWithOneSummaryTreeModel(@NotNull SummaryTreePart model2) {
        Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
        this.mySummaryStatistics.clear();
        this.mySummaryStatistics.add(model2);
    }

    public final void setSummaryVisible(@NotNull String summaryName, boolean isVisible2) {
        block2: {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)summaryName, (String)"summaryName");
                Iterable iterable = this.mySummaryStatistics;
                for (Object t : iterable) {
                    SummaryTreePart it = (SummaryTreePart)((Object)t);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSummaryName(), (Object)summaryName)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            SummaryTreePart summaryTreePart = v0;
            if (summaryTreePart == null) break block2;
            SummaryTreePart treePart = summaryTreePart;
            boolean bl = false;
            treePart.setShown(isVisible2);
        }
    }

    @Nullable
    public final Boolean isSummaryVisible(@NotNull String summaryName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)summaryName, (String)"summaryName");
            Iterable iterable = this.mySummaryStatistics;
            for (Object t : iterable) {
                SummaryTreePart it = (SummaryTreePart)((Object)t);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSummaryName(), (Object)summaryName)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        SummaryTreePart summaryTreePart = v0;
        return summaryTreePart != null ? Boolean.valueOf(summaryTreePart.isShown()) : null;
    }

    private static final boolean deleteSummaryTreeModel$lambda$9(String $summaryName, SummaryTreePart it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return Intrinsics.areEqual((Object)it.getSummaryName(), (Object)$summaryName);
    }

    private static final boolean deleteSummaryTreeModel$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

