/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.providers;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.scientific.py.tables.providers.PyPandasBaseProvider;
import com.intellij.scientific.tables.DSTableBundle;
import com.intellij.scientific.tables.DSTableRawData;
import com.intellij.scientific.tables.DataId;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.FilterExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.RowSorter;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J4\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u001e2\u0006\u0010!\u001a\u00020\"H\u0016J\u001a\u0010#\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0018\u0010&\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(H\u0016J\u001a\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u00112\u0006\u0010,\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006-"}, d2={"Lcom/intellij/scientific/py/tables/providers/PyPandasSeriesProvider;", "Lcom/intellij/scientific/py/tables/providers/PyPandasBaseProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "type", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "getType", "()Lcom/intellij/scientific/tables/api/DSTableDataType;", "isFallbackToStaticTableSupported", "", "parseStaticTableToFrameInfo", "Lcom/intellij/scientific/tables/api/DSDataFrameInfo;", "text", "", "parseStaticTableToTableData", "Lcom/intellij/scientific/tables/DSTableRawData;", "id", "Lcom/intellij/scientific/tables/DataId;", "table", "loadDynamicTableDataFrameInfo", "commandExecutor", "Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "tableVariable", "textTableOutput", "getSortingCommand", "sortKeys", "", "Ljavax/swing/RowSorter$SortKey;", "columns", "indexColumnWidth", "", "getFilteringCommand", "filters", "Lcom/intellij/scientific/tables/api/FilterExpression;", "getColumnVariableExpressionForFilterCommand", "filterExpression", "Lcom/intellij/scientific/tables/api/FilterExpression$SingleExpression;", "setSeriesDimensions", "", "seriesOutput", "dataFrameInfo", "intellij.scientific.py.tables"})
@SourceDebugExtension(value={"SMAP\nPyPandasSeriesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPandasSeriesProvider.kt\ncom/intellij/scientific/py/tables/providers/PyPandasSeriesProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n774#2:67\n865#2,2:68\n*S KotlinDebug\n*F\n+ 1 PyPandasSeriesProvider.kt\ncom/intellij/scientific/py/tables/providers/PyPandasSeriesProvider\n*L\n52#1:67\n52#1:68,2\n*E\n"})
public final class PyPandasSeriesProvider
extends PyPandasBaseProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final DSTableDataType type;

    public PyPandasSeriesProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.type = DSTableDataType.PANDAS_SERIES;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public DSTableDataType getType() {
        return this.type;
    }

    public boolean isFallbackToStaticTableSupported() {
        return false;
    }

    @NotNull
    public DSDataFrameInfo parseStaticTableToFrameInfo(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        throw new NotImplementedError("Showing Series as tables isn't supported for non-executed cells");
    }

    @NotNull
    public DSTableRawData parseStaticTableToTableData(@NotNull DataId id, @NotNull String table) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        throw new NotImplementedError("Showing Series as tables isn't supported for non-executed cells");
    }

    @Override
    @NotNull
    public DSDataFrameInfo loadDynamicTableDataFrameInfo(@NotNull DSTableCommandExecutor commandExecutor, @NotNull String tableVariable, @NotNull String textTableOutput) {
        DSDataFrameInfo dSDataFrameInfo;
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter((Object)textTableOutput, (String)"textTableOutput");
        DSDataFrameInfo $this$loadDynamicTableDataFrameInfo_u24lambda_u240 = dSDataFrameInfo = super.loadDynamicTableDataFrameInfo(commandExecutor, tableVariable, textTableOutput);
        boolean bl = false;
        this.setSeriesDimensions(textTableOutput, $this$loadDynamicTableDataFrameInfo_u24lambda_u240);
        return dSDataFrameInfo;
    }

    @NotNull
    public String getSortingCommand(@NotNull String tableVariable, @NotNull List<? extends RowSorter.SortKey> sortKeys, @NotNull List<String> columns, int indexColumnWidth) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter(sortKeys, (String)"sortKeys");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        if (sortKeys.isEmpty()) {
            return tableVariable;
        }
        return this.getSortCommand(tableVariable, sortKeys, null, indexColumnWidth);
    }

    @NotNull
    public String getFilteringCommand(@NotNull String tableVariable, @Nullable FilterExpression filters) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        if (filters == null) {
            return tableVariable;
        }
        return tableVariable + "[" + this.composeFilterCommand(tableVariable, filters) + "]";
    }

    @Override
    @NotNull
    public String getColumnVariableExpressionForFilterCommand(@NotNull String tableVariable, @NotNull FilterExpression.SingleExpression filterExpression) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter((Object)filterExpression, (String)"filterExpression");
        return tableVariable;
    }

    /*
     * WARNING - void declaration
     */
    private final void setSeriesDimensions(String seriesOutput, DSDataFrameInfo dataFrameInfo) {
        String dimText = null;
        if (seriesOutput != null) {
            String lastLine;
            void $this$filterTo$iv$iv;
            String[] stringArray = new String[]{"\n"};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)seriesOutput, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List lines = (List)destination$iv$iv;
            String string = lastLine = (String)CollectionsKt.lastOrNull((List)lines);
            boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"Name: ", (boolean)false, (int)2, null) : false;
            if (bl) {
                String[] stringArray2 = new String[]{", "};
                v3 = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)lastLine, (String[])stringArray2, (boolean)false, (int)2, (int)2, null));
            } else {
                v3 = dimText = lastLine;
            }
        }
        if (dimText == null || !StringsKt.startsWith$default(dimText, (String)"Length:", (boolean)false, (int)2, null)) {
            Object[] objectArray = new Object[3];
            objectArray[0] = dataFrameInfo.getRows();
            objectArray[1] = dimText != null ? 1 : 0;
            String string = dimText;
            if (string == null) {
                string = "";
            }
            objectArray[2] = string;
            dimText = DSTableBundle.message((String)"ds.table.dimensions.info.length", (Object[])objectArray);
        }
        dataFrameInfo.setDim(dimText);
    }
}

