/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template;

import com.intellij.jinja.model.TagLibrary;
import com.intellij.jinja.tags.Jinja2TagLibrary;
import com.intellij.jinja.template.DjangoTemplateRecursiveVisitor;
import com.intellij.jinja.template.tags.Jinja2LoadTag;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.model.DjangoTagLibrary;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DjangoCustomTagsLoadingRecursiveVisitor
extends DjangoTemplateRecursiveVisitor {
    @Override
    public void visitLoadTag(Jinja2LoadTag loadTag) {
        PsiReference[] references;
        super.visitLoadTag(loadTag);
        for (PsiReference reference : references = loadTag.getReferences()) {
            PsiElement result2 = reference.resolve();
            if (!(result2 instanceof PyFile)) continue;
            TagLibrary.getInstance(result2.getProject()).updateCustomTagsCache((PyFile)result2, file -> DjangoCustomTagsLoadingRecursiveVisitor.initCustomTagsCache(file));
        }
    }

    @NotNull
    private static TagLibrary.CustomTagCachedData initCustomTagsCache(PyFile file) {
        final TagLibrary.CustomTagCachedData result2 = new TagLibrary.CustomTagCachedData();
        result2.myModificationStamp = file.getModificationStamp();
        DjangoTagLibrary.processRegisteredTags(file, new Jinja2TagLibrary.TagProcessor(){

            @Override
            public void processTag(String name, PyElement declaration) {
                if (declaration instanceof PyFunction) {
                    if (DjangoCustomTagsLoadingRecursiveVisitor.referencesEndTag(name, (PyFunction)declaration)) {
                        result2.myBlockTags.add(name);
                    }
                    result2.myInnerTags.put(name, DjangoCustomTagsLoadingRecursiveVisitor.collectInnerTags((PyFunction)declaration));
                }
            }
        });
        TagLibrary.CustomTagCachedData customTagCachedData = result2;
        if (customTagCachedData == null) {
            DjangoCustomTagsLoadingRecursiveVisitor.$$$reportNull$$$0(0);
        }
        return customTagCachedData;
    }

    private static Set<String> collectInnerTags(PyFunction declaration) {
        InnerTagsFinder finder = new InnerTagsFinder();
        declaration.acceptChildren((PsiElementVisitor)finder);
        return finder.found;
    }

    private static boolean referencesEndTag(String name, PyFunction declaration) {
        EndTagNameFinder finder = new EndTagNameFinder("end" + name);
        declaration.acceptChildren((PsiElementVisitor)finder);
        return finder.found;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/lang/template/DjangoCustomTagsLoadingRecursiveVisitor", "initCustomTagsCache"));
    }

    private static class InnerTagsFinder
    extends PyRecursiveElementVisitor {
        private final Set<String> found = new HashSet<String>();

        private InnerTagsFinder() {
        }

        public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression node) {
            if (node == null) {
                InnerTagsFinder.$$$reportNull$$$0(0);
            }
            if (InnerTagsFinder.argOfParse(node)) {
                this.found.add(node.getStringValue());
            }
        }

        private static boolean argOfParse(PyStringLiteralExpression node) {
            PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)node, PyCallExpression.class);
            return call != null && call.getCallee() != null && "parse".equals(call.getCallee().getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/django/lang/template/DjangoCustomTagsLoadingRecursiveVisitor$InnerTagsFinder", "visitPyStringLiteralExpression"));
        }
    }

    private static class EndTagNameFinder
    extends PyRecursiveElementVisitor {
        private final String name;
        private boolean found;

        EndTagNameFinder(String name) {
            this.name = name;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                EndTagNameFinder.$$$reportNull$$$0(0);
            }
            if (this.found) {
                return;
            }
            super.visitElement(element);
        }

        public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression node) {
            if (node == null) {
                EndTagNameFinder.$$$reportNull$$$0(1);
            }
            if (this.name.equals(node.getStringValue())) {
                this.found = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/django/lang/template/DjangoCustomTagsLoadingRecursiveVisitor$EndTagNameFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyStringLiteralExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

