/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.applications;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.model.applications.DjangoAppConfig;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.ref.DjangoItemReferenceSet;
import com.jetbrains.django.util.DjangoCoreUtil;
import com.jetbrains.python.extensions.PyClassExtKt;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoAppConfigClassUtil {
    private static final PyRequirement MIN_APP_CFG_SPR_VER = DjangoCoreUtil.createRequirementAtLeast(1, 7);

    private DjangoAppConfigClassUtil() {
    }

    public static PsiReference[] getAppReferences(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        Boolean supportApplicationConfig = DjangoAppConfigClassUtil.supportApplicationConfig(module);
        if (supportApplicationConfig == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (supportApplicationConfig.booleanValue()) {
            return DjangoItemReferenceSet.createClassesReferenceSet(element).getAllReferences();
        }
        return DjangoAppConfigClassUtil.createPackageReferences(element);
    }

    public static PsiReference @NotNull [] createPackageReferences(@NotNull PsiElement element) {
        if (element == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(1);
        }
        PsiReference[] psiReferenceArray = DjangoItemReferenceSet.createPackagesReferenceSet(element).getAllReferences();
        if (psiReferenceArray == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    @Nullable
    private static Boolean supportApplicationConfig(@NotNull Module module) {
        DjangoModelApi api;
        if (module == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(3);
        }
        if ((api = (DjangoModelApi)DjangoModelApi.create(module).getSuccessOrNull()) == null) {
            return null;
        }
        return api.isDjangoPackageMatches(MIN_APP_CFG_SPR_VER);
    }

    @NotNull
    public static DjangoAppConfig getApplicationInfo(@NotNull Module djangoModule, @NotNull String nameFromInstalledApps) {
        if (djangoModule == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(4);
        }
        if (nameFromInstalledApps == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(5);
        }
        DjangoAppConfig djangoAppConfig = (DjangoAppConfig)ReadAction.compute(() -> DjangoAppConfigClassUtil.getApplicationInfoByConfigClassInternal(djangoModule, nameFromInstalledApps));
        if (djangoAppConfig == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(6);
        }
        return djangoAppConfig;
    }

    @NotNull
    @RequiresReadLock
    private static DjangoAppConfig getApplicationInfoByConfigClassInternal(@NotNull Module djangoModule, @NotNull String nameFromInstalledApps) {
        if (djangoModule == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(7);
        }
        if (nameFromInstalledApps == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(8);
        }
        ThreadingAssertions.softAssertReadAccess();
        PyPsiUtils.assertValid((Module)djangoModule);
        QualifiedName qNameFromInstalledApps = QualifiedName.fromDottedString((String)nameFromInstalledApps);
        PyClass appConfig = DjangoAppConfigClassUtil.getAppConfigClassFromQName(djangoModule, qNameFromInstalledApps);
        PyPsiUtils.assertValid((PsiElement)appConfig);
        if (appConfig == null) {
            DjangoAppConfig djangoAppConfig = DjangoAppConfig.Companion.createFromQualifiedName(nameFromInstalledApps);
            if (djangoAppConfig == null) {
                DjangoAppConfigClassUtil.$$$reportNull$$$0(9);
            }
            return djangoAppConfig;
        }
        TypeEvalContext typeEvalContext = TypeEvalContext.codeAnalysis((Project)djangoModule.getProject(), (PsiFile)appConfig.getContainingFile());
        return DjangoAppConfigClassUtil.getApplicationInfoFromConfigClass(appConfig, typeEvalContext, nameFromInstalledApps);
    }

    @NotNull
    @RequiresReadLock
    private static DjangoAppConfig getApplicationInfoFromConfigClass(@NotNull PyClass appConfig, @NotNull TypeEvalContext typeEvalContext, @NotNull String qualifiedName) {
        if (appConfig == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(10);
        }
        if (typeEvalContext == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(11);
        }
        if (qualifiedName == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(12);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (!DjangoAppConfigClassUtil.isConfigClass(appConfig, typeEvalContext)) {
            DjangoAppConfig djangoAppConfig = DjangoAppConfig.Companion.createFromQualifiedName(qualifiedName);
            if (djangoAppConfig == null) {
                DjangoAppConfigClassUtil.$$$reportNull$$$0(13);
            }
            return djangoAppConfig;
        }
        DjangoAppConfig djangoAppConfig = DjangoAppConfig.Companion.createFromAppConfigClass(appConfig, qualifiedName);
        if (djangoAppConfig == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(14);
        }
        return djangoAppConfig;
    }

    @Nullable
    private static PyClass getAppConfigClassFromQName(@NotNull Module djangoModule, @NotNull QualifiedName qNameFromInstalledApps) {
        PsiElement element;
        if (djangoModule == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(15);
        }
        if (qNameFromInstalledApps == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(16);
        }
        PyPsiUtils.assertValid((Module)djangoModule);
        PyQualifiedNameResolveContext context = PyResolveImportUtil.fromModule((Module)djangoModule);
        PyClass appConfig = (PyClass)PyUtil.as((Object)PyResolveImportUtil.resolveTopLevelMember((QualifiedName)qNameFromInstalledApps, (PyQualifiedNameResolveContext)context), PyClass.class);
        PyUtil.verboseOnly(() -> PyPsiUtils.assertValid((PsiElement)appConfig));
        if (appConfig != null) {
            return appConfig;
        }
        List elements = PyResolveImportUtil.resolveQualifiedName((QualifiedName)qNameFromInstalledApps, (PyQualifiedNameResolveContext)context);
        PsiElement psiElement = element = !elements.isEmpty() ? (PsiElement)elements.get(0) : null;
        if (element instanceof PsiDirectory) {
            PsiDirectory appDirectory = (PsiDirectory)element;
            return DjangoAppConfigClassUtil.getAppConfigFileFromApplicationRootFolder(appDirectory);
        }
        return null;
    }

    @Nullable
    public static PyClass getAppConfigFileFromApplicationRootFolder(@NotNull PsiDirectory psiDirectory) {
        PyFile pyFile;
        if (psiDirectory == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(17);
        }
        if ((pyFile = (PyFile)PyUtil.as((Object)psiDirectory.findFile("apps.py"), PyFile.class)) == null) {
            return null;
        }
        TypeEvalContext typeEvalContext = TypeEvalContext.codeAnalysis((Project)psiDirectory.getProject(), (PsiFile)pyFile.getContainingFile());
        @Nullable PyClass configClass = (PyClass)ContainerUtil.find((Iterable)pyFile.getTopLevelClasses(), pyClass -> DjangoAppConfigClassUtil.isConfigClass(pyClass, typeEvalContext));
        return configClass;
    }

    @Nullable
    public static DjangoAppConfig getAppConfigFromApplicationRootFolder(@NotNull PsiDirectory psiDirectory, @NotNull TypeEvalContext typeEvalContext) {
        PyClass configClass;
        if (psiDirectory == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(18);
        }
        if (typeEvalContext == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(19);
        }
        if ((configClass = DjangoAppConfigClassUtil.getAppConfigFileFromApplicationRootFolder(psiDirectory)) != null) {
            return DjangoAppConfigClassUtil.getApplicationInfoFromConfigClass(configClass, typeEvalContext, psiDirectory.getName());
        }
        return null;
    }

    private static boolean isConfigClass(@NotNull PyClass config2, @NotNull TypeEvalContext evalContext) {
        if (config2 == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(20);
        }
        if (evalContext == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(21);
        }
        PyUtil.verboseOnly(() -> PyPsiUtils.assertValid((PsiElement)config2));
        return PyClassExtKt.inherits((PyClass)config2, (TypeEvalContext)evalContext, (FQNamesProvider)DjangoFQNamesProvider.APP_CONFIG);
    }

    public static boolean isNameAttribute(@NotNull PyTargetExpression attribute, @NotNull TypeEvalContext typeEvalContext) {
        if (attribute == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(22);
        }
        if (typeEvalContext == null) {
            DjangoAppConfigClassUtil.$$$reportNull$$$0(23);
        }
        PyClass aClass = attribute.getContainingClass();
        return "name".equals(attribute.getName()) && aClass != null && DjangoAppConfigClassUtil.isConfigClass(aClass, typeEvalContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 9, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/applications/DjangoAppConfigClassUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoModule";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameFromInstalledApps";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appConfig";
                break;
            }
            case 11: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeEvalContext";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qNameFromInstalledApps";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evalContext";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/applications/DjangoAppConfigClassUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageReferences";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationInfoByConfigClassInternal";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationInfoFromConfigClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAppReferences";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPackageReferences";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "supportApplicationConfig";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationInfoByConfigClassInternal";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationInfoFromConfigClass";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAppConfigClassFromQName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAppConfigFileFromApplicationRootFolder";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAppConfigFromApplicationRootFolder";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isConfigClass";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isNameAttribute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 9, 13, 14 -> new IllegalStateException(string);
        };
    }
}

