/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ref;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.django.util.DjangoCoreUtil;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.django.util.DjangoPythonUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoReferenceUtil {
    private DjangoReferenceUtil() {
    }

    @Nullable
    public static PsiDirectory getDjangoRoot(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            DjangoReferenceUtil.$$$reportNull$$$0(0);
        }
        if ((file = DjangoPsiUtil.getFile(element)) == null || file.getParent() == null) {
            return null;
        }
        PsiDirectory djangoRoot = DjangoCoreUtil.getProjectRoot((PsiFileSystemItem)file.getParent());
        if (djangoRoot == null) {
            return null;
        }
        return djangoRoot;
    }

    public static List<VirtualFile> getPathVirtualFileList(VirtualFile root, String path2) {
        List pathElements = StringUtil.split((String)path2, (String)".");
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (int i = 0; root != null && i < pathElements.size(); ++i) {
            Object name = (String)pathElements.get(i);
            if (root.findChild((String)name) == null && (i == pathElements.size() - 1 || i == pathElements.size() - 2)) {
                name = (String)name + ".py";
            }
            if ((root = root.findChild((String)name)) == null) continue;
            result2.add(root);
        }
        return result2;
    }

    @Nullable
    public static PsiFile findLibraryFile(String path2, PsiElement element) {
        VirtualFile file = DjangoPythonUtil.findLibraryFile(path2, PythonSdkUtil.findPythonSdk((PsiElement)element));
        return file != null ? element.getManager().findFile(file) : null;
    }

    @Nullable
    public static PsiDirectory findLibraryDirectory(String path2, PsiElement element) {
        VirtualFile file = DjangoPythonUtil.findLibraryFile(path2, PythonSdkUtil.findPythonSdk((PsiElement)element));
        return file != null ? element.getManager().findDirectory(file) : null;
    }

    @Nullable
    public static PsiFileSystemItem findLibraryFSItem(String path2, PsiElement element) {
        PsiDirectory item = DjangoReferenceUtil.findLibraryDirectory(path2, element);
        if (item == null) {
            item = DjangoReferenceUtil.findLibraryFile(path2 + ".py", element);
        }
        return item;
    }

    @Nullable
    public static PsiFileSystemItem findProjectFSItem(PsiDirectory folder, String filePath2) {
        PsiDirectory item = DjangoPsiUtil.findFolder(folder, filePath2);
        if (item == null) {
            item = DjangoPsiUtil.findChild(folder, filePath2 + ".py");
        }
        return item;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/django/ref/DjangoReferenceUtil", "getDjangoRoot"));
    }
}

