/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import java.util.ArrayList;
import org.jetbrains.relocated.apache.batik.anim.AbstractAnimation;
import org.jetbrains.relocated.apache.batik.anim.TransformAnimation;
import org.jetbrains.relocated.apache.batik.anim.dom.AnimationTarget;
import org.jetbrains.relocated.apache.batik.anim.values.AnimatableTransformListValue;
import org.jetbrains.relocated.apache.batik.anim.values.AnimatableValue;
import org.jetbrains.relocated.apache.batik.bridge.Bridge;
import org.jetbrains.relocated.apache.batik.bridge.BridgeException;
import org.jetbrains.relocated.apache.batik.bridge.SVGAnimateElementBridge;
import org.jetbrains.relocated.apache.batik.dom.svg.SVGOMTransform;

public class SVGAnimateTransformElementBridge
extends SVGAnimateElementBridge {
    @Override
    public String getLocalName() {
        return "animateTransform";
    }

    @Override
    public Bridge getInstance() {
        return new SVGAnimateTransformElementBridge();
    }

    @Override
    protected AbstractAnimation createAnimation(AnimationTarget target) {
        short type = this.parseType();
        AnimatableValue from2 = null;
        AnimatableValue to = null;
        AnimatableValue by = null;
        if (this.element.hasAttributeNS(null, "from")) {
            from2 = this.parseValue(this.element.getAttributeNS(null, "from"), type, target);
        }
        if (this.element.hasAttributeNS(null, "to")) {
            to = this.parseValue(this.element.getAttributeNS(null, "to"), type, target);
        }
        if (this.element.hasAttributeNS(null, "by")) {
            by = this.parseValue(this.element.getAttributeNS(null, "by"), type, target);
        }
        return new TransformAnimation(this.timedElement, this, this.parseCalcMode(), this.parseKeyTimes(), this.parseKeySplines(), this.parseAdditive(), this.parseAccumulate(), this.parseValues(type, target), from2, to, by, type);
    }

    protected short parseType() {
        String typeString = this.element.getAttributeNS(null, "type");
        if (typeString.equals("translate")) {
            return 2;
        }
        if (typeString.equals("scale")) {
            return 3;
        }
        if (typeString.equals("rotate")) {
            return 4;
        }
        if (typeString.equals("skewX")) {
            return 5;
        }
        if (typeString.equals("skewY")) {
            return 6;
        }
        throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"type", typeString});
    }

    protected AnimatableValue parseValue(String s, short type, AnimationTarget target) {
        int i;
        float val2 = 0.0f;
        float val3 = 0.0f;
        int c = 44;
        int len = s.length();
        for (i = 0; i < len && (c = (int)s.charAt(i)) != 32 && c != 44; ++i) {
        }
        float val1 = Float.parseFloat(s.substring(0, i));
        if (i < len) {
            ++i;
        }
        int count2 = 1;
        if (i < len && c == 32) {
            while (i < len && (c = (int)s.charAt(i)) == 32) {
                ++i;
            }
            if (c == 44) {
                ++i;
            }
        }
        while (i < len && s.charAt(i) == ' ') {
            ++i;
        }
        int j = i;
        if (i < len && type != 5 && type != 6) {
            while (i < len && (c = (int)s.charAt(i)) != 32 && c != 44) {
                ++i;
            }
            val2 = Float.parseFloat(s.substring(j, i));
            if (i < len) {
                ++i;
            }
            ++count2;
            if (i < len && c == 32) {
                while (i < len && (c = (int)s.charAt(i)) == 32) {
                    ++i;
                }
                if (c == 44) {
                    ++i;
                }
            }
            while (i < len && s.charAt(i) == ' ') {
                ++i;
            }
            j = i;
            if (i < len && type == 4) {
                while (i < len && (c = (int)s.charAt(i)) != 44 && c != 32) {
                    ++i;
                }
                val3 = Float.parseFloat(s.substring(j, i));
                if (i < len) {
                    ++i;
                }
                ++count2;
                while (i < len && s.charAt(i) == ' ') {
                    ++i;
                }
            }
        }
        if (i != len) {
            return null;
        }
        SVGOMTransform t = new SVGOMTransform();
        switch (type) {
            case 2: {
                if (count2 == 2) {
                    t.setTranslate(val1, val2);
                    break;
                }
                t.setTranslate(val1, 0.0f);
                break;
            }
            case 3: {
                if (count2 == 2) {
                    t.setScale(val1, val2);
                    break;
                }
                t.setScale(val1, val1);
                break;
            }
            case 4: {
                if (count2 == 3) {
                    t.setRotate(val1, val2, val3);
                    break;
                }
                t.setRotate(val1, 0.0f, 0.0f);
                break;
            }
            case 5: {
                t.setSkewX(val1);
                break;
            }
            case 6: {
                t.setSkewY(val1);
            }
        }
        return new AnimatableTransformListValue(target, t);
    }

    protected AnimatableValue[] parseValues(short type, AnimationTarget target) {
        String valuesString = this.element.getAttributeNS(null, "values");
        int len = valuesString.length();
        if (len == 0) {
            return null;
        }
        ArrayList<AnimatableValue> values2 = new ArrayList<AnimatableValue>(7);
        int i = 0;
        int start2 = 0;
        block0: while (i < len) {
            int end;
            String valueString;
            AnimatableValue value2;
            while (valuesString.charAt(i) == ' ') {
                if (++i != len) continue;
                break block0;
            }
            start2 = i++;
            if (i < len) {
                char c = valuesString.charAt(i);
                while (c != ';' && ++i != len) {
                    c = valuesString.charAt(i);
                }
            }
            if ((value2 = this.parseValue(valueString = valuesString.substring(start2, end = i++), type, target)) == null) {
                throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"values", valuesString});
            }
            values2.add(value2);
        }
        AnimatableValue[] ret = new AnimatableValue[values2.size()];
        return values2.toArray(ret);
    }

    @Override
    protected boolean canAnimateType(int type) {
        return type == 9;
    }
}

