/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.jetbrains.firefox.FirefoxDeclarativeScope;
import com.jetbrains.firefox.FirefoxEvaluateContext;
import com.jetbrains.firefox.FirefoxValueManager;
import com.jetbrains.firefox.rdp.Bindings;
import com.jetbrains.firefox.rdp.Frame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.CallFrameBase;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ObjectScope;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeType;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.rpc.CommandProcessorKt;

final class FirefoxCallFrame
extends CallFrameBase {
    final String scriptUrl;
    final String scriptId;
    private final Variable thisObject;

    FirefoxCallFrame(@NotNull FirefoxValueManager valueManager, @NotNull Frame frame, boolean useBindingsFromFrameData) {
        if (valueManager == null) {
            FirefoxCallFrame.$$$reportNull$$$0(0);
        }
        if (frame == null) {
            FirefoxCallFrame.$$$reportNull$$$0(1);
        }
        super(FirefoxCallFrame.getFunctionName(frame.environment().function()), frame.where().line() - 1, frame.where().column(), (EvaluateContext)new FirefoxEvaluateContext(frame.actor(), valueManager));
        Frame.SourceYetAnotherPoorFirefoxRdpStructure source = frame.source();
        if (source == null) {
            this.scriptId = null;
            this.scriptUrl = frame.where().source().url();
        } else {
            this.scriptId = source.actor();
            this.scriptUrl = null;
        }
        this.thisObject = valueManager.createVariable("this", frame.receiver(), null);
        Frame.Environment environment = frame.environment();
        this.setHasOnlyGlobalScope(environment.parent() == null);
        this.setScopes(NotNullLazyValue.lazy(() -> {
            SmartList scopes = new SmartList();
            scopes.add(FirefoxCallFrame.createScope(environment, valueManager, true, useBindingsFromFrameData));
            Frame.Environment parent = environment;
            while ((parent = parent.parent()) != null) {
                scopes.add(FirefoxCallFrame.createScope(parent, valueManager, false, useBindingsFromFrameData));
            }
            valueManager.promoteRecentlyAddedActorsToThreadLifetime();
            return scopes;
        }));
    }

    @NotNull
    private static Scope createScope(@NotNull Frame.Environment environment, @NotNull FirefoxValueManager valueManager, boolean local, boolean useBindingsFromFrameData) {
        if (environment == null) {
            FirefoxCallFrame.$$$reportNull$$$0(2);
        }
        if (valueManager == null) {
            FirefoxCallFrame.$$$reportNull$$$0(3);
        }
        ScopeType type = switch (environment.type()) {
            case Frame.Environment.Type.OBJECT -> {
                if (environment.parent() == null) {
                    yield ScopeType.GLOBAL;
                }
                yield ScopeType.WITH;
            }
            case Frame.Environment.Type.WITH -> ScopeType.WITH;
            default -> local ? ScopeType.LOCAL : ScopeType.CLOSURE;
        };
        Bindings bindings = environment.bindings();
        if (bindings == null) {
            ObjectValue value = (ObjectValue)valueManager.createValue(environment.object(), null, null);
            CommandProcessorKt.getLOG().assertTrue(value != null);
            return new ObjectScope(type, value);
        }
        return new FirefoxDeclarativeScope(type, environment, valueManager, useBindingsFromFrameData);
    }

    @Nullable
    static String getFunctionName(@Nullable Frame.Function function) {
        if (function == null) {
            return null;
        }
        if (StringUtil.isEmpty((String)function.userDisplayName())) {
            return StringUtil.isEmpty((String)function.displayName()) ? StringUtil.nullize((String)function.name()) : function.displayName();
        }
        return function.userDisplayName();
    }

    @NotNull
    public Promise<Variable> getReceiverVariable() {
        Promise promise = Promises.resolvedPromise((Object)this.thisObject);
        if (promise == null) {
            FirefoxCallFrame.$$$reportNull$$$0(4);
        }
        return promise;
    }

    @NotNull
    public Object getEqualityObject() {
        String string = (String)ObjectUtils.chooseNotNull((Object)this.scriptId, (Object)this.scriptUrl) + "#" + this.getFunctionName();
        if (string == null) {
            FirefoxCallFrame.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/firefox/FirefoxCallFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/firefox/FirefoxCallFrame";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReceiverVariable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createScope";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

