/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.formatter;

import com.google.common.collect.Lists;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.lang.qml.QmlBundle;
import com.intellij.lang.qml.QmlLanguageDialect;
import com.intellij.lang.qml.settings.QmlSettings;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.qt.common.settings.QtSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QmlFormatProcessor
implements ExternalFormatProcessor {
    @NlsSafe
    public static final String QML_FORMAT_ID = "`qmlformat`";

    public boolean activeForFile(@NotNull PsiFile source) {
        if (source == null) {
            QmlFormatProcessor.$$$reportNull$$$0(0);
        }
        if (!source.getLanguage().equals((Object)QmlLanguageDialect.getInstance())) {
            return false;
        }
        if ("jetbrainsDummySettingsFile".equals(source.getName())) {
            return false;
        }
        QmlSettings qmlSettings = QmlSettings.getInstance(source.getProject());
        QtSettings qtSettings = QtSettings.getInstance((Project)source.getProject());
        return qmlSettings.isQmlFormatEnabledAndExists(qtSettings.getCurrentProfile());
    }

    private static boolean checkHasIntersectedFragments(List<LineFragment> lineFragments) {
        int lastOffset = -1;
        for (LineFragment fragment : lineFragments) {
            if (fragment.getStartOffset1() <= lastOffset) {
                return true;
            }
            lastOffset = fragment.getEndOffset1();
        }
        return false;
    }

    public static List<Pair<TextRange, String>> getReplacements(@NotNull String documentText, int rangeStartOffset, int rangeEndOffset, @NotNull String outText) {
        if (documentText == null) {
            QmlFormatProcessor.$$$reportNull$$$0(1);
        }
        if (outText == null) {
            QmlFormatProcessor.$$$reportNull$$$0(2);
        }
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        ComparisonManager manager = ComparisonManager.getInstance();
        List lineFragments = manager.compareLinesInner((CharSequence)documentText, (CharSequence)outText, ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        boolean hasIntersectedFragments = QmlFormatProcessor.checkHasIntersectedFragments(lineFragments);
        for (LineFragment fragment : Lists.reverse((List)lineFragments)) {
            if (!hasIntersectedFragments && (fragment.getEndOffset1() <= rangeStartOffset || fragment.getStartOffset1() >= rangeEndOffset)) continue;
            String replacementText = outText.substring(fragment.getStartOffset2(), fragment.getEndOffset2());
            result.add((Pair<TextRange, String>)new Pair((Object)new TextRange(fragment.getStartOffset1(), fragment.getEndOffset1()), (Object)replacementText));
        }
        return result;
    }

    @Nullable
    public TextRange format(@NotNull PsiFile source, @NotNull TextRange range, boolean canChangeWhiteSpacesOnly, boolean keepLineBreaks, boolean enableBulkUpdate, int cursorOffset) {
        QtSettings qtSettings;
        QmlSettings settings;
        if (source == null) {
            QmlFormatProcessor.$$$reportNull$$$0(3);
        }
        if (range == null) {
            QmlFormatProcessor.$$$reportNull$$$0(4);
        }
        if (!(settings = QmlSettings.getInstance(source.getProject())).isQmlFormatEnabledAndExists((qtSettings = QtSettings.getInstance((Project)source.getProject())).getCurrentProfile())) {
            return null;
        }
        @NotNull String qmlFormatFile = settings.findQmlFormatPath();
        if (qmlFormatFile.isEmpty()) {
            return null;
        }
        @Nullable VirtualFile virtualFile = source.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = source.getOriginalFile().getVirtualFile();
        }
        if (virtualFile == null) {
            return null;
        }
        @Nullable Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            File tmpFile = null;
            try {
                tmpFile = FileUtil.createTempFile((String)"tmpQmlFile", (String)".qml", (boolean)true);
                FileUtil.writeToFile((File)tmpFile, (String)document.getText());
                ProcessOutput processOutput = null;
                @Nullable WslPath wslPath = WslPath.parseWindowsUncPath((String)qmlFormatFile);
                if (wslPath != null) {
                    @NotNull WSLDistribution distribution = wslPath.getDistribution();
                    @NotNull String tmpFileWsl = distribution.getWslPath(tmpFile.toPath().toAbsolutePath());
                    if (tmpFileWsl != null) {
                        processOutput = distribution.executeOnWsl(5000, new String[]{wslPath.getLinuxPath(), "-n", "-f", tmpFileWsl});
                    }
                } else {
                    GeneralCommandLine commandLine = new GeneralCommandLine();
                    commandLine.setExePath(qmlFormatFile);
                    commandLine.addParameter("-n");
                    commandLine.addParameter("-f");
                    commandLine.addParameter(tmpFile.getAbsolutePath());
                    CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
                    processOutput = processHandler.runProcess();
                }
                if (processOutput == null || processOutput.getExitCode() != 0) {
                    Notifications.Bus.notify((Notification)new Notification("QmlLang", QmlBundle.message("qmlformat.error", new Object[0]), NotificationType.WARNING), (Project)source.getProject());
                    return;
                }
                @NotNull @NlsSafe String outText = processOutput.getStdout().replaceAll("\r\n", "\n").replaceAll("\r", "\n");
                application.invokeLater(() -> WriteCommandAction.runWriteCommandAction((Project)source.getProject(), null, null, () -> {
                    for (Pair<TextRange, String> replacement : QmlFormatProcessor.getReplacements(document.getText(), range.getStartOffset(), range.getEndOffset(), outText)) {
                        document.replaceString(((TextRange)replacement.first).getStartOffset(), ((TextRange)replacement.first).getEndOffset(), (CharSequence)replacement.second);
                    }
                }, (PsiFile[])new PsiFile[0]));
            }
            catch (ExecutionException | IOException message) {
                throw new RuntimeException(message);
            }
            finally {
                if (tmpFile != null) {
                    FileUtil.delete((File)tmpFile);
                }
            }
        });
        return null;
    }

    @Nullable
    public String indent(@NotNull PsiFile source, int lineStartOffset) {
        if (source == null) {
            QmlFormatProcessor.$$$reportNull$$$0(5);
        }
        return null;
    }

    @NotNull
    public String getId() {
        return QML_FORMAT_ID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/qml/formatter/QmlFormatProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "activeForFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getReplacements";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "format";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "indent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

