/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh.deploy.fixes;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.gateway.ssh.deploy.fixes.DeployFixAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u000b2\u00020\u0001:\b\u0004\u0005\u0006\u0007\b\t\n\u000bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0007\f\r\u000e\u000f\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement;", "", "<init>", "()V", "TextOutput", "DiagnosticOutput", "EnvironmentOutput", "FailureOutput", "AttachedFile", "FixAction", "DialogAction", "Companion", "Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$AttachedFile;", "Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$DiagnosticOutput;", "Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$DialogAction;", "Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$EnvironmentOutput;", "Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$FailureOutput;", "Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$FixAction;", "Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$TextOutput;", "intellij.gateway.core"})
@ApiStatus.Internal
public abstract class DeployDiagnosticElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String dateFormat = "%1$tF %1$tT,%1$tL";

    private DeployDiagnosticElement() {
    }

    public /* synthetic */ DeployDiagnosticElement(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$AttachedFile;", "Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement;", "fileName", "", "fileData", "", "<init>", "(Ljava/lang/String;[B)V", "getFileName", "()Ljava/lang/String;", "getFileData", "()[B", "intellij.gateway.core"})
    public static final class AttachedFile
    extends DeployDiagnosticElement {
        @NotNull
        private final String fileName;
        @NotNull
        private final byte[] fileData;

        public AttachedFile(@NlsSafe @NotNull String fileName, @NotNull byte[] fileData) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
            super(null);
            this.fileName = fileName;
            this.fileData = fileData;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @NotNull
        public final byte[] getFileData() {
            return this.fileData;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0007J(\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$Companion;", "", "<init>", "()V", "dateFormat", "", "getLogOutput", "", "data", "Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement;", "foldRetries", "Lkotlin/Pair;", "Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$TextOutput;", "", "commands", "intellij.gateway.core"})
    @SourceDebugExtension(value={"SMAP\nDeployDiagnosticProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeployDiagnosticProvider.kt\ncom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n808#2,11:141\n808#2,11:152\n808#2,11:163\n808#2,11:174\n1863#2,2:185\n1863#2,2:187\n1863#2,2:189\n1863#2,2:191\n1797#2,3:193\n*S KotlinDebug\n*F\n+ 1 DeployDiagnosticProvider.kt\ncom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$Companion\n*L\n65#1:141,11\n67#1:152,11\n68#1:163,11\n69#1:174,11\n71#1:185,2\n82#1:187,2\n89#1:189,2\n97#1:191,2\n107#1:193,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getLogOutput(@NotNull List<? extends DeployDiagnosticElement> data) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstanceTo$iv$iv2;
            void $this$filterIsInstanceTo$iv$iv3;
            void $this$filterIsInstanceTo$iv$iv4;
            Intrinsics.checkNotNullParameter(data, (String)"data");
            List result2 = new ArrayList();
            Iterable $this$filterIsInstance$iv = data;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo22 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv4) {
                if (!(element$iv$iv instanceof TextOutput)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List texts = (List)destination$iv$iv;
            List<Pair<TextOutput, Integer>> textWithRetriesFolded = this.foldRetries(texts);
            Iterable $this$filterIsInstance$iv2 = data;
            boolean $i$f$filterIsInstance2 = false;
            Iterable $i$f$filterIsInstanceTo22 = $this$filterIsInstance$iv2;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
                if (!(element$iv$iv instanceof EnvironmentOutput)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List environment = (List)destination$iv$iv2;
            Iterable $this$filterIsInstance$iv3 = data;
            boolean $i$f$filterIsInstance3 = false;
            destination$iv$iv2 = $this$filterIsInstance$iv3;
            Iterable destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterIsInstanceTo3 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof DiagnosticOutput)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List diagnostics = (List)destination$iv$iv3;
            Iterable $this$filterIsInstance$iv4 = data;
            boolean $i$f$filterIsInstance4 = false;
            destination$iv$iv3 = $this$filterIsInstance$iv4;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterIsInstanceTo4 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FailureOutput)) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            List failures = (List)destination$iv$iv4;
            Iterable $this$forEach$iv = textWithRetriesFolded;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                TextOutput output = (TextOutput)it.getFirst();
                int count = ((Number)it.getSecond()).intValue();
                result2.add(output + "\n");
                if (count <= 1) continue;
                result2.add("\t[command is repeated " + (count - 1) + " more times]\n");
            }
            if (!((Collection)failures).isEmpty()) {
                result2.add("\n==== FAILURES ====\n");
                $this$forEach$iv = failures;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FailureOutput it = (FailureOutput)element$iv;
                    boolean bl = false;
                    result2.add(it.getData() + "\n" + ExceptionsKt.stackTraceToString((Throwable)it.getReason()) + "\n");
                }
            }
            if (!((Collection)environment).isEmpty()) {
                result2.add("\n==== ENVIRONMENT ====\n");
                $this$forEach$iv = environment;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    EnvironmentOutput it = (EnvironmentOutput)element$iv;
                    boolean bl = false;
                    result2.add(it.getCommand() + "\n");
                    String[] stringArray = new String[]{"\n"};
                    result2.add(CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)it.getOutput(), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"\n", null, null, (int)0, null, Companion::getLogOutput$lambda$3$lambda$2, (int)30, null));
                    result2.add("\n");
                }
            }
            if (!((Collection)diagnostics).isEmpty()) {
                result2.add("\n==== DIAGNOSTIC ERRORS ====\n");
                $this$forEach$iv = diagnostics;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DiagnosticOutput it = (DiagnosticOutput)element$iv;
                    boolean bl = false;
                    result2.add(it.getData() + "\n");
                }
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<Pair<TextOutput, Integer>> foldRetries(List<TextOutput> commands) {
            List withRetriesFolded = new ArrayList();
            Iterable $this$fold$iv = commands;
            boolean $i$f$fold = false;
            List accumulator$iv = withRetriesFolded;
            for (Object element$iv : $this$fold$iv) {
                void output;
                TextOutput textOutput = (TextOutput)element$iv;
                List acc = accumulator$iv;
                boolean bl = false;
                if (acc.isEmpty() || !Intrinsics.areEqual((Object)((TextOutput)((Pair)CollectionsKt.last((List)acc)).getFirst()).getData(), (Object)output.getData())) {
                    v0 = acc.add(new Pair((Object)output, (Object)1));
                } else {
                    Pair last = (Pair)CollectionsKt.last((List)acc);
                    CollectionsKt.removeLast((List)acc);
                    v0 = acc.add(new Pair(last.getFirst(), (Object)(((Number)last.getSecond()).intValue() + 1)));
                }
                accumulator$iv = acc;
            }
            return accumulator$iv;
        }

        private static final CharSequence getLogOutput$lambda$3$lambda$2(String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return "\t" + line;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$DiagnosticOutput;", "Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement;", "data", "", "<init>", "(Ljava/lang/String;)V", "getData", "()Ljava/lang/String;", "intellij.gateway.core"})
    public static final class DiagnosticOutput
    extends DeployDiagnosticElement {
        @NotNull
        private final String data;

        public DiagnosticOutput(@NotNull String data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            super(null);
            this.data = data;
        }

        public /* synthetic */ DiagnosticOutput(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "No message";
            }
            this(string);
        }

        @NotNull
        public final String getData() {
            return this.data;
        }

        public DiagnosticOutput() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$DialogAction;", "Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement;", "text", "", "dialogFunc", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/DialogWrapper;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getText", "()Ljava/lang/String;", "getDialogFunc", "()Lkotlin/jvm/functions/Function0;", "intellij.gateway.core"})
    public static final class DialogAction
    extends DeployDiagnosticElement {
        @NotNull
        private final String text;
        @NotNull
        private final Function0<DialogWrapper> dialogFunc;

        public DialogAction(@Nls @NotNull String text, @NotNull Function0<? extends DialogWrapper> dialogFunc) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(dialogFunc, (String)"dialogFunc");
            super(null);
            this.text = text;
            this.dialogFunc = dialogFunc;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Function0<DialogWrapper> getDialogFunc() {
            return this.dialogFunc;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$EnvironmentOutput;", "Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement;", "command", "", "output", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getCommand", "()Ljava/lang/String;", "getOutput", "intellij.gateway.core"})
    public static final class EnvironmentOutput
    extends DeployDiagnosticElement {
        @NotNull
        private final String command;
        @NotNull
        private final String output;

        public EnvironmentOutput(@NotNull String command, @NotNull String output) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            super(null);
            this.command = command;
            this.output = output;
        }

        @NotNull
        public final String getCommand() {
            return this.command;
        }

        @NotNull
        public final String getOutput() {
            return this.output;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$FailureOutput;", "Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement;", "data", "", "reason", "Ljava/lang/Exception;", "Lkotlin/Exception;", "<init>", "(Ljava/lang/String;Ljava/lang/Exception;)V", "getData", "()Ljava/lang/String;", "getReason", "()Ljava/lang/Exception;", "intellij.gateway.core"})
    public static final class FailureOutput
    extends DeployDiagnosticElement {
        @NotNull
        private final String data;
        @NotNull
        private final Exception reason;

        public FailureOutput(@NotNull String data, @NotNull Exception reason) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super(null);
            this.data = data;
            this.reason = reason;
        }

        public /* synthetic */ FailureOutput(String string, Exception exception, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "No message";
            }
            this(string, exception);
        }

        @NotNull
        public final String getData() {
            return this.data;
        }

        @NotNull
        public final Exception getReason() {
            return this.reason;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$FixAction;", "Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement;", "action", "Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployFixAction;", "<init>", "(Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployFixAction;)V", "getAction", "()Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployFixAction;", "intellij.gateway.core"})
    public static final class FixAction
    extends DeployDiagnosticElement {
        @NotNull
        private final DeployFixAction action;

        public FixAction(@NotNull DeployFixAction action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            super(null);
            this.action = action;
        }

        @NotNull
        public final DeployFixAction getAction() {
            return this.action;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0010\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$TextOutput;", "Lcom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement;", "timestamp", "Ljava/util/Date;", "data", "", "description", "icon", "Ljavax/swing/Icon;", "<init>", "(Ljava/util/Date;Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;)V", "getData", "()Ljava/lang/String;", "getDescription", "getIcon", "()Ljavax/swing/Icon;", "toString", "intellij.gateway.core"})
    @SourceDebugExtension(value={"SMAP\nDeployDiagnosticProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeployDiagnosticProvider.kt\ncom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$TextOutput\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n827#2:141\n855#2,2:142\n*S KotlinDebug\n*F\n+ 1 DeployDiagnosticProvider.kt\ncom/jetbrains/gateway/ssh/deploy/fixes/DeployDiagnosticElement$TextOutput\n*L\n37#1:141\n37#1:142,2\n*E\n"})
    public static final class TextOutput
    extends DeployDiagnosticElement {
        @NotNull
        private final Date timestamp;
        @NotNull
        private final String data;
        @NotNull
        private final String description;
        @Nullable
        private final Icon icon;

        public TextOutput(@NotNull Date timestamp, @Nls @NotNull String data, @NotNull String description, @Nullable Icon icon) {
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            super(null);
            this.timestamp = timestamp;
            this.data = data;
            this.description = description;
            this.icon = icon;
        }

        public /* synthetic */ TextOutput(Date date, String string, String string2, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = "";
            }
            if ((n & 8) != 0) {
                icon = null;
            }
            this(date, string, string2, icon);
        }

        @NotNull
        public final String getData() {
            return this.data;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @Nullable
        public final Icon getIcon() {
            return this.icon;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public String toString() {
            void $this$filterNotTo$iv$iv;
            Object[] objectArray = new String[2];
            String string = DeployDiagnosticElement.dateFormat;
            Object object = new Object[]{this.timestamp};
            String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            objectArray[0] = string2 + "\t" + this.data;
            objectArray[1] = StringsKt.replace$default((String)this.description, (String)"\n", (String)"\n\t", (boolean)false, (int)4, null);
            Iterable $this$filterNot$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$filterNot = false;
            object = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                CharSequence charSequence = it;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
    }
}

