/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.codeStyle;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.MagicIntegerConstAccessor;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleGroup;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.codeStyle.CssCodeStyleMainPanel;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    public static final CodeStyleGroup STYLESHEET_GROUP = new CodeStyleGroup("stylesheet.code.style.group", CssBundle.message("css.stylesheets.configurable.title", new Object[0]), CssBundle.message("stylesheet.code.style.group.description", new Object[0]), null, (Language)CSSLanguage.INSTANCE);

    @NotNull
    public Language getLanguage() {
        CSSLanguage cSSLanguage = CSSLanguage.INSTANCE;
        if (cSSLanguage == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return cSSLanguage;
    }

    public CodeStyleGroup getGroup() {
        return STYLESHEET_GROUP;
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        if (indentOptions == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        commonSettings.LINE_COMMENT_AT_FIRST_COLUMN = false;
        commonSettings.BLOCK_COMMENT_AT_FIRST_COLUMN = false;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        return "body {\n    background: black;\n    color: #80c0c0\n}\np:first-line {\n    margin-left: 25px\n}\n\n\n\n\n/* after several blank lines */\n";
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    @NotNull
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        return new CssCodeStyleSettings(settings);
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        if (settingsType == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            CssLanguageCodeStyleSettingsProvider.customizeStyleSheetBlankLinesSettings(consumer, CssCodeStyleSettings.class);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.COMMENTER_SETTINGS) {
            consumer.showStandardOptions(new String[]{CodeStyleSettingsCustomizable.CommenterOption.BLOCK_COMMENT_ADD_SPACE.name()});
        }
    }

    public static void customizeStyleSheetBlankLinesSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull Class<? extends CssCodeStyleSettings> settingsClass) {
        if (consumer == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        if (settingsClass == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(8);
        }
        consumer.showStandardOptions(new String[]{"KEEP_BLANK_LINES_IN_CODE"});
        String groupName = CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES;
        consumer.showCustomOption(settingsClass, "BLANK_LINES_BETWEEN_BLOCKS", CssBundle.message("code.style.label.blank.lines.around.top.level.block", new Object[0]), groupName, new Object[0]);
        consumer.showCustomOption(settingsClass, "BLANK_LINES_AROUND_NESTED_SELECTOR", CssBundle.message("code.style.label.blank.lines.around.nested.selector", new Object[0]), groupName, new Object[0]);
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        if (baseSettings == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(9);
        }
        if (modelSettings == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(10);
        }
        return new CodeStyleAbstractConfigurable(baseSettings, modelSettings, this.getConfigurableDisplayName()){

            @NotNull
            protected CodeStyleAbstractPanel createPanel(@NotNull CodeStyleSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new CssCodeStyleMainPanel(this.getCurrentSettings(), settings);
            }

            @NotNull
            @NonNls
            public String getHelpTopic() {
                return "reference.settingsdialog.IDE.csscodestyle";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/css/codeStyle/CssLanguageCodeStyleSettingsProvider$1", "createPanel"));
            }
        };
    }

    @Nullable
    public CodeStyleFieldAccessor getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        if (codeStyleObject == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(11);
        }
        if (field == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(12);
        }
        if (codeStyleObject instanceof CssCodeStyleSettings) {
            String fieldName = field.getName();
            if ("BRACE_PLACEMENT".equals(fieldName)) {
                return new MagicIntegerConstAccessor(codeStyleObject, field, new int[]{0, 1}, new String[]{"end_of_line", "next_line"});
            }
            if ("VALUE_ALIGNMENT".equals(fieldName)) {
                return new MagicIntegerConstAccessor(codeStyleObject, field, new int[]{0, 1, 2}, new String[]{"do_not_align", "on_colon", "on_value"});
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/codeStyle/CssLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleObject";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/codeStyle/CssLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCustomSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "customizeStyleSheetBlankLinesSettings";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAccessor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

