/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class XmlStringWriter {
    private final Writer myWriter;
    private final StringBuffer myAttributes = new StringBuffer();
    private int myDepth = 0;
    private final LinkedList<String> myOpenTags = new LinkedList();

    public XmlStringWriter(Writer writer) {
        this.myWriter = writer;
    }

    public void write(String s) {
        try {
            this.myWriter.write(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void flush() {
        try {
            this.myWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void println() {
        this.write("\n");
    }

    public void println(String s) {
        this.print(s);
        this.println();
    }

    public XmlStringWriter print(String s) {
        this.write(s);
        return this;
    }

    public void addAttribute(@NonNls String name) {
        this.addAttribute(name, name);
    }

    public void addAttribute(@NonNls String key, int value) {
        this.addAttribute(key, String.valueOf(value));
    }

    public void addAttribute(@NonNls String key, String value) {
        if (value == null) {
            return;
        }
        if (this.myAttributes.length() > 0) {
            this.myAttributes.append(' ');
        }
        this.myAttributes.append(key);
        this.myAttributes.append("=\"");
        this.myAttributes.append(value);
        this.myAttributes.append('\"');
    }

    public void addSingleAttribute(@NonNls String attr) {
        if (StringUtil.isEmpty((String)attr)) {
            return;
        }
        if (this.myAttributes.length() > 0) {
            this.myAttributes.append(' ');
        }
        this.myAttributes.append(attr);
    }

    public void printlnOpeningTag(@NonNls String tag) {
        this.printOpeningTag(tag);
        this.println();
    }

    public void printOpeningTag(@NonNls String tag) {
        this.write("<");
        this.write(tag);
        if (this.myAttributes.length() > 0) {
            this.write(" ");
            this.write(this.myAttributes.toString());
            this.write(" ");
        }
        this.write(">");
        this.clearAttributes();
        ++this.myDepth;
        this.myOpenTags.addFirst(tag);
    }

    public void printlnClosingTag() {
        this.printClosingTag();
        this.println();
    }

    public void printClosingTag() {
        --this.myDepth;
        this.write("</");
        String tag = this.myOpenTags.poll();
        this.write(tag);
        this.write(">");
        assert (this.myAttributes.length() == 0) : "Attributes should not be added for the closing tag. Tag: " + tag + " ; attributes: " + this.myAttributes;
    }

    public void printlnFullTag(@NonNls String tag) {
        this.printlnFullTag(tag, null);
    }

    public void printlnFullTag(@NonNls String tag, String value) {
        this.printFullTag(tag, value);
        this.println();
    }

    public void printFullTag(@NonNls String tag) {
        this.printFullTag(tag, null);
    }

    public void printFullTag(@NonNls String tag, String value) {
        this.write("<");
        this.write(tag);
        if (this.myAttributes.length() > 0) {
            this.write(" ");
            this.write(this.myAttributes.toString());
            this.write(" ");
        }
        this.write(">");
        if (value != null) {
            this.write(value);
        }
        this.write("</");
        this.write(tag);
        this.write(">");
        this.clearAttributes();
    }

    public void printlnShortTag(@NonNls String tag) {
        this.printlnShortTag(tag, null);
    }

    public void printlnShortTag(@NonNls String tag, String value) {
        this.printShortTag(tag, value);
        this.println();
    }

    public void printShortTag(@NonNls String tag) {
        this.printShortTag(tag, null);
    }

    public void printShortTag(@NonNls String tag, String value) {
        this.write("<");
        this.write(tag);
        if (this.myAttributes.length() > 0) {
            this.write(" ");
            this.write(this.myAttributes.toString());
            this.write(" ");
        }
        if (value != null) {
            this.write(">");
            this.write(value);
            this.write("</");
            this.write(tag);
            this.write(">");
        } else {
            this.write("/>");
        }
        this.clearAttributes();
    }

    public void clearAttributes() {
        this.myAttributes.delete(0, this.myAttributes.length());
    }

    public void addAttributes(Map<String, String> attributes) {
        for (Map.Entry<String, String> o : attributes.entrySet()) {
            this.addAttribute(o.getKey(), o.getValue());
        }
    }
}

