/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.impl.util.CssCompatibilityData;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssBrowserCompatibilityForPropertiesInspection
extends CssBaseInspection {
    public boolean myCheckChrome = true;
    public int myChromeVersion = 71;
    public boolean myCheckEdge = true;
    public int myEdgeVersion = 18;
    public boolean myCheckFirefox = true;
    public int myFirefoxVersion = 64;
    public boolean myCheckIE = true;
    public int myIEVersion = 11;
    public boolean myCheckOpera = true;
    public int myOperaVersion = 57;
    public boolean myCheckSafari = true;
    public int mySafariVersion = 12;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{CssBrowserCompatibilityForPropertiesInspection.browser("myCheckChrome", "myChromeVersion", "Chrome"), CssBrowserCompatibilityForPropertiesInspection.browser("myCheckEdge", "myEdgeVersion", "Edge"), CssBrowserCompatibilityForPropertiesInspection.browser("myCheckFirefox", "myFirefoxVersion", "Firefox"), CssBrowserCompatibilityForPropertiesInspection.browser("myCheckIE", "myIEVersion", "Internet Explorer"), CssBrowserCompatibilityForPropertiesInspection.browser("myCheckOpera", "myOperaVersion", "Opera"), CssBrowserCompatibilityForPropertiesInspection.browser("myCheckSafari", "mySafariVersion", "Safari")});
        if (optPane == null) {
            CssBrowserCompatibilityForPropertiesInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    private static OptCheckbox browser(@Language(value="jvm-field-name") @NotNull String enabledField, @Language(value="jvm-field-name") @NotNull String versionField, @NotNull @NlsSafe String browserName) {
        if (enabledField == null) {
            CssBrowserCompatibilityForPropertiesInspection.$$$reportNull$$$0(1);
        }
        if (versionField == null) {
            CssBrowserCompatibilityForPropertiesInspection.$$$reportNull$$$0(2);
        }
        if (browserName == null) {
            CssBrowserCompatibilityForPropertiesInspection.$$$reportNull$$$0(3);
        }
        OptCheckbox optCheckbox = OptPane.checkbox((String)enabledField, (String)browserName, (OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)versionField, (String)CssBundle.message("label.version", new Object[0]), (int)1, (int)10000)});
        if (optCheckbox == null) {
            CssBrowserCompatibilityForPropertiesInspection.$$$reportNull$$$0(4);
        }
        return optCheckbox;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssBrowserCompatibilityForPropertiesInspection.$$$reportNull$$$0(5);
        }
        if (!(this.myCheckChrome || this.myCheckEdge || this.myCheckFirefox || this.myCheckIE || this.myCheckOpera || this.myCheckSafari)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                CssBrowserCompatibilityForPropertiesInspection.$$$reportNull$$$0(6);
            }
            return psiElementVisitor;
        }
        return new CssElementVisitor(){

            @Override
            public void visitCssDeclaration(CssDeclaration declaration) {
                String dialectName;
                if (!(declaration.getParent() instanceof CssBlock) || !(declaration.getParent().getParent() instanceof CssRuleset)) {
                    return;
                }
                if (declaration.isCustomProperty()) {
                    return;
                }
                PsiElement propertyNameElement = declaration.getPropertyNameElement();
                if (propertyNameElement == null) {
                    return;
                }
                if (!CssInspectionsUtil.isPureCssPropertyName(propertyNameElement)) {
                    return;
                }
                if (PsiTreeUtil.hasErrorElements((PsiElement)declaration)) {
                    return;
                }
                CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider(declaration);
                if (descriptorProvider != null && descriptorProvider.skipCssPropertyCheck(declaration)) {
                    return;
                }
                if (!(descriptorProvider != null && descriptorProvider.providesClassicCss() || (dialectName = (String)CssDialectMappings.getInstance(declaration.getProject()).getMapping(declaration.getContainingFile().getVirtualFile())) == null || dialectName.equals(CssDialect.CLASSIC.getName()))) {
                    return;
                }
                String propertyName = declaration.getPropertyName();
                if (descriptorProvider != null) {
                    propertyName = descriptorProvider.restoreFullPropertyName(propertyName, propertyNameElement);
                }
                CssBrowserCompatibilityForPropertiesInspection.this.checkProperty(holder, propertyNameElement, propertyName);
            }
        };
    }

    private void checkProperty(@NotNull ProblemsHolder holder, @NotNull PsiElement propertyNameElement, @NotNull String propertyName) {
        if (holder == null) {
            CssBrowserCompatibilityForPropertiesInspection.$$$reportNull$$$0(7);
        }
        if (propertyNameElement == null) {
            CssBrowserCompatibilityForPropertiesInspection.$$$reportNull$$$0(8);
        }
        if (propertyName == null) {
            CssBrowserCompatibilityForPropertiesInspection.$$$reportNull$$$0(9);
        }
        if (CssPropertyUtil.isVendorSpecificElement(propertyName)) {
            return;
        }
        BrowserVersion[] browsers = CssCompatibilityData.getBrowserDataForProperty(propertyName);
        if (browsers.length == 0) {
            holder.registerProblem(propertyNameElement, CssBundle.message("no.mdn.data.for.property", propertyName), new LocalQuickFix[0]);
            return;
        }
        ArrayList incompatible = new ArrayList();
        ContainerUtil.addIfNotNull(incompatible, (Object)CssBrowserCompatibilityForPropertiesInspection.getBrowserTextIfIncompatible(this.myCheckChrome, this.myChromeVersion, BrowserVersion.Browser.CHROME, browsers));
        ContainerUtil.addIfNotNull(incompatible, (Object)CssBrowserCompatibilityForPropertiesInspection.getBrowserTextIfIncompatible(this.myCheckEdge, this.myEdgeVersion, BrowserVersion.Browser.EDGE, browsers));
        ContainerUtil.addIfNotNull(incompatible, (Object)CssBrowserCompatibilityForPropertiesInspection.getBrowserTextIfIncompatible(this.myCheckFirefox, this.myFirefoxVersion, BrowserVersion.Browser.FIREFOX, browsers));
        ContainerUtil.addIfNotNull(incompatible, (Object)CssBrowserCompatibilityForPropertiesInspection.getBrowserTextIfIncompatible(this.myCheckIE, this.myIEVersion, BrowserVersion.Browser.IE, browsers));
        ContainerUtil.addIfNotNull(incompatible, (Object)CssBrowserCompatibilityForPropertiesInspection.getBrowserTextIfIncompatible(this.myCheckOpera, this.myOperaVersion, BrowserVersion.Browser.OPERA, browsers));
        ContainerUtil.addIfNotNull(incompatible, (Object)CssBrowserCompatibilityForPropertiesInspection.getBrowserTextIfIncompatible(this.myCheckSafari, this.mySafariVersion, BrowserVersion.Browser.SAFARI, browsers));
        if (!incompatible.isEmpty()) {
            holder.registerProblem(propertyNameElement, CssBundle.message("property.not.supported.by.some.browsers", propertyName, StringUtil.join(incompatible, (String)", ")), new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static String getBrowserTextIfIncompatible(boolean check, int versionToCheck, BrowserVersion.Browser browser, BrowserVersion[] browserVersions) {
        if (!check) {
            return null;
        }
        BrowserVersion browserVersion = (BrowserVersion)ContainerUtil.find((Object[])browserVersions, b -> b.getBrowser() == browser);
        if (browserVersion == null) {
            return browser.getPresentableName() + " " + versionToCheck;
        }
        String supportedSinceVersion = browserVersion.getVersion();
        if (supportedSinceVersion.isEmpty() || supportedSinceVersion.equals("true")) {
            return null;
        }
        if (StringUtil.compareVersionNumbers((String)String.valueOf(versionToCheck), (String)supportedSinceVersion) < 0) {
            return browser.getPresentableName() + " " + versionToCheck;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/CssBrowserCompatibilityForPropertiesInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledField";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionField";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserName";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyNameElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/CssBrowserCompatibilityForPropertiesInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "browser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "browser";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

