/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbt;

import com.intellij.database.dialects.base.SqlObjectBuilderImplKt;
import com.intellij.dbt.DbtModuleEntity;
import com.intellij.dbt.DbtModuleEntityKt;
import com.intellij.dbt.console.DbtCliUtilKt;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.jinja.psi.Jinja2StringLiteral;
import com.intellij.jinja.tags.Jinja2FunctionCall;
import com.intellij.jinja.template.parsing.DjangoTemplateTokenTypes;
import com.intellij.jinja.template.psi.impl.DjangoTagElementImpl;
import com.intellij.jinja.template.psi.impl.Jinja2VariableReferenceImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleBridgeUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/dbt/DbtUtils;", "", "<init>", "()V", "Companion", "intellij.dbt"})
public final class DbtUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int DBT_DIRECTORY_MAX_DEEP_LEVEL = 5;
    @NotNull
    public static final String DBT_PROJECT_FILE_NAME = "dbt_project.yml";
    @NotNull
    public static final String DBT_SCHEMA_YML_FILE_NAME = "schema.yml";
    @NotNull
    private static final String[] DIRECTORIES_TO_IGNORE;
    @NotNull
    private static final String DBT_DIRECTORIES_TESTS = "tests";
    @NotNull
    private static final String DBT_DIRECTORIES_MODELS = "models";
    @NotNull
    private static final String SEEDS_FILE_EXTENSION;
    @NotNull
    private static final String SKIP_SETUP_KEY = "--skip-profile-setup";
    @NotNull
    private static final String PROFILE_KEY = "--profile";
    @NotNull
    private static final String PROFILES_DIR_KEY = "--profiles-dir";

    static {
        String[] stringArray = new String[]{"dbt_packages", ".idea"};
        DIRECTORIES_TO_IGNORE = stringArray;
        SEEDS_FILE_EXTENSION = "csv";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0014J5\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\u0007J\u000e\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070#2\u0006\u0010$\u001a\u00020\u0007J\u0010\u0010%\u001a\u00020\u00072\b\b\u0002\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010+\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010,\u001a\u0004\u0018\u00010\u00142\u0006\u0010-\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00140#2\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00140#2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u000202J\u0010\u00103\u001a\u0004\u0018\u0001022\u0006\u00104\u001a\u000205J\u0010\u00106\u001a\u0004\u0018\u00010\u00072\u0006\u00107\u001a\u000202J\u0010\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u00020\u00102\u0006\u0010-\u001a\u00020;J\u0016\u0010=\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/dbt/DbtUtils$Companion;", "", "<init>", "()V", "DBT_DIRECTORY_MAX_DEEP_LEVEL", "", "DBT_PROJECT_FILE_NAME", "", "DBT_SCHEMA_YML_FILE_NAME", "DIRECTORIES_TO_IGNORE", "", "[Ljava/lang/String;", "DBT_DIRECTORIES_TESTS", "DBT_DIRECTORIES_MODELS", "SEEDS_FILE_EXTENSION", "isDbtModule", "", "module", "Lcom/intellij/openapi/module/Module;", "getDbtDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "containsDbtProjectFile", "directory", "generateDbtInitCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "Lorg/jetbrains/annotations/NotNull;", "pathToDbt", "projectPath", "name", "initProfileName", "initProfileDir", "guessDbtExecutable", "getDbtSettings", "Lcom/intellij/dbt/DbtModuleEntity;", "getProfileNamesFromDir", "", "profilesDir", "getDbtProfilesDir", "dbtDir", "Ljava/io/File;", "findDbtDirectory", "isUnderModelsDirectory", "virtualFile", "isUnderTestDirectory", "getFirstLevelDbtSubdirectory", "file", "getAllModels", "getAllSeeds", "isRefCall", "call", "Lcom/intellij/jinja/tags/Jinja2FunctionCall;", "getJinjaCall", "element", "Lcom/intellij/psi/PsiElement;", "getReferencedName", "refCall", "findLastSelectQuery", "Lcom/intellij/sql/psi/SqlQueryExpression;", "psiFile", "Lcom/intellij/psi/PsiFile;", "isSqlDialect", "isUnderIgnoredDirectories", "SKIP_SETUP_KEY", "PROFILE_KEY", "PROFILES_DIR_KEY", "intellij.dbt"})
    @SourceDebugExtension(value={"SMAP\nDbtUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbtUtils.kt\ncom/intellij/dbt/DbtUtils$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,261:1\n1611#2,9:262\n1863#2:271\n1864#2:273\n1620#2:274\n774#2:275\n865#2,2:276\n2318#2,5:278\n2324#2,8:286\n774#2:294\n865#2,2:295\n774#2:297\n865#2,2:298\n1#3:272\n1104#4,3:283\n1310#5,2:300\n*S KotlinDebug\n*F\n+ 1 DbtUtils.kt\ncom/intellij/dbt/DbtUtils$Companion\n*L\n128#1:262,9\n128#1:271\n128#1:273\n128#1:274\n141#1:275\n141#1:276,2\n146#1:278,5\n146#1:286,8\n180#1:294\n180#1:295,2\n190#1:297\n190#1:298,2\n128#1:272\n146#1:283,3\n244#1:300,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isDbtModule(@Nullable Module module) {
            if (module == null) {
                return false;
            }
            return this.getDbtDirectory(module) != null;
        }

        @Nullable
        public final VirtualFile getDbtDirectory(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            ModuleBridge moduleBridge = module instanceof ModuleBridge ? (ModuleBridge)module : null;
            if (moduleBridge == null) {
                return null;
            }
            ModuleBridge moduleBridge2 = moduleBridge;
            ModuleEntity moduleEntity = ModuleBridgeUtils.findModuleEntity((ModuleBridge)moduleBridge2, (EntityStorage)moduleBridge2.getEntityStorage().getCurrent());
            if (moduleEntity == null) {
                return null;
            }
            ModuleEntity moduleEntity2 = moduleEntity;
            DbtModuleEntity dbtModuleEntity = DbtModuleEntityKt.getDbtSettings(moduleEntity2);
            return dbtModuleEntity != null && (dbtModuleEntity = dbtModuleEntity.getDbtProjectPath()) != null ? VirtualFileUrls.getVirtualFile((VirtualFileUrl)dbtModuleEntity) : null;
        }

        public final boolean containsDbtProjectFile(@NotNull VirtualFile directory) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            return VirtualFileUtil.findFile((VirtualFile)directory, (String)DbtUtils.DBT_PROJECT_FILE_NAME) != null;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final GeneralCommandLine generateDbtInitCommandLine(@NotNull String pathToDbt, @NotNull String projectPath, @NotNull String name, @Nullable String initProfileName, @NotNull String initProfileDir) {
            void $this$generateDbtInitCommandLine_u24lambda_u240;
            List list;
            Intrinsics.checkNotNullParameter((Object)pathToDbt, (String)"pathToDbt");
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)initProfileDir, (String)"initProfileDir");
            List list2 = list = CollectionsKt.createListBuilder();
            GeneralCommandLine generalCommandLine = new PtyCommandLine().withWorkDirectory(projectPath);
            boolean bl = false;
            $this$generateDbtInitCommandLine_u24lambda_u240.add("init");
            $this$generateDbtInitCommandLine_u24lambda_u240.add(name);
            $this$generateDbtInitCommandLine_u24lambda_u240.add(DbtUtils.SKIP_SETUP_KEY);
            String string = initProfileName;
            boolean bl2 = string != null ? ((CharSequence)string).length() > 0 : false;
            if (bl2) {
                $this$generateDbtInitCommandLine_u24lambda_u240.add(DbtUtils.PROFILE_KEY);
                $this$generateDbtInitCommandLine_u24lambda_u240.add(initProfileName);
            }
            if (((CharSequence)initProfileDir).length() > 0) {
                $this$generateDbtInitCommandLine_u24lambda_u240.add(DbtUtils.PROFILES_DIR_KEY);
                $this$generateDbtInitCommandLine_u24lambda_u240.add(initProfileDir);
            }
            GeneralCommandLine generalCommandLine2 = generalCommandLine.withParameters(CollectionsKt.build((List)list)).withExePath(pathToDbt);
            Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"withExePath(...)");
            return generalCommandLine2;
        }

        @NotNull
        public final String guessDbtExecutable(@NotNull Module module) {
            File dbtFile;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            VirtualFile moduleDir = ProjectUtil.guessModuleDir((Module)module);
            String dbtExecutableName = DbtCliUtilKt.getDbtExecutableName();
            if (moduleDir == null) {
                return dbtExecutableName;
            }
            String venvDbtRelativePath = SystemInfo.isWindows ? "venv/Scripts/" + dbtExecutableName : "venv/bin/" + dbtExecutableName;
            VirtualFile dbtExecutable = VirtualFileUtil.findFile((VirtualFile)moduleDir, (String)venvDbtRelativePath);
            if (dbtExecutable != null && dbtExecutable.exists()) {
                dbtFile = new File(dbtExecutable.getPath());
                if (dbtExecutable.getFileSystem() instanceof TempFileSystem) {
                    String string = dbtFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    return string;
                }
                if (dbtFile.canExecute()) {
                    String string = dbtFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    return string;
                }
            }
            if ((dbtFile = PathEnvironmentVariableUtil.findInPath((String)dbtExecutableName)) != null && dbtFile.canExecute()) {
                String string = dbtFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                return string;
            }
            return dbtExecutableName;
        }

        @Nullable
        public final DbtModuleEntity getDbtSettings(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            ModuleBridge moduleBridge = module instanceof ModuleBridge ? (ModuleBridge)module : null;
            if (moduleBridge == null) {
                return null;
            }
            ModuleBridge moduleBridge2 = moduleBridge;
            ModuleEntity moduleEntity = ModuleBridgeUtils.findModuleEntity((ModuleBridge)moduleBridge2, (EntityStorage)moduleBridge2.getEntityStorage().getCurrent());
            if (moduleEntity == null) {
                return null;
            }
            ModuleEntity moduleEntity2 = moduleEntity;
            return DbtModuleEntityKt.getDbtSettings(moduleEntity2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getProfileNamesFromDir(@NotNull String profilesDir) {
            Collection destination$iv$iv;
            Intrinsics.checkNotNullParameter((Object)profilesDir, (String)"profilesDir");
            if (((CharSequence)profilesDir).length() == 0) {
                return CollectionsKt.emptyList();
            }
            File profilesFile = new File(profilesDir, "profiles.yml");
            if (!profilesFile.isFile()) {
                return CollectionsKt.emptyList();
            }
            VirtualFile virtualFile = StandardFileSystems.local().findFileByPath(profilesFile.getPath());
            if (virtualFile == null) {
                return CollectionsKt.emptyList();
            }
            VirtualFile profilesVirtualFile = virtualFile;
            PsiFile profilePsiFile = PsiManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).findFile(profilesVirtualFile);
            YAMLFile yAMLFile = profilePsiFile instanceof YAMLFile ? (YAMLFile)profilePsiFile : null;
            if (yAMLFile == null) {
                return CollectionsKt.emptyList();
            }
            YAMLFile yamlFile = yAMLFile;
            List list = yamlFile.getDocuments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDocuments(...)");
            YAMLDocument yAMLDocument = (YAMLDocument)CollectionsKt.firstOrNull((List)list);
            PsiElement psiElement = yAMLDocument != null ? yAMLDocument.getFirstChild() : null;
            Object object = psiElement instanceof YAMLMapping ? (YAMLMapping)psiElement : null;
            if (object != null && (object = object.getKeyValues()) != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = (Iterable)object;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    YAMLKeyValue it = (YAMLKeyValue)element$iv$iv;
                    boolean bl2 = false;
                    PsiElement psiElement2 = it.getKey();
                    if ((psiElement2 != null ? psiElement2.getText() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
            } else {
                return CollectionsKt.emptyList();
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final String getDbtProfilesDir(@NotNull File dbtDir) {
            String string;
            Intrinsics.checkNotNullParameter((Object)dbtDir, (String)"dbtDir");
            if (dbtDir.isDirectory() & new File(dbtDir, "profiles.yml").isFile()) {
                String string2 = dbtDir.getPath();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            } else {
                string = "";
            }
            return string;
        }

        public static /* synthetic */ String getDbtProfilesDir$default(Companion companion, File file, int n, Object object) {
            if ((n & 1) != 0) {
                file = new File(FileUtil.expandUserHome((String)"~/.dbt"));
            }
            return companion.getDbtProfilesDir(file);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final VirtualFile findDbtDirectory(@NotNull Module module) {
            Object t;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            VirtualFile virtualFile = ProjectUtil.guessModuleDir((Module)module);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile moduleDir = virtualFile;
            Set setOfModuleDir = SetsKt.setOf((Object)moduleDir);
            Collection collection = FilenameIndex.getVirtualFilesByName((String)DbtUtils.DBT_PROJECT_FILE_NAME, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)module.getProject()));
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(VirtualFileUtil.isFile((VirtualFile)it) && VfsUtil.isUnder((VirtualFile)it, (Set)setOfModuleDir))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List candidates = (List)destination$iv$iv;
            if (candidates.isEmpty()) {
                return null;
            }
            Iterable $this$minBy$iv = candidates;
            boolean $i$f$minByOrThrow = false;
            Iterator iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = minElem$iv;
            } else {
                VirtualFile it = (VirtualFile)minElem$iv;
                boolean bl = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                CharSequence $this$count$iv = string;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char it2 = element$iv = $this$count$iv.charAt(i);
                    boolean bl2 = false;
                    if (!(it2 == File.separatorChar)) continue;
                    ++count$iv;
                }
                int minValue$iv = count$iv;
                do {
                    Object e$iv = iterator$iv.next();
                    VirtualFile it3 = (VirtualFile)e$iv;
                    $i$a$-minByOrThrow-DbtUtils$Companion$findDbtDirectory$1 = false;
                    String string2 = it3.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    CharSequence $this$count$iv2 = string2;
                    boolean $i$f$count2 = false;
                    int count$iv2 = 0;
                    for (int i = 0; i < $this$count$iv2.length(); ++i) {
                        char element$iv;
                        char it4 = element$iv = $this$count$iv2.charAt(i);
                        boolean bl3 = false;
                        if (!(it4 == File.separatorChar)) continue;
                        ++count$iv2;
                    }
                    int v$iv = count$iv2;
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = minElem$iv;
            }
            return ((VirtualFile)t).getParent();
        }

        public final boolean isUnderModelsDirectory(@NotNull VirtualFile virtualFile, @NotNull Module module) {
            VirtualFile firstLevelDbtSubfolder;
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            VirtualFile virtualFile2 = firstLevelDbtSubfolder = this.getFirstLevelDbtSubdirectory(virtualFile, module);
            return Intrinsics.areEqual((Object)(virtualFile2 != null ? virtualFile2.getName() : null), (Object)DbtUtils.DBT_DIRECTORIES_MODELS);
        }

        public final boolean isUnderTestDirectory(@NotNull VirtualFile virtualFile, @NotNull Module module) {
            VirtualFile firstLevelDbtSubfolder;
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            VirtualFile virtualFile2 = firstLevelDbtSubfolder = this.getFirstLevelDbtSubdirectory(virtualFile, module);
            return Intrinsics.areEqual((Object)(virtualFile2 != null ? virtualFile2.getName() : null), (Object)DbtUtils.DBT_DIRECTORIES_TESTS);
        }

        private final VirtualFile getFirstLevelDbtSubdirectory(VirtualFile file, Module module) {
            VirtualFile targetFile;
            DbtModuleEntity dbtModuleEntity = this.getDbtSettings(module);
            if (dbtModuleEntity == null) {
                return null;
            }
            DbtModuleEntity dbtSettings = dbtModuleEntity;
            VirtualFileUrl virtualFileUrl = dbtSettings.getDbtProjectPath();
            if (virtualFileUrl == null || (virtualFileUrl = VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl)) == null) {
                return null;
            }
            VirtualFileUrl dbtRoot = virtualFileUrl;
            if (!VfsUtil.isUnder((VirtualFile)file, (Set)SetsKt.setOf((Object)dbtRoot))) {
                return null;
            }
            for (targetFile = file; targetFile != null && !Intrinsics.areEqual((Object)targetFile.getParent(), (Object)dbtRoot); targetFile = targetFile.getParent()) {
            }
            return targetFile;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<VirtualFile> getAllModels(@NotNull Module module) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            VirtualFile virtualFile = this.getDbtDirectory(module);
            if (virtualFile == null) {
                return CollectionsKt.emptyList();
            }
            VirtualFile dbtDirectory = virtualFile;
            VirtualFile virtualFile2 = dbtDirectory.findChild(DbtUtils.DBT_DIRECTORIES_MODELS);
            if (virtualFile2 == null) {
                return CollectionsKt.emptyList();
            }
            VirtualFile dbtModelsDirectory = virtualFile2;
            if (VirtualFileUtil.isFile((VirtualFile)dbtModelsDirectory)) {
                return CollectionsKt.emptyList();
            }
            List list = VfsUtil.collectChildrenRecursively((VirtualFile)dbtModelsDirectory);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"collectChildrenRecursively(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(VirtualFileUtil.isFile((VirtualFile)it) && Intrinsics.areEqual((Object)it.getExtension(), (Object)"sql"))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<VirtualFile> getAllSeeds(@NotNull Module module) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            VirtualFile virtualFile = this.getDbtDirectory(module);
            if (virtualFile == null) {
                return CollectionsKt.emptyList();
            }
            VirtualFile dbtDirectory = virtualFile;
            VirtualFile virtualFile2 = dbtDirectory.findChild("seeds");
            if (virtualFile2 == null) {
                return CollectionsKt.emptyList();
            }
            VirtualFile dbtModelsDirectory = virtualFile2;
            if (VirtualFileUtil.isFile((VirtualFile)dbtModelsDirectory)) {
                return CollectionsKt.emptyList();
            }
            List list = VfsUtil.collectChildrenRecursively((VirtualFile)dbtModelsDirectory);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"collectChildrenRecursively(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(VirtualFileUtil.isFile((VirtualFile)it) && Intrinsics.areEqual((Object)it.getExtension(), (Object)SEEDS_FILE_EXTENSION))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public final boolean isRefCall(@NotNull Jinja2FunctionCall call) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            PsiElement psiElement = call.getCallee();
            Jinja2VariableReferenceImpl jinja2VariableReferenceImpl = psiElement instanceof Jinja2VariableReferenceImpl ? (Jinja2VariableReferenceImpl)psiElement : null;
            return Intrinsics.areEqual((Object)(jinja2VariableReferenceImpl != null ? jinja2VariableReferenceImpl.getName() : null), (Object)"ref");
        }

        @Nullable
        public final Jinja2FunctionCall getJinjaCall(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            FileViewProvider fileViewProvider = element.getContainingFile().getViewProvider();
            Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"getViewProvider(...)");
            FileViewProvider viewProvider = fileViewProvider;
            PsiElement jinjaElement = viewProvider.getPsi(viewProvider.getBaseLanguage()).findElementAt(SqlObjectBuilderImplKt.getStartOffset((PsiElement)element));
            if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)jinjaElement), (Object)DjangoTemplateTokenTypes.DJANGO_EXPRESSION_START)) {
                return null;
            }
            DjangoTagElementImpl djangoTagElementImpl = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)jinjaElement, DjangoTagElementImpl.class);
            if (djangoTagElementImpl == null) {
                return null;
            }
            DjangoTagElementImpl tag = djangoTagElementImpl;
            return (Jinja2FunctionCall)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tag), Jinja2FunctionCall.class);
        }

        @Nullable
        public final String getReferencedName(@NotNull Jinja2FunctionCall refCall) {
            Intrinsics.checkNotNullParameter((Object)refCall, (String)"refCall");
            Jinja2StringLiteral jinja2StringLiteral = (Jinja2StringLiteral)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)refCall), Jinja2StringLiteral.class);
            return jinja2StringLiteral != null ? jinja2StringLiteral.getValue() : null;
        }

        @Nullable
        public final SqlQueryExpression findLastSelectQuery(@NotNull PsiFile psiFile) {
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Ref.ObjectRef result = new Ref.ObjectRef();
            PsiElementVisitor visitor2 = new PsiElementVisitor((Ref.ObjectRef<SqlQueryExpression>)result){
                final /* synthetic */ Ref.ObjectRef<SqlQueryExpression> $result;
                {
                    this.$result = $result;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    super.visitElement(element);
                    if (element instanceof SqlQueryExpression) {
                        this.$result.element = element;
                    }
                    for (PsiElement psiElement : element.getChildren()) {
                        Intrinsics.checkNotNull((Object)psiElement);
                        PsiElement child = psiElement;
                        this.visitElement(child);
                    }
                }
            };
            psiFile.accept(visitor2);
            return (SqlQueryExpression)result.element;
        }

        public final boolean isSqlDialect(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Language language = null;
            FileViewProvider fileViewProvider = file.getViewProvider();
            Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"getViewProvider(...)");
            FileViewProvider viewProvider = fileViewProvider;
            language = viewProvider instanceof TemplateLanguageFileViewProvider ? ((TemplateLanguageFileViewProvider)viewProvider).getTemplateDataLanguage() : file.getLanguage();
            return language instanceof SqlLanguageDialect || language instanceof SqlLanguage;
        }

        public final boolean isUnderIgnoredDirectories(@NotNull VirtualFile virtualFile, @NotNull Module module) {
            Object object;
            block3: {
                Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                VirtualFile[] virtualFileArray = ProjectUtil.getRootManager((Module)module).getContentRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
                Object[] $this$firstOrNull$iv = virtualFileArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl = false;
                    if (!VfsUtil.isUnder((VirtualFile)virtualFile, (Set)SetsKt.setOf((Object)it))) continue;
                    object = element$iv;
                    break block3;
                }
                object = null;
            }
            VirtualFile virtualFile2 = (VirtualFile)object;
            if (virtualFile2 == null) {
                return true;
            }
            VirtualFile root = virtualFile2;
            for (VirtualFile currentFile = virtualFile; currentFile != null && !Intrinsics.areEqual((Object)currentFile, (Object)root); currentFile = currentFile.getParent()) {
                if (!ArraysKt.contains((Object[])DIRECTORIES_TO_IGNORE, (Object)currentFile.getName())) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

