/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.sass.extensions.SassExtension;
import org.jetbrains.plugins.scss.SCSSLanguage;

public class SassExtensionFileReferenceHelper
extends FileReferenceHelper {
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(@NotNull Project project, @NotNull VirtualFile file) {
        Module module;
        if (project == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                SassExtensionFileReferenceHelper.$$$reportNull$$$0(2);
            }
            return list;
        }
        LinkedList<Object> result = new LinkedList<Object>();
        for (SassExtension sassExtension : SassExtensionFileReferenceHelper.getAppropriateSassExtensions(project, file)) {
            result.addAll(sassExtension.getStylesheetsRoots(module));
        }
        VirtualFile parent = file.getParent();
        if (parent != null) {
            result.add(parent);
        }
        List list = ContainerUtil.skipNulls((Collection)ContainerUtil.map(result, file1 -> this.getPsiFileSystemItem(project, (VirtualFile)file1)));
        if (list == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean isMine(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(4);
        }
        if (file == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(5);
        }
        if (!this.isMyFile(project, file)) {
            return false;
        }
        return SassExtensionFileReferenceHelper.getAppropriateSassExtensions(project, file).size() > 0;
    }

    @NotNull
    private static Collection<SassExtension> getAppropriateSassExtensions(@NotNull Project project, @NotNull VirtualFile file) {
        Module module;
        if (project == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(6);
        }
        if (file == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(7);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) == null) {
            List<SassExtension> list = Collections.emptyList();
            if (list == null) {
                SassExtensionFileReferenceHelper.$$$reportNull$$$0(8);
            }
            return list;
        }
        Collection<SassExtension> collection = SassExtension.getAllExtensions(module);
        if (collection == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(9);
        }
        return collection;
    }

    protected boolean isMyFile(@NotNull Project project, @NotNull VirtualFile file) {
        String extension;
        if (project == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(10);
        }
        if (file == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(11);
        }
        if ("sass".equalsIgnoreCase(extension = file.getExtension()) || "scss".equalsIgnoreCase(extension)) {
            return true;
        }
        PsiFileSystemItem item = this.getPsiFileSystemItem(project, file);
        if (item instanceof PsiFile) {
            Set allLanguages = ((PsiFile)item).getViewProvider().getLanguages();
            return allLanguages.contains((Object)SASSLanguage.INSTANCE) || allLanguages.contains((Object)SCSSLanguage.INSTANCE);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/extensions/SassExtensionFileReferenceHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/extensions/SassExtensionFileReferenceHelper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppropriateSassExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAppropriateSassExtensions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isMyFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 8, 9 -> new IllegalStateException(string);
        };
    }
}

