/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.dataframe;

import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.dataframe.aggregation.Aggregator;
import com.intellij.charts.dataframe.columns.Column;
import com.intellij.charts.dataframe.columns.ColumnId;
import com.intellij.charts.dataframe.columns.CompositeColumn;
import com.intellij.charts.dataframe.columns.CompositeType;
import com.intellij.charts.dataframe.columns.DoubleArrayColumn;
import com.intellij.charts.dataframe.columns.DoubleArrayType;
import com.intellij.charts.dataframe.columns.IntArrayColumn;
import com.intellij.charts.dataframe.columns.IntArrayType;
import com.intellij.charts.dataframe.columns.IntegerType;
import com.intellij.charts.dataframe.columns.LongArrayColumn;
import com.intellij.charts.dataframe.columns.LongArrayType;
import com.intellij.charts.dataframe.columns.LongType;
import com.intellij.charts.dataframe.columns.RealType;
import com.intellij.charts.dataframe.columns.StringArrayColumn;
import com.intellij.charts.dataframe.columns.StringArrayType;
import com.intellij.charts.dataframe.columns.StringType;
import com.intellij.charts.dataframe.columns.Type;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003H\u0016J\u0016\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\u0015\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J\u0015\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J\u0015\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0014\u001a\u00020\rH\u0096\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u001c\u0010\u0017\u001a\u00020\u00182\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J!\u0010\u001b\u001a\u00020\u00012\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d\"\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010 \u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010 \u001a\u00020\u00012\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\"H\u0016JC\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H$0\u0004\"\u0006\b\u0000\u0010$\u0018\u0001*\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u0002H$0%j\b\u0012\u0004\u0012\u0002H$`&0\u00042\u000e\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H$0(H\u0082\bJ3\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H$0\u0004\"\u0006\b\u0000\u0010$\u0018\u00012\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u00042\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00130\"H\u0082\bJb\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H$0\u0004\"\u0006\b\u0000\u0010$\u0018\u00012\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010,\u001a\u00020\u00132&\u0010-\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010/\u0012\u0004\u0012\u00020\u00130.j\u0010\u0012\u0006\u0012\u0004\u0018\u00010/\u0012\u0004\u0012\u00020\u0013`02\u0006\u00101\u001a\u0002H$H\u0082\b\u00a2\u0006\u0002\u00102Jw\u00103\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u0001H$\u0018\u00010\u00030\u0004\"\u0006\b\u0000\u0010$\u0018\u00012\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010,\u001a\u00020\u00132\u0006\u00104\u001a\u00020528\u00106\u001a4\u0012\u0004\u0012\u00020\u0011\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u0001H$\u0018\u00010\u00030\u0003\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u0001H$\u0018\u00010\u00030\u000407H\u0082\bR\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u00068"}, d2={"Lcom/intellij/charts/dataframe/DataFrameImpl;", "Lcom/intellij/charts/dataframe/DataFrame;", "columns", "", "Lcom/intellij/charts/dataframe/columns/Column;", "<init>", "(Ljava/util/List;)V", "dim", "Ljava/awt/Dimension;", "getDim", "()Ljava/awt/Dimension;", "getColumns", "getColumnId", "Lcom/intellij/charts/dataframe/columns/ColumnId;", "column", "get", "columnName", "", "columnIndex", "", "columnId", "has", "", "sortBy", "", "sortDescending", "sortingColumn", "aggregate", "aggregators", "", "Lcom/intellij/charts/dataframe/aggregation/Aggregator;", "([Lcom/intellij/charts/dataframe/aggregation/Aggregator;)Lcom/intellij/charts/dataframe/DataFrame;", "groupBy", "columnNames", "", "takeFirst", "T", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "type", "Lcom/intellij/charts/dataframe/columns/Type;", "sort", "sortedIndices", "group", "newColumnsSize", "alreadyProcessed", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "initValue", "(Lcom/intellij/charts/dataframe/columns/Column;ILjava/util/HashMap;Ljava/lang/Object;)Lcom/intellij/charts/dataframe/columns/Column;", "group1", "indexes", "", "create", "Lkotlin/Function2;", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nDataFrameImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFrameImpl.kt\ncom/intellij/charts/dataframe/DataFrameImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,223:1\n188#1,3:225\n191#1:230\n188#1,3:231\n191#1:236\n188#1,3:237\n191#1:242\n188#1,3:243\n191#1:248\n188#1,3:249\n191#1:254\n188#1,3:255\n191#1:260\n188#1,3:261\n191#1:266\n188#1,3:267\n191#1:272\n196#1,4:277\n200#1,2:282\n203#1,4:285\n196#1,4:289\n200#1,2:294\n203#1,4:297\n196#1,4:301\n200#1,2:306\n203#1,4:309\n196#1,4:313\n200#1,2:318\n203#1,4:321\n196#1,4:325\n200#1,2:330\n203#1,4:333\n211#1,9:337\n211#1,9:346\n211#1,9:355\n211#1,9:364\n185#1:382\n185#1:387\n185#1:392\n185#1:397\n1#2:224\n1863#3,2:228\n1863#3,2:234\n1863#3,2:240\n1863#3,2:246\n1863#3,2:252\n1863#3,2:258\n1863#3,2:264\n1863#3,2:270\n1863#3,2:273\n1557#3:373\n1628#3,3:374\n1557#3:377\n1628#3,3:378\n1863#3:381\n1557#3:383\n1628#3,3:384\n1557#3:388\n1628#3,3:389\n1557#3:393\n1628#3,3:394\n1557#3:398\n1628#3,3:399\n1864#3:402\n1557#3:403\n1628#3,3:404\n1863#3,2:407\n13409#4,2:275\n216#5:281\n217#5:284\n216#5:293\n217#5:296\n216#5:305\n217#5:308\n216#5:317\n217#5:320\n216#5:329\n217#5:332\n216#5,2:409\n*S KotlinDebug\n*F\n+ 1 DataFrameImpl.kt\ncom/intellij/charts/dataframe/DataFrameImpl\n*L\n42#1:225,3\n42#1:230\n43#1:231,3\n43#1:236\n44#1:237,3\n44#1:242\n45#1:243,3\n45#1:248\n46#1:249,3\n46#1:254\n47#1:255,3\n47#1:260\n48#1:261,3\n48#1:266\n49#1:267,3\n49#1:272\n109#1:277,4\n109#1:282,2\n109#1:285,4\n110#1:289,4\n110#1:294,2\n110#1:297,4\n111#1:301,4\n111#1:306,2\n111#1:309,4\n112#1:313,4\n112#1:318,2\n112#1:321,4\n113#1:325,4\n113#1:330,2\n113#1:333,4\n120#1:337,9\n121#1:346,9\n122#1:355,9\n123#1:364,9\n169#1:382\n170#1:387\n171#1:392\n172#1:397\n42#1:228,2\n43#1:234,2\n44#1:240,2\n45#1:246,2\n46#1:252,2\n47#1:258,2\n48#1:264,2\n49#1:270,2\n60#1:273,2\n135#1:373\n135#1:374,3\n142#1:377\n142#1:378,3\n163#1:381\n169#1:383\n169#1:384,3\n170#1:388\n170#1:389,3\n171#1:393\n171#1:394,3\n172#1:398\n172#1:399,3\n163#1:402\n185#1:403\n185#1:404,3\n190#1:407,2\n67#1:275,2\n109#1:281\n109#1:284\n110#1:293\n110#1:296\n111#1:305\n111#1:308\n112#1:317\n112#1:320\n113#1:329\n113#1:332\n199#1:409,2\n*E\n"})
public final class DataFrameImpl
extends DataFrame {
    @NotNull
    private final List<Column<?>> columns;

    public DataFrameImpl(@NotNull List<Column<?>> columns) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.columns = columns;
    }

    @Override
    @NotNull
    public Dimension getDim() {
        return new Dimension(this.columns.size(), this.columns.isEmpty() ? 0 : this.columns.get(0).getSize());
    }

    @Override
    @NotNull
    public List<Column<?>> getColumns() {
        return this.columns;
    }

    @Override
    @Nullable
    public ColumnId getColumnId(@NotNull Column<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        int index = this.columns.indexOf(column);
        return index == -1 ? null : new ColumnId(this.columns.get(index).getName(), index);
    }

    @Override
    @NotNull
    public Column<?> get(@NotNull String columnName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            Iterable iterable = this.columns;
            for (Object t : iterable) {
                Column column = (Column)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)column.getName(), (Object)columnName)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    @Override
    @NotNull
    public Column<?> get(int columnIndex) {
        return this.columns.get(columnIndex);
    }

    @Override
    @NotNull
    public Column<?> get(@NotNull ColumnId columnId) {
        Intrinsics.checkNotNullParameter((Object)columnId, (String)"columnId");
        return this.columns.get(columnId.getIndex());
    }

    @Override
    public boolean has(@NotNull String columnName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            Iterable iterable = this.columns;
            for (Object t : iterable) {
                Column column = (Column)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)column.getName(), (Object)columnName)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    @Override
    public boolean has(@NotNull ColumnId columnId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)columnId, (String)"columnId");
            Iterable iterable = this.columns;
            for (Object t : iterable) {
                Column column = (Column)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)column.getName(), (Object)columnId.getName())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    @Override
    public void sortBy(@NotNull ColumnId columnId, boolean sortDescending) {
        Intrinsics.checkNotNullParameter((Object)columnId, (String)"columnId");
        this.sortBy(this.get(columnId), sortDescending);
    }

    @Override
    public void sortBy(@NotNull String columnName, boolean sortDescending) {
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        this.sortBy(this.get(columnName), sortDescending);
    }

    private final void sortBy(Column<?> sortingColumn, boolean sortDescending) {
        int n = 0;
        int n2 = this.columns.get(0).getSize();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3;
            nArray[n3] = n3 = n++;
        }
        int[] indices = nArray;
        List sortedIndices = ArraysKt.sortedWith((int[])indices, sortingColumn.getComparator(sortDescending));
        int n4 = this.columns.size();
        for (int i = 0; i < n4; ++i) {
            Column<?> column;
            int n5;
            List<Column<?>> list2;
            Type<?> type = this.columns.get(i).getType();
            if (type instanceof IntegerType) {
                DataFrameImpl dataFrameImpl = this;
                Column<?> column2 = this.columns.get(i);
                var20_23 = i;
                var19_22 = this.columns;
                $i$f$sort = false;
                col$iv = column$iv.cast();
                data$iv = new ArrayList(column$iv.getSize());
                $this$forEach$iv$iv = (Iterable)CollectionsKt.getIndices((Collection)sortedIndices);
                $i$f$forEach = false;
                var15_18 = $this$forEach$iv$iv.iterator();
                while (var15_18.hasNext()) {
                    it$iv = element$iv$iv = ((IntIterator)var15_18).nextInt();
                    $i$a$-forEach-DataFrameImpl$sort$1$iv = false;
                    data$iv.add(col$iv.get(((Number)sortedIndices.get(it$iv)).intValue()));
                }
                var21_24 = col$iv.getType().createColumn(column$iv.getName(), data$iv);
                list2 = var19_22;
                n5 = var20_23;
                column = var21_24;
            } else if (type instanceof LongType) {
                this_$iv = this;
                column$iv = this.columns.get(i);
                $i$f$sort = false;
                col$iv = column$iv.cast();
                data$iv = new ArrayList(column$iv.getSize());
                $this$forEach$iv$iv = (Iterable)CollectionsKt.getIndices((Collection)sortedIndices);
                $i$f$forEach = false;
                var15_18 = $this$forEach$iv$iv.iterator();
                while (var15_18.hasNext()) {
                    it$iv = element$iv$iv = ((IntIterator)var15_18).nextInt();
                    $i$a$-forEach-DataFrameImpl$sort$1$iv = false;
                    data$iv.add(col$iv.get(((Number)sortedIndices.get(it$iv)).intValue()));
                }
                var21_24 = col$iv.getType().createColumn(column$iv.getName(), data$iv);
                list2 = var19_22;
                n5 = var20_23;
                column = var21_24;
            } else if (type instanceof RealType) {
                this_$iv = this;
                column$iv = this.columns.get(i);
                $i$f$sort = false;
                col$iv = column$iv.cast();
                data$iv = new ArrayList(column$iv.getSize());
                $this$forEach$iv$iv = (Iterable)CollectionsKt.getIndices((Collection)sortedIndices);
                $i$f$forEach = false;
                var15_18 = $this$forEach$iv$iv.iterator();
                while (var15_18.hasNext()) {
                    it$iv = element$iv$iv = ((IntIterator)var15_18).nextInt();
                    $i$a$-forEach-DataFrameImpl$sort$1$iv = false;
                    data$iv.add(col$iv.get(((Number)sortedIndices.get(it$iv)).intValue()));
                }
                var21_24 = col$iv.getType().createColumn(column$iv.getName(), data$iv);
                list2 = var19_22;
                n5 = var20_23;
                column = var21_24;
            } else if (type instanceof StringType) {
                this_$iv = this;
                column$iv = this.columns.get(i);
                $i$f$sort = false;
                col$iv = column$iv.cast();
                data$iv = new ArrayList(column$iv.getSize());
                $this$forEach$iv$iv = (Iterable)CollectionsKt.getIndices((Collection)sortedIndices);
                $i$f$forEach = false;
                var15_18 = $this$forEach$iv$iv.iterator();
                while (var15_18.hasNext()) {
                    it$iv = element$iv$iv = ((IntIterator)var15_18).nextInt();
                    $i$a$-forEach-DataFrameImpl$sort$1$iv = false;
                    data$iv.add(col$iv.get(((Number)sortedIndices.get(it$iv)).intValue()));
                }
                var21_24 = col$iv.getType().createColumn(column$iv.getName(), data$iv);
                list2 = var19_22;
                n5 = var20_23;
                column = var21_24;
            } else if (type instanceof IntArrayType) {
                this_$iv = this;
                column$iv = this.columns.get(i);
                $i$f$sort = false;
                col$iv = column$iv.cast();
                data$iv = new ArrayList(column$iv.getSize());
                $this$forEach$iv$iv = (Iterable)CollectionsKt.getIndices((Collection)sortedIndices);
                $i$f$forEach = false;
                var15_18 = $this$forEach$iv$iv.iterator();
                while (var15_18.hasNext()) {
                    it$iv = element$iv$iv = ((IntIterator)var15_18).nextInt();
                    $i$a$-forEach-DataFrameImpl$sort$1$iv = false;
                    data$iv.add(col$iv.get(((Number)sortedIndices.get(it$iv)).intValue()));
                }
                var21_24 = col$iv.getType().createColumn(column$iv.getName(), data$iv);
                list2 = var19_22;
                n5 = var20_23;
                column = var21_24;
            } else if (type instanceof DoubleArrayType) {
                this_$iv = this;
                column$iv = this.columns.get(i);
                $i$f$sort = false;
                col$iv = column$iv.cast();
                data$iv = new ArrayList(column$iv.getSize());
                $this$forEach$iv$iv = (Iterable)CollectionsKt.getIndices((Collection)sortedIndices);
                $i$f$forEach = false;
                var15_18 = $this$forEach$iv$iv.iterator();
                while (var15_18.hasNext()) {
                    it$iv = element$iv$iv = ((IntIterator)var15_18).nextInt();
                    $i$a$-forEach-DataFrameImpl$sort$1$iv = false;
                    data$iv.add(col$iv.get(((Number)sortedIndices.get(it$iv)).intValue()));
                }
                var21_24 = col$iv.getType().createColumn(column$iv.getName(), data$iv);
                list2 = var19_22;
                n5 = var20_23;
                column = var21_24;
            } else if (type instanceof LongArrayType) {
                this_$iv = this;
                column$iv = this.columns.get(i);
                $i$f$sort = false;
                col$iv = column$iv.cast();
                data$iv = new ArrayList(column$iv.getSize());
                $this$forEach$iv$iv = (Iterable)CollectionsKt.getIndices((Collection)sortedIndices);
                $i$f$forEach = false;
                var15_18 = $this$forEach$iv$iv.iterator();
                while (var15_18.hasNext()) {
                    it$iv = element$iv$iv = ((IntIterator)var15_18).nextInt();
                    $i$a$-forEach-DataFrameImpl$sort$1$iv = false;
                    data$iv.add(col$iv.get(((Number)sortedIndices.get(it$iv)).intValue()));
                }
                var21_24 = col$iv.getType().createColumn(column$iv.getName(), data$iv);
                list2 = var19_22;
                n5 = var20_23;
                column = var21_24;
            } else if (type instanceof StringArrayType) {
                this_$iv = this;
                column$iv = this.columns.get(i);
                $i$f$sort = false;
                col$iv = column$iv.cast();
                data$iv = new ArrayList(column$iv.getSize());
                $this$forEach$iv$iv = (Iterable)CollectionsKt.getIndices((Collection)sortedIndices);
                $i$f$forEach = false;
                var15_18 = $this$forEach$iv$iv.iterator();
                while (var15_18.hasNext()) {
                    it$iv = element$iv$iv = ((IntIterator)var15_18).nextInt();
                    $i$a$-forEach-DataFrameImpl$sort$1$iv = false;
                    data$iv.add(col$iv.get(((Number)sortedIndices.get(it$iv)).intValue()));
                }
                var21_24 = col$iv.getType().createColumn(column$iv.getName(), data$iv);
                list2 = var19_22;
                n5 = var20_23;
                column = var21_24;
            } else {
                throw new Exception("Unsupported column type " + this.columns.get(i).getType() + " in sorting.");
            }
            list2.set(n5, column);
        }
    }

    @Override
    @NotNull
    public DataFrame aggregate(Aggregator ... aggregators) {
        Intrinsics.checkNotNullParameter((Object)aggregators, (String)"aggregators");
        ArrayList newColumns = new ArrayList();
        Aggregator[] $this$forEach$iv = (Aggregator[])this.columns;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            Aggregator aggregator;
            Column column;
            block3: {
                column = (Column)t;
                boolean bl = false;
                Aggregator[] aggregatorArray = aggregators;
                int n = aggregatorArray.length;
                for (int i = 0; i < n; ++i) {
                    Aggregator aggregator2;
                    Aggregator it = aggregator2 = aggregatorArray[i];
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getColumnId().getName(), (Object)column.getName())) continue;
                    aggregator = aggregator2;
                    break block3;
                }
                aggregator = null;
            }
            if (aggregator != null) continue;
            newColumns.add(column);
        }
        $this$forEach$iv = aggregators;
        $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Aggregator element$iv;
            Aggregator it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            newColumns.add(it.process(this));
        }
        return new DataFrameImpl(newColumns);
    }

    @Override
    @NotNull
    public DataFrame groupBy(@NotNull ColumnId columnId) {
        Intrinsics.checkNotNullParameter((Object)columnId, (String)"columnId");
        return this.groupBy(columnId.getName());
    }

    @Override
    @NotNull
    public DataFrame groupBy(@NotNull String columnName) {
        Object v0;
        block52: {
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            Iterable iterable = this.columns;
            for (Object t : iterable) {
                Column column = (Column)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)column.getName(), (Object)columnName)) continue;
                v0 = t;
                break block52;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        Column groupingColumn = v0;
        if (groupingColumn.getType().isArray()) {
            throw new Exception("Currently cannot group on array-type columns");
        }
        HashMap alreadyProcessed = new HashMap();
        int[] indexes = new int[groupingColumn.getSize()];
        Iterator iterator2 = ((Iterable)groupingColumn).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            Object value = iterator2.next();
            Integer pos = (Integer)alreadyProcessed.get(value);
            if (pos == null) {
                pos = alreadyProcessed.size();
                ((Map)alreadyProcessed).put(value, pos);
            }
            indexes[i] = pos;
        }
        int newColumnsSize = alreadyProcessed.size();
        ArrayList newColumns = new ArrayList();
        for (Column<?> column : this.columns) {
            Column<?> column2;
            boolean bl;
            Column<?> newColumn;
            DataFrameImpl this_$iv;
            Object[] newData$iv;
            Type<?> type;
            if (Intrinsics.areEqual((Object)column.getName(), (Object)columnName)) {
                Column<?> column3;
                type = column.getType();
                if (type instanceof IntegerType) {
                    DataFrameImpl dataFrameImpl = this;
                    initValue$iv = 0;
                    $i$f$group = false;
                    col$iv = column.cast();
                    int n2 = 0;
                    Integer[] integerArray = new Integer[newColumnsSize];
                    while (n2 < newColumnsSize) {
                        int n3 = n2++;
                        integerArray[n3] = initValue$iv;
                    }
                    newData$iv = integerArray;
                    try {
                        $this$forEach$iv$iv = alreadyProcessed;
                        boolean $i$f$forEach = false;
                        Iterator iterator3 = $this$forEach$iv$iv.entrySet().iterator();
                        while (iterator3.hasNext()) {
                            Map.Entry entry = element$iv$iv = iterator3.next();
                            $i$a$-forEach-DataFrameImpl$group$1$iv = false;
                            key$iv = entry.getKey();
                            value$iv = ((Number)entry.getValue()).intValue();
                            newData$iv[value$iv] = key$iv;
                        }
                    }
                    catch (Exception e$iv) {
                        e$iv.printStackTrace();
                    }
                    column3 = col$iv.getType().createColumn(column.getName(), (List)ArraysKt.toCollection((Object[])newData$iv, (Collection)new ArrayList()));
                } else if (type instanceof LongType) {
                    this_$iv = this;
                    initValue$iv = 0L;
                    $i$f$group = false;
                    col$iv = column.cast();
                    int e$iv = 0;
                    Long[] $i$f$forEach = new Long[newColumnsSize];
                    while (e$iv < newColumnsSize) {
                        int n4 = e$iv++;
                        $i$f$forEach[n4] = initValue$iv;
                    }
                    newData$iv = $i$f$forEach;
                    try {
                        $this$forEach$iv$iv = alreadyProcessed;
                        boolean $i$f$forEach2 = false;
                        Iterator iterator4 = $this$forEach$iv$iv.entrySet().iterator();
                        while (iterator4.hasNext()) {
                            Map.Entry entry = element$iv$iv = iterator4.next();
                            $i$a$-forEach-DataFrameImpl$group$1$iv = false;
                            key$iv = entry.getKey();
                            value$iv = ((Number)entry.getValue()).intValue();
                            newData$iv[value$iv] = key$iv;
                        }
                    }
                    catch (Exception e$iv2) {
                        e$iv2.printStackTrace();
                    }
                    column3 = col$iv.getType().createColumn(column.getName(), (List)ArraysKt.toCollection((Object[])newData$iv, (Collection)new ArrayList()));
                } else if (type instanceof RealType) {
                    this_$iv = this;
                    initValue$iv = 0.0;
                    $i$f$group = false;
                    col$iv = column.cast();
                    int e$iv2 = 0;
                    Double[] $i$f$forEach2 = new Double[newColumnsSize];
                    while (e$iv2 < newColumnsSize) {
                        int n5 = e$iv2++;
                        $i$f$forEach2[n5] = initValue$iv;
                    }
                    newData$iv = $i$f$forEach2;
                    try {
                        $this$forEach$iv$iv = alreadyProcessed;
                        boolean $i$f$forEach = false;
                        Iterator iterator5 = $this$forEach$iv$iv.entrySet().iterator();
                        while (iterator5.hasNext()) {
                            Map.Entry entry = element$iv$iv = iterator5.next();
                            $i$a$-forEach-DataFrameImpl$group$1$iv = false;
                            key$iv = entry.getKey();
                            value$iv = ((Number)entry.getValue()).intValue();
                            newData$iv[value$iv] = key$iv;
                        }
                    }
                    catch (Exception e$iv) {
                        e$iv.printStackTrace();
                    }
                    column3 = col$iv.getType().createColumn(column.getName(), (List)ArraysKt.toCollection((Object[])newData$iv, (Collection)new ArrayList()));
                } else if (type instanceof StringType) {
                    this_$iv = this;
                    initValue$iv = "";
                    $i$f$group = false;
                    col$iv = column.cast();
                    int e$iv = 0;
                    String[] $i$f$forEach = new String[newColumnsSize];
                    while (e$iv < newColumnsSize) {
                        int n6 = e$iv++;
                        $i$f$forEach[n6] = initValue$iv;
                    }
                    newData$iv = $i$f$forEach;
                    try {
                        $this$forEach$iv$iv = alreadyProcessed;
                        boolean $i$f$forEach3 = false;
                        Iterator iterator6 = $this$forEach$iv$iv.entrySet().iterator();
                        while (iterator6.hasNext()) {
                            Map.Entry entry = element$iv$iv = iterator6.next();
                            $i$a$-forEach-DataFrameImpl$group$1$iv = false;
                            key$iv = entry.getKey();
                            value$iv = ((Number)entry.getValue()).intValue();
                            newData$iv[value$iv] = key$iv;
                        }
                    }
                    catch (Exception e$iv3) {
                        e$iv3.printStackTrace();
                    }
                    column3 = col$iv.getType().createColumn(column.getName(), (List)ArraysKt.toCollection((Object[])newData$iv, (Collection)new ArrayList()));
                } else if (type instanceof CompositeType) {
                    this_$iv = this;
                    initValue$iv = CollectionsKt.emptyList();
                    $i$f$group = false;
                    col$iv = column.cast();
                    int e$iv3 = 0;
                    List[] $i$f$forEach3 = new List[newColumnsSize];
                    while (e$iv3 < newColumnsSize) {
                        int n7 = e$iv3++;
                        $i$f$forEach3[n7] = initValue$iv;
                    }
                    newData$iv = $i$f$forEach3;
                    try {
                        $this$forEach$iv$iv = alreadyProcessed;
                        boolean $i$f$forEach = false;
                        Iterator iterator7 = $this$forEach$iv$iv.entrySet().iterator();
                        while (iterator7.hasNext()) {
                            Map.Entry entry = element$iv$iv = iterator7.next();
                            $i$a$-forEach-DataFrameImpl$group$1$iv = false;
                            key$iv = entry.getKey();
                            value$iv = ((Number)entry.getValue()).intValue();
                            newData$iv[value$iv] = key$iv;
                        }
                    }
                    catch (Exception e$iv) {
                        e$iv.printStackTrace();
                    }
                    column3 = col$iv.getType().createColumn(column.getName(), (List)ArraysKt.toCollection((Object[])newData$iv, (Collection)new ArrayList()));
                } else {
                    throw new Exception("Unsupported column type " + column.getType() + " in grouping.");
                }
                newColumn = column3;
                bl = newColumns.add(newColumn);
                continue;
            }
            type = column.getType();
            if (type instanceof IntegerType) {
                this_$iv = this;
                $i$f$group1 = false;
                newData$iv = new ArrayList(newColumnsSize);
                for (int i$iv = 0; i$iv < newColumnsSize; ++i$iv) {
                    newData$iv.add(new ArrayList());
                }
                i$iv = ((Iterable)column.cast()).iterator();
                var15_38 = 0;
                while (i$iv.hasNext()) {
                    int i$iv = var15_38++;
                    value$iv = i$iv.next();
                    List list2 = (List)newData$iv.get(indexes[i$iv]);
                    if (list2 == null) continue;
                    list2.add(value$iv);
                }
                newData$iv = newData$iv;
                name = column.getName();
                boolean bl2 = false;
                column2 = new IntArrayColumn(name, data);
            } else if (type instanceof LongType) {
                this_$iv = this;
                $i$f$group1 = false;
                newData$iv = new ArrayList(newColumnsSize);
                for (int i$iv = 0; i$iv < newColumnsSize; ++i$iv) {
                    newData$iv.add(new ArrayList());
                }
                i$iv = ((Iterable)column.cast()).iterator();
                var15_38 = 0;
                while (i$iv.hasNext()) {
                    int i$iv = var15_38++;
                    value$iv = i$iv.next();
                    List list3 = (List)newData$iv.get(indexes[i$iv]);
                    if (list3 == null) continue;
                    list3.add(value$iv);
                }
                data = newData$iv;
                name = column.getName();
                boolean bl3 = false;
                column2 = new LongArrayColumn(name, data);
            } else if (type instanceof RealType) {
                this_$iv = this;
                $i$f$group1 = false;
                newData$iv = new ArrayList(newColumnsSize);
                for (int i$iv = 0; i$iv < newColumnsSize; ++i$iv) {
                    newData$iv.add(new ArrayList());
                }
                i$iv = ((Iterable)column.cast()).iterator();
                var15_38 = 0;
                while (i$iv.hasNext()) {
                    int i$iv = var15_38++;
                    value$iv = i$iv.next();
                    List list4 = (List)newData$iv.get(indexes[i$iv]);
                    if (list4 == null) continue;
                    list4.add(value$iv);
                }
                data = newData$iv;
                name = column.getName();
                boolean bl4 = false;
                column2 = new DoubleArrayColumn(name, data);
            } else if (type instanceof StringType) {
                this_$iv = this;
                $i$f$group1 = false;
                newData$iv = new ArrayList(newColumnsSize);
                for (int i$iv = 0; i$iv < newColumnsSize; ++i$iv) {
                    newData$iv.add(new ArrayList());
                }
                Iterator iterator8 = ((Iterable)column.cast()).iterator();
                var15_38 = 0;
                while (iterator8.hasNext()) {
                    int i$iv = var15_38++;
                    value$iv = iterator8.next();
                    List list5 = (List)newData$iv.get(indexes[i$iv]);
                    if (list5 == null) continue;
                    list5.add(value$iv);
                }
                data = newData$iv;
                name = column.getName();
                boolean bl5 = false;
                column2 = new StringArrayColumn(name, data);
            } else {
                throw new Exception("Unsupported column type " + column.getType() + " in grouping.");
            }
            newColumn = column2;
            bl = newColumns.add(newColumn);
        }
        return new DataFrameImpl(newColumns);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataFrame groupBy(@NotNull List<String> columnNames) {
        Collection<Object> collection;
        Object $this$mapTo$iv$iv;
        Collection<Object> destination$iv$iv;
        Object object;
        ArrayList arrayList;
        void $this$mapTo$iv$iv22;
        Intrinsics.checkNotNullParameter(columnNames, (String)"columnNames");
        Iterable $this$map$iv = columnNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable<Iterable<Object>> destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv22) {
            Object v0;
            void name;
            block17: {
                String string = (String)item$iv$iv;
                arrayList = destination$iv$iv2;
                boolean bl = false;
                Iterable iterable2 = this.columns;
                object = iterable2.iterator();
                while (object.hasNext()) {
                    Object t = object.next();
                    Column column = (Column)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)column.getName(), (Object)name)) continue;
                    v0 = t;
                    break block17;
                }
                v0 = null;
            }
            Column column = v0;
            if (column == null) {
                throw new IllegalArgumentException((String)name);
            }
            arrayList.add(column);
        }
        List groupByColumns = destination$iv$iv2;
        ArrayList data = new ArrayList(this.getRowsCount());
        int $this$mapTo$iv$iv22 = this.getRowsCount();
        for (int i = 0; i < $this$mapTo$iv$iv22; ++i) {
            void $this$map$iv2;
            destination$iv$iv2 = groupByColumns;
            arrayList = data;
            boolean $i$f$map2 = false;
            Iterator iterator2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator bl = $this$mapTo$iv$iv.iterator();
            while (bl.hasNext()) {
                void column;
                Object item$iv$iv = bl.next();
                object = (Column)item$iv$iv;
                Collection<Object> collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add(column.get(i));
            }
            arrayList.add((List)destination$iv$iv);
        }
        Random rand = RandomKt.Random((long)System.currentTimeMillis());
        String systemColumnName = null;
        block4: do {
            systemColumnName = "__group_by_" + rand.nextInt();
            Iterable $i$f$map2 = this.columns;
            $this$mapTo$iv$iv = $i$f$map2.iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                destination$iv$iv = $this$mapTo$iv$iv.next();
                Column column = (Column)((Object)destination$iv$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)column.getName(), (Object)systemColumnName)) continue;
                collection = destination$iv$iv;
                continue block4;
            }
            collection = null;
        } while (collection != null);
        CompositeColumn compositeColumn = new CompositeColumn(systemColumnName, data);
        Object $this$groupBy_u24lambda_u2415 = $this$mapTo$iv$iv = new ArrayList(this.columns.size() + 1);
        boolean bl = false;
        ((ArrayList)$this$groupBy_u24lambda_u2415).addAll((Collection)this.columns);
        ((ArrayList)$this$groupBy_u24lambda_u2415).add(compositeColumn);
        List list2 = (List)$this$mapTo$iv$iv;
        DataFrameImpl df = new DataFrameImpl(list2);
        DataFrame dataFrame = df.groupBy(systemColumnName);
        Intrinsics.checkNotNull((Object)dataFrame, (String)"null cannot be cast to non-null type com.intellij.charts.dataframe.DataFrameImpl");
        DataFrameImpl gdf = (DataFrameImpl)dataFrame;
        ArrayList<Column> cols = new ArrayList<Column>(this.getColumnsCount());
        Iterable $this$forEach$iv = gdf.columns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl4;
            Column column = (Column)element$iv;
            boolean bl5 = false;
            if (Intrinsics.areEqual((Object)column.getName(), (Object)systemColumnName)) continue;
            if (columnNames.contains(column.getName())) {
                DataFrameImpl this_$iv;
                ArrayList it$iv;
                boolean bl6;
                Collection collection3;
                Iterable $this$mapTo$iv$iv$iv;
                boolean $i$f$mapTo3;
                Collection destination$iv$iv$iv;
                Iterable $this$map$iv$iv;
                boolean $i$f$map3;
                Type type;
                Type type$iv;
                String string;
                Column $this$takeFirst$iv;
                boolean $i$f$takeFirst;
                ArrayList<Column> arrayList2;
                Type type2 = column.getType();
                if (type2 instanceof IntArrayType) {
                    DataFrameImpl dataFrameImpl = this;
                    Column column2 = column.cast();
                    Type type3 = IntegerType.INSTANCE;
                    arrayList2 = cols;
                    $i$f$takeFirst = false;
                    Iterable iterable3 = $this$takeFirst$iv.toList();
                    string = $this$takeFirst$iv.getName();
                    type = type$iv;
                    $i$f$map3 = false;
                    Iterable iterable4 = $this$map$iv$iv;
                    destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
                    $i$f$mapTo3 = false;
                    for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                        ArrayList arrayList3 = (ArrayList)item$iv$iv$iv;
                        collection3 = destination$iv$iv$iv;
                        bl6 = false;
                        ArrayList arrayList4 = it$iv;
                        collection3.add(arrayList4 != null ? arrayList4.get(0) : null);
                    }
                    collection3 = (List)destination$iv$iv$iv;
                    bl4 = arrayList2.add(type.createColumn(string, (ArrayList)collection3));
                    continue;
                }
                if (type2 instanceof DoubleArrayType) {
                    this_$iv = this;
                    $this$takeFirst$iv = column.cast();
                    type$iv = RealType.INSTANCE;
                    arrayList2 = cols;
                    $i$f$takeFirst = false;
                    $this$map$iv$iv = $this$takeFirst$iv.toList();
                    string = $this$takeFirst$iv.getName();
                    type = type$iv;
                    $i$f$map3 = false;
                    $this$mapTo$iv$iv$iv = $this$map$iv$iv;
                    destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
                    $i$f$mapTo3 = false;
                    for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                        it$iv = (ArrayList)item$iv$iv$iv;
                        collection3 = destination$iv$iv$iv;
                        bl6 = false;
                        ArrayList arrayList5 = it$iv;
                        collection3.add(arrayList5 != null ? arrayList5.get(0) : null);
                    }
                    collection3 = (List)destination$iv$iv$iv;
                    bl4 = arrayList2.add(type.createColumn(string, (ArrayList)collection3));
                    continue;
                }
                if (type2 instanceof LongArrayType) {
                    this_$iv = this;
                    $this$takeFirst$iv = column.cast();
                    type$iv = LongType.INSTANCE;
                    arrayList2 = cols;
                    $i$f$takeFirst = false;
                    $this$map$iv$iv = $this$takeFirst$iv.toList();
                    string = $this$takeFirst$iv.getName();
                    type = type$iv;
                    $i$f$map3 = false;
                    $this$mapTo$iv$iv$iv = $this$map$iv$iv;
                    destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
                    $i$f$mapTo3 = false;
                    for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                        it$iv = (ArrayList)item$iv$iv$iv;
                        collection3 = destination$iv$iv$iv;
                        bl6 = false;
                        ArrayList arrayList6 = it$iv;
                        collection3.add(arrayList6 != null ? arrayList6.get(0) : null);
                    }
                    collection3 = (List)destination$iv$iv$iv;
                    bl4 = arrayList2.add(type.createColumn(string, (ArrayList)collection3));
                    continue;
                }
                if (type2 instanceof StringArrayType) {
                    this_$iv = this;
                    $this$takeFirst$iv = column.cast();
                    type$iv = StringType.INSTANCE;
                    arrayList2 = cols;
                    $i$f$takeFirst = false;
                    $this$map$iv$iv = $this$takeFirst$iv.toList();
                    string = $this$takeFirst$iv.getName();
                    type = type$iv;
                    $i$f$map3 = false;
                    $this$mapTo$iv$iv$iv = $this$map$iv$iv;
                    destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
                    $i$f$mapTo3 = false;
                    for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                        it$iv = (ArrayList)item$iv$iv$iv;
                        collection3 = destination$iv$iv$iv;
                        bl6 = false;
                        ArrayList arrayList7 = it$iv;
                        collection3.add(arrayList7 != null ? arrayList7.get(0) : null);
                    }
                    collection3 = (List)destination$iv$iv$iv;
                    bl4 = arrayList2.add(type.createColumn(string, (ArrayList)collection3));
                    continue;
                }
                throw new Exception("Unsupported column type " + column.getType() + " in grouping.");
            }
            bl4 = cols.add(column);
        }
        return new DataFrameImpl((List)cols);
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ <T> Column<T> takeFirst(Column<ArrayList<T>> $this$takeFirst, Type<T> type) {
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean $i$f$takeFirst = false;
        Iterable iterable = $this$takeFirst.toList();
        String string = $this$takeFirst.getName();
        Type<T> type2 = type;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ArrayList arrayList = (ArrayList)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            collection.add(v0 != null ? v0.get(0) : null);
        }
        collection = (List)destination$iv$iv;
        return type2.createColumn(string, (ArrayList)collection);
    }

    private final /* synthetic */ <T> Column<T> sort(Column<?> column, List<Integer> sortedIndices) {
        boolean $i$f$sort = false;
        Column<?> col = column.cast();
        ArrayList data = new ArrayList(column.getSize());
        Iterable $this$forEach$iv = (Iterable)CollectionsKt.getIndices((Collection)sortedIndices);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            data.add(col.get(((Number)sortedIndices.get(it)).intValue()));
        }
        return col.getType().createColumn(column.getName(), data);
    }

    private final /* synthetic */ <T> Column<T> group(Column<?> column, int newColumnsSize, HashMap<Object, Integer> alreadyProcessed, T initValue) {
        boolean $i$f$group = false;
        Column<?> col = column.cast();
        int n = 0;
        Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
        Object[] objectArray = new Object[newColumnsSize];
        while (n < newColumnsSize) {
            int n2 = n++;
            objectArray[n2] = initValue;
        }
        Object[] newData = objectArray;
        try {
            Map $this$forEach$iv = alreadyProcessed;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl = false;
                Object key = entry.getKey();
                int value = ((Number)entry.getValue()).intValue();
                newData[value] = key;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col.getType().createColumn(column.getName(), (List)ArraysKt.toCollection((Object[])newData, (Collection)new ArrayList()));
    }

    private final /* synthetic */ <T> Column<List<T>> group1(Column<?> column, int newColumnsSize, int[] indexes, Function2<? super String, ? super List<List<T>>, ? extends Column<List<T>>> create2) {
        boolean $i$f$group1 = false;
        ArrayList newData = new ArrayList(newColumnsSize);
        for (int i = 0; i < newColumnsSize; ++i) {
            newData.add(new ArrayList());
        }
        Iterator iterator2 = ((Iterable)column.cast()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            Object value = iterator2.next();
            List list2 = (List)newData.get(indexes[i]);
            if (list2 == null) continue;
            list2.add(value);
        }
        return (Column)create2.invoke((Object)column.getName(), newData);
    }
}

