/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.formatting.number;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchNamedGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.number.NumberFormat;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 $2\u00020\u0001:\u0005$%&'(B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0017\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u001c\u001a\u00020\u000fH\u0002J\u001a\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u001c\u001a\u00020\u000fH\u0002J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u001c\u001a\u00020\u000fH\u0002J\u001a\u0010 \u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u001c\u001a\u00020\u000fH\u0002J\u001a\u0010!\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u001c\u001a\u00020\u000fH\u0002J\u001a\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u001c\u001a\u00020\u000fH\u0002J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat;", "", "spec", "", "(Ljava/lang/String;)V", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$Spec;", "(Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$Spec;)V", "apply", "num", "", "applyGroup", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$Output;", "output", "buildExponentString", "exponent", "", "(Ljava/lang/Integer;)Ljava/lang/String;", "computeBody", "res", "numberInfo", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$NumberInfo;", "computePadding", "computePrefix", "computeSign", "computeSuffix", "getAlignedString", "handleNonNumbers", "roundToPrecision", "precision", "toExponential", "toFixedFormat", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$FormattedNumber;", "toPrecisionFormat", "toSiFormat", "toSimpleFormat", "trimFraction", "Companion", "FormattedNumber", "NumberInfo", "Output", "Spec", "commons"})
@SourceDebugExtension(value={"SMAP\nNumberFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberFormat.kt\norg/jetbrains/letsPlot/commons/formatting/number/NumberFormat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,539:1\n1#2:540\n1224#3,2:541\n*S KotlinDebug\n*F\n+ 1 NumberFormat.kt\norg/jetbrains/letsPlot/commons/formatting/number/NumberFormat\n*L\n293#1:541,2\n*E\n"})
public final class NumberFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Spec spec;
    public static final double TYPE_E_MIN = 9.9E-324;
    public static final double TYPE_S_MAX = 1.0E26;
    @NotNull
    private static final String CURRENCY = "$";
    @NotNull
    private static final String PERCENT = "%";
    @NotNull
    private static final String COMMA = ",";
    @NotNull
    private static final String FRACTION_DELIMITER = ".";
    private static final int GROUP_SIZE = 3;
    @NotNull
    private static final String[] SI_SUFFIXES;
    @NotNull
    private static final Regex NUMBER_REGEX;

    public NumberFormat(@NotNull Spec spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this.spec = Companion.normalizeSpec$commons(spec);
    }

    public NumberFormat(@NotNull String spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this(Companion.parseSpec(spec));
    }

    @NotNull
    public final String apply(@NotNull Number num) {
        Intrinsics.checkNotNullParameter((Object)num, (String)"num");
        String nonNumberString = this.handleNonNumbers(num);
        if (nonNumberString != null) {
            return nonNumberString;
        }
        NumberInfo numberInfo = NumberInfo.Companion.createNumberInfo$commons(num);
        Output output = new Output(null, null, null, null, null, 31, null);
        output = this.computeBody(output, numberInfo);
        output = this.trimFraction(output);
        output = this.computeSign(output, numberInfo);
        output = this.computePrefix(output);
        output = this.computeSuffix(output);
        if (this.spec.getComma() && !this.spec.getZero()) {
            output = this.applyGroup(output);
        }
        output = this.computePadding(output);
        if (this.spec.getComma() && this.spec.getZero()) {
            output = this.applyGroup(output);
        }
        return this.getAlignedString(output);
    }

    private final String handleNonNumbers(Number num) {
        double number = num.doubleValue();
        return Double.isNaN(number) ? "NaN" : (number == Double.NEGATIVE_INFINITY ? "-Infinity" : (number == Double.POSITIVE_INFINITY ? "+Infinity" : null));
    }

    private final String getAlignedString(Output output) {
        String string;
        Output $this$getAlignedString_u24lambda_u240 = output;
        boolean bl = false;
        switch (this.spec.getAlign()) {
            case "<": {
                string = $this$getAlignedString_u24lambda_u240.getSign() + $this$getAlignedString_u24lambda_u240.getPrefix() + $this$getAlignedString_u24lambda_u240.getBody() + $this$getAlignedString_u24lambda_u240.getSuffix() + $this$getAlignedString_u24lambda_u240.getPadding();
                break;
            }
            case "=": {
                string = $this$getAlignedString_u24lambda_u240.getSign() + $this$getAlignedString_u24lambda_u240.getPrefix() + $this$getAlignedString_u24lambda_u240.getPadding() + $this$getAlignedString_u24lambda_u240.getBody() + $this$getAlignedString_u24lambda_u240.getSuffix();
                break;
            }
            case "^": {
                int stop2 = $this$getAlignedString_u24lambda_u240.getPadding().length() / 2;
                string = StringsKt.slice((String)$this$getAlignedString_u24lambda_u240.getPadding(), (IntRange)RangesKt.until((int)0, (int)stop2)) + $this$getAlignedString_u24lambda_u240.getSign() + $this$getAlignedString_u24lambda_u240.getPrefix() + $this$getAlignedString_u24lambda_u240.getBody() + $this$getAlignedString_u24lambda_u240.getSuffix() + StringsKt.slice((String)$this$getAlignedString_u24lambda_u240.getPadding(), (IntRange)RangesKt.until((int)stop2, (int)output.getPadding().length()));
                break;
            }
            default: {
                string = $this$getAlignedString_u24lambda_u240.getPadding() + $this$getAlignedString_u24lambda_u240.getSign() + $this$getAlignedString_u24lambda_u240.getPrefix() + $this$getAlignedString_u24lambda_u240.getBody() + $this$getAlignedString_u24lambda_u240.getSuffix();
            }
        }
        return string;
    }

    private final Output applyGroup(Output output) {
        String string;
        String string2;
        String it = string2 = output.getPadding();
        boolean bl = false;
        String string3 = this.spec.getZero() ? string2 : null;
        if (string3 == null) {
            string3 = "";
        }
        String zeroPadding = string3;
        FormattedNumber body = output.getBody();
        String fullIntStr = zeroPadding + body.getIntegerPart();
        int commas = (int)(Math.ceil((double)fullIntStr.length() / 3.0) - 1.0);
        int width2 = RangesKt.coerceAtLeast((int)(this.spec.getWidth() - body.getFractionalLength() - body.getExponentialLength()), (int)(body.getIntegerPart().length() + commas));
        if ((fullIntStr = NumberFormat.Companion.group(fullIntStr)).length() > width2) {
            String string4 = fullIntStr.substring(fullIntStr.length() - width2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            fullIntStr = string4;
            if (StringsKt.startsWith$default((CharSequence)fullIntStr, (char)',', (boolean)false, (int)2, null)) {
                fullIntStr = '0' + fullIntStr;
            }
        }
        String string5 = string = "";
        String string6 = null;
        String string7 = null;
        String string8 = null;
        FormattedNumber formattedNumber = FormattedNumber.copy$default(body, fullIntStr, null, null, 6, null);
        Output output2 = output;
        boolean bl2 = false;
        boolean bl3 = this.spec.getZero();
        String string9 = bl3 ? string : null;
        if (string9 == null) {
            string9 = output.getPadding();
        }
        return Output.copy$default(output2, formattedNumber, string8, string7, string6, string9, 14, null);
    }

    private final Output computeBody(Output res, NumberInfo numberInfo) {
        FormattedNumber formattedNumber;
        switch (this.spec.getType()) {
            case "%": {
                formattedNumber = this.toFixedFormat(NumberInfo.Companion.createNumberInfo$commons(numberInfo.getNumber() * (double)100), this.spec.getPrecision());
                break;
            }
            case "c": {
                formattedNumber = new FormattedNumber(String.valueOf(numberInfo.getNumber()), null, null, 6, null);
                break;
            }
            case "d": {
                formattedNumber = this.toSimpleFormat(numberInfo, 0);
                break;
            }
            case "e": {
                formattedNumber = this.toSimpleFormat(this.toExponential(numberInfo, this.spec.getPrecision()), this.spec.getPrecision());
                break;
            }
            case "f": {
                formattedNumber = this.toFixedFormat(numberInfo, this.spec.getPrecision());
                break;
            }
            case "g": {
                formattedNumber = this.toPrecisionFormat(numberInfo, this.spec.getPrecision());
                break;
            }
            case "b": {
                String string = Long.toString(MathKt.roundToLong((double)numberInfo.getNumber()), CharsKt.checkRadix((int)2));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                formattedNumber = new FormattedNumber(string, null, null, 6, null);
                break;
            }
            case "o": {
                String string = Long.toString(MathKt.roundToLong((double)numberInfo.getNumber()), CharsKt.checkRadix((int)8));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                formattedNumber = new FormattedNumber(string, null, null, 6, null);
                break;
            }
            case "X": {
                String string = Long.toString(MathKt.roundToLong((double)numberInfo.getNumber()), CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                formattedNumber = new FormattedNumber(string2, null, null, 6, null);
                break;
            }
            case "x": {
                String string = Long.toString(MathKt.roundToLong((double)numberInfo.getNumber()), CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                formattedNumber = new FormattedNumber(string, null, null, 6, null);
                break;
            }
            case "s": {
                formattedNumber = this.toSiFormat(numberInfo, this.spec.getPrecision());
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong type: " + this.spec.getType());
            }
        }
        FormattedNumber formattedNumber2 = formattedNumber;
        return Output.copy$default(res, formattedNumber2, null, null, null, null, 30, null);
    }

    private final NumberInfo toExponential(NumberInfo numberInfo, int precision) {
        int n;
        double num = numberInfo.getNumber();
        if (num < 9.9E-324) {
            return new NumberInfo(0.0, false, 0L, 0L, null, 30, null);
        }
        if (numberInfo.getIntegerPart() == 0L) {
            n = -(numberInfo.getFractionLeadingZeros() + 1);
        } else {
            Integer n2 = numberInfo.getExponent();
            n = numberInfo.getIntegerLength() - 1 + (n2 != null ? n2 : 0);
        }
        int e = n;
        double n3 = num / Math.pow(10.0, e);
        NumberInfo newInfo = NumberInfo.Companion.createNumberInfo$commons(n3);
        if (precision > -1) {
            newInfo = this.roundToPrecision(newInfo, precision);
        }
        if (newInfo.getIntegerLength() > 1) {
            ++e;
            newInfo = NumberInfo.Companion.createNumberInfo$commons(n3 / (double)10);
        }
        return NumberInfo.copy$default(newInfo, 0.0, false, 0L, 0L, e, 15, null);
    }

    static /* synthetic */ NumberInfo toExponential$default(NumberFormat numberFormat, NumberInfo numberInfo, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return numberFormat.toExponential(numberInfo, n);
    }

    private final FormattedNumber toPrecisionFormat(NumberInfo numberInfo, int precision) {
        if (numberInfo.getIntegerPart() == 0L) {
            if (numberInfo.getFractionalPart() == 0L) {
                return this.toFixedFormat(numberInfo, precision - 1);
            }
            if (numberInfo.getFractionLeadingZeros() >= 6) {
                return this.toSimpleFormat(this.toExponential(numberInfo, precision - 1), precision - 1);
            }
            return this.toFixedFormat(numberInfo, precision + numberInfo.getFractionLeadingZeros());
        }
        if (numberInfo.getIntegerLength() > precision) {
            return this.toSimpleFormat(this.toExponential(numberInfo, precision - 1), precision - 1);
        }
        return this.toFixedFormat(numberInfo, precision - numberInfo.getIntegerLength());
    }

    static /* synthetic */ FormattedNumber toPrecisionFormat$default(NumberFormat numberFormat, NumberInfo numberInfo, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return numberFormat.toPrecisionFormat(numberInfo, n);
    }

    private final FormattedNumber toFixedFormat(NumberInfo numberInfo, int precision) {
        int completePrecision;
        if (precision <= 0) {
            return new FormattedNumber(String.valueOf(MathKt.roundToLong((double)numberInfo.getNumber())), null, null, 6, null);
        }
        NumberInfo newNumberInfo = this.roundToPrecision(numberInfo, precision);
        int n = completePrecision = numberInfo.getIntegerLength() < newNumberInfo.getIntegerLength() ? precision - 1 : precision;
        if (newNumberInfo.getFractionalPart() == 0L) {
            return new FormattedNumber(String.valueOf(newNumberInfo.getIntegerPart()), StringsKt.repeat((CharSequence)"0", (int)completePrecision), null, 4, null);
        }
        String fractionString = StringsKt.padEnd((String)newNumberInfo.getFractionString(), (int)completePrecision, (char)'0');
        return new FormattedNumber(String.valueOf(newNumberInfo.getIntegerPart()), fractionString, null, 4, null);
    }

    static /* synthetic */ FormattedNumber toFixedFormat$default(NumberFormat numberFormat, NumberInfo numberInfo, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return numberFormat.toFixedFormat(numberInfo, n);
    }

    private final FormattedNumber toSimpleFormat(NumberInfo numberInfo, int precision) {
        String exponentString = this.buildExponentString(numberInfo.getExponent());
        NumberInfo expNumberInfo = NumberInfo.Companion.createNumberInfo$commons((double)numberInfo.getIntegerPart() + (double)numberInfo.getFractionalPart() / (double)NumberInfo.Companion.getMAX_DECIMAL_VALUE$commons());
        if (precision > -1) {
            FormattedNumber formattedNumber = this.toFixedFormat(expNumberInfo, precision);
            return FormattedNumber.copy$default(formattedNumber, null, null, exponentString, 3, null);
        }
        String integerString = String.valueOf(expNumberInfo.getIntegerPart());
        String fractionString = expNumberInfo.getFractionalPart() == 0L ? "" : expNumberInfo.getFractionString();
        return new FormattedNumber(integerString, fractionString, exponentString);
    }

    static /* synthetic */ FormattedNumber toSimpleFormat$default(NumberFormat numberFormat, NumberInfo numberInfo, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return numberFormat.toSimpleFormat(numberInfo, n);
    }

    private final String buildExponentString(Integer exponent) {
        String string;
        if (exponent == null) {
            return "";
        }
        if (this.spec.getRichOutput()) {
            switch (exponent) {
                case 0: {
                    string = "";
                    break;
                }
                case 1: {
                    string = "\u00b710";
                    break;
                }
                default: {
                    string = "\u00b7\\(10^{" + exponent + "}\\)";
                    break;
                }
            }
        } else {
            String expSign = MathKt.getSign((int)exponent) >= 0 ? "+" : "";
            string = 'e' + expSign + exponent;
        }
        return string;
    }

    private final FormattedNumber toSiFormat(NumberInfo numberInfo, int precision) {
        NumberInfo expNumberInfo = numberInfo.getExponent() == null ? this.toExponential(numberInfo, precision - 1) : numberInfo;
        Integer n = expNumberInfo.getExponent();
        int exponent = n != null ? n : 0;
        int suffixExp = (int)RangesKt.coerceAtMost((double)RangesKt.coerceAtLeast((double)Math.floor((double)exponent / 3.0), (double)-8.0), (double)8.0) * 3;
        NumberInfo newNumberInfo = NumberInfo.Companion.createNumberInfo$commons(numberInfo.getNumber() * Math.pow(10.0, -suffixExp));
        int suffixIndex = 8 + suffixExp / 3;
        String exponentString = SI_SUFFIXES[suffixIndex];
        FormattedNumber formattedNumber = this.toFixedFormat(newNumberInfo, precision - newNumberInfo.getIntegerLength());
        return FormattedNumber.copy$default(formattedNumber, null, null, exponentString, 3, null);
    }

    static /* synthetic */ FormattedNumber toSiFormat$default(NumberFormat numberFormat, NumberInfo numberInfo, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return numberFormat.toSiFormat(numberInfo, n);
    }

    private final NumberInfo roundToPrecision(NumberInfo numberInfo, int precision) {
        Integer n = numberInfo.getExponent();
        int exp = n != null ? n : 0;
        int totalPrecision = precision + exp;
        long fractionalPart = 0L;
        long integerPart = 0L;
        if (totalPrecision < 0) {
            fractionalPart = 0L;
            int intShift = Math.abs(totalPrecision);
            integerPart = numberInfo.getIntegerLength() <= intShift ? 0L : numberInfo.getIntegerPart() / (long)Math.pow(10.0, intShift) * (long)Math.pow(10.0, intShift);
        } else {
            long precisionExp = NumberInfo.Companion.getMAX_DECIMAL_VALUE$commons() / (long)Math.pow(10.0, totalPrecision);
            fractionalPart = precisionExp == 0L ? numberInfo.getFractionalPart() : MathKt.roundToLong((double)((double)numberInfo.getFractionalPart() / (double)precisionExp)) * precisionExp;
            integerPart = numberInfo.getIntegerPart();
            if (fractionalPart == NumberInfo.Companion.getMAX_DECIMAL_VALUE$commons()) {
                fractionalPart = 0L;
                ++integerPart;
            }
        }
        double num = (double)integerPart + (double)fractionalPart / (double)NumberInfo.Companion.getMAX_DECIMAL_VALUE$commons();
        return NumberInfo.copy$default(numberInfo, num, false, integerPart, fractionalPart, null, 18, null);
    }

    static /* synthetic */ NumberInfo roundToPrecision$default(NumberFormat numberFormat, NumberInfo numberInfo, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return numberFormat.roundToPrecision(numberInfo, n);
    }

    private final Output trimFraction(Output output) {
        if (!this.spec.getTrim() || ((CharSequence)output.getBody().getFractionalPart()).length() == 0) {
            return output;
        }
        char[] cArray = new char[]{'0'};
        String trimmedFraction = StringsKt.trimEnd((String)output.getBody().getFractionalPart(), (char[])cArray);
        return Output.copy$default(output, FormattedNumber.copy$default(output.getBody(), null, trimmedFraction, null, 5, null), null, null, null, null, 30, null);
    }

    private final Output computeSign(Output output, NumberInfo numberInfo) {
        boolean isNegative;
        boolean bl;
        block1: {
            FormattedNumber $this$computeSign_u24lambda_u244 = output.getBody();
            boolean bl2 = false;
            Sequence $this$all$iv = SequencesKt.plus((Sequence)StringsKt.asSequence((CharSequence)$this$computeSign_u24lambda_u244.getIntegerPart()), (Sequence)StringsKt.asSequence((CharSequence)$this$computeSign_u24lambda_u244.getFractionalPart()));
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                char it = ((Character)element$iv).charValue();
                boolean bl3 = false;
                if (it == '0') continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        boolean isBodyZero = bl;
        boolean bl4 = isNegative = numberInfo.getNegative() && !isBodyZero;
        String signStr = isNegative ? "-" : (!Intrinsics.areEqual((Object)this.spec.getSign(), (Object)"-") ? this.spec.getSign() : "");
        return Output.copy$default(output, null, signStr, null, null, null, 29, null);
    }

    private final Output computePrefix(Output output) {
        String string;
        String string2 = this.spec.getSymbol();
        if (Intrinsics.areEqual((Object)string2, (Object)CURRENCY)) {
            string = CURRENCY;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"#")) {
            if (StringsKt.indexOf$default((CharSequence)"boxX", (String)this.spec.getType(), (int)0, (boolean)false, (int)6, null) > -1) {
                StringBuilder stringBuilder = new StringBuilder().append('0');
                String string3 = this.spec.getType().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                string = stringBuilder.append(string3).toString();
            } else {
                string = "";
            }
        } else {
            string = "";
        }
        String prefix = string;
        return Output.copy$default(output, null, null, prefix, null, null, 27, null);
    }

    private final Output computeSuffix(Output res) {
        String string;
        String string2 = string = PERCENT;
        String string3 = null;
        String string4 = null;
        FormattedNumber formattedNumber = null;
        Output output = res;
        boolean bl = false;
        boolean bl2 = Intrinsics.areEqual((Object)this.spec.getType(), (Object)PERCENT);
        String string5 = bl2 ? string : null;
        if (string5 == null) {
            string5 = "";
        }
        return Output.copy$default(output, formattedNumber, string4, string3, string5, null, 23, null);
    }

    private final Output computePadding(Output output) {
        int length = output.getSign().length() + output.getPrefix().length() + output.getBody().getFullLength() + output.getSuffix().length();
        String padding = length < this.spec.getWidth() ? StringsKt.repeat((CharSequence)this.spec.getFill(), (int)(this.spec.getWidth() - length)) : "";
        return Output.copy$default(output, null, null, null, null, padding, 15, null);
    }

    static {
        String[] stringArray = new String[]{"y", "z", "a", "f", "p", "n", "\u00b5", "m", "", "k", "M", "G", "T", "P", "E", "Z", "Y"};
        SI_SUFFIXES = stringArray;
        NUMBER_REGEX = new Regex("^(?:([^{}])?([<>=^]))?([+ -])?([#$])?(0)?(\\d+)?(,)?(?:\\.(\\d+))?(~)?([%bcdefgosXx])?(&)?$");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$Companion;", "", "()V", "COMMA", "", "CURRENCY", "FRACTION_DELIMITER", "GROUP_SIZE", "", "NUMBER_REGEX", "Lkotlin/text/Regex;", "PERCENT", "SI_SUFFIXES", "", "[Ljava/lang/String;", "TYPE_E_MIN", "", "TYPE_S_MAX", "group", "str", "isValidPattern", "", "spec", "normalizeSpec", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$Spec;", "normalizeSpec$commons", "parseSpec", "commons"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isValidPattern(@NotNull String spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            return NUMBER_REGEX.matches((CharSequence)spec);
        }

        @NotNull
        public final Spec parseSpec(@NotNull String spec) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            MatchResult matchResult = Regex.find$default((Regex)NUMBER_REGEX, (CharSequence)spec, (int)0, (int)2, null);
            if (matchResult == null) {
                throw new IllegalArgumentException("Wrong number format pattern: '" + spec + '\'');
            }
            MatchResult matchResult2 = matchResult;
            Object object7 = matchResult2.getGroups().get(1);
            if (object7 == null || (object7 = object7.getValue()) == null) {
                object7 = object6 = " ";
            }
            if ((object5 = matchResult2.getGroups().get(2)) == null || (object5 = object5.getValue()) == null) {
                object5 = object4 = ">";
            }
            if ((object3 = matchResult2.getGroups().get(3)) == null || (object3 = object3.getValue()) == null) {
                object3 = object2 = "-";
            }
            if ((object = matchResult2.getGroups().get(4)) == null || (object = object.getValue()) == null) {
                object = "";
            }
            Object object8 = object;
            boolean bl = matchResult2.getGroups().get(5) != null;
            Object object9 = matchResult2.getGroups().get(6);
            if (object9 == null || (object9 = object9.getValue()) == null) {
                object9 = "-1";
            }
            int n = Integer.parseInt((String)object9);
            boolean bl2 = matchResult2.getGroups().get(7) != null;
            Object object10 = matchResult2.getGroups().get(8);
            if (object10 == null || (object10 = object10.getValue()) == null) {
                object10 = "6";
            }
            int n2 = Integer.parseInt((String)object10);
            boolean bl3 = matchResult2.getGroups().get(9) != null;
            Object object11 = matchResult2.getGroups().get(10);
            if (object11 == null || (object11 = object11.getValue()) == null) {
                object11 = "";
            }
            Object object12 = object11;
            boolean bl4 = matchResult2.getGroups().get(11) != null;
            Spec formatSpec = new Spec((String)object6, (String)object4, (String)object2, (String)object8, bl, n, bl2, n2, (String)object12, bl3, bl4);
            return this.normalizeSpec$commons(formatSpec);
        }

        @NotNull
        public final Spec normalizeSpec$commons(@NotNull Spec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            int precision = spec.getPrecision();
            String type = spec.getType();
            boolean trim = spec.getTrim();
            if (Intrinsics.areEqual((Object)type, (Object)"")) {
                if (precision == -1) {
                    precision = 12;
                }
                type = "g";
            }
            if (Intrinsics.areEqual((Object)type, (Object)"g")) {
                trim = true;
            }
            boolean zero = spec.getZero();
            String fill2 = spec.getFill();
            String align = spec.getAlign();
            if (zero || Intrinsics.areEqual((Object)fill2, (Object)"0") && Intrinsics.areEqual((Object)align, (Object)"=")) {
                zero = true;
                fill2 = "0";
                align = "=";
            }
            return Spec.copy$default(spec, fill2, align, null, null, zero, 0, false, precision, type, trim, false, 1132, null);
        }

        private final String group(String str) {
            return ((Object)StringsKt.reversed((CharSequence)SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.chunked((Sequence)StringsKt.asSequence((CharSequence)((Object)StringsKt.reversed((CharSequence)str)).toString()), (int)3), (Function1)group.1.INSTANCE), (CharSequence)NumberFormat.COMMA, null, null, (int)0, null, null, (int)62, null))).toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0010\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$FormattedNumber;", "", "integerPart", "", "fractionalPart", "exponentialPart", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "exponentialLength", "", "getExponentialLength", "()I", "getExponentialPart", "()Ljava/lang/String;", "fractionalLength", "getFractionalLength", "getFractionalPart", "fullLength", "getFullLength", "getIntegerPart", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "commons"})
    @SourceDebugExtension(value={"SMAP\nNumberFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberFormat.kt\norg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$FormattedNumber\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,539:1\n1#2:540\n*E\n"})
    private static final class FormattedNumber {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String integerPart;
        @NotNull
        private final String fractionalPart;
        @NotNull
        private final String exponentialPart;
        private final int fractionalLength;
        private final int fullLength;
        @NotNull
        private static final Regex POWER_REGEX = new Regex("^\u00b7\\\\\\(10\\^\\{(?<degree>-?\\d+)\\}\\\\\\)$");

        public FormattedNumber(@NotNull String integerPart, @NotNull String fractionalPart, @NotNull String exponentialPart) {
            Intrinsics.checkNotNullParameter((Object)integerPart, (String)"integerPart");
            Intrinsics.checkNotNullParameter((Object)fractionalPart, (String)"fractionalPart");
            Intrinsics.checkNotNullParameter((Object)exponentialPart, (String)"exponentialPart");
            this.integerPart = integerPart;
            this.fractionalPart = fractionalPart;
            this.exponentialPart = exponentialPart;
            this.fractionalLength = ((CharSequence)this.fractionalPart).length() == 0 ? 0 : this.fractionalPart.length() + 1;
            this.fullLength = this.integerPart.length() + this.fractionalLength + this.getExponentialLength();
        }

        public /* synthetic */ FormattedNumber(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            if ((n & 4) != 0) {
                string3 = "";
            }
            this(string, string2, string3);
        }

        @NotNull
        public final String getIntegerPart() {
            return this.integerPart;
        }

        @NotNull
        public final String getFractionalPart() {
            return this.fractionalPart;
        }

        @NotNull
        public final String getExponentialPart() {
            return this.exponentialPart;
        }

        public final int getFractionalLength() {
            return this.fractionalLength;
        }

        public final int getExponentialLength() {
            MatchResult matchResult = Regex.find$default((Regex)POWER_REGEX, (CharSequence)this.exponentialPart, (int)0, (int)2, null);
            if (matchResult == null) {
                return this.exponentialPart.length();
            }
            MatchResult match2 = matchResult;
            MatchGroupCollection matchGroupCollection = match2.getGroups();
            Intrinsics.checkNotNull((Object)matchGroupCollection, (String)"null cannot be cast to non-null type kotlin.text.MatchNamedGroupCollection");
            MatchNamedGroupCollection matchGroups = (MatchNamedGroupCollection)matchGroupCollection;
            Object object = matchGroups.get("degree");
            return object != null && (object = object.getValue()) != null ? ((String)object).length() + 2 : this.exponentialPart.length();
        }

        public final int getFullLength() {
            return this.fullLength;
        }

        @NotNull
        public String toString() {
            String string;
            String string2 = string = NumberFormat.FRACTION_DELIMITER;
            StringBuilder stringBuilder = new StringBuilder().append(this.integerPart);
            boolean bl = false;
            boolean bl2 = ((CharSequence)this.fractionalPart).length() > 0;
            String string3 = bl2 ? string : null;
            if (string3 == null) {
                string3 = "";
            }
            return stringBuilder.append(string3).append(this.fractionalPart).append(this.exponentialPart).toString();
        }

        @NotNull
        public final String component1() {
            return this.integerPart;
        }

        @NotNull
        public final String component2() {
            return this.fractionalPart;
        }

        @NotNull
        public final String component3() {
            return this.exponentialPart;
        }

        @NotNull
        public final FormattedNumber copy(@NotNull String integerPart, @NotNull String fractionalPart, @NotNull String exponentialPart) {
            Intrinsics.checkNotNullParameter((Object)integerPart, (String)"integerPart");
            Intrinsics.checkNotNullParameter((Object)fractionalPart, (String)"fractionalPart");
            Intrinsics.checkNotNullParameter((Object)exponentialPart, (String)"exponentialPart");
            return new FormattedNumber(integerPart, fractionalPart, exponentialPart);
        }

        public static /* synthetic */ FormattedNumber copy$default(FormattedNumber formattedNumber, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = formattedNumber.integerPart;
            }
            if ((n & 2) != 0) {
                string2 = formattedNumber.fractionalPart;
            }
            if ((n & 4) != 0) {
                string3 = formattedNumber.exponentialPart;
            }
            return formattedNumber.copy(string, string2, string3);
        }

        public int hashCode() {
            int result2 = this.integerPart.hashCode();
            result2 = result2 * 31 + this.fractionalPart.hashCode();
            result2 = result2 * 31 + this.exponentialPart.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FormattedNumber)) {
                return false;
            }
            FormattedNumber formattedNumber = (FormattedNumber)other;
            if (!Intrinsics.areEqual((Object)this.integerPart, (Object)formattedNumber.integerPart)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fractionalPart, (Object)formattedNumber.fractionalPart)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.exponentialPart, (Object)formattedNumber.exponentialPart);
        }

        public FormattedNumber() {
            this(null, null, null, 7, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$FormattedNumber$Companion;", "", "()V", "POWER_REGEX", "Lkotlin/text/Regex;", "getPOWER_REGEX$annotations", "commons"})
        public static final class Companion {
            private Companion() {
            }

            private static /* synthetic */ void getPOWER_REGEX$annotations() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0018\b\u0080\b\u0018\u0000 ,2\u00020\u0001:\u0001,B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\rJ\t\u0010!\u001a\u00020\nH\u00c6\u0003J\t\u0010\"\u001a\u00020\fH\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010%\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJB\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010'J\u0013\u0010(\u001a\u00020\f2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020\bH\u00d6\u0001J\t\u0010+\u001a\u00020\u0015H\u00d6\u0001R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006-"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$NumberInfo;", "", "number", "", "integerPart", "", "fractionalPart", "exponent", "", "(Ljava/lang/Number;JJLjava/lang/Integer;)V", "", "negative", "", "(DZJJLjava/lang/Integer;)V", "getExponent", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "fractionLeadingZeros", "getFractionLeadingZeros", "()I", "fractionString", "", "getFractionString", "()Ljava/lang/String;", "getFractionalPart", "()J", "integerLength", "getIntegerLength", "getIntegerPart", "getNegative", "()Z", "getNumber", "()D", "component1", "component2", "component3", "component4", "component5", "copy", "(DZJJLjava/lang/Integer;)Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$NumberInfo;", "equals", "other", "hashCode", "toString", "Companion", "commons"})
    public static final class NumberInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final double number;
        private final boolean negative;
        private final long integerPart;
        private final long fractionalPart;
        @Nullable
        private final Integer exponent;
        private final int fractionLeadingZeros;
        private final int integerLength;
        @NotNull
        private final String fractionString;
        private static final int MAX_DECIMALS = 18;
        private static final long MAX_DECIMAL_VALUE = (long)Math.pow(10.0, 18);

        public NumberInfo(double number, boolean negative, long integerPart, long fractionalPart, @Nullable Integer exponent) {
            this.number = number;
            this.negative = negative;
            this.integerPart = integerPart;
            this.fractionalPart = fractionalPart;
            this.exponent = exponent;
            this.fractionLeadingZeros = 18 - NumberInfo.Companion.length(this.fractionalPart);
            this.integerLength = NumberInfo.Companion.length(this.integerPart);
            char[] cArray = new char[]{'0'};
            this.fractionString = StringsKt.repeat((CharSequence)"0", (int)this.fractionLeadingZeros) + StringsKt.trimEnd((String)String.valueOf(this.fractionalPart), (char[])cArray);
        }

        public /* synthetic */ NumberInfo(double d, boolean bl, long l, long l2, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                d = 0.0;
            }
            if ((n2 & 2) != 0) {
                bl = false;
            }
            if ((n2 & 4) != 0) {
                l = 0L;
            }
            if ((n2 & 8) != 0) {
                l2 = 0L;
            }
            if ((n2 & 0x10) != 0) {
                n = null;
            }
            this(d, bl, l, l2, n);
        }

        public final double getNumber() {
            return this.number;
        }

        public final boolean getNegative() {
            return this.negative;
        }

        public final long getIntegerPart() {
            return this.integerPart;
        }

        public final long getFractionalPart() {
            return this.fractionalPart;
        }

        @Nullable
        public final Integer getExponent() {
            return this.exponent;
        }

        public NumberInfo(@NotNull Number number, long integerPart, long fractionalPart, @Nullable Integer exponent) {
            Intrinsics.checkNotNullParameter((Object)number, (String)"number");
            this(Math.abs(number.doubleValue()), number.doubleValue() < 0.0, integerPart, fractionalPart, exponent);
        }

        public /* synthetic */ NumberInfo(Number number, long l, long l2, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                l = 0L;
            }
            if ((n2 & 4) != 0) {
                l2 = 0L;
            }
            if ((n2 & 8) != 0) {
                n = null;
            }
            this(number, l, l2, n);
        }

        public final int getFractionLeadingZeros() {
            return this.fractionLeadingZeros;
        }

        public final int getIntegerLength() {
            return this.integerLength;
        }

        @NotNull
        public final String getFractionString() {
            return this.fractionString;
        }

        public final double component1() {
            return this.number;
        }

        public final boolean component2() {
            return this.negative;
        }

        public final long component3() {
            return this.integerPart;
        }

        public final long component4() {
            return this.fractionalPart;
        }

        @Nullable
        public final Integer component5() {
            return this.exponent;
        }

        @NotNull
        public final NumberInfo copy(double number, boolean negative, long integerPart, long fractionalPart, @Nullable Integer exponent) {
            return new NumberInfo(number, negative, integerPart, fractionalPart, exponent);
        }

        public static /* synthetic */ NumberInfo copy$default(NumberInfo numberInfo, double d, boolean bl, long l, long l2, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                d = numberInfo.number;
            }
            if ((n2 & 2) != 0) {
                bl = numberInfo.negative;
            }
            if ((n2 & 4) != 0) {
                l = numberInfo.integerPart;
            }
            if ((n2 & 8) != 0) {
                l2 = numberInfo.fractionalPart;
            }
            if ((n2 & 0x10) != 0) {
                n = numberInfo.exponent;
            }
            return numberInfo.copy(d, bl, l, l2, n);
        }

        @NotNull
        public String toString() {
            return "NumberInfo(number=" + this.number + ", negative=" + this.negative + ", integerPart=" + this.integerPart + ", fractionalPart=" + this.fractionalPart + ", exponent=" + this.exponent + ')';
        }

        public int hashCode() {
            int result2 = Double.hashCode(this.number);
            result2 = result2 * 31 + Boolean.hashCode(this.negative);
            result2 = result2 * 31 + Long.hashCode(this.integerPart);
            result2 = result2 * 31 + Long.hashCode(this.fractionalPart);
            result2 = result2 * 31 + (this.exponent == null ? 0 : ((Object)this.exponent).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NumberInfo)) {
                return false;
            }
            NumberInfo numberInfo = (NumberInfo)other;
            if (Double.compare(this.number, numberInfo.number) != 0) {
                return false;
            }
            if (this.negative != numberInfo.negative) {
                return false;
            }
            if (this.integerPart != numberInfo.integerPart) {
                return false;
            }
            if (this.fractionalPart != numberInfo.fractionalPart) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.exponent, (Object)numberInfo.exponent);
        }

        public NumberInfo() {
            this(0.0, false, 0L, 0L, null, 31, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$NumberInfo$Companion;", "", "()V", "MAX_DECIMALS", "", "MAX_DECIMAL_VALUE", "", "getMAX_DECIMAL_VALUE$commons", "()J", "createNumberInfo", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$NumberInfo;", "num", "", "createNumberInfo$commons", "length", "v", "commons"})
        @SourceDebugExtension(value={"SMAP\nNumberFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberFormat.kt\norg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$NumberInfo$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,539:1\n1#2:540\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            public final long getMAX_DECIMAL_VALUE$commons() {
                return MAX_DECIMAL_VALUE;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final NumberInfo createNumberInfo$commons(@NotNull Number num) {
                void $this$createNumberInfo_u24lambda_u240;
                int exponent;
                MatchResult.Destructured destructured;
                Intrinsics.checkNotNullParameter((Object)num, (String)"num");
                Function2 encodeFraction2 = createNumberInfo.encodeFraction.1.INSTANCE;
                Regex regex = new Regex("^(\\d+)\\.?(\\d+)?e?([+-]?\\d+)?$");
                String string = String.valueOf(Math.abs(num.doubleValue())).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
                if (matchResult == null || (destructured = matchResult.getDestructured()) == null) {
                    throw new IllegalStateException(("Wrong number: " + num).toString());
                }
                MatchResult.Destructured destructured2 = destructured;
                String intStr = (String)destructured2.getMatch().getGroupValues().get(1);
                String fracStr = (String)destructured2.getMatch().getGroupValues().get(2);
                String exponentString = (String)destructured2.getMatch().getGroupValues().get(3);
                Integer n = StringsKt.toIntOrNull((String)exponentString);
                int n2 = exponent = n != null ? n : 0;
                if (Math.abs(exponent) >= 18) {
                    return new NumberInfo(num, Long.parseLong(intStr), 0L, exponent);
                }
                if (!(exponent < 18)) {
                    String string2 = "Check failed.";
                    throw new IllegalStateException(string2.toString());
                }
                if (exponent < 0) {
                    return new NumberInfo(num, 0L, ((Number)encodeFraction2.invoke((Object)(intStr + fracStr), (Object)(Math.abs(exponent) + fracStr.length()))).longValue(), null, 10, null);
                }
                if (!(0 <= exponent ? exponent < 19 : false)) {
                    String string3 = "Check failed.";
                    throw new IllegalStateException(string3.toString());
                }
                if (exponent >= fracStr.length()) {
                    return new NumberInfo(num, Long.parseLong(intStr + fracStr + StringsKt.repeat((CharSequence)"0", (int)(exponent - fracStr.length()))), 0L, null, 12, null);
                }
                if (!(exponent >= 0 && exponent < fracStr.length())) {
                    String string4 = "Check failed.";
                    throw new IllegalStateException(string4.toString());
                }
                long l = Long.parseLong(intStr + StringsKt.substring((String)fracStr, (IntRange)RangesKt.until((int)0, (int)exponent)));
                String string5 = fracStr.substring(exponent);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                String string6 = string5;
                long l2 = l;
                Number number = num;
                boolean bl = false;
                long l3 = ((Number)encodeFraction2.invoke((Object)$this$createNumberInfo_u24lambda_u240, (Object)$this$createNumberInfo_u24lambda_u240.length())).longValue();
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n3 = 8;
                Integer n4 = null;
                long l4 = l3;
                long l5 = l2;
                Number number2 = number;
                return new NumberInfo(number2, l5, l4, n4, n3, defaultConstructorMarker);
            }

            private final int length(long v) {
                if (v == 0L) {
                    return 1;
                }
                int len = 0;
                for (long rem = v; rem > 0L; rem /= (long)10) {
                    ++len;
                }
                return len;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$Output;", "", "body", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$FormattedNumber;", "sign", "", "prefix", "suffix", "padding", "(Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$FormattedNumber;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBody", "()Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$FormattedNumber;", "getPadding", "()Ljava/lang/String;", "getPrefix", "getSign", "getSuffix", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "commons"})
    private static final class Output {
        @NotNull
        private final FormattedNumber body;
        @NotNull
        private final String sign;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;
        @NotNull
        private final String padding;

        public Output(@NotNull FormattedNumber body, @NotNull String sign, @NotNull String prefix, @NotNull String suffix, @NotNull String padding) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
            this.body = body;
            this.sign = sign;
            this.prefix = prefix;
            this.suffix = suffix;
            this.padding = padding;
        }

        public /* synthetic */ Output(FormattedNumber formattedNumber, String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                formattedNumber = new FormattedNumber(null, null, null, 7, null);
            }
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                string2 = "";
            }
            if ((n & 8) != 0) {
                string3 = "";
            }
            if ((n & 0x10) != 0) {
                string4 = "";
            }
            this(formattedNumber, string, string2, string3, string4);
        }

        @NotNull
        public final FormattedNumber getBody() {
            return this.body;
        }

        @NotNull
        public final String getSign() {
            return this.sign;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        @NotNull
        public final String getPadding() {
            return this.padding;
        }

        @NotNull
        public final FormattedNumber component1() {
            return this.body;
        }

        @NotNull
        public final String component2() {
            return this.sign;
        }

        @NotNull
        public final String component3() {
            return this.prefix;
        }

        @NotNull
        public final String component4() {
            return this.suffix;
        }

        @NotNull
        public final String component5() {
            return this.padding;
        }

        @NotNull
        public final Output copy(@NotNull FormattedNumber body, @NotNull String sign, @NotNull String prefix, @NotNull String suffix, @NotNull String padding) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
            return new Output(body, sign, prefix, suffix, padding);
        }

        public static /* synthetic */ Output copy$default(Output output, FormattedNumber formattedNumber, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                formattedNumber = output.body;
            }
            if ((n & 2) != 0) {
                string = output.sign;
            }
            if ((n & 4) != 0) {
                string2 = output.prefix;
            }
            if ((n & 8) != 0) {
                string3 = output.suffix;
            }
            if ((n & 0x10) != 0) {
                string4 = output.padding;
            }
            return output.copy(formattedNumber, string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "Output(body=" + this.body + ", sign=" + this.sign + ", prefix=" + this.prefix + ", suffix=" + this.suffix + ", padding=" + this.padding + ')';
        }

        public int hashCode() {
            int result2 = this.body.hashCode();
            result2 = result2 * 31 + this.sign.hashCode();
            result2 = result2 * 31 + this.prefix.hashCode();
            result2 = result2 * 31 + this.suffix.hashCode();
            result2 = result2 * 31 + this.padding.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Output)) {
                return false;
            }
            Output output = (Output)other;
            if (!Intrinsics.areEqual((Object)this.body, (Object)output.body)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sign, (Object)output.sign)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.prefix, (Object)output.prefix)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.suffix, (Object)output.suffix)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.padding, (Object)output.padding);
        }

        public Output() {
            this(null, null, null, null, null, 31, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b%\b\u0086\b\u0018\u00002\u00020\u0001Bs\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\b\u0012\b\b\u0002\u0010\u000f\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\t\u0010!\u001a\u00020\bH\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\bH\u00c6\u0003J\t\u0010&\u001a\u00020\nH\u00c6\u0003J\t\u0010'\u001a\u00020\bH\u00c6\u0003J\t\u0010(\u001a\u00020\nH\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003Jw\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\b2\b\b\u0002\u0010\u000f\u001a\u00020\bH\u00c6\u0001J\u0013\u0010+\u001a\u00020\b2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020\nH\u00d6\u0001J\t\u0010.\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014\u00a8\u0006/"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$Spec;", "", "fill", "", "align", "sign", "symbol", "zero", "", "width", "", "comma", "precision", "type", "trim", "richOutput", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZIZILjava/lang/String;ZZ)V", "getAlign", "()Ljava/lang/String;", "getComma", "()Z", "getFill", "getPrecision", "()I", "getRichOutput", "getSign", "getSymbol", "getTrim", "getType", "getWidth", "getZero", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "commons"})
    public static final class Spec {
        @NotNull
        private final String fill;
        @NotNull
        private final String align;
        @NotNull
        private final String sign;
        @NotNull
        private final String symbol;
        private final boolean zero;
        private final int width;
        private final boolean comma;
        private final int precision;
        @NotNull
        private final String type;
        private final boolean trim;
        private final boolean richOutput;

        public Spec(@NotNull String fill2, @NotNull String align, @NotNull String sign, @NotNull String symbol, boolean zero, int width2, boolean comma, int precision, @NotNull String type, boolean trim, boolean richOutput) {
            Intrinsics.checkNotNullParameter((Object)fill2, (String)"fill");
            Intrinsics.checkNotNullParameter((Object)align, (String)"align");
            Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.fill = fill2;
            this.align = align;
            this.sign = sign;
            this.symbol = symbol;
            this.zero = zero;
            this.width = width2;
            this.comma = comma;
            this.precision = precision;
            this.type = type;
            this.trim = trim;
            this.richOutput = richOutput;
        }

        public /* synthetic */ Spec(String string, String string2, String string3, String string4, boolean bl, int n, boolean bl2, int n2, String string5, boolean bl3, boolean bl4, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                string = " ";
            }
            if ((n3 & 2) != 0) {
                string2 = ">";
            }
            if ((n3 & 4) != 0) {
                string3 = "-";
            }
            if ((n3 & 8) != 0) {
                string4 = "";
            }
            if ((n3 & 0x10) != 0) {
                bl = false;
            }
            if ((n3 & 0x20) != 0) {
                n = -1;
            }
            if ((n3 & 0x40) != 0) {
                bl2 = false;
            }
            if ((n3 & 0x80) != 0) {
                n2 = 6;
            }
            if ((n3 & 0x100) != 0) {
                string5 = "";
            }
            if ((n3 & 0x200) != 0) {
                bl3 = false;
            }
            if ((n3 & 0x400) != 0) {
                bl4 = false;
            }
            this(string, string2, string3, string4, bl, n, bl2, n2, string5, bl3, bl4);
        }

        @NotNull
        public final String getFill() {
            return this.fill;
        }

        @NotNull
        public final String getAlign() {
            return this.align;
        }

        @NotNull
        public final String getSign() {
            return this.sign;
        }

        @NotNull
        public final String getSymbol() {
            return this.symbol;
        }

        public final boolean getZero() {
            return this.zero;
        }

        public final int getWidth() {
            return this.width;
        }

        public final boolean getComma() {
            return this.comma;
        }

        public final int getPrecision() {
            return this.precision;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final boolean getTrim() {
            return this.trim;
        }

        public final boolean getRichOutput() {
            return this.richOutput;
        }

        @NotNull
        public final String component1() {
            return this.fill;
        }

        @NotNull
        public final String component2() {
            return this.align;
        }

        @NotNull
        public final String component3() {
            return this.sign;
        }

        @NotNull
        public final String component4() {
            return this.symbol;
        }

        public final boolean component5() {
            return this.zero;
        }

        public final int component6() {
            return this.width;
        }

        public final boolean component7() {
            return this.comma;
        }

        public final int component8() {
            return this.precision;
        }

        @NotNull
        public final String component9() {
            return this.type;
        }

        public final boolean component10() {
            return this.trim;
        }

        public final boolean component11() {
            return this.richOutput;
        }

        @NotNull
        public final Spec copy(@NotNull String fill2, @NotNull String align, @NotNull String sign, @NotNull String symbol, boolean zero, int width2, boolean comma, int precision, @NotNull String type, boolean trim, boolean richOutput) {
            Intrinsics.checkNotNullParameter((Object)fill2, (String)"fill");
            Intrinsics.checkNotNullParameter((Object)align, (String)"align");
            Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new Spec(fill2, align, sign, symbol, zero, width2, comma, precision, type, trim, richOutput);
        }

        public static /* synthetic */ Spec copy$default(Spec spec, String string, String string2, String string3, String string4, boolean bl, int n, boolean bl2, int n2, String string5, boolean bl3, boolean bl4, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = spec.fill;
            }
            if ((n3 & 2) != 0) {
                string2 = spec.align;
            }
            if ((n3 & 4) != 0) {
                string3 = spec.sign;
            }
            if ((n3 & 8) != 0) {
                string4 = spec.symbol;
            }
            if ((n3 & 0x10) != 0) {
                bl = spec.zero;
            }
            if ((n3 & 0x20) != 0) {
                n = spec.width;
            }
            if ((n3 & 0x40) != 0) {
                bl2 = spec.comma;
            }
            if ((n3 & 0x80) != 0) {
                n2 = spec.precision;
            }
            if ((n3 & 0x100) != 0) {
                string5 = spec.type;
            }
            if ((n3 & 0x200) != 0) {
                bl3 = spec.trim;
            }
            if ((n3 & 0x400) != 0) {
                bl4 = spec.richOutput;
            }
            return spec.copy(string, string2, string3, string4, bl, n, bl2, n2, string5, bl3, bl4);
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Spec(fill=").append(this.fill).append(", align=").append(this.align).append(", sign=").append(this.sign).append(", symbol=").append(this.symbol).append(", zero=").append(this.zero).append(", width=").append(this.width).append(", comma=").append(this.comma).append(", precision=").append(this.precision).append(", type=").append(this.type).append(", trim=").append(this.trim).append(", richOutput=").append(this.richOutput).append(')');
            return stringBuilder.toString();
        }

        public int hashCode() {
            int result2 = this.fill.hashCode();
            result2 = result2 * 31 + this.align.hashCode();
            result2 = result2 * 31 + this.sign.hashCode();
            result2 = result2 * 31 + this.symbol.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.zero);
            result2 = result2 * 31 + Integer.hashCode(this.width);
            result2 = result2 * 31 + Boolean.hashCode(this.comma);
            result2 = result2 * 31 + Integer.hashCode(this.precision);
            result2 = result2 * 31 + this.type.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.trim);
            result2 = result2 * 31 + Boolean.hashCode(this.richOutput);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spec)) {
                return false;
            }
            Spec spec = (Spec)other;
            if (!Intrinsics.areEqual((Object)this.fill, (Object)spec.fill)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.align, (Object)spec.align)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sign, (Object)spec.sign)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.symbol, (Object)spec.symbol)) {
                return false;
            }
            if (this.zero != spec.zero) {
                return false;
            }
            if (this.width != spec.width) {
                return false;
            }
            if (this.comma != spec.comma) {
                return false;
            }
            if (this.precision != spec.precision) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)spec.type)) {
                return false;
            }
            if (this.trim != spec.trim) {
                return false;
            }
            return this.richOutput == spec.richOutput;
        }

        public Spec() {
            this(null, null, null, null, false, 0, false, 0, null, false, false, 2047, null);
        }
    }
}

