/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.intern.util.VectorAdapter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000 %*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001%B3\b\u0002\u0012\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014JC\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u00002\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011J\u001a\u0010\u001e\u001a\u00028\u0000*\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0000H\u0082\u0002\u00a2\u0006\u0002\u0010 J\u001a\u0010\u001e\u001a\u00028\u0000*\u00028\u00002\u0006\u0010!\u001a\u00020\u0006H\u0082\u0002\u00a2\u0006\u0002\u0010\"J\u001a\u0010#\u001a\u00028\u0000*\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0000H\u0082\u0002\u00a2\u0006\u0002\u0010 J\u001a\u0010$\u001a\u00028\u0000*\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0000H\u0082\u0002\u00a2\u0006\u0002\u0010 R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\u00020\u0006*\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0015\u0010\u000e\u001a\u00020\u0006*\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006&"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/AdaptiveResampler;", "T", "", "transform", "Lkotlin/Function1;", "precision", "", "vec", "Lorg/jetbrains/letsPlot/commons/intern/util/VectorAdapter;", "(Lkotlin/jvm/functions/Function1;DLorg/jetbrains/letsPlot/commons/intern/util/VectorAdapter;)V", "precisionSqr", "x", "getX", "(Ljava/lang/Object;)D", "y", "getY", "resample", "", "p1", "p2", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "", "t1", "t2", "output", "", "depth", "", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/util/List;I)V", "points", "div", "other", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "v", "(Ljava/lang/Object;D)Ljava/lang/Object;", "minus", "plus", "Companion", "commons"})
@SourceDebugExtension(value={"SMAP\nAdaptiveResampler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdaptiveResampler.kt\norg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/AdaptiveResampler\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,117:1\n1313#2,2:118\n*S KotlinDebug\n*F\n+ 1 AdaptiveResampler.kt\norg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/AdaptiveResampler\n*L\n66#1:118,2\n*E\n"})
public final class AdaptiveResampler<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<T, T> transform;
    @NotNull
    private final VectorAdapter<T> vec;
    private final double precisionSqr;
    public static final double PIXEL_PRECISION = 0.95;
    private static final int MAX_DEPTH_LIMIT = 9;

    private AdaptiveResampler(Function1<? super T, ? extends T> transform2, double precision, VectorAdapter<T> vec) {
        this.transform = transform2;
        this.vec = vec;
        this.precisionSqr = precision * precision;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<T> resample(@NotNull List<? extends T> points) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Object pPrev = null;
        Object object = CollectionsKt.firstOrNull(points);
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        pPrev = object;
        Object tPrev = null;
        Object object2 = this.transform.invoke(pPrev);
        if (object2 == null) {
            return CollectionsKt.emptyList();
        }
        tPrev = object2;
        Object object3 = CollectionsKt.lastOrNull(points);
        if (object3 == null) {
            return CollectionsKt.emptyList();
        }
        Object pLast = object3;
        Object object4 = this.transform.invoke(pLast);
        if (object4 == null) {
            return CollectionsKt.emptyList();
        }
        Object tLast = object4;
        ArrayList<Object> output = new ArrayList<Object>(points.size());
        Sequence sequence = SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)points), (int)1);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object t;
            Object element$iv;
            Object p = element$iv = iterator2.next();
            boolean bl = false;
            if (this.transform.invoke(p) == null) continue;
            output.add(tPrev);
            this.resample(pPrev, tPrev, p, t, (List)output, 9);
            pPrev = p;
            tPrev = t;
        }
        output.add(tLast);
        return output;
    }

    @NotNull
    public final List<T> resample(T p1, T p2) {
        Object object = this.transform.invoke(p1);
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        Object t1 = object;
        Object object2 = this.transform.invoke(p2);
        if (object2 == null) {
            return CollectionsKt.emptyList();
        }
        Object t2 = object2;
        List output = new ArrayList();
        output.add(t1);
        this.resample(p1, t1, p2, t2, output, 9);
        output.add(t2);
        return output;
    }

    private final void resample(T p1, T t1, T p2, T t2, List<T> output, int depth) {
        if (Intrinsics.areEqual(p1, p2)) {
            return;
        }
        T pm = this.div(this.plus(p1, p2), 2.0);
        Object object = this.transform.invoke(pm);
        if (object == null) {
            return;
        }
        Object tm = object;
        if (MathKt.distance2ToLine(this.getX(tm), this.getY(tm), this.getX(t1), this.getY(t1), this.getX(t2), this.getY(t2)) >= this.precisionSqr && depth > 0) {
            this.resample(p1, t1, pm, tm, output, depth - 1);
            output.add(tm);
            this.resample(pm, tm, p2, t2, output, depth - 1);
        } else if (MathKt.distance2(this.getX(t1), this.getY(t1), this.getX(t2), this.getY(t2)) > this.precisionSqr) {
            output.add(tm);
        }
    }

    public final double getX(T $this$x) {
        return this.vec.x($this$x);
    }

    public final double getY(T $this$y) {
        return this.vec.y($this$y);
    }

    private final T minus(T $this$minus, T other) {
        return this.vec.create(this.getX($this$minus) - this.getX(other), this.getY($this$minus) - this.getY(other));
    }

    private final T plus(T $this$plus, T other) {
        return this.vec.create(this.getX($this$plus) + this.getX(other), this.getY($this$plus) + this.getY(other));
    }

    private final T div(T $this$div, T other) {
        return this.vec.create(this.getX($this$div) / this.getX(other), this.getY($this$div) / this.getY(other));
    }

    private final T div(T $this$div, double v) {
        return this.vec.create(this.getX($this$div) / v, this.getY($this$div) / v);
    }

    public /* synthetic */ AdaptiveResampler(Function1 transform2, double precision, VectorAdapter vec, DefaultConstructorMarker $constructor_marker) {
        this(transform2, precision, vec);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002J>\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000e0\b\"\u0004\b\u0001\u0010\u000e2\u0006\u0010\f\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u0002H\u000e\u0012\u0006\u0012\u0004\u0018\u0001H\u000e0\u000bJ8\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\f\u001a\u00020\u00062\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000bJ:\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00062\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/AdaptiveResampler$Companion;", "", "()V", "MAX_DEPTH_LIMIT", "", "PIXEL_PRECISION", "", "forDoubleVector", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/AdaptiveResampler;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "transform", "Lkotlin/Function1;", "precision", "generic", "T", "adapter", "Lorg/jetbrains/letsPlot/commons/intern/util/VectorAdapter;", "resample", "", "points", "p1", "p2", "commons"})
    public static final class Companion {
        private Companion() {
        }

        private final AdaptiveResampler<DoubleVector> forDoubleVector(Function1<? super DoubleVector, DoubleVector> transform2, double precision) {
            return new AdaptiveResampler<DoubleVector>(transform2, precision, VectorAdapter.Companion.getDOUBLE_VECTOR_ADAPTER(), null);
        }

        @NotNull
        public final <T> AdaptiveResampler<T> generic(double precision, @NotNull VectorAdapter<T> adapter, @NotNull Function1<? super T, ? extends T> transform2) {
            Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(transform2, (String)"transform");
            return new AdaptiveResampler(transform2, precision, adapter, null);
        }

        @NotNull
        public final List<DoubleVector> resample(@NotNull List<DoubleVector> points, double precision, @NotNull Function1<? super DoubleVector, DoubleVector> transform2) {
            Intrinsics.checkNotNullParameter(points, (String)"points");
            Intrinsics.checkNotNullParameter(transform2, (String)"transform");
            return this.forDoubleVector(transform2, precision).resample(points);
        }

        @NotNull
        public final List<DoubleVector> resample(@NotNull DoubleVector p1, @NotNull DoubleVector p2, double precision, @NotNull Function1<? super DoubleVector, DoubleVector> transform2) {
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            Intrinsics.checkNotNullParameter(transform2, (String)"transform");
            return this.forDoubleVector(transform2, precision).resample(p1, p2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

